/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyTuple;
import org.python.modules.PyStruct;

public class struct {
    public static final PyObject error = Py.makeClass("error", Py.Exception, struct.exceptionNamespace());
    public static String __doc__ = "Functions to convert between Python values and C structs.\nPython strings are used to hold the data representing the C\nstruct and also as format strings to describe the layout of\ndata in the C struct.\n\nThe optional first format char indicates byte ordering and\nalignment:\n @: native w/native alignment(default)\n =: native w/standard alignment\n <: little-endian, std. alignment\n >: big-endian, std. alignment\n !: network, std (same as >)\n\nThe remaining chars indicate types of args and must match\nexactly; these can be preceded by a decimal repeat count:\n x: pad byte (no data); c:char; b:signed byte; B:unsigned byte;\n h:short; H:unsigned short; i:int; I:unsigned int;\n l:long; L:unsigned long; f:float; d:double.\nSpecial cases (preceding decimal count indicates length):\n s:string (array of char); p: pascal string (w. count byte).\nWhitespace between formats is ignored.\n\nThe variable struct.error is an exception raised on errors.";
    private static FormatDef[] lilendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new LEShortFormatDef().init('h', 2, 0), new LEUnsignedShortFormatDef().init('H', 2, 0), new LEIntFormatDef().init('i', 4, 0), new LEUnsignedIntFormatDef().init('I', 4, 0), new LEIntFormatDef().init('l', 4, 0), new LEUnsignedIntFormatDef().init('L', 4, 0), new LELongFormatDef().init('q', 8, 0), new LEUnsignedLongFormatDef().init('Q', 8, 0), new LEFloatFormatDef().init('f', 4, 0), new LEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] bigendian_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 0), new BEUnsignedShortFormatDef().init('H', 2, 0), new BEIntFormatDef().init('i', 4, 0), new BEUnsignedIntFormatDef().init('I', 4, 0), new BEIntFormatDef().init('l', 4, 0), new BEUnsignedIntFormatDef().init('L', 4, 0), new BELongFormatDef().init('q', 8, 0), new BEUnsignedLongFormatDef().init('Q', 8, 0), new BEFloatFormatDef().init('f', 4, 0), new BEDoubleFormatDef().init('d', 8, 0)};
    private static FormatDef[] native_table = new FormatDef[]{new PadFormatDef().init('x', 1, 0), new ByteFormatDef().init('b', 1, 0), new UnsignedByteFormatDef().init('B', 1, 0), new CharFormatDef().init('c', 1, 0), new StringFormatDef().init('s', 1, 0), new PascalStringFormatDef().init('p', 1, 0), new BEShortFormatDef().init('h', 2, 2), new BEUnsignedShortFormatDef().init('H', 2, 2), new BEIntFormatDef().init('i', 4, 4), new BEUnsignedIntFormatDef().init('I', 4, 4), new BEIntFormatDef().init('l', 4, 4), new BEUnsignedIntFormatDef().init('L', 4, 4), new BELongFormatDef().init('q', 8, 8), new BEUnsignedLongFormatDef().init('Q', 8, 8), new BEFloatFormatDef().init('f', 4, 4), new BEDoubleFormatDef().init('d', 8, 8)};

    static FormatDef[] whichtable(String pfmt) {
        char c2 = pfmt.charAt(0);
        switch (c2) {
            case '<': {
                return lilendian_table;
            }
            case '!': 
            case '>': {
                return bigendian_table;
            }
            case '=': {
                return bigendian_table;
            }
        }
        return native_table;
    }

    private static FormatDef getentry(char c2, FormatDef[] f2) {
        for (int i2 = 0; i2 < f2.length; ++i2) {
            if (f2[i2].name != c2) continue;
            return f2[i2];
        }
        throw struct.StructError("bad char in struct format");
    }

    private static int align(int size, FormatDef e2) {
        if (e2.alignment != 0) {
            size = (size + e2.alignment - 1) / e2.alignment * e2.alignment;
        }
        return size;
    }

    static int calcsize(String format, FormatDef[] f2) {
        int size = 0;
        int len = format.length();
        for (int j2 = 0; j2 < len; ++j2) {
            char c2 = format.charAt(j2);
            if (j2 == 0 && (c2 == '@' || c2 == '<' || c2 == '>' || c2 == '=' || c2 == '!') || Character.isWhitespace(c2)) continue;
            int num = 1;
            if (Character.isDigit(c2)) {
                num = Character.digit(c2, 10);
                while (++j2 < len && Character.isDigit(c2 = format.charAt(j2))) {
                    int x = num * 10 + Character.digit(c2, 10);
                    if (x / 10 != num) {
                        throw struct.StructError("overflow in item count");
                    }
                    num = x;
                }
                if (j2 >= len) break;
            }
            FormatDef e2 = struct.getentry(c2, f2);
            int itemsize = e2.size;
            size = struct.align(size, e2);
            int x = num * itemsize;
            if (x / itemsize == num && (size += x) >= 0) continue;
            throw struct.StructError("total struct size too long");
        }
        return size;
    }

    public static int calcsize(String format) {
        FormatDef[] f2 = struct.whichtable(format);
        return struct.calcsize(format, f2);
    }

    public static PyString pack(PyObject[] args) {
        if (args.length < 1) {
            Py.TypeError("illegal argument type for built-in operation");
        }
        String format = args[0].toString();
        FormatDef[] f2 = struct.whichtable(format);
        int size = struct.calcsize(format, f2);
        return new PyString(struct.pack(format, f2, size, 1, args).toString());
    }

    public static void pack_into(PyObject[] args) {
        if (args.length < 3) {
            Py.TypeError("illegal argument type for built-in operation");
        }
        String format = args[0].toString();
        FormatDef[] f2 = struct.whichtable(format);
        int size = struct.calcsize(format, f2);
        struct.pack_into(format, f2, size, 1, args);
    }

    static void pack_into(String format, FormatDef[] f2, int size, int argstart, PyObject[] args) {
        if (args.length - argstart < 2) {
            Py.TypeError("illegal argument type for built-in operation");
        }
        if (!(args[argstart] instanceof PyArray)) {
            throw Py.TypeError("pack_into takes an array arg");
        }
        PyArray buffer = (PyArray)args[argstart];
        int offset = args[argstart + 1].__int__().asInt();
        ByteStream res = struct.pack(format, f2, size, argstart + 2, args);
        if (res.pos > buffer.__len__()) {
            throw struct.StructError("pack_into requires a buffer of at least " + res.pos + " bytes, got " + buffer.__len__());
        }
        int i2 = 0;
        while (i2 < res.pos) {
            char val = res.data[i2];
            buffer.set(offset, val);
            ++i2;
            ++offset;
        }
    }

    static ByteStream pack(String format, FormatDef[] f2, int size, int start, PyObject[] args) {
        ByteStream res = new ByteStream();
        int i2 = start;
        int len = format.length();
        for (int j2 = 0; j2 < len; ++j2) {
            char c2 = format.charAt(j2);
            if (j2 == 0 && (c2 == '@' || c2 == '<' || c2 == '>' || c2 == '=' || c2 == '!') || Character.isWhitespace(c2)) continue;
            int num = 1;
            if (Character.isDigit(c2)) {
                num = Character.digit(c2, 10);
                while (++j2 < len && Character.isDigit(c2 = format.charAt(j2))) {
                    num = num * 10 + Character.digit(c2, 10);
                }
                if (j2 >= len) break;
            }
            FormatDef e2 = struct.getentry(c2, f2);
            int nres = struct.align(res.size(), e2) - res.size();
            while (nres-- > 0) {
                res.writeByte(0);
            }
            i2 += e2.doPack(res, num, i2, args);
        }
        if (i2 < args.length) {
            throw struct.StructError("too many arguments for pack format");
        }
        return res;
    }

    public static PyTuple unpack(String format, String string) {
        int len;
        FormatDef[] f2 = struct.whichtable(format);
        int size = struct.calcsize(format, f2);
        if (size != (len = string.length())) {
            throw struct.StructError("unpack str size does not match format");
        }
        return struct.unpack(f2, size, format, new ByteStream(string));
    }

    public static PyTuple unpack(String format, PyArray buffer) {
        int len;
        String string = buffer.tostring();
        FormatDef[] f2 = struct.whichtable(format);
        int size = struct.calcsize(format, f2);
        if (size != (len = string.length())) {
            throw struct.StructError("unpack str size does not match format");
        }
        return struct.unpack(f2, size, format, new ByteStream(string));
    }

    public static PyTuple unpack_from(String format, String string) {
        return struct.unpack_from(format, string, 0);
    }

    public static PyTuple unpack_from(String format, String string, int offset) {
        int len;
        FormatDef[] f2 = struct.whichtable(format);
        int size = struct.calcsize(format, f2);
        if (size >= (len = string.length()) - offset + 1) {
            throw struct.StructError("unpack_from str size does not match format");
        }
        return struct.unpack(f2, size, format, new ByteStream(string, offset));
    }

    static PyTuple unpack(FormatDef[] f2, int size, String format, ByteStream str) {
        PyList res = new PyList();
        int flen = format.length();
        for (int j2 = 0; j2 < flen; ++j2) {
            char c2 = format.charAt(j2);
            if (j2 == 0 && (c2 == '@' || c2 == '<' || c2 == '>' || c2 == '=' || c2 == '!') || Character.isWhitespace(c2)) continue;
            int num = 1;
            if (Character.isDigit(c2)) {
                num = Character.digit(c2, 10);
                while (++j2 < flen && Character.isDigit(c2 = format.charAt(j2))) {
                    num = num * 10 + Character.digit(c2, 10);
                }
                if (j2 > flen) break;
            }
            FormatDef e2 = struct.getentry(c2, f2);
            str.skip(struct.align(str.size(), e2) - str.size());
            e2.doUnpack(str, num, res);
        }
        return PyTuple.fromIterable(res);
    }

    static PyException StructError(String explanation) {
        return new PyException(error, explanation);
    }

    private static PyObject exceptionNamespace() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__module__", (PyObject)new PyString("struct"));
        return dict;
    }

    public static PyStruct Struct(PyObject[] args, String[] keywords) {
        return new PyStruct(args, keywords);
    }

    static class BEDoubleFormatDef
    extends FormatDef {
        BEDoubleFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long bits = Double.doubleToLongBits(this.get_float(value));
            this.BEwriteInt(buf, (int)(bits >>> 32));
            this.BEwriteInt(buf, (int)(bits & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long bits = ((long)this.BEreadInt(buf) << 32) + ((long)this.BEreadInt(buf) & 0xFFFFFFFFL);
            double v = Double.longBitsToDouble(bits);
            if (PyFloat.double_format == PyFloat.Format.UNKNOWN && (Double.isInfinite(v) || Double.isNaN(v))) {
                throw Py.ValueError("can't unpack IEEE 754 special value on non-IEEE platform");
            }
            return Py.newFloat(v);
        }
    }

    static class BEFloatFormatDef
    extends FormatDef {
        BEFloatFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int bits = Float.floatToIntBits((float)this.get_float(value));
            this.BEwriteInt(buf, bits);
        }

        Object unpack(ByteStream buf) {
            int bits = this.BEreadInt(buf);
            float v = Float.intBitsToFloat(bits);
            if (PyFloat.float_format == PyFloat.Format.UNKNOWN && (Float.isInfinite(v) || Float.isNaN(v))) {
                throw Py.ValueError("can't unpack IEEE 754 special value on non-IEEE platform");
            }
            return Py.newFloat(v);
        }
    }

    static class LEDoubleFormatDef
    extends FormatDef {
        LEDoubleFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long bits = Double.doubleToLongBits(this.get_float(value));
            this.LEwriteInt(buf, (int)(bits & 0xFFFFFFFFFFFFFFFFL));
            this.LEwriteInt(buf, (int)(bits >>> 32));
        }

        Object unpack(ByteStream buf) {
            long bits = ((long)this.LEreadInt(buf) & 0xFFFFFFFFL) + ((long)this.LEreadInt(buf) << 32);
            double v = Double.longBitsToDouble(bits);
            if (PyFloat.double_format == PyFloat.Format.UNKNOWN && (Double.isInfinite(v) || Double.isNaN(v))) {
                throw Py.ValueError("can't unpack IEEE 754 special value on non-IEEE platform");
            }
            return Py.newFloat(v);
        }
    }

    static class LEFloatFormatDef
    extends FormatDef {
        LEFloatFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int bits = Float.floatToIntBits((float)this.get_float(value));
            this.LEwriteInt(buf, bits);
        }

        Object unpack(ByteStream buf) {
            int bits = this.LEreadInt(buf);
            float v = Float.intBitsToFloat(bits);
            if (PyFloat.float_format == PyFloat.Format.UNKNOWN && (Float.isInfinite(v) || Float.isNaN(v))) {
                throw Py.ValueError("can't unpack IEEE 754 special value on non-IEEE platform");
            }
            return Py.newFloat(v);
        }
    }

    static class BELongFormatDef
    extends FormatDef {
        BELongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long lvalue = this.get_long(value);
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.BEwriteInt(buf, high);
            this.BEwriteInt(buf, low);
        }

        Object unpack(ByteStream buf) {
            long high = (long)this.BEreadInt(buf) << 32 & 0xFFFFFFFF00000000L;
            long low = (long)this.BEreadInt(buf) & 0xFFFFFFFFL;
            long result = high | low;
            return new PyLong(result);
        }
    }

    static class LELongFormatDef
    extends FormatDef {
        LELongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            long lvalue = this.get_long(value);
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.LEwriteInt(buf, low);
            this.LEwriteInt(buf, high);
        }

        Object unpack(ByteStream buf) {
            long low = (long)this.LEreadInt(buf) & 0xFFFFFFFFL;
            long high = (long)this.LEreadInt(buf) << 32 & 0xFFFFFFFF00000000L;
            long result = high | low;
            return new PyLong(result);
        }
    }

    static class BEUnsignedLongFormatDef
    extends FormatDef {
        BEUnsignedLongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            BigInteger bi = this.get_ulong(value);
            if (bi.compareTo(BigInteger.valueOf(0L)) < 0) {
                throw struct.StructError("can't convert negative long to unsigned");
            }
            long lvalue = bi.longValue();
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.BEwriteInt(buf, high);
            this.BEwriteInt(buf, low);
        }

        Object unpack(ByteStream buf) {
            long high = (long)this.BEreadInt(buf) & 0xFFFFFFFFL;
            long low = (long)this.BEreadInt(buf) & 0xFFFFFFFFL;
            BigInteger result = BigInteger.valueOf(high);
            result = result.multiply(BigInteger.valueOf(0x100000000L));
            result = result.add(BigInteger.valueOf(low));
            return new PyLong(result);
        }
    }

    static class LEUnsignedLongFormatDef
    extends FormatDef {
        LEUnsignedLongFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            BigInteger bi = this.get_ulong(value);
            if (bi.compareTo(BigInteger.valueOf(0L)) < 0) {
                throw struct.StructError("can't convert negative long to unsigned");
            }
            long lvalue = bi.longValue();
            int high = (int)((lvalue & 0xFFFFFFFF00000000L) >> 32);
            int low = (int)(lvalue & 0xFFFFFFFFL);
            this.LEwriteInt(buf, low);
            this.LEwriteInt(buf, high);
        }

        Object unpack(ByteStream buf) {
            long low = (long)this.LEreadInt(buf) & 0xFFFFFFFFL;
            long high = (long)this.LEreadInt(buf) & 0xFFFFFFFFL;
            BigInteger result = BigInteger.valueOf(high);
            result = result.multiply(BigInteger.valueOf(0x100000000L));
            result = result.add(BigInteger.valueOf(low));
            return new PyLong(result);
        }
    }

    static class BEUnsignedIntFormatDef
    extends FormatDef {
        BEUnsignedIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.BEwriteInt(buf, (int)(this.get_long(value) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long v = this.BEreadInt(buf);
            if (v < 0L) {
                v += 0x100000000L;
            }
            return new PyLong(v);
        }
    }

    static class BEIntFormatDef
    extends FormatDef {
        BEIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.BEwriteInt(buf, this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            return Py.newInteger(this.BEreadInt(buf));
        }
    }

    static class LEUnsignedIntFormatDef
    extends FormatDef {
        LEUnsignedIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.LEwriteInt(buf, (int)(this.get_long(value) & 0xFFFFFFFFFFFFFFFFL));
        }

        Object unpack(ByteStream buf) {
            long v = this.LEreadInt(buf);
            if (v < 0L) {
                v += 0x100000000L;
            }
            return new PyLong(v);
        }
    }

    static class LEIntFormatDef
    extends FormatDef {
        LEIntFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            this.LEwriteInt(buf, this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            int v = this.LEreadInt(buf);
            return Py.newInteger(v);
        }
    }

    static class BEUnsignedShortFormatDef
    extends BEShortFormatDef {
        BEUnsignedShortFormatDef() {
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() << 8 | buf.readByte();
            return Py.newInteger(v);
        }
    }

    static class BEShortFormatDef
    extends FormatDef {
        BEShortFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int v = this.get_int(value);
            buf.writeByte(v >> 8 & 0xFF);
            buf.writeByte(v & 0xFF);
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() << 8 | buf.readByte();
            if (v > Short.MAX_VALUE) {
                v -= 65536;
            }
            return Py.newInteger(v);
        }
    }

    static class LEUnsignedShortFormatDef
    extends LEShortFormatDef {
        LEUnsignedShortFormatDef() {
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() | buf.readByte() << 8;
            return Py.newInteger(v);
        }
    }

    static class LEShortFormatDef
    extends FormatDef {
        LEShortFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            int v = this.get_int(value);
            buf.writeByte(v & 0xFF);
            buf.writeByte(v >> 8 & 0xFF);
        }

        Object unpack(ByteStream buf) {
            int v = buf.readByte() | buf.readByte() << 8;
            if (v > Short.MAX_VALUE) {
                v -= 65536;
            }
            return Py.newInteger(v);
        }
    }

    static class UnsignedByteFormatDef
    extends ByteFormatDef {
        UnsignedByteFormatDef() {
        }

        Object unpack(ByteStream buf) {
            return Py.newInteger(buf.readByte());
        }
    }

    static class ByteFormatDef
    extends FormatDef {
        ByteFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            buf.writeByte(this.get_int(value));
        }

        Object unpack(ByteStream buf) {
            int b2 = buf.readByte();
            if (b2 > 127) {
                b2 -= 256;
            }
            return Py.newInteger(b2);
        }
    }

    static class CharFormatDef
    extends FormatDef {
        CharFormatDef() {
        }

        void pack(ByteStream buf, PyObject value) {
            if (!(value instanceof PyString) || value.__len__() != 1) {
                throw struct.StructError("char format require string of length 1");
            }
            buf.writeByte(value.toString().charAt(0));
        }

        Object unpack(ByteStream buf) {
            return Py.newString((char)buf.readByte());
        }
    }

    static class PascalStringFormatDef
    extends StringFormatDef {
        PascalStringFormatDef() {
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            PyObject value = args[pos];
            if (!(value instanceof PyString)) {
                throw struct.StructError("argument for 'p' must be a string");
            }
            buf.writeByte(Math.min(255, Math.min(value.toString().length(), count - 1)));
            return super.doPack(buf, count - 1, pos, args);
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            int n2 = buf.readByte();
            if (n2 >= count) {
                n2 = count - 1;
            }
            super.doUnpack(buf, n2, list);
            buf.skip(Math.max(count - n2 - 1, 0));
        }
    }

    static class StringFormatDef
    extends FormatDef {
        StringFormatDef() {
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            PyObject value = args[pos];
            if (!(value instanceof PyString)) {
                throw struct.StructError("argument for 's' must be a string");
            }
            String s = value.toString();
            int len = s.length();
            buf.writeString(s, 0, Math.min(count, len));
            if (len < count) {
                count -= len;
                for (int i2 = 0; i2 < count; ++i2) {
                    buf.writeByte(0);
                }
            }
            return 1;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            list.append(Py.newString(buf.readString(count)));
        }
    }

    static class PadFormatDef
    extends FormatDef {
        PadFormatDef() {
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            while (count-- > 0) {
                buf.writeByte(0);
            }
            return 0;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            while (count-- > 0) {
                buf.readByte();
            }
        }
    }

    static class ByteStream {
        char[] data;
        int len;
        int pos;

        ByteStream() {
            this.data = new char[10];
            this.len = 0;
            this.pos = 0;
        }

        ByteStream(String s) {
            this(s, 0);
        }

        ByteStream(String s, int offset) {
            int size = s.length() - offset;
            this.data = new char[size];
            s.getChars(offset, s.length(), this.data, 0);
            this.len = size;
            this.pos = 0;
        }

        int readByte() {
            return this.data[this.pos++] & 0xFF;
        }

        void read(char[] buf, int pos, int len) {
            System.arraycopy(this.data, this.pos, buf, pos, len);
            this.pos += len;
        }

        String readString(int l2) {
            char[] data = new char[l2];
            this.read(data, 0, l2);
            return new String(data);
        }

        private void ensureCapacity(int l2) {
            if (this.pos + l2 >= this.data.length) {
                char[] b2 = new char[(this.pos + l2) * 2];
                System.arraycopy(this.data, 0, b2, 0, this.pos);
                this.data = b2;
            }
        }

        void writeByte(int b2) {
            this.ensureCapacity(1);
            this.data[this.pos++] = (char)(b2 & 0xFF);
        }

        void write(char[] buf, int pos, int len) {
            this.ensureCapacity(len);
            System.arraycopy(buf, pos, this.data, this.pos, len);
            this.pos += len;
        }

        void writeString(String s, int pos, int len) {
            char[] data = new char[len];
            s.getChars(pos, len, data, 0);
            this.write(data, 0, len);
        }

        int skip(int l2) {
            this.pos += l2;
            return this.pos;
        }

        int size() {
            return this.pos;
        }

        public String toString() {
            return new String(this.data, 0, this.pos);
        }
    }

    static class FormatDef {
        char name;
        int size;
        int alignment;

        FormatDef() {
        }

        FormatDef init(char name, int size, int alignment) {
            this.name = name;
            this.size = size;
            this.alignment = alignment;
            return this;
        }

        void pack(ByteStream buf, PyObject value) {
        }

        Object unpack(ByteStream buf) {
            return null;
        }

        int doPack(ByteStream buf, int count, int pos, PyObject[] args) {
            if (pos + count > args.length) {
                throw struct.StructError("insufficient arguments to pack");
            }
            int cnt = count;
            while (count-- > 0) {
                this.pack(buf, args[pos++]);
            }
            return cnt;
        }

        void doUnpack(ByteStream buf, int count, PyList list) {
            while (count-- > 0) {
                list.append(Py.java2py(this.unpack(buf)));
            }
        }

        int get_int(PyObject value) {
            try {
                return value.asInt();
            }
            catch (PyException ex) {
                throw struct.StructError("required argument is not an integer");
            }
        }

        long get_long(PyObject value) {
            if (value instanceof PyLong) {
                Object v = value.__tojava__(Long.TYPE);
                if (v == Py.NoConversion) {
                    throw struct.StructError("long int too long to convert");
                }
                return (Long)v;
            }
            return this.get_int(value);
        }

        BigInteger get_ulong(PyObject value) {
            if (value instanceof PyLong) {
                BigInteger v = (BigInteger)value.__tojava__(BigInteger.class);
                if (v.compareTo(PyLong.maxULong) > 0) {
                    throw struct.StructError("unsigned long int too long to convert");
                }
                return v;
            }
            return BigInteger.valueOf(this.get_int(value));
        }

        double get_float(PyObject value) {
            return value.__float__().getValue();
        }

        void BEwriteInt(ByteStream buf, int v) {
            buf.writeByte(v >>> 24 & 0xFF);
            buf.writeByte(v >>> 16 & 0xFF);
            buf.writeByte(v >>> 8 & 0xFF);
            buf.writeByte(v >>> 0 & 0xFF);
        }

        void LEwriteInt(ByteStream buf, int v) {
            buf.writeByte(v >>> 0 & 0xFF);
            buf.writeByte(v >>> 8 & 0xFF);
            buf.writeByte(v >>> 16 & 0xFF);
            buf.writeByte(v >>> 24 & 0xFF);
        }

        int BEreadInt(ByteStream buf) {
            int b1 = buf.readByte();
            int b2 = buf.readByte();
            int b3 = buf.readByte();
            int b4 = buf.readByte();
            return (b1 << 24) + (b2 << 16) + (b3 << 8) + (b4 << 0);
        }

        int LEreadInt(ByteStream buf) {
            int b1 = buf.readByte();
            int b2 = buf.readByte();
            int b3 = buf.readByte();
            int b4 = buf.readByte();
            return (b1 << 0) + (b2 << 8) + (b3 << 16) + (b4 << 24);
        }
    }
}

