/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._csv;

import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.expose.ExposedType;
import org.python.modules._csv.PyDialect;
import org.python.modules._csv.PyReader$PyExposer;
import org.python.modules._csv.QuoteStyle;
import org.python.modules._csv._csv;

@ExposedType(name="_csv.reader")
public class PyReader
extends PyIterator {
    public static final PyType TYPE;
    public PyString __doc__ = Py.newString("CSV reader\n\nReader objects are responsible for reading and parsing tabular data\nin CSV format.\n");
    public PyDialect dialect;
    public int line_num = 0;
    private PyObject input_iter;
    private ParserState state = ParserState.START_RECORD;
    private PyList fields = new PyList();
    private StringBuffer field = new StringBuffer(4096);
    private boolean numeric_field = false;
    private static final int INITIAL_BUILDER_CAPACITY = 4096;

    public PyReader(PyObject input_iter, PyDialect dialect) {
        this.input_iter = input_iter;
        this.dialect = dialect;
    }

    /*
     * WARNING - void declaration
     */
    public PyObject __iternext__() {
        this.parse_reset();
        do {
            PyObject lineobj;
            if ((lineobj = this.input_iter.__iternext__()) == null) {
                if (this.field.length() != 0) {
                    throw _csv.Error("newline inside string");
                }
                return null;
            }
            ++this.line_num;
            String string = lineobj.toString();
            int line = string.length();
            int n2 = 0;
            while (n2 < line) {
                void c2;
                char linelen = string.charAt(n2);
                if (linelen == '\u0000') {
                    throw _csv.Error("line contains NULL byte");
                }
                this.parse_process_char(linelen);
                ++c2;
            }
            this.parse_process_char('\u0000');
        } while (this.state != ParserState.START_RECORD);
        PyList pyList = this.fields;
        this.fields = new PyList();
        return pyList;
    }

    private void parse_process_char(char c2) {
        switch (this.state) {
            case START_RECORD: {
                if (c2 == '\u0000') break;
                if (c2 == '\n' || c2 == '\r') {
                    this.state = ParserState.EAT_CRNL;
                    break;
                }
                this.state = ParserState.START_FIELD;
            }
            case START_FIELD: {
                if (c2 == '\n' || c2 == '\r' || c2 == '\u0000') {
                    this.parse_save_field();
                    this.state = c2 == '\u0000' ? ParserState.START_RECORD : ParserState.EAT_CRNL;
                    break;
                }
                if (c2 == this.dialect.quotechar && this.dialect.quoting != QuoteStyle.QUOTE_NONE) {
                    this.state = ParserState.IN_QUOTED_FIELD;
                    break;
                }
                if (c2 == this.dialect.escapechar) {
                    this.state = ParserState.ESCAPED_CHAR;
                    break;
                }
                if (c2 == ' ' && this.dialect.skipinitialspace) break;
                if (c2 == this.dialect.delimiter) {
                    this.parse_save_field();
                    break;
                }
                if (this.dialect.quoting == QuoteStyle.QUOTE_NONNUMERIC) {
                    this.numeric_field = true;
                }
                this.parse_add_char(c2);
                this.state = ParserState.IN_FIELD;
                break;
            }
            case ESCAPED_CHAR: {
                if (c2 == '\u0000') {
                    c2 = (char)10;
                }
                this.parse_add_char(c2);
                this.state = ParserState.IN_FIELD;
                break;
            }
            case IN_FIELD: {
                if (c2 == '\n' || c2 == '\r' || c2 == '\u0000') {
                    this.parse_save_field();
                    this.state = c2 == '\u0000' ? ParserState.START_RECORD : ParserState.EAT_CRNL;
                    break;
                }
                if (c2 == this.dialect.escapechar) {
                    this.state = ParserState.ESCAPED_CHAR;
                    break;
                }
                if (c2 == this.dialect.delimiter) {
                    this.parse_save_field();
                    this.state = ParserState.START_FIELD;
                    break;
                }
                this.parse_add_char(c2);
                break;
            }
            case IN_QUOTED_FIELD: {
                if (c2 == '\u0000') break;
                if (c2 == this.dialect.escapechar) {
                    this.state = ParserState.ESCAPE_IN_QUOTED_FIELD;
                    break;
                }
                if (c2 == this.dialect.quotechar && this.dialect.quoting != QuoteStyle.QUOTE_NONE) {
                    if (this.dialect.doublequote) {
                        this.state = ParserState.QUOTE_IN_QUOTED_FIELD;
                        break;
                    }
                    this.state = ParserState.IN_FIELD;
                    break;
                }
                this.parse_add_char(c2);
                break;
            }
            case ESCAPE_IN_QUOTED_FIELD: {
                if (c2 == '\u0000') {
                    c2 = (char)10;
                }
                this.parse_add_char(c2);
                this.state = ParserState.IN_QUOTED_FIELD;
                break;
            }
            case QUOTE_IN_QUOTED_FIELD: {
                if (this.dialect.quoting != QuoteStyle.QUOTE_NONE && c2 == this.dialect.quotechar) {
                    this.parse_add_char(c2);
                    this.state = ParserState.IN_QUOTED_FIELD;
                    break;
                }
                if (c2 == this.dialect.delimiter) {
                    this.parse_save_field();
                    this.state = ParserState.START_FIELD;
                    break;
                }
                if (c2 == '\n' || c2 == '\r' || c2 == '\u0000') {
                    this.parse_save_field();
                    this.state = c2 == '\u0000' ? ParserState.START_RECORD : ParserState.EAT_CRNL;
                    break;
                }
                if (!this.dialect.strict) {
                    this.parse_add_char(c2);
                    this.state = ParserState.IN_FIELD;
                    break;
                }
                throw _csv.Error(String.format("'%c' expected after '%c'", Character.valueOf(this.dialect.delimiter), Character.valueOf(this.dialect.quotechar)));
            }
            case EAT_CRNL: {
                if (c2 == '\n' || c2 == '\r') break;
                if (c2 == '\u0000') {
                    this.state = ParserState.START_RECORD;
                    break;
                }
                String err = "new-line character seen in unquoted field - do you need to open the file in universal-newline mode?";
                throw _csv.Error(err);
            }
        }
    }

    private void parse_reset() {
        this.fields = new PyList();
        this.state = ParserState.START_RECORD;
        this.numeric_field = false;
    }

    private void parse_save_field() {
        PyObject field = new PyString(this.field.toString());
        if (this.numeric_field) {
            this.numeric_field = false;
            field = ((PyObject)field).__float__();
        }
        this.fields.append(field);
        this.field = new StringBuffer(4096);
    }

    private void parse_add_char(char c2) {
        int field_len = this.field.length();
        if (field_len >= _csv.field_limit) {
            throw _csv.Error(String.format("field larger than field limit (%d)", _csv.field_limit));
        }
        this.field.append(c2);
    }

    static {
        PyType.addBuilder(PyReader.class, new PyReader$PyExposer());
        TYPE = PyType.fromClass(PyReader.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParserState {
        START_RECORD,
        START_FIELD,
        ESCAPED_CHAR,
        IN_FIELD,
        IN_QUOTED_FIELD,
        ESCAPE_IN_QUOTED_FIELD,
        QUOTE_IN_QUOTED_FIELD,
        EAT_CRNL;

    }
}

