/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._collections;

import org.python.core.Py;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyException;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.ThreadState;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._collections.PyDeque$PyExposer;

@ExposedType(name="collections.deque")
public class PyDeque
extends PyObject {
    public static final PyType TYPE;
    private int size = 0;
    private Node header = new Node(null, null, null);

    public PyDeque() {
        this(TYPE);
    }

    public PyDeque(PyType subType) {
        super(subType);
        this.header.left = (this.header.right = this.header);
    }

    @ExposedNew
    final void deque___init__(PyObject[] args, String[] kwds) {
        if (kwds.length > 0) {
            throw Py.TypeError("deque() does not take keyword arguments");
        }
        int nargs = args.length;
        if (nargs > 1) {
            throw PyBuiltinCallable.DefaultInfo.unexpectedCall(nargs, false, "deque", 0, 1);
        }
        if (nargs == 0) {
            return;
        }
        this.deque_extend(args[0]);
    }

    final void deque_append(PyObject obj) {
        this.addBefore(obj, this.header);
    }

    final void deque_appendleft(PyObject obj) {
        this.addBefore(obj, this.header.right);
    }

    private Node addBefore(PyObject obj, Node node) {
        Node newNode = new Node(obj, node, node.left);
        newNode.left.right = newNode;
        newNode.right.left = newNode;
        ++this.size;
        return newNode;
    }

    final void deque_clear() {
        Node node = this.header.right;
        while (node != this.header) {
            Node right = node.right;
            node.left = null;
            node.right = null;
            node.data = null;
            node = right;
        }
        this.header.right = (this.header.left = this.header);
        this.size = 0;
    }

    final void deque_extend(PyObject iterable) {
        for (PyObject item : iterable.asIterable()) {
            this.deque_append(item);
        }
    }

    final void deque_extendleft(PyObject iterable) {
        for (PyObject item : iterable.asIterable()) {
            this.deque_appendleft(item);
        }
    }

    final PyObject deque_pop() {
        return this.removeNode(this.header.left);
    }

    final PyObject deque_popleft() {
        return this.removeNode(this.header.right);
    }

    private PyObject removeNode(Node node) {
        if (node == this.header) {
            throw Py.IndexError("pop from an empty deque");
        }
        PyObject obj = node.data;
        node.left.right = node.right;
        node.right.left = node.left;
        node.right = null;
        node.left = null;
        node.data = null;
        --this.size;
        return obj;
    }

    final PyObject deque_remove(PyObject value) {
        int n2 = this.size;
        Node tmp = this.header.right;
        boolean match = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (tmp.data.equals(value)) {
                match = true;
            }
            if (n2 != this.size) {
                throw Py.IndexError("deque mutated during remove().");
            }
            if (match) {
                return this.removeNode(tmp);
            }
            tmp = tmp.right;
        }
        throw Py.ValueError("deque.remove(x): x not in deque");
    }

    final void deque_rotate(int steps) {
        int i2;
        if (this.size == 0) {
            return;
        }
        int halfsize = this.size + 1 >> 1;
        if (steps > halfsize || steps < -halfsize) {
            if ((steps %= this.size) > halfsize) {
                steps -= this.size;
            } else if (steps < -halfsize) {
                steps += this.size;
            }
        }
        for (i2 = 0; i2 < steps; ++i2) {
            this.deque_appendleft(this.deque_pop());
        }
        for (i2 = 0; i2 > steps; --i2) {
            this.deque_append(this.deque_popleft());
        }
    }

    public String toString() {
        return this.deque_toString();
    }

    final String deque_toString() {
        ThreadState ts = Py.getThreadState();
        if (!ts.enterRepr(this)) {
            return "[...]";
        }
        StringBuilder buf = new StringBuilder("deque").append("([");
        Node tmp = this.header.right;
        while (tmp != this.header) {
            buf.append(tmp.data.__repr__().toString());
            if (tmp.right != this.header) {
                buf.append(", ");
            }
            tmp = tmp.right;
        }
        buf.append("])");
        ts.exitRepr(this);
        return buf.toString();
    }

    public int __len__() {
        return this.deque___len__();
    }

    final int deque___len__() {
        return this.size;
    }

    public boolean __nonzero__() {
        return this.deque___nonzero__();
    }

    final boolean deque___nonzero__() {
        return this.size != 0;
    }

    public PyObject __finditem__(PyObject key) {
        try {
            return this.deque___getitem__(key);
        }
        catch (PyException pe) {
            if (pe.match(Py.KeyError)) {
                return null;
            }
            throw pe;
        }
    }

    final PyObject deque___getitem__(PyObject index) {
        return this.getNode(index).data;
    }

    public void __setitem__(PyObject index, PyObject value) {
        this.deque___setitem__(index, value);
    }

    final void deque___setitem__(PyObject index, PyObject value) {
        Node node = this.getNode(index).right;
        this.removeNode(node.left);
        this.addBefore(value, node);
    }

    public void __delitem__(PyObject key) {
        this.deque___delitem__(key);
    }

    final void deque___delitem__(PyObject key) {
        this.removeNode(this.getNode(key));
    }

    private Node getNode(PyObject index) {
        int pos = 0;
        if (!index.isIndex()) {
            throw Py.TypeError(String.format("sequence index must be integer, not '%.200s'", index.getType().fastGetName()));
        }
        pos = index.asIndex(Py.IndexError);
        if (pos < 0) {
            pos += this.size;
        }
        if (pos < 0 || pos >= this.size) {
            throw Py.IndexError("index out of range: " + index);
        }
        Node tmp = this.header;
        if (pos < this.size >> 1) {
            for (int i2 = 0; i2 <= pos; ++i2) {
                tmp = tmp.right;
            }
        } else {
            for (int i3 = this.size - 1; i3 >= pos; --i3) {
                tmp = tmp.left;
            }
        }
        return tmp;
    }

    public PyObject __iter__() {
        return this.deque___iter__();
    }

    final PyObject deque___iter__() {
        return new PyDequeIter();
    }

    public synchronized PyObject __eq__(PyObject o2) {
        return this.deque___eq__(o2);
    }

    final synchronized PyObject deque___eq__(PyObject o2) {
        int ol;
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o2.__len__())) {
            return Py.False;
        }
        int i2 = PyDeque.cmp(this, tl, o2, ol);
        return i2 < 0 ? Py.True : Py.False;
    }

    public synchronized PyObject __ne__(PyObject o2) {
        return this.deque___ne__(o2);
    }

    final synchronized PyObject deque___ne__(PyObject o2) {
        int ol;
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o2.__len__())) {
            return Py.True;
        }
        int i2 = PyDeque.cmp(this, tl, o2, ol);
        return i2 < 0 ? Py.False : Py.True;
    }

    public synchronized PyObject __lt__(PyObject o2) {
        return this.deque___lt__(o2);
    }

    final synchronized PyObject deque___lt__(PyObject o2) {
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int i2 = PyDeque.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._lt(o2.__finditem__(i2));
    }

    public synchronized PyObject __le__(PyObject o2) {
        return this.deque___le__(o2);
    }

    final synchronized PyObject deque___le__(PyObject o2) {
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int i2 = PyDeque.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -1 || i2 == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._le(o2.__finditem__(i2));
    }

    public synchronized PyObject __gt__(PyObject o2) {
        return this.deque___gt__(o2);
    }

    final synchronized PyObject deque___gt__(PyObject o2) {
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int i2 = PyDeque.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._gt(o2.__finditem__(i2));
    }

    public synchronized PyObject __ge__(PyObject o2) {
        return this.deque___ge__(o2);
    }

    final synchronized PyObject deque___ge__(PyObject o2) {
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int i2 = PyDeque.cmp(this, -1, o2, -1);
        if (i2 < 0) {
            return i2 == -3 || i2 == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i2)._ge(o2.__finditem__(i2));
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i2 = 0; i2 < ol1 && i2 < ol2; ++i2) {
            if (o1.__getitem__(i2).equals(o2.__getitem__(i2))) continue;
            return i2;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    public int hashCode() {
        return this.deque_hashCode();
    }

    final int deque_hashCode() {
        throw Py.TypeError("deque objects are unhashable");
    }

    public PyObject __reduce__() {
        return this.deque___reduce__();
    }

    final PyObject deque___reduce__() {
        PyObject dict = this.getDict();
        if (dict == null) {
            dict = Py.None;
        }
        return new PyTuple(this.getType(), Py.EmptyTuple, dict, this.__iter__());
    }

    final PyObject deque___copy__() {
        PyDeque pd = (PyDeque)this.getType().__call__();
        pd.deque_extend(this);
        return pd;
    }

    static {
        PyType.addBuilder(PyDeque.class, new PyDeque$PyExposer());
        TYPE = PyType.fromClass(PyDeque.class);
    }

    private class PyDequeIter
    extends PyIterator {
        private Node lastReturned;
        private int itersize;

        public PyDequeIter() {
            this.lastReturned = PyDeque.this.header;
            this.itersize = PyDeque.this.size;
        }

        public PyObject __iternext__() {
            if (this.itersize != PyDeque.this.size) {
                throw Py.RuntimeError("deque changed size during iteration");
            }
            if (this.lastReturned.right != PyDeque.this.header) {
                this.lastReturned = this.lastReturned.right;
                return this.lastReturned.data;
            }
            return null;
        }
    }

    private static class Node {
        private Node left;
        private Node right;
        private PyObject data;

        Node(PyObject data, Node right, Node left) {
            this.data = data;
            this.right = right;
            this.left = left;
        }
    }
}

