/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PyString;
import org.python.core.imp;
import org.python.core.packagecache.CachedJarsPackageManager;
import org.python.core.util.RelativeFile;

public abstract class PathPackageManager
extends CachedJarsPackageManager {
    public PyList searchPath = new PyList();

    protected boolean packageExists(PyList path, String pkg, String name) {
        String child = pkg.replace('.', File.separatorChar) + File.separator + name;
        for (int i2 = 0; i2 < path.__len__(); ++i2) {
            String dir2 = path.pyget(i2).__str__().toString();
            RelativeFile f2 = new RelativeFile(dir2, child);
            try {
                if (!f2.isDirectory() || !imp.caseok(f2, name)) continue;
                PackageExistsFileFilter m2 = new PackageExistsFileFilter();
                f2.listFiles(m2);
                boolean exists = m2.packageExists();
                if (exists) {
                    Py.writeComment("import", "java package as '" + f2.getAbsolutePath() + "'");
                }
                return exists;
            }
            catch (SecurityException se) {
                return false;
            }
        }
        return false;
    }

    protected void doDir(PyList path, PyList ret, PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        String child = jpkg.__name__.replace('.', File.separatorChar);
        for (int i2 = 0; i2 < path.__len__(); ++i2) {
            File childFile;
            String[] list;
            String dir2 = path.pyget(i2).__str__().toString();
            if (dir2.length() == 0) {
                dir2 = null;
            }
            if ((list = (childFile = new File(dir2, child)).list()) == null) continue;
            block3: for (int j2 = 0; j2 < list.length; ++j2) {
                String jname = list[j2];
                File cand = new File(childFile, jname);
                int jlen = jname.length();
                boolean pkgCand = false;
                if (cand.isDirectory()) {
                    if (!instantiate && exclpkgs) continue;
                    pkgCand = true;
                } else {
                    if (!jname.endsWith(".class")) continue;
                    jlen -= 6;
                }
                jname = jname.substring(0, jlen);
                PyString name = new PyString(jname);
                if (this.filterByName(jname, pkgCand) || jpkg.__dict__.has_key(name) || jpkg.clsSet.has_key(name) || ret.__contains__(name) || !Character.isJavaIdentifierStart(jname.charAt(0))) continue;
                for (int k2 = 1; k2 < jlen; ++k2) {
                    if (!Character.isJavaIdentifierPart(jname.charAt(k2))) continue block3;
                }
                if (!pkgCand) {
                    try {
                        int acc = PathPackageManager.checkAccess(new BufferedInputStream(new FileInputStream(cand)));
                        if (acc == -1) continue;
                        if (this.filterByAccess(jname, acc)) {
                        }
                    }
                    catch (IOException e2) {}
                    continue;
                }
                if (instantiate) {
                    if (pkgCand) {
                        jpkg.addPackage(jname);
                    } else {
                        jpkg.addClass(jname, Py.findClass(jpkg.__name__ + "." + jname));
                    }
                }
                ret.append(name);
            }
        }
    }

    public void addDirectory(File dir2) {
        try {
            if (dir2.getPath().length() == 0) {
                this.searchPath.append(Py.EmptyString);
            } else {
                this.searchPath.append(new PyString(dir2.getCanonicalPath()));
            }
        }
        catch (IOException e2) {
            this.warning("skipping bad directory, '" + dir2 + "'");
        }
    }

    public void addClassPath(String path) {
        PyList paths = new PyString(path).split(File.pathSeparator);
        for (int i2 = 0; i2 < paths.__len__(); ++i2) {
            String entry = paths.pyget(i2).toString();
            if (entry.endsWith(".jar") || entry.endsWith(".zip")) {
                this.addJarToPackages(new File(entry), true);
                continue;
            }
            File dir2 = new File(entry);
            if (entry.length() != 0 && !dir2.isDirectory()) continue;
            this.addDirectory(dir2);
        }
    }

    public PyList doDir(PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        PyList basic = this.basicDoDir(jpkg, instantiate, exclpkgs);
        PyList ret = new PyList();
        this.doDir(this.searchPath, ret, jpkg, instantiate, exclpkgs);
        return this.merge(basic, ret);
    }

    public boolean packageExists(String pkg, String name) {
        return this.packageExists(this.searchPath, pkg, name);
    }

    private static class PackageExistsFileFilter
    implements FilenameFilter {
        private boolean java;
        private boolean python;

        private PackageExistsFileFilter() {
        }

        public boolean accept(File dir2, String name) {
            if (name.endsWith(".py") || name.endsWith("$py.class") || name.endsWith("$_PyInner.class")) {
                this.python = true;
            } else if (name.endsWith(".class")) {
                this.java = true;
            }
            return false;
        }

        public boolean packageExists() {
            return !this.python || this.java;
        }
    }
}

