/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.lang.reflect.Method;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBaseException;
import org.python.core.PyBuiltinCallable;
import org.python.core.PyBuiltinMethod;
import org.python.core.PyFrame;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.ThreadState;
import org.python.modules.zipimport.zipimport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class exceptions
extends PyObject
implements ClassDictInit {
    public static String __doc__ = "Python's standard exception class hierarchy.\n\nExceptions found here are defined both in the exceptions module and the\nbuilt-in namespace.  It is recommended that user-defined exceptions\ninherit from Exception.  See the documentation for the exception\ninheritance hierarchy.\n";

    public static void classDictInit(PyObject dict) {
        dict.invoke("clear");
        dict.__setitem__("__name__", (PyObject)new PyString("exceptions"));
        dict.__setitem__("__doc__", (PyObject)new PyString(__doc__));
        ThreadState ts = Py.getThreadState();
        if (ts.systemState == null) {
            ts.systemState = Py.defaultSystemState;
        }
        PyFrame frame = new PyFrame(null, new PyStringMap());
        frame.f_back = ts.frame;
        if (frame.f_builtins == null) {
            frame.f_builtins = frame.f_back != null ? frame.f_back.f_builtins : PySystemState.getDefaultBuiltins();
        }
        ts.frame = frame;
        PyObject baseExcDict = PyBaseException.TYPE.fastGetDict();
        baseExcDict.__setitem__("__doc__", (PyObject)Py.newString("Common base class for all exceptions"));
        dict.__setitem__("BaseException", (PyObject)PyBaseException.TYPE);
        exceptions.buildClass(dict, "KeyboardInterrupt", "BaseException", "Program interrupted by user.");
        exceptions.buildClass(dict, "SystemExit", "BaseException", exceptions.SystemExit(), "Request to exit from the interpreter.");
        exceptions.buildClass(dict, "Exception", "BaseException", "Common base class for all non-exit exceptions.");
        exceptions.buildClass(dict, "StandardError", "Exception", "Base class for all standard Python exceptions that do not represent\ninterpreter exiting.");
        exceptions.buildClass(dict, "SyntaxError", "StandardError", exceptions.SyntaxError(), "Invalid syntax.");
        exceptions.buildClass(dict, "IndentationError", "SyntaxError", "Improper indentation.");
        exceptions.buildClass(dict, "TabError", "IndentationError", "Improper mixture of spaces and tabs.");
        exceptions.buildClass(dict, "EnvironmentError", "StandardError", exceptions.EnvironmentError(), "Base class for I/O related errors.");
        exceptions.buildClass(dict, "IOError", "EnvironmentError", "I/O operation failed.");
        exceptions.buildClass(dict, "OSError", "EnvironmentError", "OS system call failed.");
        exceptions.buildClass(dict, "RuntimeError", "StandardError", "Unspecified run-time error.");
        exceptions.buildClass(dict, "NotImplementedError", "RuntimeError", "Method or function hasn't been implemented yet.");
        exceptions.buildClass(dict, "SystemError", "StandardError", "Internal error in the Python interpreter.\n\nPlease report this to the Python maintainer, along with the traceback,\nthe Python version, and the hardware/OS platform and version.");
        exceptions.buildClass(dict, "ReferenceError", "StandardError", "Weak ref proxy used after referent went away.");
        exceptions.buildClass(dict, "EOFError", "StandardError", "Read beyond end of file.");
        exceptions.buildClass(dict, "ImportError", "StandardError", "Import can't find module, or can't find name in module.");
        exceptions.buildClass(dict, "TypeError", "StandardError", "Inappropriate argument type.");
        exceptions.buildClass(dict, "ValueError", "StandardError", "Inappropriate argument value (of correct type).");
        exceptions.buildClass(dict, "UnicodeError", "ValueError", "Unicode related error.");
        exceptions.buildClass(dict, "UnicodeEncodeError", "UnicodeError", exceptions.UnicodeEncodeError(), "Unicode encoding error.");
        exceptions.buildClass(dict, "UnicodeDecodeError", "UnicodeError", exceptions.UnicodeDecodeError(), "Unicode decoding error.");
        exceptions.buildClass(dict, "UnicodeTranslateError", "UnicodeError", exceptions.UnicodeTranslateError(), "Unicode translation error.");
        exceptions.buildClass(dict, "AssertionError", "StandardError", "Assertion failed.");
        exceptions.buildClass(dict, "ArithmeticError", "StandardError", "Base class for arithmetic errors.");
        exceptions.buildClass(dict, "OverflowError", "ArithmeticError", "Result too large to be represented.");
        exceptions.buildClass(dict, "FloatingPointError", "ArithmeticError", "Floating point operation failed.");
        exceptions.buildClass(dict, "ZeroDivisionError", "ArithmeticError", "Second argument to a division or modulo operation was zero.");
        exceptions.buildClass(dict, "LookupError", "StandardError", "Base class for lookup errors.");
        exceptions.buildClass(dict, "IndexError", "LookupError", "Sequence index out of range.");
        exceptions.buildClass(dict, "KeyError", "LookupError", exceptions.KeyError(), "Mapping key not found.");
        exceptions.buildClass(dict, "AttributeError", "StandardError", "Attribute not found.");
        exceptions.buildClass(dict, "NameError", "StandardError", "Name not found globally.");
        exceptions.buildClass(dict, "UnboundLocalError", "NameError", "Local name referenced but not bound to a value.");
        exceptions.buildClass(dict, "MemoryError", "StandardError", "Out of memory.");
        exceptions.buildClass(dict, "StopIteration", "Exception", "Signal the end from iterator.next().");
        exceptions.buildClass(dict, "GeneratorExit", "Exception", "Request that a generator exit.");
        exceptions.buildClass(dict, "Warning", "Exception", "Base class for warning categories.");
        exceptions.buildClass(dict, "UserWarning", "Warning", "Base class for warnings generated by user code.");
        exceptions.buildClass(dict, "DeprecationWarning", "Warning", "Base class for warnings about deprecated features.");
        exceptions.buildClass(dict, "PendingDeprecationWarning", "Warning", "Base class for warnings about features which will be deprecated\nin the future.");
        exceptions.buildClass(dict, "SyntaxWarning", "Warning", "Base class for warnings about dubious syntax.");
        exceptions.buildClass(dict, "RuntimeWarning", "Warning", "Base class for warnings about dubious runtime behavior.");
        exceptions.buildClass(dict, "FutureWarning", "Warning", "Base class for warnings about constructs that will change semantically\nin the future.");
        exceptions.buildClass(dict, "ImportWarning", "Warning", "Base class for warnings about probable mistakes in module imports");
        exceptions.buildClass(dict, "UnicodeWarning", "Warning", "Base class for warnings about Unicode related problems, mostly\nrelated to conversion problems.");
        zipimport.initClassExceptions(dict);
        ts.frame = ts.frame.f_back;
    }

    public static PyObject SyntaxError() {
        PyStringMap __dict__ = new PyStringMap();
        exceptions.defineSlots(__dict__, "msg", "filename", "lineno", "offset", "text", "print_file_and_line");
        ((PyObject)__dict__).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "SyntaxError__init__"));
        ((PyObject)__dict__).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "SyntaxError__str__"));
        return __dict__;
    }

    public static void SyntaxError__init__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException.TYPE.invoke("__init__", self, args, kwargs);
        exceptions.initSlots(self);
        if (args.length >= 1) {
            self.__setattr__("msg", args[0]);
        }
        if (args.length == 2) {
            PyObject[] info = Py.make_array(args[1]);
            if (info.length != 4) {
                throw Py.IndexError("tuple index out of range");
            }
            self.__setattr__("filename", info[0]);
            self.__setattr__("lineno", info[1]);
            self.__setattr__("offset", info[2]);
            self.__setattr__("text", info[3]);
        }
    }

    public static PyString SyntaxError__str__(PyObject self, PyObject[] arg, String[] kwargs) {
        PyObject msg = self.__getattr__("msg");
        PyString str = msg.__str__();
        if (!(msg instanceof PyString)) {
            return Py.newString(((PyObject)str).toString());
        }
        PyObject filename = self.__findattr__("filename");
        PyObject lineno = self.__findattr__("lineno");
        boolean haveFilename = filename instanceof PyString;
        boolean haveLieno = lineno instanceof PyInteger;
        if (!haveFilename && !haveLieno) {
            return str;
        }
        String result = haveFilename && haveLieno ? String.format("%s (%s, line %d)", str, exceptions.basename(filename.toString()), lineno.asInt()) : (haveFilename ? String.format("%s (%s)", str, exceptions.basename(filename.toString())) : String.format("%s (line %d)", str, lineno.asInt()));
        return Py.newString(result);
    }

    public static PyObject EnvironmentError() {
        PyStringMap dict = new PyStringMap();
        exceptions.defineSlots(dict, "errno", "strerror", "filename");
        ((PyObject)dict).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "EnvironmentError__init__"));
        ((PyObject)dict).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "EnvironmentError__str__"));
        ((PyObject)dict).__setitem__("__reduce__", exceptions.bindStaticJavaMethod("__reduce__", "EnvironmentError__reduce__"));
        return dict;
    }

    public static void EnvironmentError__init__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException.TYPE.invoke("__init__", self, args, kwargs);
        exceptions.initSlots(self);
        if (args.length <= 1 || args.length > 3) {
            return;
        }
        PyObject errno2 = args[0];
        PyObject strerror = args[1];
        self.__setattr__("errno", errno2);
        self.__setattr__("strerror", strerror);
        if (args.length == 3) {
            self.__setattr__("filename", args[2]);
            self.__setattr__("args", (PyObject)new PyTuple(errno2, strerror));
        }
    }

    public static PyObject EnvironmentError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        String result;
        PyObject errno2 = self.__findattr__("errno");
        PyObject strerror = self.__findattr__("strerror");
        PyObject filename = self.__findattr__("filename");
        if (filename.__nonzero__()) {
            result = String.format("[Errno %s] %s: %s", errno2, strerror, filename.__repr__());
        } else if (errno2.__nonzero__() && strerror.__nonzero__()) {
            result = String.format("[Errno %s] %s", errno2, strerror);
        } else {
            return PyBaseException.TYPE.invoke("__str__", self, args, kwargs);
        }
        return Py.newString(result);
    }

    public static PyObject EnvironmentError__reduce__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException selfBase = (PyBaseException)self;
        PyObject reduceArgs = selfBase.args;
        PyObject filename = self.__findattr__("filename");
        if (selfBase.args.__len__() == 2 && filename != null) {
            reduceArgs = new PyTuple(selfBase.args.__finditem__(0), selfBase.args.__finditem__(1), filename);
        }
        if (selfBase.__dict__ != null) {
            return new PyTuple(selfBase.getType(), reduceArgs, selfBase.__dict__);
        }
        return new PyTuple(selfBase.getType(), reduceArgs);
    }

    public static PyObject SystemExit() {
        PyStringMap dict = new PyStringMap();
        exceptions.defineSlots(dict, "code");
        ((PyObject)dict).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "SystemExit__init__"));
        return dict;
    }

    public static void SystemExit__init__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException.TYPE.invoke("__init__", self, args, kwargs);
        exceptions.initSlots(self);
        if (args.length == 1) {
            self.__setattr__("code", args[0]);
        } else if (args.length > 1) {
            self.__setattr__("code", (PyObject)new PyTuple(args));
        }
    }

    public static PyObject KeyError() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "KeyError__str__"));
        return dict;
    }

    public static PyObject KeyError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException selfBase = (PyBaseException)self;
        if (selfBase.args.__len__() == 1) {
            return selfBase.args.__getitem__(0).__repr__();
        }
        return PyBaseException.TYPE.invoke("__str__", self, args, kwargs);
    }

    public static PyObject UnicodeError() {
        PyStringMap dict = new PyStringMap();
        exceptions.defineSlots(dict, "encoding", "object", "start", "end", "reason");
        return dict;
    }

    public static void UnicodeError__init__(PyObject self, PyObject[] args, String[] kwargs, PyType objectType) {
        ArgParser ap = new ArgParser("__init__", args, kwargs, new String[]{"encoding", "object", "start", "end", "reason"}, 5);
        self.__setattr__("encoding", ap.getPyObjectByType(0, PyString.TYPE));
        self.__setattr__("object", ap.getPyObjectByType(1, objectType));
        self.__setattr__("start", ap.getPyObjectByType(2, PyInteger.TYPE));
        self.__setattr__("end", ap.getPyObjectByType(3, PyInteger.TYPE));
        self.__setattr__("reason", ap.getPyObjectByType(4, PyString.TYPE));
    }

    public static PyObject UnicodeDecodeError() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "UnicodeDecodeError__init__"));
        ((PyObject)dict).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "UnicodeDecodeError__str__"));
        return dict;
    }

    public static void UnicodeDecodeError__init__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException.TYPE.invoke("__init__", self, args, kwargs);
        exceptions.UnicodeError__init__(self, args, kwargs, PyString.TYPE);
    }

    public static PyString UnicodeDecodeError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        String string;
        int start = exceptions.getStart(self, false);
        int end = exceptions.getEnd(self, false);
        PyObject encoding = self.__getattr__("encoding");
        PyObject reason = self.__getattr__("reason");
        if (end == start + 1) {
            PyObject pyObject = self.__getattr__("object");
            int object = pyObject.toString().charAt(start) & 0xFF;
            String badByte = String.format("'%.400s' codec can't decode byte 0x%x in position %d: %.400s", encoding, object, start, reason);
        } else {
            string = String.format("'%.400s' codec can't decode bytes in position %d-%d: %.400s", encoding, start, end - 1, reason);
        }
        return Py.newString(string);
    }

    public static PyObject UnicodeEncodeError() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "UnicodeEncodeError__init__"));
        ((PyObject)dict).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "UnicodeEncodeError__str__"));
        return dict;
    }

    public static void UnicodeEncodeError__init__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException.TYPE.invoke("__init__", self, args, kwargs);
        exceptions.UnicodeError__init__(self, args, kwargs, PyUnicode.TYPE);
    }

    public static PyString UnicodeEncodeError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        String string;
        int start = exceptions.getStart(self, true);
        int end = exceptions.getEnd(self, true);
        PyObject encoding = self.__getattr__("encoding");
        PyObject reason = self.__getattr__("reason");
        if (end == start + 1) {
            PyObject pyObject = self.__getattr__("object");
            int object = pyObject.toString().codePointAt(start);
            String badchar = object <= 255 ? String.format("x%02x", object) : (object <= 65535 ? String.format("u%04x", object) : String.format("U%08x", object));
            String badcharStr = String.format("'%.400s' codec can't encode character u'\\%s' in position %d: %.400s", encoding, badchar, start, reason);
        } else {
            string = String.format("'%.400s' codec can't encode characters in position %d-%d: %.400s", encoding, start, end - 1, reason);
        }
        return Py.newString(string);
    }

    public static PyObject UnicodeTranslateError() {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__init__", exceptions.bindStaticJavaMethod("__init__", "UnicodeTranslateError__init__"));
        ((PyObject)dict).__setitem__("__str__", exceptions.bindStaticJavaMethod("__str__", "UnicodeTranslateError__str__"));
        return dict;
    }

    public static void UnicodeTranslateError__init__(PyObject self, PyObject[] args, String[] kwargs) {
        PyBaseException.TYPE.invoke("__init__", self, args, kwargs);
        ArgParser ap = new ArgParser("__init__", args, kwargs, new String[]{"object", "start", "end", "reason"}, 4);
        self.__setattr__("object", ap.getPyObjectByType(0, PyUnicode.TYPE));
        self.__setattr__("start", ap.getPyObjectByType(1, PyInteger.TYPE));
        self.__setattr__("end", ap.getPyObjectByType(2, PyInteger.TYPE));
        self.__setattr__("reason", ap.getPyObjectByType(3, PyString.TYPE));
    }

    public static PyString UnicodeTranslateError__str__(PyObject self, PyObject[] args, String[] kwargs) {
        String string;
        int start = exceptions.getStart(self, true);
        int end = exceptions.getEnd(self, true);
        PyObject reason = self.__getattr__("reason");
        if (end == start + 1) {
            int n2 = self.__getattr__("object").toString().codePointAt(start);
            String badchar = n2 <= 255 ? String.format("x%02x", n2) : (n2 <= 65535 ? String.format("u%04x", n2) : String.format("U%08x", n2));
            String badCharStr = String.format("can't translate character u'\\%s' in position %d: %.400s", badchar, start, reason);
        } else {
            string = String.format("can't translate characters in position %d-%d: %.400s", start, end - 1, reason);
        }
        return Py.newString(string);
    }

    public static int getStart(PyObject self, boolean unicode) {
        int start = exceptions.getInt(self.__getattr__("start"), "start");
        PyString object = unicode ? exceptions.getUnicode(self.__getattr__("object"), "object") : exceptions.getString(self.__getattr__("object"), "object");
        if (start < 0) {
            start = 0;
        }
        if (start >= ((PyObject)object).__len__()) {
            start = ((PyObject)object).__len__() - 1;
        }
        return start;
    }

    public static int getEnd(PyObject self, boolean unicode) {
        int end = exceptions.getInt(self.__getattr__("end"), "end");
        PyString object = unicode ? exceptions.getUnicode(self.__getattr__("object"), "object") : exceptions.getString(self.__getattr__("object"), "object");
        if (end < 1) {
            end = 1;
        }
        if (end > ((PyObject)object).__len__()) {
            end = ((PyObject)object).__len__();
        }
        return end;
    }

    public static int getInt(PyObject attr, String name) {
        if (attr instanceof PyInteger) {
            return ((PyInteger)attr).asInt();
        }
        if (attr instanceof PyLong) {
            return ((PyLong)attr).asInt();
        }
        throw Py.TypeError(String.format("%.200s attribute must be int", name));
    }

    public static PyString getString(PyObject attr, String name) {
        if (!(attr instanceof PyString)) {
            throw Py.TypeError(String.format("%.200s attribute must be str", name));
        }
        return (PyString)attr;
    }

    public static PyUnicode getUnicode(PyObject attr, String name) {
        if (!(attr instanceof PyUnicode)) {
            throw Py.TypeError(String.format("%.200s attribute must be unicode", name));
        }
        return (PyUnicode)attr;
    }

    private static String basename(String name) {
        int lastSep = name.lastIndexOf(File.separatorChar);
        if (lastSep > -1) {
            return name.substring(lastSep + 1, name.length());
        }
        return name;
    }

    private static void defineSlots(PyObject dict, String ... slotNames) {
        PyObject[] slots = new PyObject[slotNames.length];
        for (int i2 = 0; i2 < slotNames.length; ++i2) {
            slots[i2] = Py.newString(slotNames[i2]);
        }
        dict.__setitem__("__slots__", (PyObject)new PyTuple(slots));
    }

    private static void initSlots(PyObject self) {
        for (PyObject name : self.__findattr__("__slots__").asIterable()) {
            if (!(name instanceof PyString)) continue;
            self.__setattr__((PyString)name, Py.None);
        }
    }

    private static PyObject buildClass(PyObject dict, String classname, String superclass, String doc) {
        return exceptions.buildClass(dict, classname, superclass, new PyStringMap(), doc);
    }

    private static PyObject buildClass(PyObject dict, String classname, String superclass, PyObject classDict, String doc) {
        classDict.__setitem__("__doc__", (PyObject)Py.newString(doc));
        PyType type = (PyType)Py.makeClass("exceptions." + classname, dict.__finditem__(superclass), classDict);
        type.builtin = true;
        dict.__setitem__(classname, (PyObject)type);
        return type;
    }

    public static PyObject bindStaticJavaMethod(String name, String methodName) {
        return exceptions.bindStaticJavaMethod(name, exceptions.class, methodName);
    }

    public static PyObject bindStaticJavaMethod(String name, Class<?> cls, String methodName) {
        Method javaMethod;
        try {
            javaMethod = cls.getMethod(methodName, PyObject.class, PyObject[].class, String[].class);
        }
        catch (Exception e2) {
            throw Py.JavaError(e2);
        }
        return new BoundStaticJavaMethod(name, javaMethod);
    }

    static class BoundStaticJavaMethod
    extends PyBuiltinMethod {
        private Method javaMethod;

        public BoundStaticJavaMethod(String name, Method javaMethod) {
            super(name);
            this.javaMethod = javaMethod;
        }

        protected BoundStaticJavaMethod(PyType type, PyObject self, PyBuiltinCallable.Info info, Method javaMethod) {
            super(type, self, info);
            this.javaMethod = javaMethod;
        }

        public PyBuiltinCallable bind(PyObject self) {
            return new BoundStaticJavaMethod(this.getType(), self, this.info, this.javaMethod);
        }

        public PyObject __get__(PyObject obj, PyObject type) {
            if (obj != null) {
                return this.bind(obj);
            }
            return this.makeDescriptor((PyType)type);
        }

        public PyObject __call__(PyObject[] args, String[] kwargs) {
            try {
                return Py.java2py(this.javaMethod.invoke(null, this.self, args, kwargs));
            }
            catch (Throwable t) {
                throw Py.JavaError(t);
            }
        }
    }
}

