/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.ContextManager;
import org.python.core.Py;
import org.python.core.PyBaseCode;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyFunction;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.ThreadState;

public class ContextGuard
implements ContextManager {
    private final PyObject __enter__method;
    private final PyObject __exit__method;

    private ContextGuard(PyObject manager) {
        this.__exit__method = manager.__getattr__("__exit__");
        this.__enter__method = manager.__getattr__("__enter__");
    }

    public PyObject __enter__(ThreadState ts) {
        return this.__enter__method.__call__(ts);
    }

    public boolean __exit__(ThreadState ts, PyException exception) {
        PyObject traceback;
        PyObject value;
        PyObject type;
        if (exception != null) {
            type = exception.type;
            value = exception.value;
            traceback = exception.traceback;
        } else {
            value = traceback = Py.None;
            type = traceback;
        }
        return this.__exit__method.__call__(ts, type, value == null ? Py.None : value, traceback == null ? Py.None : traceback).__nonzero__();
    }

    public static ContextManager getManager(PyObject manager) {
        if (manager instanceof ContextManager) {
            return (ContextManager)((Object)manager);
        }
        return new ContextGuard(manager);
    }

    public static PyObject makeManager(PyObject object) {
        if (object instanceof PyFunction) {
            PyFunction function = (PyFunction)object;
            PyCode code = function.func_code;
            if (code instanceof PyBaseCode) {
                PyBaseCode pyCode = (PyBaseCode)code;
                if (pyCode.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
                    return new PyFunction(function.func_globals, function.func_defaults, new ContextCode(pyCode), function.__doc__, function.func_closure == null ? null : ((PyTuple)function.func_closure).getArray());
                }
            }
        }
        throw Py.TypeError("Argument must be a generator function.");
    }

    private static abstract class GeneratorContextManager
    extends PyObject
    implements ContextManager {
        final PyFrame frame;

        public GeneratorContextManager(PyFrame frame) {
            this.frame = frame;
        }

        public PyObject __enter__(ThreadState ts) {
            PyObject res = this.body(ts);
            if (this.frame.f_lasti == -1) {
                throw Py.RuntimeError("generator didn't yield");
            }
            return res;
        }

        public boolean __exit__(ThreadState ts, PyException exception) {
            PyObject res;
            if (exception != null) {
                this.frame.setGeneratorInput(exception);
            }
            try {
                res = this.body(ts);
            }
            catch (PyException e2) {
                if (e2.equals(exception)) {
                    return false;
                }
                throw e2;
            }
            if (this.frame.f_lasti != -1) {
                throw Py.RuntimeError("generator didn't stop");
            }
            return res.__nonzero__();
        }

        abstract PyObject body(ThreadState var1);
    }

    private static class ContextCode
    extends PyBaseCode {
        private final PyBaseCode code;

        ContextCode(PyBaseCode code) {
            this.co_name = code.co_name;
            this.code = code;
            this.co_argcount = code.co_argcount;
            this.nargs = code.nargs;
            this.co_firstlineno = code.co_firstlineno;
            this.co_varnames = code.co_varnames;
            this.co_cellvars = code.co_cellvars;
            this.jy_npurecell = code.jy_npurecell;
            this.co_freevars = code.co_freevars;
            this.co_filename = code.co_filename;
            this.co_nlocals = code.co_nlocals;
            this.varargs = code.varargs;
            this.varkwargs = code.varkwargs;
            for (CodeFlag flag : CodeFlag.values()) {
                if (!code.co_flags.isFlagSet(flag) || flag == CodeFlag.CO_GENERATOR) continue;
                this.co_flags.setFlag(flag);
            }
        }

        protected PyObject interpret(PyFrame frame, ThreadState ts) {
            frame.f_back = null;
            return new GeneratorContextManager(frame){

                PyObject body(ThreadState ts) {
                    return ContextCode.this.code.interpret(this.frame, ts);
                }
            };
        }

        public PyObject call(ThreadState ts, PyFrame frame, final PyObject closure) {
            frame.f_back = null;
            return new GeneratorContextManager(frame){

                PyObject body(ThreadState ts) {
                    return ContextCode.this.code.call(ts, this.frame, closure);
                }
            };
        }
    }
}

