/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.runners.statements;

import org.junit.internal.AssumptionViolatedException;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpectException
extends Statement {
    private Statement fNext;
    private final Class<? extends Throwable> fExpected;

    public ExpectException(Statement next, Class<? extends Throwable> expected) {
        this.fNext = next;
        this.fExpected = expected;
    }

    @Override
    public void evaluate() throws Exception {
        boolean complete;
        block4: {
            complete = false;
            try {
                this.fNext.evaluate();
                complete = true;
            }
            catch (AssumptionViolatedException e2) {
                throw e2;
            }
            catch (Throwable e3) {
                if (this.fExpected.isAssignableFrom(e3.getClass())) break block4;
                String message = "Unexpected exception, expected<" + this.fExpected.getName() + "> but was<" + e3.getClass().getName() + ">";
                throw new Exception(message, e3);
            }
        }
        if (complete) {
            throw new AssertionError((Object)("Expected exception: " + this.fExpected.getName()));
        }
    }
}

