/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.jogamp.java3d.AudioDevice;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.PhysicalBody;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.audioengines.AudioEngine3DL2;
import org.jogamp.java3d.utils.universe.ConfigScreen;
import org.jogamp.java3d.utils.universe.ConfigView;
import org.jogamp.java3d.utils.universe.ConfiguredUniverse;
import org.jogamp.java3d.utils.universe.SimpleUniverse;
import org.jogamp.java3d.utils.universe.ViewerAvatar;
import org.jogamp.java3d.utils.universe.ViewingPlatform;

public class Viewer {
    private static final boolean debug = false;
    private static PhysicalBody physicalBody = null;
    private static PhysicalEnvironment physicalEnvironment = null;
    private View view;
    private ViewerAvatar avatar;
    private Canvas3D[] canvases;
    private JFrame[] j3dJFrames;
    private JPanel[] j3dJPanels;
    private Window[] j3dWindows;
    private ViewingPlatform viewingPlatform;

    public Viewer() {
        this(null, null, null, true);
    }

    public Viewer(Canvas3D userCanvas) {
        Canvas3D[] canvas3DArray;
        if (userCanvas == null) {
            canvas3DArray = null;
        } else {
            Canvas3D[] canvas3DArray2 = new Canvas3D[1];
            canvas3DArray = canvas3DArray2;
            canvas3DArray2[0] = userCanvas;
        }
        this(canvas3DArray, null, null, true);
    }

    public Viewer(Canvas3D[] userCanvases) {
        this(userCanvases, null, null, true);
    }

    public Viewer(Canvas3D[] userCanvases, PhysicalBody userBody, PhysicalEnvironment userEnvironment, boolean setVisible) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        physicalBody = userBody == null ? new PhysicalBody() : userBody;
        physicalEnvironment = userEnvironment == null ? new PhysicalEnvironment() : userEnvironment;
        if (userCanvases == null) {
            GraphicsConfiguration config = ConfiguredUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D(config);
            this.canvases[0].setFocusable(true);
            this.createFramesAndPanels(setVisible);
        } else {
            this.canvases = new Canvas3D[userCanvases.length];
            int i2 = 0;
            while (i2 < userCanvases.length) {
                this.canvases[i2] = userCanvases[i2];
                this.canvases[i2].setFocusable(true);
                ++i2;
            }
        }
        this.view = new View();
        this.view.setUserHeadToVworldEnable(true);
        int i3 = 0;
        while (i3 < this.canvases.length) {
            this.view.addCanvas3D(this.canvases[i3]);
            ++i3;
        }
        this.view.setPhysicalBody(physicalBody);
        this.view.setPhysicalEnvironment(physicalEnvironment);
    }

    public Viewer(URL userConfig) {
        this(null, userConfig);
    }

    public Viewer(Canvas3D userCanvas, URL userConfig) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        if (physicalBody == null) {
            physicalBody = new PhysicalBody();
        }
        if (physicalEnvironment == null) {
            physicalEnvironment = new PhysicalEnvironment();
        }
        if (userCanvas == null) {
            GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
            this.canvases = new Canvas3D[1];
            this.canvases[0] = new Canvas3D(config);
            this.createFramesAndPanels(true);
        } else {
            this.canvases = new Canvas3D[1];
            this.canvases[0] = userCanvas;
        }
        this.canvases[0].setFocusable(true);
        this.view = new View();
        this.view.setUserHeadToVworldEnable(true);
        this.view.addCanvas3D(this.canvases[0]);
        this.view.setPhysicalBody(physicalBody);
        this.view.setPhysicalEnvironment(physicalEnvironment);
    }

    Viewer(ConfigScreen[] cs, ConfigView cv, boolean setVisible) {
        this.view = null;
        this.avatar = null;
        this.canvases = null;
        this.j3dJFrames = null;
        this.j3dJPanels = null;
        this.j3dWindows = null;
        this.viewingPlatform = null;
        this.view = cv.j3dView;
        physicalBody = cv.physicalBody;
        physicalEnvironment = cv.physicalEnvironment;
        GraphicsEnvironment graphicsEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = graphicsEnv.getScreenDevices();
        if (devices == null) {
            throw new RuntimeException("No screen devices available in local environment");
        }
        this.canvases = new Canvas3D[cs.length];
        this.j3dJFrames = new JFrame[cs.length];
        this.j3dJPanels = new JPanel[cs.length];
        this.j3dWindows = new Window[cs.length];
        GraphicsConfigTemplate3D tpl3D = new GraphicsConfigTemplate3D();
        if (cv.stereoEnable) {
            tpl3D.setStereo(2);
        }
        if (cv.antialiasingEnable) {
            tpl3D.setSceneAntialiasing(2);
        }
        int i2 = 0;
        while (i2 < cs.length) {
            Container contentPane;
            if (cs[i2].frameBufferNumber >= devices.length) {
                ConfigScreen cfr_ignored_0 = cs[i2];
                throw new ArrayIndexOutOfBoundsException(ConfigScreen.errorMessage(cs[i2].creatingCommand, "Screen " + cs[i2].frameBufferNumber + " is invalid; " + (devices.length - 1) + " is the maximum local index."));
            }
            GraphicsConfiguration cfg = devices[cs[i2].frameBufferNumber].getBestConfiguration(tpl3D);
            if (cfg == null) {
                throw new RuntimeException("No GraphicsConfiguration on screen " + cs[i2].frameBufferNumber + " conforms to template");
            }
            GraphicsConfiguration defCfg = cfg.getDevice().getDefaultConfiguration();
            Rectangle bounds = defCfg.getBounds();
            cs[i2].j3dJFrame = this.j3dJFrames[i2] = new JFrame(cs[i2].instanceName, defCfg);
            if (cs[i2].noBorderFullScreen) {
                this.j3dJFrames[i2].setUndecorated(true);
                cs[i2].j3dWindow = this.j3dWindows[i2] = this.j3dJFrames[i2];
                contentPane = this.j3dJFrames[i2].getContentPane();
                contentPane.setLayout(new BorderLayout());
                this.j3dWindows[i2].setSize(bounds.width, bounds.height);
                this.j3dWindows[i2].setLocation(bounds.x, bounds.y);
            } else {
                cs[i2].j3dWindow = this.j3dWindows[i2] = this.j3dJFrames[i2];
                contentPane = this.j3dJFrames[i2].getContentPane();
                contentPane.setLayout(new BorderLayout());
                if (cs[i2].fullScreen) {
                    this.j3dWindows[i2].setSize(bounds.width, bounds.height);
                    this.j3dWindows[i2].setLocation(bounds.x, bounds.y);
                } else {
                    this.j3dWindows[i2].setSize(cs[i2].windowWidthInPixels, cs[i2].windowHeightInPixels);
                    this.j3dWindows[i2].setLocation(bounds.x + cs[i2].windowX, bounds.y + cs[i2].windowY);
                }
            }
            cs[i2].j3dCanvas = this.canvases[i2] = new Canvas3D(cfg);
            this.canvases[i2].setStereoEnable(cv.stereoEnable);
            this.canvases[i2].setMonoscopicViewPolicy(cs[i2].monoscopicViewPolicy);
            Screen3D screen = this.canvases[i2].getScreen3D();
            if (cs[i2].physicalScreenWidth != 0.0) {
                screen.setPhysicalScreenWidth(cs[i2].physicalScreenWidth);
            }
            if (cs[i2].physicalScreenHeight != 0.0) {
                screen.setPhysicalScreenHeight(cs[i2].physicalScreenHeight);
            }
            if (cs[i2].trackerBaseToImagePlate != null) {
                screen.setTrackerBaseToImagePlate(new Transform3D(cs[i2].trackerBaseToImagePlate));
            }
            if (cs[i2].headTrackerToLeftImagePlate != null) {
                screen.setHeadTrackerToLeftImagePlate(new Transform3D(cs[i2].headTrackerToLeftImagePlate));
            }
            if (cs[i2].headTrackerToRightImagePlate != null) {
                screen.setHeadTrackerToRightImagePlate(new Transform3D(cs[i2].headTrackerToRightImagePlate));
            }
            cs[i2].j3dJPanel = this.j3dJPanels[i2] = new JPanel();
            this.j3dJPanels[i2].setLayout(new BorderLayout());
            this.j3dJPanels[i2].add("Center", this.canvases[i2]);
            contentPane.add("Center", this.j3dJPanels[i2]);
            this.view.addCanvas3D(this.canvases[i2]);
            this.addWindowCloseListener(this.j3dWindows[i2]);
            this.canvases[i2].setFocusable(true);
            ++i2;
        }
        if (setVisible) {
            this.setVisible(true);
        }
    }

    private void createFramesAndPanels(boolean setVisible) {
        this.j3dJFrames = new JFrame[this.canvases.length];
        this.j3dJPanels = new JPanel[this.canvases.length];
        this.j3dWindows = new Window[this.canvases.length];
        int i2 = 0;
        while (i2 < this.canvases.length) {
            this.j3dJFrames[i2] = new JFrame();
            this.j3dWindows[i2] = this.j3dJFrames[i2];
            this.j3dJFrames[i2].getContentPane().setLayout(new BorderLayout());
            this.j3dJFrames[i2].setSize(256, 256);
            this.j3dJPanels[i2] = new JPanel();
            this.j3dJPanels[i2].setLayout(new BorderLayout());
            this.j3dJPanels[i2].add("Center", this.canvases[i2]);
            this.j3dJFrames[i2].getContentPane().add("Center", this.j3dJPanels[i2]);
            if (setVisible) {
                this.j3dJFrames[i2].setVisible(true);
            }
            this.addWindowCloseListener(this.j3dJFrames[i2]);
            ++i2;
        }
    }

    public void setVisible(boolean visible) {
        int i2 = 0;
        while (i2 < this.j3dWindows.length) {
            this.j3dWindows[i2].setVisible(visible);
            ++i2;
        }
    }

    public View getView() {
        return this.view;
    }

    public void setViewingPlatform(ViewingPlatform platform) {
        if (this.viewingPlatform != null) {
            this.viewingPlatform.removeViewer(this);
        }
        this.viewingPlatform = platform;
        if (platform != null) {
            this.view.attachViewPlatform(platform.getViewPlatform());
            platform.addViewer(this);
            if (this.avatar != null) {
                this.viewingPlatform.setAvatar(this, this.avatar);
            }
        } else {
            this.view.attachViewPlatform(null);
        }
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewingPlatform;
    }

    public void setAvatar(ViewerAvatar avatar) {
        if (this.avatar == avatar) {
            return;
        }
        this.avatar = avatar;
        if (this.viewingPlatform != null) {
            this.viewingPlatform.setAvatar(this, this.avatar);
        }
    }

    public ViewerAvatar getAvatar() {
        return this.avatar;
    }

    public PhysicalBody getPhysicalBody() {
        return physicalBody;
    }

    public PhysicalEnvironment getPhysicalEnvironment() {
        return physicalEnvironment;
    }

    public Canvas3D getCanvas3D() {
        return this.canvases[0];
    }

    public Canvas3D getCanvas3D(int canvasNum) {
        if (canvasNum > this.canvases.length) {
            return null;
        }
        return this.canvases[canvasNum];
    }

    public Canvas3D[] getCanvas3Ds() {
        Canvas3D[] ret = new Canvas3D[this.canvases.length];
        int i2 = 0;
        while (i2 < this.canvases.length) {
            ret[i2] = this.canvases[i2];
            ++i2;
        }
        return ret;
    }

    public Canvas3D getCanvases() {
        return this.getCanvas3D();
    }

    public Frame getFrame() {
        throw new UnsupportedOperationException("AWT Frame components are not created by the Viewer class");
    }

    public JFrame getJFrame(int frameNum) {
        if (this.j3dJFrames == null || frameNum > this.j3dJFrames.length) {
            return null;
        }
        return this.j3dJFrames[frameNum];
    }

    public JFrame[] getJFrames() {
        if (this.j3dJFrames == null) {
            return null;
        }
        JFrame[] ret = new JFrame[this.j3dJFrames.length];
        int i2 = 0;
        while (i2 < this.j3dJFrames.length) {
            ret[i2] = this.j3dJFrames[i2];
            ++i2;
        }
        return ret;
    }

    public Panel getPanel() {
        throw new UnsupportedOperationException("AWT Panel components are not created by the Viewer class");
    }

    public JPanel getJPanel(int panelNum) {
        if (this.j3dJPanels == null || panelNum > this.j3dJPanels.length) {
            return null;
        }
        return this.j3dJPanels[panelNum];
    }

    public JPanel[] getJPanels() {
        if (this.j3dJPanels == null) {
            return null;
        }
        JPanel[] ret = new JPanel[this.j3dJPanels.length];
        int i2 = 0;
        while (i2 < this.j3dJPanels.length) {
            ret[i2] = this.j3dJPanels[i2];
            ++i2;
        }
        return ret;
    }

    public AudioDevice createAudioDevice() {
        if (physicalEnvironment == null) {
            System.err.println("Java 3D: createAudioDevice: physicalEnvironment is null");
            return null;
        }
        try {
            String audioDeviceClassName = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("j3d.audiodevice");
                }
            });
            if (audioDeviceClassName == null) {
                throw new UnsupportedOperationException("No AudioDevice specified");
            }
            Class<?> audioDeviceClass = null;
            try {
                audioDeviceClass = Class.forName(audioDeviceClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (audioDeviceClass == null) {
                ClassLoader audioDeviceClassLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return ClassLoader.getSystemClassLoader();
                    }
                });
                if (audioDeviceClassLoader == null) {
                    throw new IllegalStateException("System ClassLoader is null");
                }
                audioDeviceClass = Class.forName(audioDeviceClassName, true, audioDeviceClassLoader);
            }
            Class<PhysicalEnvironment> physEnvClass = PhysicalEnvironment.class;
            Constructor<?> audioDeviceConstructor = audioDeviceClass.getConstructor(physEnvClass);
            Object[] args = new PhysicalEnvironment[]{physicalEnvironment};
            AudioEngine3DL2 mixer = (AudioEngine3DL2)audioDeviceConstructor.newInstance(args);
            mixer.initialize();
            return mixer;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            physicalEnvironment.setAudioDevice(null);
            System.err.println("Java 3D: audio is disabled");
            return null;
        }
    }

    public SimpleUniverse getUniverse() {
        return this.getViewingPlatform().getUniverse();
    }

    void addWindowCloseListener(Window win) {
        SecurityManager sm = System.getSecurityManager();
        boolean doExit = true;
        if (sm != null) {
            try {
                sm.checkExit(0);
            }
            catch (SecurityException e2) {
                doExit = false;
            }
        }
        final boolean _doExit = doExit;
        win.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvent) {
                Window w = winEvent.getWindow();
                w.setVisible(false);
                try {
                    w.dispose();
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (_doExit) {
                    System.exit(0);
                }
            }
        });
    }
}

