/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.PhysicalBody;
import org.jogamp.java3d.PhysicalEnvironment;
import org.jogamp.java3d.Screen3D;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class ViewInfo {
    private static final boolean verbose = false;
    public static final int SCREEN_AUTO_UPDATE = 1;
    public static final int CANVAS_AUTO_UPDATE = 2;
    public static final int VIEW_AUTO_UPDATE = 4;
    public static final int HEAD_AUTO_UPDATE = 8;
    public static final int PLATFORM_AUTO_UPDATE = 16;
    private static Map staticVpMap = new HashMap();
    private static Map staticSiMap = new HashMap();
    private Map screenMap = null;
    private Map viewPlatformMap = null;
    private View view = null;
    private Sensor headTracker = null;
    private boolean useTracking = false;
    private boolean clipVirtual = false;
    private ViewPlatformInfo vpi = null;
    private int canvasCount = 0;
    private Map canvasMap = new HashMap();
    private CanvasInfo[] canvasInfo = new CanvasInfo[1];
    private boolean updateView = true;
    private boolean updateHead = true;
    private boolean autoUpdate = false;
    private int autoUpdateFlags = 0;
    private int viewPolicy = 0;
    private int resizePolicy = 1;
    private int movementPolicy = 1;
    private int eyePolicy = 2;
    private int projectionPolicy = 1;
    private int frontClipPolicy = 3;
    private int backClipPolicy = 3;
    private int scalePolicy = 0;
    private boolean coeCentering = true;
    private Transform3D coeToTrackerBase = null;
    private Transform3D headToHeadTracker = null;
    private Transform3D headTrackerToTrackerBase = null;
    private Transform3D trackerBaseToHeadTracker = null;
    private Transform3D headToTrackerBase = null;
    private Transform3D coeToHeadTracker = null;
    private PhysicalEnvironment env = null;
    private PhysicalBody body = null;
    private Point3d leftEyeInHead = new Point3d();
    private Point3d rightEyeInHead = new Point3d();
    private Vector3d v3d = new Vector3d();
    private double[] m16d = new double[16];
    private Point3d leftEye = new Point3d();
    private Point3d rightEye = new Point3d();
    private Map newMap = new HashMap();
    private Set newSet = new HashSet();

    public ViewInfo(View view) {
        this(view, 0);
    }

    public ViewInfo(View view, int autoUpdateFlags) {
        this(view, autoUpdateFlags, staticSiMap, staticVpMap);
    }

    public ViewInfo(View view, int autoUpdateFlags, Map screenMap, Map viewPlatformMap) {
        if (view == null) {
            throw new IllegalArgumentException("View is null");
        }
        if (screenMap == null) {
            throw new IllegalArgumentException("screenMap is null");
        }
        if (viewPlatformMap == null) {
            throw new IllegalArgumentException("viewPlatformMap is null");
        }
        this.view = view;
        this.screenMap = screenMap;
        this.viewPlatformMap = viewPlatformMap;
        if (autoUpdateFlags == 0) {
            this.autoUpdate = false;
        } else {
            this.autoUpdate = true;
            this.autoUpdateFlags = autoUpdateFlags;
        }
        this.getViewInfo();
    }

    public void getImagePlateToViewPlatform(Canvas3D c3d, Transform3D ip2vpl, Transform3D ip2vpr) {
        CanvasInfo ci = this.updateCache(c3d, "getImagePlateToViewPlatform", false);
        this.getImagePlateToViewPlatform(ci);
        ip2vpl.set(ci.plateToViewPlatform);
        if (ci.useStereo && ip2vpr != null) {
            ip2vpr.set(ci.rightPlateToViewPlatform);
        }
    }

    private void getImagePlateToViewPlatform(CanvasInfo ci) {
        if (ci.updatePlateToViewPlatform) {
            if (ci.plateToViewPlatform == null) {
                ci.plateToViewPlatform = new Transform3D();
            }
            this.getCoexistenceToImagePlate(ci);
            this.getViewPlatformToCoexistence(ci);
            ci.plateToViewPlatform.mul(ci.coeToPlate, ci.viewPlatformToCoe);
            ci.plateToViewPlatform.invert();
            if (ci.useStereo) {
                if (ci.rightPlateToViewPlatform == null) {
                    ci.rightPlateToViewPlatform = new Transform3D();
                }
                ci.rightPlateToViewPlatform.mul(ci.coeToRightPlate, ci.viewPlatformToCoe);
                ci.rightPlateToViewPlatform.invert();
            }
            ci.updatePlateToViewPlatform = false;
        }
    }

    public void getImagePlateToVworld(Canvas3D c3d, Transform3D ip2vwl, Transform3D ip2vwr) {
        CanvasInfo ci = this.updateCache(c3d, "getImagePlateToVworld", true);
        this.getImagePlateToVworld(ci);
        ip2vwl.set(ci.plateToVworld);
        if (ci.useStereo && ip2vwr != null) {
            ip2vwr.set(ci.rightPlateToVworld);
        }
    }

    private void getImagePlateToVworld(CanvasInfo ci) {
        if (ci.updatePlateToVworld) {
            if (ci.plateToVworld == null) {
                ci.plateToVworld = new Transform3D();
            }
            this.getImagePlateToViewPlatform(ci);
            ci.plateToVworld.mul(this.vpi.viewPlatformToVworld, ci.plateToViewPlatform);
            if (ci.useStereo) {
                if (ci.rightPlateToVworld == null) {
                    ci.rightPlateToVworld = new Transform3D();
                }
                ci.rightPlateToVworld.mul(this.vpi.viewPlatformToVworld, ci.rightPlateToViewPlatform);
            }
            ci.updatePlateToVworld = false;
        }
    }

    public void getCoexistenceToImagePlate(Canvas3D c3d, Transform3D coe2ipl, Transform3D coe2ipr) {
        CanvasInfo ci = this.updateCache(c3d, "getCoexistenceToImagePlate", false);
        this.getCoexistenceToImagePlate(ci);
        coe2ipl.set(ci.coeToPlate);
        if (ci.useStereo && coe2ipr != null) {
            coe2ipr.set(ci.coeToRightPlate);
        }
    }

    private void getCoexistenceToImagePlate(CanvasInfo ci) {
        if (ci.updateCoeToPlate) {
            if (ci.coeToPlate == null) {
                ci.coeToPlate = new Transform3D();
                ci.coeToRightPlate = new Transform3D();
            }
            if (this.viewPolicy == 1) {
                ci.coeToPlate.mul(ci.si.headTrackerToLeftPlate, this.coeToHeadTracker);
                if (ci.useStereo) {
                    ci.coeToRightPlate.mul(ci.si.headTrackerToRightPlate, this.coeToHeadTracker);
                } else {
                    ci.coeToRightPlate.set(ci.coeToPlate);
                }
            } else if (this.coeCentering) {
                if (this.movementPolicy == 1) {
                    this.v3d.set(ci.canvasX + ci.canvasWidth / 2.0, ci.canvasY + ci.canvasHeight / 2.0, 0.0);
                } else {
                    this.v3d.set(ci.si.screenWidth / 2.0, ci.si.screenHeight / 2.0, 0.0);
                }
                ci.coeToPlate.set(this.v3d);
                ci.coeToRightPlate.set(this.v3d);
            } else {
                ci.coeToPlate.mul(ci.si.trackerBaseToPlate, this.coeToTrackerBase);
                ci.coeToRightPlate.set(ci.coeToPlate);
            }
            ci.updateCoeToPlate = false;
        }
    }

    public void getViewPlatformToCoexistence(Canvas3D c3d, Transform3D vp2coe) {
        CanvasInfo ci = this.updateCache(c3d, "getViewPlatformToCoexistence", false);
        this.getViewPlatformToCoexistence(ci);
        vp2coe.set(ci.viewPlatformToCoe);
    }

    private void getViewPlatformToCoexistence(CanvasInfo ci) {
        if (!ci.updateViewPlatformToCoe) {
            return;
        }
        if (ci.viewPlatformToCoe == null) {
            ci.viewPlatformToCoe = new Transform3D();
        }
        this.getScreenScale(ci);
        if (this.resizePolicy == 1) {
            ci.viewPlatformToCoe.setScale(ci.screenScale * ci.windowScale);
        } else {
            ci.viewPlatformToCoe.setScale(ci.screenScale);
        }
        if (this.viewPolicy == 1) {
            ci.updateViewPlatformToCoe = false;
            return;
        }
        double eyeHeight = this.body.getNominalEyeHeightFromGround();
        int viewAttachPolicy = this.view.getViewPlatform().getViewAttachPolicy();
        int pworldAttachPolicy = this.env.getCoexistenceCenterInPworldPolicy();
        double eyeOffset = this.eyePolicy == 2 ? ci.getFieldOfViewOffset() : this.body.getNominalEyeOffsetFromNominalScreen();
        if (pworldAttachPolicy == 2) {
            if (viewAttachPolicy == 0) {
                this.v3d.set(0.0, 0.0, eyeOffset);
            } else if (viewAttachPolicy == 2) {
                this.v3d.set(0.0, 0.0, 0.0);
            } else {
                this.v3d.set(0.0, -eyeHeight, eyeOffset);
            }
        } else if (pworldAttachPolicy == 0) {
            if (viewAttachPolicy == 0) {
                this.v3d.set(0.0, 0.0, 0.0);
            } else if (viewAttachPolicy == 2) {
                this.v3d.set(0.0, 0.0, -eyeOffset);
            } else {
                this.v3d.set(0.0, -eyeHeight, 0.0);
            }
        } else if (viewAttachPolicy == 0) {
            this.v3d.set(0.0, eyeHeight, 0.0);
        } else if (viewAttachPolicy == 2) {
            this.v3d.set(0.0, eyeHeight, -eyeOffset);
        } else {
            this.v3d.set(0.0, 0.0, 0.0);
        }
        ci.viewPlatformToCoe.setTranslation(this.v3d);
        ci.updateViewPlatformToCoe = false;
    }

    public void getCoexistenceToViewPlatform(Canvas3D c3d, Transform3D coe2vp) {
        CanvasInfo ci = this.updateCache(c3d, "getCoexistenceToViewPlatform", false);
        this.getCoexistenceToViewPlatform(ci);
        coe2vp.set(ci.coeToViewPlatform);
    }

    private void getCoexistenceToViewPlatform(CanvasInfo ci) {
        if (ci.updateCoeToViewPlatform) {
            if (ci.coeToViewPlatform == null) {
                ci.coeToViewPlatform = new Transform3D();
            }
            this.getViewPlatformToCoexistence(ci);
            ci.coeToViewPlatform.invert(ci.viewPlatformToCoe);
            ci.updateCoeToViewPlatform = false;
        }
    }

    public void getCoexistenceToVworld(Canvas3D c3d, Transform3D coe2vw) {
        CanvasInfo ci = this.updateCache(c3d, "getCoexistenceToVworld", true);
        this.getCoexistenceToVworld(ci);
        coe2vw.set(ci.coeToVworld);
    }

    private void getCoexistenceToVworld(CanvasInfo ci) {
        if (ci.updateCoeToVworld) {
            if (ci.coeToVworld == null) {
                ci.coeToVworld = new Transform3D();
            }
            this.getCoexistenceToViewPlatform(ci);
            ci.coeToVworld.mul(this.vpi.viewPlatformToVworld, ci.coeToViewPlatform);
            ci.updateCoeToVworld = false;
        }
    }

    public void getEyeToImagePlate(Canvas3D c3d, Transform3D e2ipl, Transform3D e2ipr) {
        CanvasInfo ci = this.updateCache(c3d, "getEyeToImagePlate", false);
        this.getEyeToImagePlate(ci);
        e2ipl.set(ci.eyeToPlate);
        if (ci.useStereo && e2ipr != null) {
            e2ipr.set(ci.rightEyeToPlate);
        }
    }

    private void getEyeToImagePlate(CanvasInfo ci) {
        if (ci.updateEyeInPlate) {
            if (ci.eyeToPlate == null) {
                ci.eyeToPlate = new Transform3D();
            }
            if (this.viewPolicy == 1) {
                this.getEyesHMD(ci);
            } else if (this.useTracking) {
                this.getEyesTracked(ci);
            } else {
                this.getEyesFixedScreen(ci);
            }
            ci.updateEyeInPlate = false;
        }
    }

    private void getEyesHMD(CanvasInfo ci) {
        if (ci.useStereo) {
            this.leftEye.set(this.leftEyeInHead);
            this.headToHeadTracker.transform(this.leftEye);
            ci.si.headTrackerToLeftPlate.transform(this.leftEye, ci.eyeInPlate);
            this.rightEye.set(this.rightEyeInHead);
            this.headToHeadTracker.transform(this.rightEye);
            ci.si.headTrackerToRightPlate.transform(this.rightEye, ci.rightEyeInPlate);
            if (ci.rightEyeToPlate == null) {
                ci.rightEyeToPlate = new Transform3D();
            }
            this.v3d.set(ci.rightEyeInPlate);
            ci.rightEyeToPlate.set(this.v3d);
        } else {
            switch (ci.monoscopicPolicy) {
                case 0: {
                    this.leftEye.set(this.leftEyeInHead);
                    this.headToHeadTracker.transform(this.leftEye);
                    ci.si.headTrackerToLeftPlate.transform(this.leftEye, ci.eyeInPlate);
                    break;
                }
                case 1: {
                    this.rightEye.set(this.rightEyeInHead);
                    this.headToHeadTracker.transform(this.rightEye);
                    ci.si.headTrackerToRightPlate.transform(this.rightEye, ci.eyeInPlate);
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal monoscopic view policy for 2-channel HMD");
                }
            }
        }
        this.v3d.set(ci.eyeInPlate);
        ci.eyeToPlate.set(this.v3d);
    }

    private void getEyesTracked(CanvasInfo ci) {
        this.leftEye.set(this.leftEyeInHead);
        this.rightEye.set(this.rightEyeInHead);
        this.headToTrackerBase.transform(this.leftEye);
        this.headToTrackerBase.transform(this.rightEye);
        if (this.coeCentering) {
            this.getCoexistenceToImagePlate(ci);
            ci.coeToPlate.transform(this.leftEye);
            ci.coeToRightPlate.transform(this.rightEye);
        } else {
            ci.si.trackerBaseToPlate.transform(this.leftEye);
            ci.si.trackerBaseToPlate.transform(this.rightEye);
        }
        this.setEyeScreenRelative(ci, this.leftEye, this.rightEye);
    }

    private void getEyesFixedScreen(CanvasInfo ci) {
        switch (this.eyePolicy) {
            case 2: {
                double z = ci.getFieldOfViewOffset();
                this.setEyeWindowRelative(ci, z, z);
                break;
            }
            case 1: {
                this.setEyeWindowRelative(ci, ((CanvasInfo)ci).leftManualEyeInPlate.z, ((CanvasInfo)ci).rightManualEyeInPlate.z);
                break;
            }
            case 0: {
                this.setEyeScreenRelative(ci, ci.leftManualEyeInPlate, ci.rightManualEyeInPlate);
                break;
            }
            case 3: {
                this.view.getLeftManualEyeInCoexistence(this.leftEye);
                this.view.getRightManualEyeInCoexistence(this.rightEye);
                this.getCoexistenceToImagePlate(ci);
                ci.coeToPlate.transform(this.leftEye);
                ci.coeToRightPlate.transform(this.rightEye);
                this.setEyeScreenRelative(ci, this.leftEye, this.rightEye);
            }
        }
    }

    private void setEyeWindowRelative(CanvasInfo ci, double leftZ, double rightZ) {
        double centerX = ci.canvasX + ci.canvasWidth / 2.0;
        this.leftEye.x = centerX + this.leftEyeInHead.x;
        this.rightEye.x = centerX + this.rightEyeInHead.x;
        this.leftEye.y = this.rightEye.y = ci.canvasY + ci.canvasHeight / 2.0;
        this.leftEye.z = leftZ;
        this.rightEye.z = rightZ;
        this.setEyeScreenRelative(ci, this.leftEye, this.rightEye);
    }

    private void setEyeScreenRelative(CanvasInfo ci, Point3d leftEye, Point3d rightEye) {
        if (ci.useStereo) {
            ci.eyeInPlate.set(leftEye);
            ci.rightEyeInPlate.set(rightEye);
            if (ci.rightEyeToPlate == null) {
                ci.rightEyeToPlate = new Transform3D();
            }
            this.v3d.set(ci.rightEyeInPlate);
            ci.rightEyeToPlate.set(this.v3d);
        } else {
            switch (ci.monoscopicPolicy) {
                case 2: {
                    ci.eyeInPlate.set((leftEye.x + rightEye.x) / 2.0, (leftEye.y + rightEye.y) / 2.0, (leftEye.z + rightEye.z) / 2.0);
                    break;
                }
                case 0: {
                    ci.eyeInPlate.set(leftEye);
                    break;
                }
                case 1: {
                    ci.eyeInPlate.set(rightEye);
                }
            }
        }
        this.v3d.set(ci.eyeInPlate);
        ci.eyeToPlate.set(this.v3d);
    }

    public void getEyeToViewPlatform(Canvas3D c3d, Transform3D e2vpl, Transform3D e2vpr) {
        CanvasInfo ci = this.updateCache(c3d, "getEyeToViewPlatform", false);
        this.getEyeToViewPlatform(ci);
        e2vpl.set(ci.eyeToViewPlatform);
        if (ci.useStereo && e2vpr != null) {
            e2vpr.set(ci.rightEyeToViewPlatform);
        }
    }

    private void getEyeToViewPlatform(CanvasInfo ci) {
        if (ci.updateEyeToViewPlatform) {
            if (ci.eyeToViewPlatform == null) {
                ci.eyeToViewPlatform = new Transform3D();
            }
            this.getEyeToImagePlate(ci);
            this.getImagePlateToViewPlatform(ci);
            ci.eyeToViewPlatform.mul(ci.plateToViewPlatform, ci.eyeToPlate);
            if (ci.useStereo) {
                if (ci.rightEyeToViewPlatform == null) {
                    ci.rightEyeToViewPlatform = new Transform3D();
                }
                ci.rightEyeToViewPlatform.mul(ci.rightPlateToViewPlatform, ci.rightEyeToPlate);
            }
            ci.updateEyeToViewPlatform = false;
        }
    }

    public void getViewPlatformToEye(Canvas3D c3d, Transform3D vp2el, Transform3D vp2er) {
        CanvasInfo ci = this.updateCache(c3d, "getViewPlatformToEye", false);
        this.getViewPlatformToEye(ci);
        vp2el.set(ci.viewPlatformToEye);
        if (ci.useStereo && vp2er != null) {
            vp2er.set(ci.viewPlatformToRightEye);
        }
    }

    private void getViewPlatformToEye(CanvasInfo ci) {
        if (ci.updateViewPlatformToEye) {
            if (ci.viewPlatformToEye == null) {
                ci.viewPlatformToEye = new Transform3D();
            }
            this.getEyeToViewPlatform(ci);
            ci.viewPlatformToEye.invert(ci.eyeToViewPlatform);
            if (ci.useStereo) {
                if (ci.viewPlatformToRightEye == null) {
                    ci.viewPlatformToRightEye = new Transform3D();
                }
                ci.viewPlatformToRightEye.invert(ci.rightEyeToViewPlatform);
            }
            ci.updateViewPlatformToEye = false;
        }
    }

    public void getEyeToVworld(Canvas3D c3d, Transform3D e2vwl, Transform3D e2vwr) {
        CanvasInfo ci = this.updateCache(c3d, "getEyeToVworld", true);
        this.getEyeToVworld(ci);
        e2vwl.set(ci.eyeToVworld);
        if (ci.useStereo && e2vwr != null) {
            e2vwr.set(ci.rightEyeToVworld);
        }
    }

    private void getEyeToVworld(CanvasInfo ci) {
        if (ci.updateEyeToVworld) {
            if (ci.eyeToVworld == null) {
                ci.eyeToVworld = new Transform3D();
            }
            this.getEyeToViewPlatform(ci);
            ci.eyeToVworld.mul(this.vpi.viewPlatformToVworld, ci.eyeToViewPlatform);
            if (ci.useStereo) {
                if (ci.rightEyeToVworld == null) {
                    ci.rightEyeToVworld = new Transform3D();
                }
                ci.rightEyeToVworld.mul(this.vpi.viewPlatformToVworld, ci.rightEyeToViewPlatform);
            }
            ci.updateEyeToVworld = false;
        }
    }

    public void getProjection(Canvas3D c3d, Transform3D e2ccl, Transform3D e2ccr) {
        CanvasInfo ci = this.updateCache(c3d, "getProjection", true);
        this.getProjection(ci);
        e2ccl.set(ci.projection);
        if (ci.useStereo && e2ccr != null) {
            e2ccr.set(ci.rightProjection);
        }
    }

    private void getProjection(CanvasInfo ci) {
        if (ci.updateProjection) {
            if (ci.projection == null) {
                ci.projection = new Transform3D();
            }
            this.getEyeToImagePlate(ci);
            this.getClipDistances(ci);
            double backClip = this.getBackClip(ci, ci.eyeInPlate);
            this.computeProjection(ci, ci.eyeInPlate, this.getFrontClip(ci, ci.eyeInPlate), backClip, ci.projection);
            if (ci.useStereo) {
                if (ci.rightProjection == null) {
                    ci.rightProjection = new Transform3D();
                }
                this.computeProjection(ci, ci.rightEyeInPlate, this.getFrontClip(ci, ci.rightEyeInPlate), backClip, ci.rightProjection);
            }
            ci.updateProjection = false;
        }
    }

    public void getInverseProjection(Canvas3D c3d, Transform3D cc2el, Transform3D cc2er) {
        CanvasInfo ci = this.updateCache(c3d, "getInverseProjection", true);
        this.getInverseProjection(ci);
        cc2el.set(ci.inverseProjection);
        if (ci.useStereo && cc2er != null) {
            cc2er.set(ci.inverseRightProjection);
        }
    }

    private void getInverseProjection(CanvasInfo ci) {
        if (ci.updateInverseProjection) {
            if (ci.inverseProjection == null) {
                ci.inverseProjection = new Transform3D();
            }
            this.getProjection(ci);
            ci.inverseProjection.invert(ci.projection);
            if (ci.useStereo) {
                if (ci.inverseRightProjection == null) {
                    ci.inverseRightProjection = new Transform3D();
                }
                ci.inverseRightProjection.invert(ci.rightProjection);
            }
            ci.updateInverseProjection = false;
        }
    }

    public void getInverseViewPlatformProjection(Canvas3D c3d, Transform3D cc2vpl, Transform3D cc2vpr) {
        CanvasInfo ci = this.updateCache(c3d, "getInverseViewPlatformProjection", true);
        this.getInverseViewPlatformProjection(ci);
        cc2vpl.set(ci.inverseViewPlatformProjection);
        if (ci.useStereo & cc2vpr != null) {
            cc2vpr.set(ci.inverseViewPlatformRightProjection);
        }
    }

    private void getInverseViewPlatformProjection(CanvasInfo ci) {
        if (ci.updateInverseViewPlatformProjection) {
            if (ci.inverseViewPlatformProjection == null) {
                ci.inverseViewPlatformProjection = new Transform3D();
            }
            this.getInverseProjection(ci);
            this.getEyeToViewPlatform(ci);
            ci.inverseViewPlatformProjection.mul(ci.eyeToViewPlatform, ci.inverseProjection);
            if (ci.useStereo) {
                if (ci.inverseViewPlatformRightProjection == null) {
                    ci.inverseViewPlatformRightProjection = new Transform3D();
                }
                ci.inverseViewPlatformRightProjection.mul(ci.rightEyeToViewPlatform, ci.inverseRightProjection);
            }
            ci.updateInverseVworldProjection = false;
        }
    }

    public void getInverseVworldProjection(Canvas3D c3d, Transform3D cc2vwl, Transform3D cc2vwr) {
        CanvasInfo ci = this.updateCache(c3d, "getInverseVworldProjection", true);
        this.getInverseVworldProjection(ci);
        cc2vwl.set(ci.inverseVworldProjection);
        if (ci.useStereo & cc2vwr != null) {
            cc2vwr.set(ci.inverseVworldRightProjection);
        }
    }

    private void getInverseVworldProjection(CanvasInfo ci) {
        if (ci.updateInverseVworldProjection) {
            if (ci.inverseVworldProjection == null) {
                ci.inverseVworldProjection = new Transform3D();
            }
            this.getInverseViewPlatformProjection(ci);
            ci.inverseVworldProjection.mul(this.vpi.viewPlatformToVworld, ci.inverseViewPlatformProjection);
            if (ci.useStereo) {
                if (ci.inverseVworldRightProjection == null) {
                    ci.inverseVworldRightProjection = new Transform3D();
                }
                ci.inverseVworldRightProjection.mul(this.vpi.viewPlatformToVworld, ci.inverseViewPlatformRightProjection);
            }
            ci.updateInverseVworldProjection = false;
        }
    }

    private void computeProjection(CanvasInfo ci, Point3d eye, double front, double back, Transform3D p) {
        double lx = ci.canvasX - eye.x;
        double ly = ci.canvasY - eye.y;
        double hx = ci.canvasX + ci.canvasWidth - eye.x;
        double hy = ci.canvasY + ci.canvasHeight - eye.y;
        double nz = front - eye.z;
        double fz = back - eye.z;
        double iz = -eye.z;
        if (this.projectionPolicy == 1) {
            this.computePerspectiveProjection(lx, ly, hx, hy, iz, nz, fz, this.m16d);
        } else {
            this.computeParallelProjection(lx, ly, hx, hy, nz, fz, this.m16d);
        }
        p.set(this.m16d);
    }

    private void computePerspectiveProjection(double lx, double ly, double hx, double hy, double iz, double nz, double fz, double[] m2) {
        double idx = 1.0 / (hx - lx);
        double idy = 1.0 / (hy - ly);
        double idz = 1.0 / (nz - fz);
        m2[0] = -2.0 * iz * idx;
        m2[5] = -2.0 * iz * idy;
        m2[2] = (hx + lx) * idx;
        m2[6] = (hy + ly) * idy;
        m2[10] = -(nz + fz) * idz;
        m2[11] = 2.0 * fz * nz * idz;
        m2[14] = -1.0;
        m2[15] = 0.0;
        m2[13] = 0.0;
        m2[12] = 0.0;
        m2[9] = 0.0;
        m2[8] = 0.0;
        m2[7] = 0.0;
        m2[4] = 0.0;
        m2[3] = 0.0;
        m2[1] = 0.0;
    }

    private void computeParallelProjection(double lx, double ly, double hx, double hy, double nz, double fz, double[] m2) {
        double idx = 1.0 / (hx - lx);
        double idy = 1.0 / (hy - ly);
        double idz = 1.0 / (nz - fz);
        m2[0] = 2.0 * idx;
        m2[5] = 2.0 * idy;
        m2[10] = 2.0 * idz;
        m2[3] = -(hx + lx) * idx;
        m2[7] = -(hy + ly) * idy;
        m2[11] = -(nz + fz) * idz;
        m2[15] = 1.0;
        m2[14] = 0.0;
        m2[13] = 0.0;
        m2[12] = 0.0;
        m2[9] = 0.0;
        m2[8] = 0.0;
        m2[6] = 0.0;
        m2[4] = 0.0;
        m2[2] = 0.0;
        m2[1] = 0.0;
    }

    private double getFrontClip(CanvasInfo ci, Point3d eye) {
        if (this.frontClipPolicy == 3 || this.frontClipPolicy == 2) {
            return eye.z - ci.frontClipDistance;
        }
        return -ci.frontClipDistance;
    }

    private double getBackClip(CanvasInfo ci, Point3d eye) {
        if (this.backClipPolicy == 3 || this.backClipPolicy == 2) {
            return eye.z - ci.backClipDistance;
        }
        return -ci.backClipDistance;
    }

    private double getClipScale(CanvasInfo ci, int clipPolicy) {
        if (clipPolicy == 2 || clipPolicy == 0) {
            this.getScreenScale(ci);
            if (this.resizePolicy == 1) {
                return this.vpi.vworldToViewPlatformScale * ci.screenScale * ci.windowScale;
            }
            return this.vpi.vworldToViewPlatformScale * ci.screenScale;
        }
        if (this.resizePolicy == 1) {
            return ci.windowScale;
        }
        return 1.0;
    }

    public double getPhysicalFrontClipDistance(Canvas3D c3d) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalFrontClipDistance", true);
        this.getClipDistances(ci);
        return ci.frontClipDistance;
    }

    public double getPhysicalBackClipDistance(Canvas3D c3d) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalBackClipDistance", true);
        this.getClipDistances(ci);
        return ci.backClipDistance;
    }

    private void getClipDistances(CanvasInfo ci) {
        if (ci.updateClipDistances) {
            ci.frontClipDistance = this.view.getFrontClipDistance() * this.getClipScale(ci, this.frontClipPolicy);
            ci.backClipDistance = this.view.getBackClipDistance() * this.getClipScale(ci, this.backClipPolicy);
            ci.updateClipDistances = false;
        }
    }

    private void getScreenScale(CanvasInfo ci) {
        if (ci.updateScreenScale) {
            if (this.scalePolicy == 0) {
                ci.screenScale = ci.si.screenWidth / 2.0;
            } else {
                ci.screenScale = this.view.getScreenScale();
            }
            ci.updateScreenScale = false;
        }
    }

    public double getPhysicalToViewPlatformScale(Canvas3D c3d) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalToViewPlatformScale", false);
        this.getPhysicalToViewPlatformScale(ci);
        return ci.physicalToVpScale;
    }

    private void getPhysicalToViewPlatformScale(CanvasInfo ci) {
        if (ci.updatePhysicalToVpScale) {
            this.getScreenScale(ci);
            if (this.resizePolicy == 1) {
                ci.physicalToVpScale = 1.0 / (ci.screenScale * ci.windowScale);
            } else {
                ci.physicalToVpScale = 1.0 / ci.screenScale;
            }
            ci.updatePhysicalToVpScale = false;
        }
    }

    public double getPhysicalToVirtualScale(Canvas3D c3d) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalToVirtualScale", true);
        this.getPhysicalToVirtualScale(ci);
        return ci.physicalToVirtualScale;
    }

    private void getPhysicalToVirtualScale(CanvasInfo ci) {
        if (ci.updatePhysicalToVirtualScale) {
            this.getPhysicalToViewPlatformScale(ci);
            ci.physicalToVirtualScale = ci.physicalToVpScale / this.vpi.vworldToViewPlatformScale;
            ci.updatePhysicalToVirtualScale = false;
        }
    }

    public double getPhysicalWidth(Canvas3D c3d) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalWidth", false);
        return ci.canvasWidth;
    }

    public double getPhysicalHeight(Canvas3D c3d) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalHeight", false);
        return ci.canvasHeight;
    }

    public void getPhysicalLocation(Canvas3D c3d, Point3d location) {
        CanvasInfo ci = this.updateCache(c3d, "getPhysicalLocation", false);
        location.set(ci.canvasX, ci.canvasY, 0.0);
    }

    public void getPixelLocationInImagePlate(Canvas3D c3d, int x, int y, Point3d location) {
        CanvasInfo ci = this.updateCache(c3d, "getPixelLocationInImagePlate", false);
        location.set(ci.canvasX + (double)x * ci.si.metersPerPixelX, ci.canvasY - (double)y * ci.si.metersPerPixelY + ci.canvasHeight, 0.0);
    }

    public void getSensorToVworld(Canvas3D c3d, Sensor sensor, Transform3D s2vw) {
        CanvasInfo ci = this.updateCache(c3d, "getSensorToVworld", true);
        this.getTrackerBaseToVworld(ci);
        sensor.getRead(s2vw);
        s2vw.mul(ci.trackerBaseToVworld, s2vw);
    }

    public void getTrackerBaseToViewPlatform(Canvas3D c3d, Transform3D tb2vp) {
        CanvasInfo ci = this.updateCache(c3d, "getTrackerBaseToViewPlatform", false);
        this.getTrackerBaseToViewPlatform(ci);
        tb2vp.set(ci.trackerBaseToViewPlatform);
    }

    private void getTrackerBaseToViewPlatform(CanvasInfo ci) {
        if (ci.updateTrackerBaseToViewPlatform) {
            if (ci.trackerBaseToViewPlatform == null) {
                ci.trackerBaseToViewPlatform = new Transform3D();
            }
            this.getViewPlatformToCoexistence(ci);
            ci.trackerBaseToViewPlatform.mul(this.coeToTrackerBase, ci.viewPlatformToCoe);
            ci.trackerBaseToViewPlatform.invert();
            ci.updateTrackerBaseToViewPlatform = false;
        }
    }

    public void getTrackerBaseToVworld(Canvas3D c3d, Transform3D tb2vw) {
        CanvasInfo ci = this.updateCache(c3d, "getTrackerBaseToVworld", true);
        this.getTrackerBaseToVworld(ci);
        tb2vw.set(ci.trackerBaseToVworld);
    }

    private void getTrackerBaseToVworld(CanvasInfo ci) {
        if (ci.updateTrackerBaseToVworld) {
            if (ci.trackerBaseToVworld == null) {
                ci.trackerBaseToVworld = new Transform3D();
            }
            this.getTrackerBaseToViewPlatform(ci);
            ci.trackerBaseToVworld.mul(this.vpi.viewPlatformToVworld, ci.trackerBaseToViewPlatform);
            ci.updateTrackerBaseToVworld = false;
        }
    }

    public static synchronized void clear() {
        Iterator i2 = staticVpMap.values().iterator();
        while (i2.hasNext()) {
            ((ViewPlatformInfo)i2.next()).clear();
        }
        staticVpMap.clear();
        i2 = staticSiMap.values().iterator();
        while (i2.hasNext()) {
            ((ScreenInfo)i2.next()).clear();
        }
        staticSiMap.clear();
    }

    public void updateScreen(Screen3D s3d) {
        ScreenInfo si = (ScreenInfo)this.screenMap.get(s3d);
        if (si != null) {
            si.updateScreen = true;
        }
    }

    public void updateCanvas(Canvas3D c3d) {
        CanvasInfo ci = (CanvasInfo)this.canvasMap.get(c3d);
        if (ci != null) {
            ci.updateCanvas = true;
        }
    }

    public void updateView() {
        this.updateView = true;
    }

    public void updateHead() {
        this.updateHead = true;
    }

    public void updateViewPlatform() {
        this.vpi.updateViewPlatformToVworld = true;
    }

    private void getAutoUpdate(CanvasInfo ci) {
        if ((this.autoUpdateFlags & 1) != 0) {
            ci.si.updateScreen = true;
        }
        if ((this.autoUpdateFlags & 2) != 0) {
            ci.updateCanvas = true;
        }
        if ((this.autoUpdateFlags & 0x10) != 0) {
            this.vpi.updateViewPlatformToVworld = true;
        }
        if ((this.autoUpdateFlags & 8) != 0) {
            this.updateHead = true;
        }
    }

    private CanvasInfo updateCache(Canvas3D c3d, String name, boolean vworld) {
        CanvasInfo ci;
        if (this.updateView || (this.autoUpdateFlags & 4) != 0) {
            this.getViewInfo();
        }
        if ((ci = (CanvasInfo)this.canvasMap.get(c3d)) == null) {
            throw new IllegalArgumentException("Specified Canvas3D is not a component of the View");
        }
        if (this.autoUpdate) {
            this.getAutoUpdate(ci);
        }
        if (ci.si.updateScreen) {
            ci.si.getScreenInfo();
        }
        if (ci.updateCanvas) {
            ci.getCanvasInfo();
        }
        if (vworld && this.vpi.updateViewPlatformToVworld) {
            this.vpi.getViewPlatformToVworld();
        }
        if (this.useTracking && this.updateHead) {
            this.getHeadInfo();
        }
        return ci;
    }

    private void getViewInfo() {
        int i2;
        if (this.canvasCount != this.view.numCanvas3Ds()) {
            this.canvasCount = this.view.numCanvas3Ds();
            this.getCanvases();
        } else {
            i2 = 0;
            while (i2 < this.canvasCount) {
                if (this.canvasMap.get(this.view.getCanvas3D(i2)) != this.canvasInfo[i2]) {
                    this.getCanvases();
                    break;
                }
                ++i2;
            }
        }
        this.getViewPlatform();
        this.body = this.view.getPhysicalBody();
        this.env = this.view.getPhysicalEnvironment();
        this.useTracking = this.useHeadTracking();
        if (this.view.getTrackingEnable() && this.env.getTrackingAvailable()) {
            int headIndex = this.env.getHeadIndex();
            this.headTracker = this.env.getSensor(headIndex);
        }
        this.viewPolicy = this.view.getViewPolicy();
        this.projectionPolicy = this.view.getProjectionPolicy();
        this.resizePolicy = this.view.getWindowResizePolicy();
        this.movementPolicy = this.view.getWindowMovementPolicy();
        this.eyePolicy = this.view.getWindowEyepointPolicy();
        this.scalePolicy = this.view.getScreenScalePolicy();
        this.backClipPolicy = this.view.getBackClipPolicy();
        this.frontClipPolicy = this.view.getFrontClipPolicy();
        if (this.useTracking || this.viewPolicy == 1) {
            if (this.headToHeadTracker == null) {
                this.headToHeadTracker = new Transform3D();
            }
            if (this.headTrackerToTrackerBase == null) {
                this.headTrackerToTrackerBase = new Transform3D();
            }
            if (this.viewPolicy == 1) {
                if (this.trackerBaseToHeadTracker == null) {
                    this.trackerBaseToHeadTracker = new Transform3D();
                }
                if (this.coeToHeadTracker == null) {
                    this.coeToHeadTracker = new Transform3D();
                }
            } else if (this.headToTrackerBase == null) {
                this.headToTrackerBase = new Transform3D();
            }
            this.body.getLeftEyePosition(this.leftEyeInHead);
            this.body.getRightEyePosition(this.rightEyeInHead);
            this.body.getHeadToHeadTracker(this.headToHeadTracker);
        }
        if (this.eyePolicy == 1 || this.eyePolicy == 2) {
            this.body.getLeftEyePosition(this.leftEyeInHead);
            this.body.getRightEyePosition(this.rightEyeInHead);
        }
        this.coeCentering = this.env.getCoexistenceCenterInPworldPolicy() != 2 || this.viewPolicy == 1 ? false : this.view.getCoexistenceCenteringEnable();
        if (!this.coeCentering || this.useTracking) {
            if (this.coeToTrackerBase == null) {
                this.coeToTrackerBase = new Transform3D();
            }
            this.env.getCoexistenceToTrackerBase(this.coeToTrackerBase);
        }
        this.clipVirtual = this.backClipPolicy == 2 || this.backClipPolicy == 0 || this.frontClipPolicy == 2 || this.frontClipPolicy == 0;
        i2 = 0;
        while (i2 < this.canvasCount) {
            this.canvasInfo[i2].updateViewDependencies();
            ++i2;
        }
        this.updateView = false;
    }

    private void getCanvases() {
        if (this.canvasInfo.length < this.canvasCount) {
            this.canvasInfo = new CanvasInfo[this.canvasCount];
        }
        int i2 = 0;
        while (i2 < this.canvasCount) {
            CanvasInfo ci;
            Canvas3D c3d = this.view.getCanvas3D(i2);
            Screen3D s3d = c3d.getScreen3D();
            ScreenInfo si = (ScreenInfo)this.screenMap.get(s3d);
            if (si == null) {
                si = new ScreenInfo(s3d, c3d.getGraphicsConfiguration());
                this.screenMap.put(s3d, si);
            }
            if (this.newSet.add(si)) {
                si.clear(this);
            }
            if ((ci = (CanvasInfo)this.canvasMap.get(c3d)) == null) {
                ci = new CanvasInfo(c3d, si);
            }
            si.addCanvasInfo(this, ci);
            this.newMap.put(c3d, ci);
            this.canvasInfo[i2] = ci;
            ++i2;
        }
        i2 = this.canvasCount;
        while (i2 < this.canvasInfo.length) {
            this.canvasInfo[i2] = null;
            ++i2;
        }
        Map tmp = this.canvasMap;
        this.canvasMap = this.newMap;
        this.newMap = tmp;
        this.newMap.clear();
        this.newSet.clear();
    }

    private void clearCanvases() {
        this.canvasCount = 0;
        this.canvasMap.clear();
        this.updateView = true;
    }

    private void getViewPlatform() {
        ViewPlatform vp = this.view.getViewPlatform();
        if (vp == null) {
            throw new IllegalStateException("The View must be attached to a ViewPlatform");
        }
        ViewPlatformInfo tmpVpi = (ViewPlatformInfo)this.viewPlatformMap.get(vp);
        if (tmpVpi == null) {
            tmpVpi = new ViewPlatformInfo(vp);
            this.viewPlatformMap.put(vp, tmpVpi);
        }
        if (this.vpi != tmpVpi) {
            if (this.vpi != null) {
                this.vpi.removeViewInfo(this);
            }
            this.vpi = tmpVpi;
            this.vpi.addViewInfo(this);
            if (vp.getCapability(11)) {
                this.vpi.updateViewPlatformToVworld = true;
            }
        }
    }

    private void clearViewPlatform() {
        this.updateView = true;
    }

    private void updateVworldDependencies() {
        int i2 = 0;
        while (i2 < this.canvasCount) {
            this.canvasInfo[i2].updateVworldDependencies();
            ++i2;
        }
    }

    protected Transform3D getHeadTrackerToTrackerBase() {
        this.headTracker.getRead(this.headTrackerToTrackerBase);
        return this.headTrackerToTrackerBase;
    }

    protected boolean useHeadTracking() {
        return this.view.getTrackingEnable() && this.env.getTrackingAvailable();
    }

    private void getHeadInfo() {
        this.headTrackerToTrackerBase = this.getHeadTrackerToTrackerBase();
        if (this.viewPolicy == 1) {
            this.trackerBaseToHeadTracker.invert(this.headTrackerToTrackerBase);
            this.coeToHeadTracker.mul(this.trackerBaseToHeadTracker, this.coeToTrackerBase);
        } else {
            this.headToTrackerBase.mul(this.headTrackerToTrackerBase, this.headToHeadTracker);
        }
        int i2 = 0;
        while (i2 < this.canvasCount) {
            this.canvasInfo[i2].updateHeadDependencies();
            ++i2;
        }
        this.updateHead = false;
    }

    private static void t3dPrint(Transform3D t3d, String name) {
        double[] m2 = new double[16];
        t3d.get(m2);
        String[] sa = ViewInfo.formatMatrixRows(4, 4, m2);
        System.err.println(name);
        int i2 = 0;
        while (i2 < 4) {
            System.err.println(sa[i2]);
            ++i2;
        }
    }

    private static String[] formatMatrixRows(int rowCount, int colCount, double[] m2) {
        DecimalFormat df = new DecimalFormat("0.000000");
        FieldPosition fp = new FieldPosition(0);
        StringBuffer sb0 = new StringBuffer();
        StringBuffer sb1 = new StringBuffer();
        String[] rows = new String[rowCount];
        int i2 = 0;
        while (i2 < rowCount) {
            sb0.setLength(0);
            int j2 = 0;
            while (j2 < colCount) {
                sb1.setLength(0);
                df.format(m2[i2 * colCount + j2], sb1, fp);
                int pad = 8 - fp.getEndIndex();
                int k2 = 0;
                while (k2 < pad) {
                    sb1.insert(0, " ");
                    ++k2;
                }
                sb0.append(sb1);
                ++j2;
            }
            rows[i2] = sb0.toString();
            ++i2;
        }
        return rows;
    }

    private class CanvasInfo {
        private Canvas3D c3d = null;
        private ScreenInfo si = null;
        private boolean updateCanvas = true;
        private double canvasX = 0.0;
        private double canvasY = 0.0;
        private boolean updatePosition = true;
        private double canvasWidth = 0.0;
        private double canvasHeight = 0.0;
        private double windowScale = 0.0;
        private boolean updateWindowScale = true;
        private double screenScale = 0.0;
        private boolean updateScreenScale = true;
        private boolean useStereo = false;
        private boolean updateStereo = true;
        private Transform3D coeToPlate = null;
        private Transform3D coeToRightPlate = null;
        private boolean updateCoeToPlate = true;
        private Transform3D viewPlatformToCoe = null;
        private Transform3D coeToViewPlatform = null;
        private boolean updateViewPlatformToCoe = true;
        private boolean updateCoeToViewPlatform = true;
        private Transform3D plateToViewPlatform = null;
        private Transform3D rightPlateToViewPlatform = null;
        private boolean updatePlateToViewPlatform = true;
        private Transform3D trackerBaseToViewPlatform = null;
        private boolean updateTrackerBaseToViewPlatform = true;
        private Point3d eyeInPlate = new Point3d();
        private Point3d rightEyeInPlate = new Point3d();
        private Transform3D eyeToPlate = null;
        private Transform3D rightEyeToPlate = null;
        private boolean updateEyeInPlate = true;
        private Point3d leftManualEyeInPlate = new Point3d();
        private Point3d rightManualEyeInPlate = new Point3d();
        private boolean updateManualEye = true;
        private int monoscopicPolicy = -1;
        private boolean updateMonoPolicy = true;
        private Transform3D eyeToViewPlatform = null;
        private Transform3D rightEyeToViewPlatform = null;
        private boolean updateEyeToViewPlatform = true;
        private Transform3D viewPlatformToEye = null;
        private Transform3D viewPlatformToRightEye = null;
        private boolean updateViewPlatformToEye = true;
        private Transform3D projection = null;
        private Transform3D rightProjection = null;
        private boolean updateProjection = true;
        private Transform3D inverseProjection = null;
        private Transform3D inverseRightProjection = null;
        private boolean updateInverseProjection = true;
        private Transform3D inverseViewPlatformProjection = null;
        private Transform3D inverseViewPlatformRightProjection = null;
        private boolean updateInverseViewPlatformProjection = true;
        private double frontClipDistance = 0.0;
        private double backClipDistance = 0.0;
        private boolean updateClipDistances = true;
        private double physicalToVpScale = 0.0;
        private double physicalToVirtualScale = 0.0;
        private boolean updatePhysicalToVpScale = true;
        private boolean updatePhysicalToVirtualScale = true;
        private Transform3D plateToVworld = null;
        private Transform3D rightPlateToVworld = null;
        private boolean updatePlateToVworld = true;
        private Transform3D coeToVworld = null;
        private boolean updateCoeToVworld = true;
        private Transform3D eyeToVworld = null;
        private Transform3D rightEyeToVworld = null;
        private boolean updateEyeToVworld = true;
        private Transform3D trackerBaseToVworld = null;
        private boolean updateTrackerBaseToVworld = true;
        private Transform3D inverseVworldProjection = null;
        private Transform3D inverseVworldRightProjection = null;
        private boolean updateInverseVworldProjection = true;

        private CanvasInfo(Canvas3D c3d, ScreenInfo si) {
            this.si = si;
            this.c3d = c3d;
        }

        private void getCanvasInfo() {
            int newMonoPolicy;
            boolean newStereo;
            boolean bl = newStereo = this.c3d.getStereoEnable() && this.c3d.getStereoAvailable();
            if (this.useStereo != newStereo) {
                this.useStereo = newStereo;
                this.updateStereo = true;
            }
            this.canvasWidth = (double)this.c3d.getWidth() * this.si.metersPerPixelX;
            this.canvasHeight = (double)this.c3d.getHeight() * this.si.metersPerPixelY;
            double newScale = this.canvasWidth / this.si.screenWidth;
            if (this.windowScale != newScale) {
                this.windowScale = newScale;
                this.updateWindowScale = true;
            }
            Point awtLocation = this.c3d.getLocationOnScreen();
            int x = awtLocation.x - ((ScreenInfo)this.si).screenBounds.x;
            int y = awtLocation.y - ((ScreenInfo)this.si).screenBounds.y;
            double newCanvasX = this.si.metersPerPixelX * (double)x;
            double newCanvasY = this.si.metersPerPixelY * (double)(((ScreenInfo)this.si).screenBounds.height - (y + this.c3d.getHeight()));
            if (this.canvasX != newCanvasX || this.canvasY != newCanvasY) {
                this.canvasX = newCanvasX;
                this.canvasY = newCanvasY;
                this.updatePosition = true;
            }
            if (this.monoscopicPolicy != (newMonoPolicy = this.c3d.getMonoscopicViewPolicy())) {
                this.monoscopicPolicy = newMonoPolicy;
                this.updateMonoPolicy = true;
            }
            this.c3d.getLeftManualEyeInImagePlate(ViewInfo.this.leftEye);
            this.c3d.getRightManualEyeInImagePlate(ViewInfo.this.rightEye);
            if (!ViewInfo.this.leftEye.equals(this.leftManualEyeInPlate) || !ViewInfo.this.rightEye.equals(this.rightManualEyeInPlate)) {
                this.leftManualEyeInPlate.set(ViewInfo.this.leftEye);
                this.rightManualEyeInPlate.set(ViewInfo.this.rightEye);
                this.updateManualEye = true;
            }
            this.updateCanvasDependencies();
            this.updateStereo = false;
            this.updateWindowScale = false;
            this.updatePosition = false;
            this.updateMonoPolicy = false;
            this.updateManualEye = false;
            this.updateCanvas = false;
        }

        private double getFieldOfViewOffset() {
            return 0.5 * this.canvasWidth / Math.tan(0.5 * ViewInfo.this.view.getFieldOfView());
        }

        private void updateScreenDependencies() {
            if (this.si.updatePixelSize || this.si.updateScreenSize) {
                if (ViewInfo.this.eyePolicy == 1 || ViewInfo.this.eyePolicy == 2) {
                    this.updateEyeInPlate = true;
                }
                if (ViewInfo.this.resizePolicy == 1 || ViewInfo.this.eyePolicy == 2) {
                    this.updateViewPlatformToCoe = true;
                }
                if (ViewInfo.this.resizePolicy == 1) {
                    this.updateClipDistances = true;
                    this.updatePhysicalToVpScale = true;
                    this.updatePhysicalToVirtualScale = true;
                }
                this.updateProjection = true;
            }
            if (this.si.updateScreenSize && ViewInfo.this.scalePolicy == 0) {
                this.updateScreenScale = true;
                this.updateClipDistances = true;
                this.updatePhysicalToVpScale = true;
                this.updatePhysicalToVirtualScale = true;
                this.updateViewPlatformToCoe = true;
            }
            if (ViewInfo.this.viewPolicy == 1) {
                if (this.si.updateHeadTrackerToPlate) {
                    this.updateEyeInPlate = true;
                    this.updateCoeToPlate = true;
                }
            } else if (ViewInfo.this.coeCentering) {
                if (ViewInfo.this.movementPolicy == 1) {
                    if (this.si.updatePixelSize || this.si.updateScreenSize) {
                        this.updateCoeToPlate = true;
                    }
                } else if (this.si.updateScreenSize) {
                    this.updateCoeToPlate = true;
                }
            } else if (this.si.updateTrackerBaseToPlate) {
                this.updateCoeToPlate = true;
            }
            if (this.updateCoeToPlate && ViewInfo.this.eyePolicy == 3) {
                this.updateEyeInPlate = true;
            }
            if (this.updateViewPlatformToCoe) {
                this.updateCoeToViewPlatform = true;
                this.updateCoeToVworld = true;
                this.updateTrackerBaseToViewPlatform = true;
                this.updateTrackerBaseToVworld = true;
            }
            if (this.updateCoeToPlate || this.updateViewPlatformToCoe) {
                this.updatePlateToViewPlatform = true;
                this.updatePlateToVworld = true;
            }
            this.updateEyeDependencies();
        }

        private void updateEyeDependencies() {
            if (this.updateEyeInPlate) {
                this.updateEyeToVworld = true;
                this.updateProjection = true;
            }
            if (this.updateProjection) {
                this.updateInverseProjection = true;
                this.updateInverseViewPlatformProjection = true;
                this.updateInverseVworldProjection = true;
            }
            if (this.updateEyeInPlate || this.updatePlateToViewPlatform) {
                this.updateViewPlatformToEye = true;
                this.updateEyeToViewPlatform = true;
            }
        }

        private void updateCanvasDependencies() {
            if (this.updateStereo || this.updateMonoPolicy || this.updateManualEye && (ViewInfo.this.eyePolicy == 1 || ViewInfo.this.eyePolicy == 0)) {
                this.updateEyeInPlate = true;
            }
            if (this.updateWindowScale || this.updatePosition) {
                if (ViewInfo.this.coeCentering && ViewInfo.this.movementPolicy == 1) {
                    this.updateCoeToPlate = true;
                    if (ViewInfo.this.eyePolicy == 3) {
                        this.updateEyeInPlate = true;
                    }
                }
                if (ViewInfo.this.eyePolicy == 2 || ViewInfo.this.eyePolicy == 1) {
                    this.updateEyeInPlate = true;
                }
            }
            if (this.updateWindowScale) {
                if (ViewInfo.this.resizePolicy == 1 || ViewInfo.this.eyePolicy == 2) {
                    this.updateViewPlatformToCoe = true;
                    this.updateCoeToViewPlatform = true;
                    this.updateCoeToVworld = true;
                    this.updateTrackerBaseToViewPlatform = true;
                    this.updateTrackerBaseToVworld = true;
                }
                if (ViewInfo.this.resizePolicy == 1) {
                    this.updateClipDistances = true;
                    this.updateProjection = true;
                    this.updatePhysicalToVpScale = true;
                    this.updatePhysicalToVirtualScale = true;
                }
            }
            if (this.updateViewPlatformToCoe || this.updateCoeToPlate) {
                this.updatePlateToViewPlatform = true;
                this.updatePlateToVworld = true;
            }
            if (ViewInfo.this.coeCentering && !this.updateManualEye && !this.updateWindowScale && ViewInfo.this.movementPolicy == 1 && ViewInfo.this.eyePolicy != 0) {
                return;
            }
            this.updateEyeDependencies();
        }

        private void updateViewDependencies() {
            this.updateEyeInPlate = true;
            this.updateProjection = true;
            this.updateClipDistances = true;
            this.updatePhysicalToVpScale = true;
            this.updatePhysicalToVirtualScale = true;
            this.updateCoeToPlate = true;
            this.updateViewPlatformToCoe = true;
            this.updateCoeToViewPlatform = true;
            this.updateCoeToVworld = true;
            this.updatePlateToViewPlatform = true;
            this.updatePlateToVworld = true;
            this.updateTrackerBaseToViewPlatform = true;
            this.updateTrackerBaseToVworld = true;
            this.updateScreenScale = true;
            this.updateEyeDependencies();
        }

        private void updateHeadDependencies() {
            if (ViewInfo.this.viewPolicy == 1) {
                this.updateCoeToPlate = true;
                this.updatePlateToViewPlatform = true;
                this.updatePlateToVworld = true;
                this.updateViewPlatformToEye = true;
                this.updateEyeToViewPlatform = true;
                this.updateEyeToVworld = true;
                this.updateInverseViewPlatformProjection = true;
                this.updateInverseVworldProjection = true;
            } else {
                this.updateEyeInPlate = true;
                this.updateEyeDependencies();
            }
        }

        private void updateVworldDependencies() {
            this.updatePlateToVworld = true;
            this.updateCoeToVworld = true;
            this.updateEyeToVworld = true;
            this.updateTrackerBaseToVworld = true;
            this.updateInverseVworldProjection = true;
            if (ViewInfo.this.vpi.updateVworldScale) {
                this.updatePhysicalToVirtualScale = true;
            }
            if (ViewInfo.this.vpi.updateVworldScale && ViewInfo.this.clipVirtual) {
                this.updateProjection = true;
                this.updateClipDistances = true;
                this.updateInverseProjection = true;
                this.updateInverseViewPlatformProjection = true;
            }
        }
    }

    private static class ScreenInfo {
        private Screen3D s3d = null;
        private GraphicsConfiguration graphicsConfiguration = null;
        private boolean updateScreen = true;
        private Map viewInfoMap = new HashMap();
        private List viewInfoList = new LinkedList();
        private Transform3D t3d = new Transform3D();
        private double screenWidth = 0.0;
        private double screenHeight = 0.0;
        private boolean updateScreenSize = true;
        private Rectangle screenBounds = null;
        private double metersPerPixelX = 0.0;
        private double metersPerPixelY = 0.0;
        private boolean updatePixelSize = true;
        private Transform3D trackerBaseToPlate = new Transform3D();
        private Transform3D headTrackerToLeftPlate = new Transform3D();
        private Transform3D headTrackerToRightPlate = new Transform3D();
        private boolean updateTrackerBaseToPlate = false;
        private boolean updateHeadTrackerToPlate = false;

        private ScreenInfo(Screen3D s3d, GraphicsConfiguration gc2) {
            this.s3d = s3d;
            this.graphicsConfiguration = gc2;
        }

        private List getCanvasList(ViewInfo vi) {
            LinkedList canvasList = (LinkedList)this.viewInfoMap.get(vi);
            if (canvasList == null) {
                canvasList = new LinkedList();
                this.viewInfoMap.put(vi, canvasList);
                this.viewInfoList.add(canvasList);
            }
            return canvasList;
        }

        private synchronized void clear(ViewInfo vi) {
            this.getCanvasList(vi).clear();
        }

        private synchronized void clear() {
            Iterator<Object> i2 = this.viewInfoMap.keySet().iterator();
            while (i2.hasNext()) {
                ((ViewInfo)i2.next()).clearCanvases();
            }
            this.viewInfoMap.clear();
            i2 = this.viewInfoList.iterator();
            while (i2.hasNext()) {
                ((List)i2.next()).clear();
            }
            this.viewInfoList.clear();
        }

        private synchronized void addCanvasInfo(ViewInfo vi, CanvasInfo ci) {
            this.getCanvasList(vi).add(ci);
        }

        private synchronized void getScreenInfo() {
            GraphicsConfiguration gc1;
            this.s3d.getTrackerBaseToImagePlate(this.t3d);
            if (!this.t3d.equals(this.trackerBaseToPlate)) {
                this.trackerBaseToPlate.set(this.t3d);
                this.updateTrackerBaseToPlate = true;
            }
            this.s3d.getHeadTrackerToLeftImagePlate(this.t3d);
            if (!this.t3d.equals(this.headTrackerToLeftPlate)) {
                this.headTrackerToLeftPlate.set(this.t3d);
                this.updateHeadTrackerToPlate = true;
            }
            this.s3d.getHeadTrackerToRightImagePlate(this.t3d);
            if (!this.t3d.equals(this.headTrackerToRightPlate)) {
                this.headTrackerToRightPlate.set(this.t3d);
                this.updateHeadTrackerToPlate = true;
            }
            double w = this.s3d.getPhysicalScreenWidth();
            double h2 = this.s3d.getPhysicalScreenHeight();
            if (w != this.screenWidth || h2 != this.screenHeight) {
                this.screenWidth = w;
                this.screenHeight = h2;
                this.updateScreenSize = true;
            }
            if ((gc1 = this.graphicsConfiguration) == null) {
                gc1 = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            }
            this.screenBounds = gc1.getBounds();
            double mpx = this.screenWidth / (double)this.screenBounds.width;
            double mpy = this.screenHeight / (double)this.screenBounds.height;
            if (mpx != this.metersPerPixelX || mpy != this.metersPerPixelY) {
                this.metersPerPixelX = mpx;
                this.metersPerPixelY = mpy;
                this.updatePixelSize = true;
            }
            Iterator vi = this.viewInfoList.iterator();
            while (vi.hasNext()) {
                Iterator ci = ((List)vi.next()).iterator();
                while (ci.hasNext()) {
                    ((CanvasInfo)ci.next()).updateScreenDependencies();
                }
            }
            this.updateTrackerBaseToPlate = false;
            this.updateHeadTrackerToPlate = false;
            this.updateScreenSize = false;
            this.updatePixelSize = false;
            this.updateScreen = false;
        }
    }

    private static class ViewPlatformInfo {
        private ViewPlatform vp = null;
        private List viewInfo = new LinkedList();
        private double[] m = new double[16];
        private Transform3D viewPlatformToVworld = new Transform3D();
        private Transform3D vworldToViewPlatform = new Transform3D();
        private double vworldToViewPlatformScale = 1.0;
        private boolean updateViewPlatformToVworld = false;
        private boolean updateVworldScale = false;

        private ViewPlatformInfo(ViewPlatform vp) {
            this.vp = vp;
        }

        private synchronized void addViewInfo(ViewInfo vi) {
            this.viewInfo.add(vi);
        }

        private synchronized void removeViewInfo(ViewInfo vi) {
            this.viewInfo.remove(vi);
        }

        private synchronized void clear() {
            Iterator i2 = this.viewInfo.iterator();
            while (i2.hasNext()) {
                ((ViewInfo)i2.next()).clearViewPlatform();
            }
            this.viewInfo.clear();
        }

        private synchronized void getViewPlatformToVworld() {
            this.vp.getLocalToVworld(this.viewPlatformToVworld);
            this.vworldToViewPlatform.invert(this.viewPlatformToVworld);
            this.vworldToViewPlatform.get(this.m);
            double newScale = Math.sqrt(this.m[0] * this.m[0] + this.m[1] * this.m[1] + this.m[2] * this.m[2]);
            if (newScale > this.vworldToViewPlatformScale + 1.0E-7 || newScale < this.vworldToViewPlatformScale - 1.0E-7) {
                this.vworldToViewPlatformScale = newScale;
                this.updateVworldScale = true;
            }
            Iterator i2 = this.viewInfo.iterator();
            while (i2.hasNext()) {
                ((ViewInfo)i2.next()).updateVworldDependencies();
            }
            this.updateVworldScale = false;
            this.updateViewPlatformToVworld = false;
        }
    }
}

