/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GraphicsConfigTemplate3D;
import org.jogamp.java3d.HiResCoord;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.View;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.java3d.utils.universe.LocaleFactory;
import org.jogamp.java3d.utils.universe.Viewer;
import org.jogamp.java3d.utils.universe.ViewingPlatform;

public class SimpleUniverse
extends VirtualUniverse {
    protected Locale locale;
    protected Viewer[] viewer = null;

    public SimpleUniverse() {
        this(null, 1, null, null);
    }

    public SimpleUniverse(int numTransforms) {
        this(null, numTransforms, null, null);
    }

    public SimpleUniverse(Canvas3D canvas) {
        this(null, 1, canvas, null);
    }

    public SimpleUniverse(Canvas3D canvas, int numTransforms) {
        this(null, numTransforms, canvas, null);
    }

    public SimpleUniverse(Canvas3D canvas, int numTransforms, LocaleFactory localeFactory) {
        this(null, numTransforms, canvas, null, localeFactory);
    }

    public SimpleUniverse(HiResCoord origin, int numTransforms, Canvas3D canvas, URL userConfig) {
        this(origin, numTransforms, canvas, userConfig, null);
    }

    public SimpleUniverse(HiResCoord origin, int numTransforms, Canvas3D canvas, URL userConfig, LocaleFactory localeFactory) {
        this.createLocale(origin, localeFactory);
        ViewingPlatform vwp = new ViewingPlatform(numTransforms);
        vwp.setUniverse(this);
        this.viewer = new Viewer[1];
        this.viewer[0] = new Viewer(canvas);
        this.viewer[0].setViewingPlatform(vwp);
        this.locale.addBranchGraph(vwp);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer) {
        this(viewingPlatform, viewer, null);
    }

    public SimpleUniverse(ViewingPlatform viewingPlatform, Viewer viewer, LocaleFactory localeFactory) {
        this.createLocale(null, localeFactory);
        viewingPlatform.setUniverse(this);
        this.viewer = new Viewer[1];
        this.viewer[0] = viewer;
        this.viewer[0].setViewingPlatform(viewingPlatform);
        this.locale.addBranchGraph(viewingPlatform);
    }

    SimpleUniverse(HiResCoord origin, LocaleFactory localeFactory) {
        this.createLocale(origin, localeFactory);
    }

    private void createLocale(HiResCoord origin, LocaleFactory localeFactory) {
        this.locale = localeFactory != null ? (origin != null ? localeFactory.createLocale(this, origin) : localeFactory.createLocale(this)) : (origin != null ? new Locale(this, origin) : new Locale(this));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Viewer getViewer() {
        return this.viewer[0];
    }

    public ViewingPlatform getViewingPlatform() {
        return this.viewer[0].getViewingPlatform();
    }

    public Canvas3D getCanvas() {
        return this.getCanvas(0);
    }

    public Canvas3D getCanvas(int canvasNum) {
        return this.viewer[0].getCanvas3D(canvasNum);
    }

    public void addBranchGraph(BranchGroup bg) {
        this.locale.addBranchGraph(bg);
    }

    public static GraphicsConfiguration getPreferredConfiguration() {
        GraphicsConfigTemplate3D template = new GraphicsConfigTemplate3D();
        String stereo = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("j3d.stereo");
            }
        });
        if (stereo != null) {
            if (stereo.equals("REQUIRED")) {
                template.setStereo(1);
            } else if (stereo.equals("PREFERRED")) {
                template.setStereo(2);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getBestConfiguration(template);
    }

    public void cleanup() {
        View view = this.viewer[0].getView();
        int i2 = view.numCanvas3Ds() - 1;
        while (i2 >= 0) {
            Canvas3D c2 = view.getCanvas3D(i2);
            if (c2.isOffScreen()) {
                c2.setOffScreenBuffer(null);
            }
            --i2;
        }
        view.removeAllCanvas3Ds();
        this.viewer[0].setViewingPlatform(null);
        this.removeAllLocales();
        Primitive.clearGeometryCache();
    }
}

