/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.universe;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jogamp.java3d.utils.universe.ConfigCommand;
import org.jogamp.java3d.utils.universe.ConfigDevice;
import org.jogamp.java3d.utils.universe.ConfigObject;
import org.jogamp.java3d.utils.universe.ConfigPhysicalBody;
import org.jogamp.java3d.utils.universe.ConfigPhysicalEnvironment;
import org.jogamp.java3d.utils.universe.ConfigScreen;
import org.jogamp.java3d.utils.universe.ConfigSensor;
import org.jogamp.java3d.utils.universe.ConfigSexpression;
import org.jogamp.java3d.utils.universe.ConfigView;
import org.jogamp.java3d.utils.universe.ConfigViewPlatform;
import org.jogamp.java3d.utils.universe.ConfigViewPlatformBehavior;

public class ConfigContainer {
    private Map baseNameMap = new HashMap();
    private Map viewCanvasMap = new HashMap();
    private ReadOnlyMap bodyMap = null;
    private ReadOnlyMap environmentMap = null;
    private ReadOnlyMap viewerMap = null;
    private ReadOnlyMap deviceMap = null;
    private ReadOnlyMap sensorMap = null;
    private ReadOnlyMap behaviorMap = null;
    private ReadOnlyMap platformMap = null;
    private ReadOnlyMap genericObjectMap = null;
    private ReadOnlySet bodies = null;
    private ReadOnlySet environments = null;
    private ReadOnlySet viewers = null;
    private ReadOnlySet devices = null;
    private ReadOnlySet sensors = null;
    private ReadOnlySet behaviors = null;
    private ReadOnlySet platforms = null;
    private ReadOnlySet genericObjects = null;
    private int transformCount = 1;
    private boolean setVisible = false;
    private ClassLoader classLoader = ClassLoader.getSystemClassLoader();
    String currentFileName = null;

    public ConfigContainer(URL userConfig) {
        this(userConfig, false, 1, true);
    }

    public ConfigContainer(URL userConfig, ClassLoader classLoader) {
        this(userConfig, false, 1, true, classLoader);
    }

    public ConfigContainer(URL userConfig, boolean setVisible, int transformCount) {
        this(userConfig, setVisible, transformCount, true);
    }

    public ConfigContainer(URL userConfig, boolean setVisible, int transformCount, ClassLoader classLoader) {
        this(userConfig, setVisible, transformCount, true, classLoader);
    }

    ConfigContainer(URL userConfig, boolean setVisible, int transformCount, boolean attachBehaviors) {
        if (transformCount < 1) {
            throw new IllegalArgumentException("transformCount must be greater than 0");
        }
        this.loadConfig(userConfig);
        this.processConfig(setVisible, transformCount, attachBehaviors);
    }

    ConfigContainer(URL userConfig, boolean setVisible, int transformCount, boolean attachBehaviors, ClassLoader classLoader) {
        this(userConfig, setVisible, transformCount, attachBehaviors);
        this.classLoader = classLoader;
    }

    private void loadConfig(URL userConfig) {
        InputStream inputStream = null;
        StreamTokenizer streamTokenizer = null;
        String lastFileName = this.currentFileName;
        this.currentFileName = userConfig.toString();
        try {
            inputStream = userConfig.openStream();
            BufferedReader r = new BufferedReader(new InputStreamReader(inputStream));
            streamTokenizer = new StreamTokenizer(r);
        }
        catch (IOException e2) {
            throw new IllegalArgumentException(e2 + "\nUnable to open " + this.currentFileName);
        }
        streamTokenizer.ordinaryChar(47);
        streamTokenizer.wordChars(95, 95);
        streamTokenizer.wordChars(36, 36);
        streamTokenizer.wordChars(123, 125);
        streamTokenizer.slashSlashComments(true);
        streamTokenizer.slashStarComments(true);
        ConfigSexpression sexp = new ConfigSexpression();
        while (sexp.parseAndEval(this, streamTokenizer, 0) != Boolean.FALSE) {
        }
        try {
            inputStream.close();
        }
        catch (IOException e3) {
            throw new IllegalArgumentException(e3 + "\nUnable to close " + this.currentFileName);
        }
        this.currentFileName = lastFileName;
    }

    void evaluateCommand(ArrayList elements, int lineNumber) {
        ConfigCommand cmd = new ConfigCommand(elements, this.currentFileName, lineNumber);
        switch (cmd.type) {
            case 0: {
                ConfigObject co = this.createConfigObject(cmd);
                this.addConfigObject(co);
                break;
            }
            case 3: {
                ConfigObject co = this.createConfigAlias(cmd);
                this.addConfigObject(co);
                break;
            }
            case 2: {
                ConfigObject co = this.findConfigObject(cmd.baseName, cmd.instanceName);
                co.setProperty(cmd);
                break;
            }
            case 5: {
                if (!(cmd.argv[1] instanceof String)) {
                    throw new IllegalArgumentException("Include file must be a URL string");
                }
                URL url = null;
                String urlString = (String)cmd.argv[1];
                try {
                    url = new URL(urlString);
                }
                catch (MalformedURLException e2) {
                    throw new IllegalArgumentException(e2.toString());
                }
                this.loadConfig(url);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown command \"" + cmd.commandName + "\"");
            }
        }
    }

    private ConfigObject createConfigObject(ConfigCommand cmd) {
        Class<?> objectClass = null;
        ConfigObject configObject = null;
        try {
            objectClass = Class.forName("org.jogamp.java3d.utils.universe.Config" + cmd.baseName);
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("\"" + cmd.baseName + "\"" + " is not a configurable object; ignoring command");
        }
        try {
            configObject = (ConfigObject)objectClass.newInstance();
        }
        catch (IllegalAccessException e3) {
            System.out.println(e3);
            throw new IllegalArgumentException("Ignoring command");
        }
        catch (InstantiationException e4) {
            System.out.println(e4);
            throw new IllegalArgumentException("Ignoring command");
        }
        int i2 = 2;
        while (i2 < cmd.argc) {
            if (cmd.argv[i2] instanceof String && ((String)cmd.argv[i2]).equals("Alias")) {
                if (i2 == cmd.argc - 2 && cmd.argv[i2 + 1] instanceof String) {
                    this.addConfigObject(new ConfigAlias(cmd.baseName, (String)cmd.argv[i2 + 1], configObject));
                    cmd.argc -= 2;
                } else {
                    throw new IllegalArgumentException("The alias name must be a string and must be the last command argument");
                }
            }
            ++i2;
        }
        configObject.baseName = cmd.baseName;
        configObject.instanceName = cmd.instanceName;
        configObject.creatingCommand = cmd;
        configObject.configContainer = this;
        configObject.setClassLoader(this.classLoader);
        configObject.initialize(cmd);
        return configObject;
    }

    private ConfigObject createConfigAlias(ConfigCommand cmd) {
        if (cmd.argc != 3 || !(cmd.argv[2] instanceof String)) {
            throw new IllegalArgumentException("Command \"" + cmd.commandName + "\" requires an instance name as second argument");
        }
        ConfigObject original = this.findConfigObject(cmd.baseName, (String)cmd.argv[2]);
        return new ConfigAlias(cmd.baseName, cmd.instanceName, original);
    }

    private void addConfigObject(ConfigObject object) {
        ArrayList<ConfigObject> instances = (ArrayList<ConfigObject>)this.baseNameMap.get(object.baseName);
        if (instances == null) {
            instances = new ArrayList<ConfigObject>();
            this.baseNameMap.put(object.baseName, instances);
        }
        int i2 = 0;
        while (i2 < instances.size()) {
            ConfigObject co = (ConfigObject)instances.get(i2);
            if (co.instanceName.equals(object.instanceName)) {
                String base = object.baseName;
                if (base.equals("Screen")) {
                    base = "Screen or Window";
                }
                throw new IllegalArgumentException("Duplicate " + base + " instance name \"" + object.instanceName + "\" ignored");
            }
            ++i2;
        }
        instances.add(object);
    }

    ConfigObject findConfigObject(String baseName, String instanceName) {
        ArrayList instances = (ArrayList)this.baseNameMap.get(baseName);
        if (instances != null) {
            int i2 = 0;
            while (i2 < instances.size()) {
                ConfigObject configObject = (ConfigObject)instances.get(i2);
                if (configObject.instanceName.equals(instanceName)) {
                    if (configObject.isAlias) {
                        return configObject.original;
                    }
                    return configObject;
                }
                ++i2;
            }
        }
        if (baseName.equals("Screen")) {
            baseName = "Screen or Window";
        }
        throw new IllegalArgumentException(String.valueOf(baseName) + " \"" + instanceName + "\" not found");
    }

    Collection findConfigObjects(String baseName) {
        return this.findConfigObjects(baseName, true);
    }

    Collection findConfigObjects(String baseName, boolean filterAlias) {
        ArrayList instances = (ArrayList)this.baseNameMap.get(baseName);
        if (instances == null || instances.size() == 0) {
            return null;
        }
        if (filterAlias) {
            ArrayList<ConfigObject> output = new ArrayList<ConfigObject>();
            int i2 = 0;
            while (i2 < instances.size()) {
                ConfigObject configObject = (ConfigObject)instances.get(i2);
                if (!configObject.isAlias) {
                    output.add(configObject);
                }
                ++i2;
            }
            return output;
        }
        return instances;
    }

    private ConfigObject findConfigObject(String baseName, ConfigCommand cmd) {
        if (cmd.argc != 2 || !(cmd.argv[1] instanceof String)) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Parameter must be a single string"));
        }
        try {
            return this.findConfigObject(baseName, (String)cmd.argv[1]);
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, e2.getMessage()));
        }
    }

    Object evaluateBuiltIn(ConfigCommand cmd) {
        int argc = cmd.argc;
        Object[] argv = cmd.argv;
        if (cmd.commandName.equals("ConfigContainer")) {
            return this;
        }
        if (cmd.commandName.equals("Canvas3D")) {
            return ((ConfigScreen)this.findConfigObject((String)"Screen", (ConfigCommand)cmd)).j3dCanvas;
        }
        if (this.baseNameMap.get(cmd.commandName) != null) {
            return this.findConfigObject((String)cmd.commandName, (ConfigCommand)cmd).targetObject;
        }
        throw new IllegalArgumentException(ConfigObject.errorMessage(cmd, "Unknown built-in command \"" + cmd.commandName + "\""));
    }

    private void processConfig(boolean setVisible, int transformCount, boolean attachBehaviors) {
        Collection vp;
        Collection pe;
        this.setVisible = setVisible;
        this.transformCount = transformCount;
        Collection c2 = this.findConfigObjects("PhysicalBody");
        if (c2 != null) {
            this.processPhysicalBodies(c2);
        }
        if ((pe = this.findConfigObjects("PhysicalEnvironment")) != null) {
            this.processPhysicalEnvironments(pe);
        }
        if ((c2 = this.findConfigObjects("View")) != null) {
            this.processViews(c2, setVisible);
        }
        c2 = this.findConfigObjects("Device");
        Collection s = this.findConfigObjects("Sensor");
        if (c2 != null) {
            this.processDevices(c2, s, pe);
        }
        if ((vp = this.findConfigObjects("ViewPlatform")) != null) {
            this.processViewPlatforms(vp, transformCount);
        }
        if ((c2 = this.findConfigObjects("ViewPlatformBehavior")) != null) {
            this.processViewPlatformBehaviors(c2, vp, attachBehaviors);
        }
        if ((c2 = this.findConfigObjects("Object")) != null) {
            this.processGenericObjects(c2);
        }
    }

    private void processPhysicalEnvironments(Collection c2) {
        for (ConfigPhysicalEnvironment e2 : c2) {
            e2.targetObject = e2.createJ3dPhysicalEnvironment();
        }
    }

    private void processPhysicalBodies(Collection c2) {
        for (ConfigPhysicalBody b2 : c2) {
            b2.targetObject = b2.createJ3dPhysicalBody();
        }
    }

    private void processViews(Collection c2, boolean setVisible) {
        for (ConfigView v : c2) {
            v.targetObject = v.createViewer(setVisible);
        }
    }

    private void processDevices(Collection c2, Collection s, Collection p) {
        ConfigDevice cd2 = null;
        for (ConfigDevice cd2 : c2) {
            cd2.targetObject = cd2.createInputDevice();
        }
        Iterator i2 = c2.iterator();
        while (i2.hasNext()) {
            ((ConfigDevice)i2.next()).processProperties();
        }
        for (ConfigDevice cd2 : c2) {
            if (cd2.j3dInputDevice.initialize()) continue;
            throw new RuntimeException(ConfigDevice.errorMessage(cd2.creatingCommand, "could not initialize device \"" + cd2.instanceName + "\""));
        }
        if (s != null) {
            for (ConfigSensor cs : s) {
                cs.configureSensor();
                cs.targetObject = cs.j3dSensor;
            }
        }
        if (p != null) {
            i2 = p.iterator();
            while (i2.hasNext()) {
                ((ConfigPhysicalEnvironment)i2.next()).processDevices();
            }
        }
    }

    private void processViewPlatforms(Collection c2, int numTransforms) {
        for (ConfigViewPlatform cvp : c2) {
            cvp.targetObject = cvp.createViewingPlatform(numTransforms);
        }
    }

    private void processViewPlatformBehaviors(Collection behaviors, Collection viewPlatforms, boolean attach) {
        for (ConfigViewPlatformBehavior b2 : behaviors) {
            b2.targetObject = b2.createViewPlatformBehavior();
        }
        Iterator i2 = behaviors.iterator();
        while (i2.hasNext()) {
            ((ConfigViewPlatformBehavior)i2.next()).processProperties();
        }
        if (attach && viewPlatforms != null) {
            i2 = viewPlatforms.iterator();
            while (i2.hasNext()) {
                ((ConfigViewPlatform)i2.next()).processBehavior();
            }
        }
    }

    private void processGenericObjects(Collection objects) {
        for (ConfigObject o2 : objects) {
            o2.targetObject = o2.createTargetObject();
        }
        Iterator i2 = objects.iterator();
        while (i2.hasNext()) {
            ((ConfigObject)i2.next()).processProperties();
        }
    }

    private ReadOnlySet createSet(String baseName) {
        Collection c2 = this.findConfigObjects(baseName, true);
        if (c2 == null || c2.size() == 0) {
            return null;
        }
        Iterator i2 = c2.iterator();
        ArrayList<Object> l2 = new ArrayList<Object>();
        while (i2.hasNext()) {
            l2.add(((ConfigObject)i2.next()).targetObject);
        }
        return new ReadOnlySet(l2);
    }

    private ReadOnlyMap createMap(String baseName) {
        Collection c2 = this.findConfigObjects(baseName, false);
        if (c2 == null || c2.size() == 0) {
            return null;
        }
        Iterator i2 = c2.iterator();
        HashMap<String, Object> m2 = new HashMap<String, Object>();
        while (i2.hasNext()) {
            ConfigObject co = (ConfigObject)i2.next();
            if (co.isAlias) {
                m2.put(co.instanceName, co.original.targetObject);
                continue;
            }
            m2.put(co.instanceName, co.targetObject);
        }
        return new ReadOnlyMap(m2);
    }

    public Set getPhysicalBodies() {
        if (this.bodies != null) {
            return this.bodies;
        }
        this.bodies = this.createSet("PhysicalBody");
        return this.bodies;
    }

    public Map getNamedPhysicalBodies() {
        if (this.bodyMap != null) {
            return this.bodyMap;
        }
        this.bodyMap = this.createMap("PhysicalBody");
        return this.bodyMap;
    }

    public Set getPhysicalEnvironments() {
        if (this.environments != null) {
            return this.environments;
        }
        this.environments = this.createSet("PhysicalEnvironment");
        return this.environments;
    }

    public Map getNamedPhysicalEnvironments() {
        if (this.environmentMap != null) {
            return this.environmentMap;
        }
        this.environmentMap = this.createMap("PhysicalEnvironment");
        return this.environmentMap;
    }

    public Set getViewers() {
        if (this.viewers != null) {
            return this.viewers;
        }
        this.viewers = this.createSet("View");
        return this.viewers;
    }

    public Map getNamedViewers() {
        if (this.viewerMap != null) {
            return this.viewerMap;
        }
        this.viewerMap = this.createMap("View");
        return this.viewerMap;
    }

    public Set getInputDevices() {
        if (this.devices != null) {
            return this.devices;
        }
        this.devices = this.createSet("Device");
        return this.devices;
    }

    public Map getNamedInputDevices() {
        if (this.deviceMap != null) {
            return this.deviceMap;
        }
        this.deviceMap = this.createMap("Device");
        return this.deviceMap;
    }

    public Set getSensors() {
        if (this.sensors != null) {
            return this.sensors;
        }
        this.sensors = this.createSet("Sensor");
        return this.sensors;
    }

    public Map getNamedSensors() {
        if (this.sensorMap != null) {
            return this.sensorMap;
        }
        this.sensorMap = this.createMap("Sensor");
        return this.sensorMap;
    }

    public Set getViewingPlatforms() {
        if (this.platforms != null) {
            return this.platforms;
        }
        this.platforms = this.createSet("ViewPlatform");
        return this.platforms;
    }

    public Map getNamedViewingPlatforms() {
        if (this.platformMap != null) {
            return this.platformMap;
        }
        this.platformMap = this.createMap("ViewPlatform");
        return this.platformMap;
    }

    public Set getViewPlatformBehaviors() {
        if (this.behaviors != null) {
            return this.behaviors;
        }
        this.behaviors = this.createSet("ViewPlatformBehavior");
        return this.behaviors;
    }

    public Map getNamedViewPlatformBehaviors() {
        if (this.behaviorMap != null) {
            return this.behaviorMap;
        }
        this.behaviorMap = this.createMap("ViewPlatformBehavior");
        return this.behaviorMap;
    }

    public Map getNamedCanvases(String viewName) {
        AbstractMap m2 = (HashMap)this.viewCanvasMap.get(viewName);
        if (m2 != null) {
            return m2;
        }
        m2 = new HashMap();
        ConfigView cv = (ConfigView)this.findConfigObject("View", viewName);
        for (ConfigScreen cs : cv.screens) {
            m2.put(cs.instanceName, cs.j3dCanvas);
            Iterator j2 = cs.aliases.iterator();
            while (j2.hasNext()) {
                m2.put(j2.next(), cs.j3dCanvas);
            }
        }
        m2 = new ReadOnlyMap(m2);
        this.viewCanvasMap.put(viewName, m2);
        return m2;
    }

    public Set getGenericObjects() {
        if (this.genericObjects != null) {
            return this.genericObjects;
        }
        this.genericObjects = this.createSet("Object");
        return this.genericObjects;
    }

    public Map getNamedGenericObjects() {
        if (this.genericObjectMap != null) {
            return this.genericObjectMap;
        }
        this.genericObjectMap = this.createMap("Object");
        return this.genericObjectMap;
    }

    public int getViewPlatformTransformCount() {
        return this.transformCount;
    }

    public boolean getViewerVisibility() {
        return this.setVisible;
    }

    public void clear() {
        Iterator i2 = this.baseNameMap.values().iterator();
        while (i2.hasNext()) {
            ((Collection)i2.next()).clear();
        }
        this.baseNameMap.clear();
        i2 = this.viewCanvasMap.values().iterator();
        while (i2.hasNext()) {
            ((ReadOnlyMap)i2.next()).map.clear();
        }
        this.viewCanvasMap.clear();
        this.currentFileName = null;
        if (this.bodies != null) {
            this.bodies.collection.clear();
            this.bodies = null;
        }
        if (this.environments != null) {
            this.environments.collection.clear();
            this.environments = null;
        }
        if (this.devices != null) {
            this.devices.collection.clear();
            this.devices = null;
        }
        if (this.sensors != null) {
            this.sensors.collection.clear();
            this.sensors = null;
        }
        if (this.behaviors != null) {
            this.behaviors.collection.clear();
            this.behaviors = null;
        }
        if (this.platforms != null) {
            this.platforms.collection.clear();
            this.platforms = null;
        }
        if (this.viewers != null) {
            this.viewers.collection.clear();
            this.viewers = null;
        }
        if (this.genericObjects != null) {
            this.genericObjects.collection.clear();
            this.genericObjects = null;
        }
        if (this.bodyMap != null) {
            this.bodyMap.map.clear();
            this.bodyMap = null;
        }
        if (this.environmentMap != null) {
            this.environmentMap.map.clear();
            this.environmentMap = null;
        }
        if (this.deviceMap != null) {
            this.deviceMap.map.clear();
            this.deviceMap = null;
        }
        if (this.sensorMap != null) {
            this.sensorMap.map.clear();
            this.sensorMap = null;
        }
        if (this.behaviorMap != null) {
            this.behaviorMap.map.clear();
            this.behaviorMap = null;
        }
        if (this.platformMap != null) {
            this.platformMap.map.clear();
            this.platformMap = null;
        }
        if (this.viewerMap != null) {
            this.viewerMap.map.clear();
            this.viewerMap = null;
        }
        if (this.genericObjectMap != null) {
            this.genericObjectMap.map.clear();
            this.genericObjectMap = null;
        }
    }

    public static URL getConfigURL() {
        return ConfigContainer.getConfigURL(null);
    }

    public static URL getConfigURL(String defaultURLString) {
        URL url = null;
        String urlString = null;
        final String defProp = defaultURLString;
        urlString = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("j3d.configURL", defProp);
            }
        });
        if (urlString == null) {
            return null;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e2) {
            System.out.println(e2);
            return null;
        }
        return url;
    }

    private static class ConfigAlias
    extends ConfigObject {
        ConfigAlias(String baseName, String instanceName, ConfigObject targ) {
            this.baseName = baseName;
            this.instanceName = instanceName;
            this.isAlias = true;
            this.original = targ;
            targ.aliases.add(instanceName);
        }
    }

    private static class ReadOnlyIterator
    implements Iterator {
        private Iterator i;

        ReadOnlyIterator(Iterator i2) {
            this.i = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ReadOnlyMap
    extends AbstractMap {
        HashMap map;
        private Set entrySet = null;

        ReadOnlyMap(Map map) {
            this.map = new HashMap(map);
        }

        @Override
        public Object get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new ReadOnlySet(this.map.entrySet());
            }
            return this.entrySet;
        }
    }

    private static class ReadOnlySet
    extends AbstractSet {
        Collection collection = null;

        ReadOnlySet(Collection c2) {
            this.collection = c2;
        }

        @Override
        public int size() {
            return this.collection.size();
        }

        @Override
        public Iterator iterator() {
            return new ReadOnlyIterator(this.collection.iterator());
        }
    }
}

