/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.geometry;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.geometry.Cone;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.utils.geometry.PrimitiveState;

public class ConeState
extends PrimitiveState {
    private float radius = 1.0f;
    private float height = 2.0f;
    private int xdivision = 15;
    private int ydivision = 1;
    private int bodyAppearance = 0;
    private int capAppearance = 0;

    public ConeState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.bodyAppearance = control.getSymbolTable().addReference(((Cone)this.node).getShape(0).getAppearance());
            this.capAppearance = control.getSymbolTable().addReference(((Cone)this.node).getShape(1).getAppearance());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.bodyAppearance);
        out.writeInt(this.capAppearance);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.bodyAppearance = in.readInt();
        this.capAppearance = in.readInt();
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeFloat(((Cone)this.node).getRadius());
        out.writeFloat(((Cone)this.node).getHeight());
        out.writeInt(((Cone)this.node).getXdivisions());
        out.writeInt(((Cone)this.node).getYdivisions());
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.radius = in.readFloat();
        this.height = in.readFloat();
        this.xdivision = in.readInt();
        this.ydivision = in.readInt();
    }

    @Override
    public void buildGraph() {
        if (this.bodyAppearance == this.capAppearance) {
            ((Cone)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
        } else {
            ((Cone)this.node).setAppearance(0, (Appearance)this.control.getSymbolTable().getJ3dNode(this.bodyAppearance));
            ((Cone)this.node).setAppearance(1, (Appearance)this.control.getSymbolTable().getJ3dNode(this.capAppearance));
        }
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        Object[] objectArray = new Object[6];
        objectArray[0] = new Float(this.radius);
        objectArray[1] = new Float(this.height);
        objectArray[2] = new Integer(this.primflags);
        objectArray[3] = new Integer(this.xdivision);
        objectArray[4] = new Integer(this.ydivision);
        Cone cone = (Cone)this.createNode(j3dClass, new Class[]{Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Appearance.class}, objectArray);
        return cone;
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Cone(this.radius, this.height, this.primflags, this.xdivision, this.ydivision, null);
    }
}

