/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.ImageComponent2D;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.Texture2D;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.TextureState;

public class Texture2DState
extends TextureState {
    private int detailImage = 0;

    public Texture2DState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            Texture2D t = (Texture2D)this.node;
            this.detailImage = control.getSymbolTable().addReference(t.getDetailImage());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.detailImage);
        out.writeInt(((Texture2D)this.node).getDetailTextureMode());
        out.writeInt(((Texture2D)this.node).getDetailTextureLevel());
        int num = ((Texture2D)this.node).getDetailTextureFuncPointsCount();
        out.writeInt(num);
        float[] lod = new float[num];
        float[] pts = new float[num];
        ((Texture2D)this.node).getDetailTextureFunc(lod, pts);
        int i2 = 0;
        while (i2 < num) {
            out.writeFloat(lod[i2]);
            out.writeFloat(pts[i2]);
            ++i2;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.detailImage = in.readInt();
        ((Texture2D)this.node).setDetailTextureMode(in.readInt());
        ((Texture2D)this.node).setDetailTextureLevel(in.readInt());
        int num = in.readInt();
        float[] lod = new float[num];
        float[] pts = new float[num];
        int i2 = 0;
        while (i2 < num) {
            lod[i2] = in.readFloat();
            pts[i2] = in.readFloat();
            ++i2;
        }
        ((Texture2D)this.node).setDetailTextureFunc(lod, pts);
    }

    @Override
    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.detailImage);
    }

    @Override
    public void buildGraph() {
        Texture2D t = (Texture2D)this.node;
        t.setDetailImage((ImageComponent2D)this.control.getSymbolTable().getJ3dNode(this.detailImage));
        super.buildGraph();
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(this.mipMapMode), new Integer(this.format), new Integer(this.width), new Integer(this.height), new Integer(this.boundaryWidth)});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Texture2D(this.mipMapMode, this.format, this.width, this.height, this.boundaryWidth);
    }
}

