/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.PointSound;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SoundState;
import org.jogamp.vecmath.Point3f;

public class PointSoundState
extends SoundState {
    public PointSoundState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        float[] distance = new float[((PointSound)this.node).getDistanceGainLength()];
        float[] gain = new float[distance.length];
        ((PointSound)this.node).getDistanceGain(distance, gain);
        out.writeInt(distance.length);
        int i2 = 0;
        while (i2 < distance.length) {
            out.writeFloat(distance[i2]);
            out.writeFloat(gain[i2]);
            ++i2;
        }
        Point3f pos = new Point3f();
        ((PointSound)this.node).getPosition(pos);
        this.control.writePoint3f(out, pos);
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        float[] distance = new float[in.readInt()];
        float[] gain = new float[distance.length];
        int i2 = 0;
        while (i2 < distance.length) {
            distance[i2] = in.readFloat();
            gain[i2] = in.readFloat();
            ++i2;
        }
        ((PointSound)this.node).setDistanceGain(distance, gain);
        ((PointSound)this.node).setPosition(this.control.readPoint3f(in));
    }

    @Override
    protected SceneGraphObject createNode() {
        return new PointSound();
    }
}

