/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.OrderedGroup;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.GroupState;

public class OrderedGroupState
extends GroupState {
    public OrderedGroupState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        int[] childIndexOrder = ((OrderedGroup)this.node).getChildIndexOrder();
        out.writeInt(childIndexOrder.length);
        int i2 = 0;
        while (i2 < childIndexOrder.length) {
            out.writeInt(childIndexOrder[i2]);
            ++i2;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        int[] childIndexOrder = new int[in.readInt()];
        int i2 = 0;
        while (i2 < childIndexOrder.length) {
            childIndexOrder[i2] = in.readInt();
            ++i2;
        }
        ((OrderedGroup)this.node).setChildIndexOrder(childIndexOrder);
    }

    @Override
    protected SceneGraphObject createNode() {
        return new OrderedGroup();
    }
}

