/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.ModelClip;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;
import org.jogamp.vecmath.Vector4d;

public class ModelClipState
extends LeafState {
    private int[] scopes;
    private int influencingBoundingLeaf;

    public ModelClipState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.scopes = new int[((ModelClip)this.node).numScopes()];
            int i2 = 0;
            while (i2 < this.scopes.length) {
                this.scopes[i2] = control.getSymbolTable().addReference(((ModelClip)this.node).getScope(i2));
                ++i2;
            }
            this.influencingBoundingLeaf = control.getSymbolTable().addReference(((ModelClip)this.node).getInfluencingBoundingLeaf());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        boolean[] enables = new boolean[6];
        ((ModelClip)this.node).getEnables(enables);
        out.writeInt(this.scopes.length);
        int i2 = 0;
        while (i2 < this.scopes.length) {
            out.writeInt(this.scopes[i2]);
            ++i2;
        }
        out.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(out, ((ModelClip)this.node).getInfluencingBounds());
        Vector4d[] planes = new Vector4d[6];
        ((ModelClip)this.node).getPlanes(planes);
        int i3 = 0;
        while (i3 < 6) {
            out.writeBoolean(enables[i3]);
            this.control.writeVector4d(out, planes[i3]);
            ++i3;
        }
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.scopes = new int[in.readInt()];
        int i2 = 0;
        while (i2 < this.scopes.length) {
            this.scopes[i2] = in.readInt();
            ++i2;
        }
        this.influencingBoundingLeaf = in.readInt();
        ((ModelClip)this.node).setInfluencingBounds(this.control.readBounds(in));
        boolean[] enables = new boolean[6];
        Vector4d[] planes = new Vector4d[6];
        int i3 = 0;
        while (i3 < 6) {
            enables[i3] = in.readBoolean();
            planes[i3] = this.control.readVector4d(in);
            ++i3;
        }
        ((ModelClip)this.node).setEnables(enables);
        ((ModelClip)this.node).setPlanes(planes);
    }

    @Override
    public void buildGraph() {
        int i2 = 0;
        while (i2 < this.scopes.length) {
            ((ModelClip)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i2]));
            ++i2;
        }
        ((ModelClip)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new ModelClip();
    }
}

