/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.IndexedGeometryStripArray;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.GeometryArrayState;

public abstract class IndexedGeometryArrayState
extends GeometryArrayState {
    protected int indexCount;

    public IndexedGeometryArrayState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        boolean coordOnly;
        super.writeObject(out);
        int[] indices = new int[((IndexedGeometryArray)this.node).getIndexCount()];
        boolean bl = coordOnly = (this.vertexFormat & 0x200) != 0;
        if (!((this.vertexFormat & 4) == 0 && (this.vertexFormat & 0xC) == 0 || coordOnly)) {
            ((IndexedGeometryArray)this.node).getColorIndices(0, indices);
            this.writeIntArray(out, indices);
        }
        if ((this.vertexFormat & 1) != 0) {
            ((IndexedGeometryArray)this.node).getCoordinateIndices(0, indices);
            this.writeIntArray(out, indices);
        }
        if ((this.vertexFormat & 2) != 0 && !coordOnly) {
            ((IndexedGeometryArray)this.node).getNormalIndices(0, indices);
            this.writeIntArray(out, indices);
        }
        if (!((this.vertexFormat & 0x20) == 0 && (this.vertexFormat & 0x40) == 0 && (this.vertexFormat & 0x400) == 0 || coordOnly)) {
            int i2 = 0;
            while (i2 < ((IndexedGeometryArray)this.node).getTexCoordSetCount()) {
                ((IndexedGeometryArray)this.node).getTextureCoordinateIndices(i2, 0, indices);
                this.writeIntArray(out, indices);
                ++i2;
            }
        }
        if (!(this.node instanceof IndexedGeometryStripArray)) {
            out.writeInt(((IndexedGeometryArray)this.node).getValidIndexCount());
        }
        out.writeInt(((IndexedGeometryArray)this.node).getInitialIndexIndex());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        boolean coordOnly;
        super.readObject(in);
        int[] indices = new int[this.indexCount];
        boolean bl = coordOnly = (this.vertexFormat & 0x200) != 0;
        if (!((this.vertexFormat & 4) == 0 && (this.vertexFormat & 0xC) == 0 || coordOnly)) {
            this.readIntArray(in, indices);
            ((IndexedGeometryArray)this.node).setColorIndices(0, indices);
        }
        if ((this.vertexFormat & 1) != 0) {
            this.readIntArray(in, indices);
            ((IndexedGeometryArray)this.node).setCoordinateIndices(0, indices);
        }
        if ((this.vertexFormat & 2) != 0 && !coordOnly) {
            this.readIntArray(in, indices);
            ((IndexedGeometryArray)this.node).setNormalIndices(0, indices);
        }
        if (!((this.vertexFormat & 0x20) == 0 && (this.vertexFormat & 0x40) == 0 && (this.vertexFormat & 0x400) == 0 || coordOnly)) {
            int i2 = 0;
            while (i2 < this.texCoordSetCount) {
                this.readIntArray(in, indices);
                ((IndexedGeometryArray)this.node).setTextureCoordinateIndices(i2, 0, indices);
                ++i2;
            }
        }
        if (!(this.node instanceof IndexedGeometryStripArray)) {
            ((IndexedGeometryArray)this.node).setValidIndexCount(in.readInt());
        }
        ((IndexedGeometryArray)this.node).setInitialIndexIndex(in.readInt());
    }

    @Override
    protected void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        out.writeInt(((IndexedGeometryArray)this.node).getIndexCount());
    }

    @Override
    protected void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        this.indexCount = in.readInt();
    }

    protected void writeIntArray(DataOutput out, int[] array) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(byteStream);
        int i2 = 0;
        while (i2 < array.length) {
            dataOut.writeInt(array[i2]);
            ++i2;
        }
        dataOut.close();
        out.writeInt(byteStream.size());
        out.write(byteStream.toByteArray());
    }

    private void readIntArray(DataInput in, int[] array) throws IOException {
        byte[] buffer = new byte[in.readInt()];
        in.readFully(buffer);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(buffer);
        DataInputStream dataIn = new DataInputStream(byteStream);
        int i2 = 0;
        while (i2 < array.length) {
            array[i2] = dataIn.readInt();
            ++i2;
        }
        dataIn.close();
    }
}

