/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.SceneGraphIO;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeState;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SceneGraphObjectState;

public class GroupState
extends NodeState {
    protected SceneGraphObjectState[] groupChildren;

    public GroupState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        this.control.writeBounds(out, ((Group)this.node).getCollisionBounds());
        int numChildren = this.checkProcessChildren() ? ((Group)this.node).numChildren() : 0;
        out.writeInt(numChildren);
        int i2 = 0;
        while (i2 < numChildren) {
            this.control.writeObject(out, this.control.createState(((Group)this.node).getChild(i2)));
            ++i2;
        }
        out.writeBoolean(((Group)this.node).getAlternateCollisionTarget());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        ((Group)this.node).setCollisionBounds(this.control.readBounds(in));
        int numChildren = in.readInt();
        this.groupChildren = new SceneGraphObjectState[numChildren];
        int i2 = 0;
        while (i2 < numChildren) {
            this.groupChildren[i2] = this.control.readObject(in);
            ((Group)this.node).addChild((Node)this.groupChildren[i2].getNode());
            ++i2;
        }
        ((Group)this.node).setAlternateCollisionTarget(in.readBoolean());
    }

    private boolean checkProcessChildren() {
        if (this.node instanceof SceneGraphIO) {
            return ((SceneGraphIO)((Object)this.node)).saveChildren();
        }
        return this.processChildren();
    }

    protected boolean processChildren() {
        return true;
    }

    @Override
    public void buildGraph() {
        int i2 = 0;
        while (i2 < this.groupChildren.length) {
            if (!this.groupChildren[i2].getSymbol().graphBuilt) {
                this.groupChildren[i2].getSymbol().graphBuilt = true;
                this.groupChildren[i2].buildGraph();
            }
            ++i2;
        }
        super.buildGraph();
    }

    @Override
    public void cleanup() {
        int i2 = 0;
        while (i2 < this.groupChildren.length) {
            this.groupChildren[i2].cleanup();
            this.groupChildren[i2] = null;
            ++i2;
        }
        this.groupChildren = null;
        super.cleanup();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Group();
    }
}

