/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.awt.Font;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.Font3D;
import org.jogamp.java3d.FontExtrusion;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;

public class Font3DState
extends NodeComponentState {
    private Font font = null;
    private double tesselationTolerance = 0.0;
    private FontExtrusion extrudePath = null;

    public Font3DState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
    }

    @Override
    public void writeConstructorParams(DataOutput out) throws IOException {
        super.writeConstructorParams(out);
        Font3D font3D = (Font3D)this.node;
        this.font = font3D.getFont();
        out.writeUTF(this.font.getFontName());
        out.writeInt(this.font.getStyle());
        out.writeInt(this.font.getSize());
        out.writeDouble(font3D.getTessellationTolerance());
        this.extrudePath = new FontExtrusion();
        font3D.getFontExtrusion(this.extrudePath);
        if (this.extrudePath.getExtrusionShape() == null) {
            this.extrudePath = null;
        }
        if (this.extrudePath != null) {
            Shape shape = this.extrudePath.getExtrusionShape();
            if (shape != null) {
                PathIterator shapePath = shape.getPathIterator(null);
                float[] coords = new float[6];
                while (!shapePath.isDone()) {
                    int segType = shapePath.currentSegment(coords);
                    out.writeInt(segType);
                    int points = 0;
                    if (segType == 0) {
                        points = 1;
                    } else if (segType == 1) {
                        points = 1;
                    } else if (segType == 2) {
                        points = 2;
                    } else if (segType == 3) {
                        points = 3;
                    }
                    int i2 = 0;
                    while (i2 < points) {
                        out.writeFloat(coords[i2 * 2 + 0]);
                        out.writeFloat(coords[i2 * 2 + 1]);
                        ++i2;
                    }
                    if (shapePath.isDone()) continue;
                    shapePath.next();
                }
            }
            out.writeInt(Integer.MIN_VALUE);
            out.writeDouble(this.extrudePath.getTessellationTolerance());
        } else {
            out.writeInt(Integer.MIN_VALUE);
        }
    }

    @Override
    public void readConstructorParams(DataInput in) throws IOException {
        super.readConstructorParams(in);
        String fontName = in.readUTF();
        int style = in.readInt();
        int size = in.readInt();
        this.font = new Font(fontName, style, size);
        this.tesselationTolerance = in.readDouble();
        GeneralPath shape = null;
        int segType = in.readInt();
        while (segType != Integer.MIN_VALUE) {
            if (shape == null) {
                shape = new GeneralPath();
            }
            if (segType == 0) {
                shape.moveTo(in.readFloat(), in.readFloat());
            } else if (segType == 1) {
                shape.lineTo(in.readFloat(), in.readFloat());
            } else if (segType == 2) {
                shape.quadTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
            } else if (segType == 3) {
                shape.curveTo(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat());
            } else if (segType == 4) {
                shape.closePath();
            }
            segType = in.readInt();
        }
        this.extrudePath = shape != null ? new FontExtrusion(shape, in.readDouble()) : null;
    }

    @Override
    public SceneGraphObject createNode(Class j3dClass) {
        return this.createNode(j3dClass, new Class[]{Font.class, Double.TYPE, FontExtrusion.class}, new Object[]{this.font, new Double(this.tesselationTolerance), this.extrudePath});
    }

    @Override
    protected SceneGraphObject createNode() {
        return new Font3D(this.font, this.tesselationTolerance, this.extrudePath);
    }
}

