/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jogamp.java3d.AlternateAppearance;
import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.BoundingLeaf;
import org.jogamp.java3d.Group;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.LeafState;

public class AlternateAppearanceState
extends LeafState {
    private int[] scopes;
    private int appearance;
    private int influencingBoundingLeaf;

    public AlternateAppearanceState(SymbolTableData symbol, Controller control) {
        super(symbol, control);
        if (this.node != null) {
            this.scopes = new int[((AlternateAppearance)this.node).numScopes()];
            int i2 = 0;
            while (i2 < this.scopes.length) {
                this.scopes[i2] = control.getSymbolTable().addReference(((AlternateAppearance)this.node).getScope(i2));
                ++i2;
            }
            this.appearance = control.getSymbolTable().addReference(((AlternateAppearance)this.node).getAppearance());
            this.influencingBoundingLeaf = control.getSymbolTable().addReference(((AlternateAppearance)this.node).getInfluencingBoundingLeaf());
        }
    }

    @Override
    public void writeObject(DataOutput out) throws IOException {
        super.writeObject(out);
        out.writeInt(this.scopes.length);
        int i2 = 0;
        while (i2 < this.scopes.length) {
            out.writeInt(this.scopes[i2]);
            ++i2;
        }
        out.writeInt(this.appearance);
        out.writeInt(this.influencingBoundingLeaf);
        this.control.writeBounds(out, ((AlternateAppearance)this.node).getInfluencingBounds());
    }

    @Override
    public void readObject(DataInput in) throws IOException {
        super.readObject(in);
        this.scopes = new int[in.readInt()];
        int i2 = 0;
        while (i2 < this.scopes.length) {
            this.scopes[i2] = in.readInt();
            ++i2;
        }
        this.appearance = in.readInt();
        this.influencingBoundingLeaf = in.readInt();
        ((AlternateAppearance)this.node).setInfluencingBounds(this.control.readBounds(in));
    }

    public void addSubReference() {
        this.control.getSymbolTable().incNodeComponentRefCount(this.appearance);
    }

    @Override
    public void buildGraph() {
        int i2 = 0;
        while (i2 < this.scopes.length) {
            ((AlternateAppearance)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i2]));
            ++i2;
        }
        ((AlternateAppearance)this.node).setAppearance((Appearance)this.control.getSymbolTable().getJ3dNode(this.appearance));
        ((AlternateAppearance)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.influencingBoundingLeaf));
        super.buildGraph();
    }

    @Override
    protected SceneGraphObject createNode() {
        return new AlternateAppearance();
    }
}

