/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.scenegraph.io.retained;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.SceneGraphObject;
import org.jogamp.java3d.utils.scenegraph.io.NamedObjectException;
import org.jogamp.java3d.utils.scenegraph.io.ObjectNotLoadedException;
import org.jogamp.java3d.utils.scenegraph.io.SceneGraphObjectReferenceControl;
import org.jogamp.java3d.utils.scenegraph.io.retained.Controller;
import org.jogamp.java3d.utils.scenegraph.io.retained.RandomAccessFileControl;
import org.jogamp.java3d.utils.scenegraph.io.retained.SGIORuntimeException;
import org.jogamp.java3d.utils.scenegraph.io.retained.SymbolTableData;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NodeComponentState;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.NullSceneGraphObjectState;
import org.jogamp.java3d.utils.scenegraph.io.state.org.jogamp.java3d.SceneGraphObjectState;

public class SymbolTable
implements SceneGraphObjectReferenceControl {
    private int nodeID = 1;
    private HashMap j3dNodeIndex;
    private ArrayList nodeIDIndex;
    private HashMap danglingReferences;
    private Stack unsavedNodeComponentsStack;
    private LinkedList sharedNodes;
    private HashMap namedObjects;
    private ArrayList branchGraphs;
    private ArrayList branchGraphDependencies;
    private Controller control;
    private int currentBranchGraphID = -1;
    private int nextBranchGraphID = 0;

    public SymbolTable(Controller control) {
        this.control = control;
        this.j3dNodeIndex = new HashMap();
        this.danglingReferences = new HashMap();
        this.nodeIDIndex = new ArrayList();
        this.nodeIDIndex.add(null);
        this.sharedNodes = new LinkedList();
        this.namedObjects = new HashMap();
        this.branchGraphs = new ArrayList();
        this.branchGraphDependencies = new ArrayList();
        this.unsavedNodeComponentsStack = new Stack();
    }

    private void checkforDanglingReferences() {
        ListIterator list = this.sharedNodes.listIterator();
        while (list.hasNext()) {
            SymbolTableData data = (SymbolTableData)list.next();
            if (data.branchGraphID != -3) continue;
            System.err.println("Warning : node " + data.j3dNode + " is referenced but is not attached to a BranchGraph");
            System.err.println("Setting reference to null. This scene may not look correct when loaded");
        }
    }

    private void removeNullDependencies(HashSet set) {
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)it.next();
            if (symbol.branchGraphID != -3) continue;
            it.remove();
        }
    }

    public void writeTable(DataOutput out) throws IOException {
        this.checkforDanglingReferences();
        ListIterator list = this.sharedNodes.listIterator();
        out.writeInt(this.sharedNodes.size());
        out.writeInt(this.nodeID);
        while (list.hasNext()) {
            SymbolTableData data = (SymbolTableData)list.next();
            data.writeObject(out);
        }
        String[] names = this.getNames();
        out.writeInt(names.length);
        int i2 = 0;
        while (i2 < names.length) {
            out.writeUTF(names[i2]);
            SceneGraphObject node = (SceneGraphObject)this.namedObjects.get(names[i2]);
            SymbolTableData symbol = this.getSymbol(node);
            if (symbol != null) {
                out.writeInt(symbol.nodeID);
            } else {
                out.writeInt(0);
            }
            ++i2;
        }
        out.writeInt(this.branchGraphs.size());
        i2 = 0;
        while (i2 < this.branchGraphs.size()) {
            ((SymbolTableData)this.branchGraphs.get(i2)).writeObject(out);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.branchGraphDependencies.size()) {
            HashSet set = (HashSet)this.branchGraphDependencies.get(i2);
            if (set == null) {
                out.writeInt(0);
            } else {
                this.removeNullDependencies(set);
                out.writeInt(set.size());
                for (SymbolTableData symbol : set) {
                    out.writeInt(symbol.nodeID);
                }
            }
            ++i2;
        }
    }

    public void readTable(DataInput in, boolean streamRead) throws IOException {
        int size = in.readInt();
        this.nodeID = in.readInt();
        this.nodeIDIndexEnsureCapacity(this.nodeID);
        int i2 = 0;
        while (i2 < size) {
            SymbolTableData symbol = new SymbolTableData(0, null, null, -1);
            symbol.readObject(in);
            if (!streamRead) {
                this.sharedNodes.add(symbol);
                this.nodeIDIndex.set(symbol.nodeID, symbol);
            }
            ++i2;
        }
        size = in.readInt();
        int j2 = 0;
        while (j2 < size) {
            String name = in.readUTF();
            int id = in.readInt();
            this.namedObjects.put(name, new Integer(id));
            ++j2;
        }
        size = in.readInt();
        i2 = 0;
        while (i2 < size) {
            this.branchGraphs.add(null);
            ++i2;
        }
        j2 = 0;
        while (j2 < size) {
            SymbolTableData tmp = new SymbolTableData(0, null, null, -1);
            tmp.readObject(in);
            SymbolTableData symbol = this.getSymbol(tmp.nodeID);
            if (symbol == null) {
                symbol = tmp;
                if (symbol.referenceCount > 1) {
                    this.sharedNodes.add(symbol);
                }
                this.nodeIDIndex.set(symbol.nodeID, symbol);
            }
            this.branchGraphs.set(j2, symbol);
            ++j2;
        }
        i2 = 0;
        while (i2 < size) {
            int setSize = in.readInt();
            if (setSize == 0) {
                this.branchGraphDependencies.add(null);
            } else {
                HashSet<SymbolTableData> set = new HashSet<SymbolTableData>();
                this.branchGraphDependencies.add(set);
                int j3 = 0;
                while (j3 < setSize) {
                    set.add(this.getSymbol(in.readInt()));
                    ++j3;
                }
            }
            ++i2;
        }
    }

    public void setBranchGraphRoot(SymbolTableData symbol, long filePointer) {
        if (symbol.branchGraphID < 0) {
            symbol.branchGraphID = this.nextBranchGraphID++;
        }
        this.currentBranchGraphID = symbol.branchGraphID;
        int i2 = this.branchGraphs.size();
        while (i2 < this.currentBranchGraphID + 1) {
            this.branchGraphs.add(null);
            this.branchGraphDependencies.add(null);
            ++i2;
        }
        this.branchGraphs.set(this.currentBranchGraphID, symbol);
        symbol.branchGraphFilePointer = filePointer;
    }

    public SymbolTableData getBranchGraphRoot(int graphID) {
        return (SymbolTableData)this.branchGraphs.get(graphID);
    }

    public void setBranchGraphID(SymbolTableData symbol) {
        symbol.branchGraphID = this.currentBranchGraphID;
    }

    public int[] getBranchGraphDependencies(int graphID) {
        HashSet set = (HashSet)this.branchGraphDependencies.get(graphID);
        if (set == null) {
            return new int[0];
        }
        int[] ret = new int[set.size()];
        Iterator it = set.iterator();
        int i2 = 0;
        while (it.hasNext()) {
            ret[i2++] = ((SymbolTableData)it.next()).branchGraphID;
        }
        return ret;
    }

    public boolean branchGraphHasDependencies(int graphID) {
        HashSet set = (HashSet)this.branchGraphDependencies.get(graphID);
        return set != null && set.size() != 0;
    }

    public int getBranchGraphCount() {
        return this.branchGraphs.size();
    }

    public long getBranchGraphFilePosition(int graphID) {
        SymbolTableData symbol = (SymbolTableData)this.branchGraphs.get(graphID);
        return symbol.branchGraphFilePointer;
    }

    public SymbolTableData createSymbol(SceneGraphObject node) {
        SymbolTableData data = (SymbolTableData)this.j3dNodeIndex.get(node);
        SymbolTableData dangling = (SymbolTableData)this.danglingReferences.get(node);
        if (dangling != null) {
            data = dangling;
            data.branchGraphID = this.currentBranchGraphID;
            this.danglingReferences.remove(dangling);
        } else if (data == null) {
            data = new SymbolTableData(this.nodeID++, node, null, this.currentBranchGraphID);
            this.j3dNodeIndex.put(node, data);
            this.nodeIDIndex.add(data);
        } else if (data.j3dNode instanceof Node) {
            throw new RuntimeException("Object already in Symbol table " + node);
        }
        return data;
    }

    public SymbolTableData createSymbol(SceneGraphObjectState state, SceneGraphObject node, int nodeID) {
        SymbolTableData data = (SymbolTableData)this.j3dNodeIndex.get(node);
        if (data == null) {
            this.nodeIDIndexEnsureCapacity(nodeID);
            data = (SymbolTableData)this.nodeIDIndex.get(nodeID);
            if (data == null) {
                data = new SymbolTableData(nodeID, node, state, -2);
                this.j3dNodeIndex.put(node, data);
                this.nodeIDIndex.set(data.getNodeID(), data);
            } else if (data.getJ3dNode() == null) {
                data.j3dNode = node;
                data.nodeState = state;
                this.j3dNodeIndex.put(node, data);
            }
        } else {
            throw new SGIORuntimeException("Object already in Symbol table ");
        }
        return data;
    }

    private void nodeIDIndexEnsureCapacity(int size) {
        this.nodeIDIndex.ensureCapacity(size);
        int adjust = size - this.nodeIDIndex.size();
        int i2 = 0;
        while (i2 <= adjust) {
            this.nodeIDIndex.add(null);
            ++i2;
        }
    }

    private SymbolTableData createDanglingSymbol(SceneGraphObject node) {
        SymbolTableData data = (SymbolTableData)this.j3dNodeIndex.get(node);
        if (data == null) {
            data = new SymbolTableData(this.nodeID++, node, null, -3);
            this.j3dNodeIndex.put(node, data);
            this.nodeIDIndex.add(data);
            this.danglingReferences.put(node, data);
        } else if (data.nodeState == null) {
            if (data.referenceCount == 1) {
                this.sharedNodes.add(data);
            }
            ++data.referenceCount;
        } else {
            throw new SGIORuntimeException("Object already in Symbol table ");
        }
        return data;
    }

    private SymbolTableData createNodeComponentSymbol(SceneGraphObject node) {
        SymbolTableData symbol = new SymbolTableData(this.nodeID++, node, null, this.currentBranchGraphID);
        symbol.isNodeComponent = true;
        this.j3dNodeIndex.put(node, symbol);
        this.nodeIDIndex.add(symbol);
        ((LinkedList)this.unsavedNodeComponentsStack.peek()).add(symbol);
        this.control.createState(symbol);
        return symbol;
    }

    public int getUnsavedNodeComponentsSize() {
        return ((LinkedList)this.unsavedNodeComponentsStack.peek()).size();
    }

    public ListIterator getUnsavedNodeComponents() {
        return ((LinkedList)this.unsavedNodeComponentsStack.peek()).listIterator(0);
    }

    public void startUnsavedNodeComponentFrame() {
        this.unsavedNodeComponentsStack.push(new LinkedList());
    }

    public void endUnsavedNodeComponentFrame() {
        this.unsavedNodeComponentsStack.pop();
        this.confirmInterGraphDependency();
    }

    private void confirmInterGraphDependency() {
        HashSet set = (HashSet)this.branchGraphDependencies.get(this.currentBranchGraphID);
        if (set == null) {
            return;
        }
        Iterator it = set.iterator();
        while (it.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)it.next();
            if (symbol.branchGraphID != this.currentBranchGraphID) continue;
            it.remove();
        }
    }

    private void addInterGraphDependency(SymbolTableData symbol) {
        HashSet<SymbolTableData> set = (HashSet<SymbolTableData>)this.branchGraphDependencies.get(this.currentBranchGraphID);
        if (set == null) {
            set = new HashSet<SymbolTableData>();
            this.branchGraphDependencies.set(this.currentBranchGraphID, set);
        }
        set.add(symbol);
    }

    public void incNodeComponentRefCount(int nodeID) {
        if (nodeID == 0) {
            return;
        }
        SymbolTableData symbol = this.getSymbol(nodeID);
        ((NodeComponentState)symbol.nodeState).addSubReference();
        if (symbol.referenceCount == 1) {
            this.sharedNodes.add(symbol);
        }
        ++symbol.referenceCount;
    }

    @Override
    public int addReference(SceneGraphObject node) {
        if (node == null) {
            return 0;
        }
        SymbolTableData symbol = this.getSymbol(node);
        if (symbol == null) {
            if (node instanceof Node) {
                symbol = this.createDanglingSymbol(node);
                if (symbol.branchGraphID != this.currentBranchGraphID) {
                    this.addInterGraphDependency(symbol);
                    this.sharedNodes.add(symbol);
                }
            } else {
                symbol = this.createNodeComponentSymbol(node);
            }
            return symbol.nodeID;
        }
        return this.addReference(symbol);
    }

    public int addReference(SymbolTableData symbol) {
        if (symbol != null) {
            if (symbol.referenceCount == 1) {
                this.sharedNodes.add(symbol);
            }
            ++symbol.referenceCount;
            if (symbol.j3dNode instanceof NodeComponent && symbol.referenceCount > 1) {
                ((NodeComponentState)symbol.nodeState).addSubReference();
            }
            if (symbol.branchGraphID != this.currentBranchGraphID && symbol.j3dNode instanceof Node) {
                this.addInterGraphDependency(symbol);
            }
        } else {
            throw new SGIORuntimeException("Null Symbol");
        }
        return symbol.nodeID;
    }

    public int addBranchGraphReference(SceneGraphObject node, int branchGraphID) {
        if (node == null) {
            return 0;
        }
        SymbolTableData symbol = this.getSymbol(node);
        if (symbol != null) {
            if (symbol.referenceCount == 1) {
                this.sharedNodes.add(symbol);
            }
            ++symbol.referenceCount;
        } else {
            symbol = new SymbolTableData(this.nodeID++, node, null, -3);
            this.j3dNodeIndex.put(node, symbol);
            this.nodeIDIndex.add(symbol);
            this.danglingReferences.put(node, symbol);
        }
        symbol.branchGraphID = branchGraphID;
        int i2 = this.branchGraphs.size();
        while (i2 < branchGraphID + 1) {
            this.branchGraphs.add(null);
            this.branchGraphDependencies.add(null);
            ++i2;
        }
        this.branchGraphs.set(symbol.branchGraphID, symbol);
        return symbol.nodeID;
    }

    public boolean isLoaded(int nodeID) {
        SymbolTableData symbol = this.getSymbol(nodeID);
        if (symbol == null) {
            return false;
        }
        return symbol.j3dNode != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SceneGraphObject getJ3dNode(int nodeID) {
        if (nodeID == 0) {
            return null;
        }
        SymbolTableData symbol = this.getSymbol(nodeID);
        if (symbol.branchGraphID == -3) {
            return null;
        }
        if (symbol != null && symbol.j3dNode == null) {
            if (symbol.isNodeComponent && this.control instanceof RandomAccessFileControl) {
                try {
                    ((RandomAccessFileControl)this.control).loadNodeComponent(symbol);
                }
                catch (IOException e2) {
                    System.out.println("FAILED to seek and load NodeComponent");
                    return null;
                }
            } else {
                System.out.println("WARNING - Object has not been loaded " + nodeID);
                System.out.println("Need to load branchgraph " + symbol.branchGraphID);
                return null;
            }
        }
        if (symbol == null) {
            throw new SGIORuntimeException("Missing Symbol " + nodeID);
        }
        if (!symbol.graphBuilt) {
            symbol.graphBuilt = true;
            symbol.nodeState.buildGraph();
        }
        return symbol.j3dNode;
    }

    public SymbolTableData getSymbol(SceneGraphObject node) {
        return (SymbolTableData)this.j3dNodeIndex.get(node);
    }

    public SymbolTableData getSymbol(int nodeID) {
        if (nodeID == 0 || nodeID > this.nodeIDIndex.size()) {
            return null;
        }
        return (SymbolTableData)this.nodeIDIndex.get(nodeID);
    }

    public SymbolTableData getSharedGroup(int nodeID) {
        SymbolTableData symbol = this.getSymbol(nodeID);
        if (symbol.nodeState == null && this.control instanceof RandomAccessFileControl) {
            try {
                ((RandomAccessFileControl)this.control).loadSharedGroup(symbol);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                throw new SGIORuntimeException("Internal error in getSharedGroup");
            }
        }
        return symbol;
    }

    public void setFilePosition(long ptr, SceneGraphObjectState state) {
        if (state instanceof NullSceneGraphObjectState) {
            return;
        }
        SymbolTableData symbol = this.getSymbol(state.getNodeID());
        symbol.filePosition = ptr;
    }

    public void addNamedObject(String name, SceneGraphObject object) {
        this.namedObjects.put(name, object);
    }

    public void addNamedObjects(HashMap map) {
        if (map != null) {
            this.namedObjects.putAll(map);
        }
    }

    public SceneGraphObject getNamedObject(String name) throws NamedObjectException, ObjectNotLoadedException {
        Object obj = this.namedObjects.get(name);
        if (obj == null) {
            throw new NamedObjectException("Unknown name :" + name);
        }
        if (obj instanceof SceneGraphObject) {
            return (SceneGraphObject)obj;
        }
        SymbolTableData symbol = this.getSymbol((Integer)obj);
        if (symbol == null || symbol.j3dNode == null) {
            throw new ObjectNotLoadedException(((Integer)obj).toString());
        }
        return symbol.j3dNode;
    }

    public String[] getNames() {
        return this.namedObjects.keySet().toArray(new String[0]);
    }

    public void getNamedObjectMap(HashMap map) {
        map.putAll(this.namedObjects);
    }

    public String toString() {
        SymbolTableData data;
        StringBuffer buf = new StringBuffer();
        int i2 = 0;
        while (i2 < this.nodeIDIndex.size()) {
            data = (SymbolTableData)this.nodeIDIndex.get(i2);
            if (data != null) {
                buf.append(String.valueOf(data.nodeID) + " " + data.referenceCount + " " + data.filePosition + "  " + data.branchGraphID + "  " + data.nodeState + "\n");
            }
            ++i2;
        }
        buf.append("\nShared Objects\n");
        ListIterator l2 = this.sharedNodes.listIterator();
        while (l2.hasNext()) {
            data = (SymbolTableData)l2.next();
            buf.append(String.valueOf(data.nodeID) + " " + data.referenceCount + " " + data.filePosition + "  " + data.branchGraphID + "  " + data.j3dNode + "\n");
        }
        buf.append("\nNamed Objects\n");
        String[] names = this.getNames();
        int i3 = 0;
        while (i3 < names.length) {
            buf.append(String.valueOf(names[i3]) + "  " + this.namedObjects.get(names[i3]));
            ++i3;
        }
        buf.append("\nBranch Graphs\n");
        i3 = 0;
        while (i3 < this.branchGraphs.size()) {
            SymbolTableData data2 = (SymbolTableData)this.branchGraphs.get(i3);
            if (data2 == null) {
                System.out.println("Data is null " + i3 + "  " + this.branchGraphs.size());
            }
            buf.append(String.valueOf(data2.nodeID) + " " + data2.referenceCount + " " + data2.filePosition + "  " + data2.branchGraphID + "  " + data2.j3dNode + " " + data2.nodeState + "\n");
            ++i3;
        }
        buf.append("\nBranch Graph Dependencies\n");
        i3 = 0;
        while (i3 < this.branchGraphDependencies.size()) {
            buf.append("Graph " + i3 + " - ");
            HashSet set = (HashSet)this.branchGraphDependencies.get(i3);
            if (set != null) {
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    buf.append(String.valueOf(((SymbolTableData)it.next()).nodeID) + " ");
                }
            }
            buf.append("\n");
            ++i3;
        }
        buf.append("------------------");
        return buf.toString();
    }

    public void clear() {
        this.j3dNodeIndex.clear();
        this.nodeIDIndex.clear();
        while (!this.unsavedNodeComponentsStack.empty()) {
            this.unsavedNodeComponentsStack.pop();
        }
        this.danglingReferences.clear();
        this.sharedNodes.clear();
        this.namedObjects.clear();
        this.nodeID = 1;
    }

    public void clearUnshared() {
        String[] names = this.getNames();
        int i2 = 0;
        while (i2 < names.length) {
            try {
                SymbolTableData symbol;
                Object obj = this.namedObjects.get(names[i2]);
                if (obj instanceof Integer && (symbol = this.getSymbol((Integer)obj)) != null && symbol.j3dNode != null) {
                    this.namedObjects.put(names[i2], symbol.j3dNode);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            ++i2;
        }
        this.j3dNodeIndex.clear();
        this.nodeIDIndex.clear();
        while (!this.unsavedNodeComponentsStack.empty()) {
            this.unsavedNodeComponentsStack.pop();
        }
        this.nodeIDIndexEnsureCapacity(this.nodeID);
        ListIterator list = this.sharedNodes.listIterator();
        while (list.hasNext()) {
            SymbolTableData symbol = (SymbolTableData)list.next();
            this.nodeIDIndex.set(symbol.nodeID, symbol);
            this.j3dNodeIndex.put(symbol.j3dNode, symbol);
        }
        for (SymbolTableData symbol : this.danglingReferences.values()) {
            this.nodeIDIndex.set(symbol.nodeID, symbol);
            this.j3dNodeIndex.put(symbol.j3dNode, symbol);
        }
    }

    @Override
    public SceneGraphObject resolveReference(int nodeID) {
        return this.getJ3dNode(nodeID);
    }
}

