/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.picking;

import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.CompressedGeometry;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArray;
import org.jogamp.java3d.IndexedGeometryArray;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.Morph;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickConeRay;
import org.jogamp.java3d.PickConeSegment;
import org.jogamp.java3d.PickCylinderRay;
import org.jogamp.java3d.PickCylinderSegment;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.utils.picking.PickIntersection;
import org.jogamp.java3d.utils.picking.PickResult;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class PickTool {
    private final boolean debug = true;
    protected boolean userDefineShape = false;
    PickShape pickShape;
    BranchGroup pickRootBG = null;
    Locale pickRootL = null;
    Point3d start = null;
    int mode = 512;
    public static final int BOUNDS = 512;
    public static final int GEOMETRY = 256;
    public static final int GEOMETRY_INTERSECT_INFO = 1024;
    public static final int INTERSECT_TEST = 4097;
    public static final int INTERSECT_COORD = 4098;
    public static final int INTERSECT_FULL = 4100;

    public PickTool(BranchGroup b2) {
        this.pickRootBG = b2;
    }

    public BranchGroup getBranchGroup() {
        return this.pickRootBG;
    }

    public PickTool(Locale l2) {
        this.pickRootL = l2;
    }

    public Locale getLocale() {
        return this.pickRootL;
    }

    public Locale setBranchGroup(Locale l2) {
        return l2;
    }

    public static void setCapabilities(Node node, int level) {
        if (node instanceof Morph) {
            Morph morph = (Morph)node;
            switch (level) {
                case 4098: 
                case 4100: {
                    morph.setCapability(12);
                }
                case 4097: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
            }
            double[] weights = morph.getWeights();
            int i2 = 0;
            while (i2 < weights.length) {
                GeometryArray ga = morph.getGeometryArray(i2);
                PickTool.setCapabilities(ga, level);
                ++i2;
            }
        } else if (node instanceof Shape3D) {
            Shape3D shape = (Shape3D)node;
            switch (level) {
                case 4098: 
                case 4100: {
                    shape.setCapability(12);
                }
                case 4097: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Improper level");
                }
            }
            int i3 = 0;
            while (i3 < shape.numGeometries()) {
                Geometry geo = shape.getGeometry(i3);
                if (geo instanceof GeometryArray) {
                    PickTool.setCapabilities((GeometryArray)geo, level);
                } else if (geo instanceof CompressedGeometry) {
                    PickTool.setCapabilities((CompressedGeometry)geo, level);
                }
                ++i3;
            }
        } else {
            throw new IllegalArgumentException("Improper node type");
        }
    }

    private static void setCapabilities(GeometryArray ga, int level) {
        switch (level) {
            case 4100: {
                ga.setCapability(2);
                ga.setCapability(4);
                ga.setCapability(6);
            }
            case 4098: {
                ga.setCapability(8);
                ga.setCapability(17);
                ga.setCapability(0);
            }
            case 4097: {
                ga.setCapability(18);
            }
        }
        if (ga instanceof IndexedGeometryArray) {
            PickTool.setCapabilities((IndexedGeometryArray)ga, level);
        }
    }

    private static void setCapabilities(IndexedGeometryArray iga, int level) {
        switch (level) {
            case 4100: {
                iga.setCapability(11);
                iga.setCapability(13);
                iga.setCapability(15);
            }
            case 4098: {
                iga.setCapability(9);
            }
        }
    }

    private static void setCapabilities(CompressedGeometry cg, int level) {
        switch (level) {
            case 4098: 
            case 4100: {
                cg.setCapability(2);
            }
            case 4097: {
                cg.setCapability(18);
            }
        }
    }

    public void setShape(PickShape ps, Point3d startPt) {
        this.pickShape = ps;
        this.start = startPt;
        this.userDefineShape = ps != null;
    }

    public void setShapeBounds(Bounds bounds, Point3d startPt) {
        this.pickShape = new PickBounds(bounds);
        this.start = startPt;
        this.userDefineShape = true;
    }

    public void setMode(int mode) {
        if (mode != 512 && mode != 256 && mode != 1024) {
            throw new IllegalArgumentException();
        }
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setShapeRay(Point3d start, Vector3d dir2) {
        this.pickShape = new PickRay(start, dir2);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeSegment(Point3d start, Point3d end) {
        this.pickShape = new PickSegment(start, end);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeCylinderSegment(Point3d start, Point3d end, double radius) {
        this.pickShape = new PickCylinderSegment(start, end, radius);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeCylinderRay(Point3d start, Vector3d dir2, double radius) {
        this.pickShape = new PickCylinderRay(start, dir2, radius);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeConeSegment(Point3d start, Point3d end, double angle) {
        this.pickShape = new PickConeSegment(start, end, angle);
        this.start = start;
        this.userDefineShape = true;
    }

    public void setShapeConeRay(Point3d start, Vector3d dir2, double angle) {
        this.pickShape = new PickConeRay(start, dir2, angle);
        this.start = start;
        this.userDefineShape = true;
    }

    public PickShape getPickShape() {
        return this.pickShape;
    }

    public Point3d getStartPosition() {
        return this.start;
    }

    public PickResult[] pickAll() {
        PickResult[] retval = null;
        switch (this.mode) {
            case 512: {
                retval = this.pickAll(this.pickShape);
                break;
            }
            case 256: {
                retval = this.pickGeomAll(this.pickShape);
                break;
            }
            case 1024: {
                retval = this.pickGeomAllIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return retval;
    }

    public PickResult pickAny() {
        PickResult retval = null;
        switch (this.mode) {
            case 512: {
                retval = this.pickAny(this.pickShape);
                break;
            }
            case 256: {
                retval = this.pickGeomAny(this.pickShape);
                break;
            }
            case 1024: {
                retval = this.pickGeomAnyIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return retval;
    }

    public PickResult[] pickAllSorted() {
        PickResult[] retval = null;
        switch (this.mode) {
            case 512: {
                retval = this.pickAllSorted(this.pickShape);
                break;
            }
            case 256: {
                retval = this.pickGeomAllSorted(this.pickShape);
                break;
            }
            case 1024: {
                retval = this.pickGeomAllSortedIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return retval;
    }

    public PickResult pickClosest() {
        PickResult retval = null;
        switch (this.mode) {
            case 512: {
                retval = this.pickClosest(this.pickShape);
                break;
            }
            case 256: {
                retval = this.pickGeomClosest(this.pickShape);
                break;
            }
            case 1024: {
                retval = this.pickGeomClosestIntersect(this.pickShape);
                break;
            }
            default: {
                throw new RuntimeException("Invalid pick mode");
            }
        }
        return retval;
    }

    private PickResult[] pickAll(PickShape pickShape) {
        PickResult[] pr = null;
        SceneGraphPath[] sgp = null;
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAll(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        pr = new PickResult[sgp.length];
        int i2 = 0;
        while (i2 < sgp.length) {
            pr[i2] = new PickResult(sgp[i2], pickShape);
            ++i2;
        }
        return pr;
    }

    private PickResult[] pickAllSorted(PickShape pickShape) {
        PickResult[] pr = null;
        SceneGraphPath[] sgp = null;
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAllSorted(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAllSorted(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        pr = new PickResult[sgp.length];
        int i2 = 0;
        while (i2 < sgp.length) {
            pr[i2] = new PickResult(sgp[i2], pickShape);
            ++i2;
        }
        return pr;
    }

    private PickResult pickAny(PickShape pickShape) {
        PickResult pr = null;
        SceneGraphPath sgp = null;
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAny(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAny(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        pr = new PickResult(sgp, pickShape);
        return pr;
    }

    private PickResult pickClosest(PickShape pickShape) {
        PickResult pr = null;
        SceneGraphPath sgp = null;
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickClosest(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickClosest(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        pr = new PickResult(sgp, pickShape);
        return pr;
    }

    private PickResult[] pickGeomAll(PickShape pickShape) {
        SceneGraphPath[] sgp = null;
        Node[] obj = null;
        int cnt = 0;
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAll(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        boolean[] found = new boolean[sgp.length];
        obj = new Node[sgp.length];
        PickResult[] pr = new PickResult[sgp.length];
        int i2 = 0;
        while (i2 < sgp.length) {
            obj[i2] = sgp[i2].getObject();
            pr[i2] = new PickResult(sgp[i2], pickShape);
            if (obj[i2] instanceof Shape3D) {
                found[i2] = ((Shape3D)obj[i2]).intersect(sgp[i2], pickShape);
            } else if (obj[i2] instanceof Morph) {
                found[i2] = ((Morph)obj[i2]).intersect(sgp[i2], pickShape);
            }
            if (found[i2]) {
                ++cnt;
            }
            ++i2;
        }
        if (cnt == 0) {
            return null;
        }
        PickResult[] newpr = new PickResult[cnt];
        cnt = 0;
        i2 = 0;
        while (i2 < sgp.length) {
            if (found[i2]) {
                pr[cnt++] = pr[i2];
            }
            ++i2;
        }
        return pr;
    }

    private PickResult[] pickGeomAllSorted(PickShape pickShape) {
        SceneGraphPath[] sgp = null;
        Node[] obj = null;
        int cnt = 0;
        double[] dist = new double[1];
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAll(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        boolean[] found = new boolean[sgp.length];
        double[] distArr = new double[sgp.length];
        obj = new Node[sgp.length];
        PickResult[] pr = new PickResult[sgp.length];
        int i2 = 0;
        while (i2 < sgp.length) {
            obj[i2] = sgp[i2].getObject();
            pr[i2] = new PickResult(sgp[i2], pickShape);
            if (obj[i2] instanceof Shape3D) {
                found[i2] = ((Shape3D)obj[i2]).intersect(sgp[i2], pickShape, dist);
                distArr[i2] = dist[0];
            } else if (obj[i2] instanceof Morph) {
                found[i2] = ((Morph)obj[i2]).intersect(sgp[i2], pickShape, dist);
                distArr[i2] = dist[0];
            }
            if (found[i2]) {
                ++cnt;
            }
            ++i2;
        }
        if (cnt == 0) {
            return null;
        }
        PickResult[] npr = new PickResult[cnt];
        double[] distance = new double[cnt];
        cnt = 0;
        i2 = 0;
        while (i2 < sgp.length) {
            if (found[i2]) {
                distance[cnt] = distArr[i2];
                npr[cnt++] = pr[i2];
            }
            ++i2;
        }
        if (cnt > 1) {
            return this.sortPickResults(npr, distance);
        }
        return npr;
    }

    private PickResult pickGeomAny(PickShape pickShape) {
        Node obj = null;
        SceneGraphPath[] sgpa = null;
        if (this.pickRootBG != null) {
            sgpa = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgpa = this.pickRootL.pickAll(pickShape);
        }
        if (sgpa == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < sgpa.length) {
            obj = sgpa[i2].getObject();
            PickResult pr = new PickResult(sgpa[i2], pickShape);
            if (obj instanceof Shape3D ? ((Shape3D)obj).intersect(sgpa[i2], pickShape) : obj instanceof Morph && ((Morph)obj).intersect(sgpa[i2], pickShape)) {
                return pr;
            }
            ++i2;
        }
        return null;
    }

    private PickResult pickGeomClosest(PickShape pickShape) {
        PickResult[] pr = this.pickGeomAllSorted(pickShape);
        if (pr == null) {
            return null;
        }
        return pr[0];
    }

    private PickResult[] pickGeomAllIntersect(PickShape pickShape) {
        SceneGraphPath[] sgp = null;
        Object obj = null;
        int cnt = 0;
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAll(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        boolean[] found = new boolean[sgp.length];
        PickResult[] pr = new PickResult[sgp.length];
        int i2 = 0;
        while (i2 < sgp.length) {
            pr[i2] = new PickResult(sgp[i2], pickShape);
            if (pr[i2].numIntersections() > 0) {
                found[i2] = true;
                ++cnt;
            }
            ++i2;
        }
        if (cnt == 0) {
            return null;
        }
        PickResult[] newpr = new PickResult[cnt];
        cnt = 0;
        i2 = 0;
        while (i2 < sgp.length) {
            if (found[i2]) {
                pr[cnt++] = pr[i2];
            }
            ++i2;
        }
        return pr;
    }

    private PickResult[] pickGeomAllSortedIntersect(PickShape pickShape) {
        SceneGraphPath[] sgp = null;
        Object obj = null;
        int cnt = 0;
        double[] dist = new double[1];
        if (this.pickRootBG != null) {
            sgp = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgp = this.pickRootL.pickAll(pickShape);
        }
        if (sgp == null) {
            return null;
        }
        boolean[] found = new boolean[sgp.length];
        double[] distArr = new double[sgp.length];
        PickResult[] pr = new PickResult[sgp.length];
        int i2 = 0;
        while (i2 < sgp.length) {
            pr[i2] = new PickResult(sgp[i2], pickShape);
            int numIntersection = pr[i2].numIntersections();
            if (numIntersection > 0) {
                found[i2] = true;
                boolean needToSwap = false;
                double minDist = pr[i2].getIntersection(0).getDistance();
                int minIndex = 0;
                int j2 = 1;
                while (j2 < numIntersection) {
                    double tempDist = pr[i2].getIntersection(j2).getDistance();
                    if (minDist > tempDist) {
                        minDist = tempDist;
                        minIndex = j2;
                        needToSwap = true;
                    }
                    ++j2;
                }
                if (needToSwap) {
                    PickIntersection pi0 = pr[i2].getIntersection(0);
                    PickIntersection piMin = pr[i2].getIntersection(minIndex);
                    pr[i2].intersections.set(0, piMin);
                    pr[i2].intersections.set(minIndex, pi0);
                }
                distArr[i2] = pr[i2].getIntersection(0).getDistance();
                ++cnt;
            }
            ++i2;
        }
        if (cnt == 0) {
            return null;
        }
        PickResult[] npr = new PickResult[cnt];
        double[] distance = new double[cnt];
        cnt = 0;
        i2 = 0;
        while (i2 < sgp.length) {
            if (found[i2]) {
                distance[cnt] = distArr[i2];
                npr[cnt++] = pr[i2];
            }
            ++i2;
        }
        if (cnt > 1) {
            return this.sortPickResults(npr, distance);
        }
        return npr;
    }

    private PickResult pickGeomClosestIntersect(PickShape pickShape) {
        PickResult[] pr = this.pickGeomAllSortedIntersect(pickShape);
        if (pr == null) {
            return null;
        }
        return pr[0];
    }

    private PickResult pickGeomAnyIntersect(PickShape pickShape) {
        Object obj = null;
        SceneGraphPath[] sgpa = null;
        if (this.pickRootBG != null) {
            sgpa = this.pickRootBG.pickAll(pickShape);
        } else if (this.pickRootL != null) {
            sgpa = this.pickRootL.pickAll(pickShape);
        }
        if (sgpa == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < sgpa.length) {
            PickResult pr = new PickResult(sgpa[i2], pickShape);
            pr.setFirstIntersectOnly(true);
            if (pr.numIntersections() > 0) {
                return pr;
            }
            ++i2;
        }
        return null;
    }

    private PickResult[] sortPickResults(PickResult[] pr, double[] dist) {
        int[] pos = new int[pr.length];
        PickResult[] prsorted = new PickResult[pr.length];
        int i2 = 0;
        while (i2 < pr.length) {
            pos[i2] = i2;
            ++i2;
        }
        this.quicksort(0, dist.length - 1, dist, pos);
        i2 = 0;
        while (i2 < pr.length) {
            prsorted[i2] = pr[pos[i2]];
            ++i2;
        }
        return prsorted;
    }

    private final void quicksort(int l2, int r, double[] dist, int[] pos) {
        int i2 = l2;
        int j2 = r;
        double k2 = dist[(l2 + r) / 2];
        while (true) {
            if (dist[i2] < k2) {
                ++i2;
                continue;
            }
            while (k2 < dist[j2]) {
                --j2;
            }
            if (i2 <= j2) {
                double tmp = dist[i2];
                dist[i2] = dist[j2];
                dist[j2] = tmp;
                int p = pos[i2];
                pos[i2] = pos[j2];
                pos[j2] = p;
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (l2 < j2) {
            this.quicksort(l2, j2, dist, pos);
        }
        if (l2 < r) {
            this.quicksort(i2, r, dist, pos);
        }
    }
}

