/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.picking;

import java.awt.event.MouseEvent;
import org.jogamp.java3d.BranchGroup;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Locale;
import org.jogamp.java3d.PickConeRay;
import org.jogamp.java3d.PickCylinderRay;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.utils.picking.PickTool;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

public class PickCanvas
extends PickTool {
    Canvas3D canvas;
    float tolerance = 2.0f;
    int save_xpos;
    int save_ypos;

    public PickCanvas(Canvas3D c2, BranchGroup b2) {
        super(b2);
        this.canvas = c2;
    }

    public PickCanvas(Canvas3D c2, Locale l2) {
        super(l2);
        this.canvas = c2;
    }

    public Canvas3D getCanvas() {
        return this.canvas;
    }

    public void setTolerance(float t) {
        if (t < 0.0f) {
            throw new IllegalArgumentException();
        }
        this.tolerance = t;
        if (this.pickShape != null && !this.userDefineShape) {
            this.pickShape = null;
            this.setShapeLocation(this.save_xpos, this.save_ypos);
        }
    }

    public float getTolerance() {
        return this.tolerance;
    }

    public void setShapeLocation(MouseEvent mevent) {
        this.setShapeLocation(mevent.getX(), mevent.getY());
    }

    public void setShapeLocation(int xpos, int ypos) {
        Transform3D motion = new Transform3D();
        Point3d eyePosn = new Point3d();
        Point3d mousePosn = new Point3d();
        Vector3d mouseVec = new Vector3d();
        boolean isParallel = false;
        double radius = 0.0;
        double spreadAngle = 0.0;
        this.save_xpos = xpos;
        this.save_ypos = ypos;
        this.canvas.getCenterEyeInImagePlate(eyePosn);
        this.canvas.getPixelLocationInImagePlate(xpos, ypos, mousePosn);
        if (this.canvas.getView() != null && this.canvas.getView().getProjectionPolicy() == 0) {
            eyePosn.x = mousePosn.x;
            eyePosn.y = mousePosn.y;
            isParallel = true;
        }
        Vector3d eyeToCanvas = new Vector3d();
        eyeToCanvas.sub(mousePosn, eyePosn);
        double distanceEyeToCanvas = eyeToCanvas.length();
        Point3d deltaImgPlate = new Point3d();
        this.canvas.getPixelLocationInImagePlate(xpos + 1, ypos, deltaImgPlate);
        Vector3d ptToDelta = new Vector3d();
        ptToDelta.sub(mousePosn, deltaImgPlate);
        double distancePtToDelta = ptToDelta.length();
        distancePtToDelta *= (double)this.tolerance;
        this.canvas.getImagePlateToVworld(motion);
        motion.transform(eyePosn);
        this.start = new Point3d(eyePosn);
        motion.transform(mousePosn);
        mouseVec.sub(mousePosn, eyePosn);
        mouseVec.normalize();
        if ((double)this.tolerance == 0.0) {
            if (this.pickShape != null && this.pickShape instanceof PickRay) {
                ((PickRay)this.pickShape).set(eyePosn, mouseVec);
            } else {
                this.pickShape = new PickRay(eyePosn, mouseVec);
            }
        } else if (isParallel) {
            distancePtToDelta *= motion.getScale();
            if (this.pickShape != null && this.pickShape instanceof PickCylinderRay) {
                ((PickCylinderRay)this.pickShape).set(eyePosn, mouseVec, distancePtToDelta);
            } else {
                this.pickShape = new PickCylinderRay(eyePosn, mouseVec, distancePtToDelta);
            }
        } else {
            spreadAngle = Math.atan(distancePtToDelta / distanceEyeToCanvas);
            if (this.pickShape != null && this.pickShape instanceof PickConeRay) {
                ((PickConeRay)this.pickShape).set(eyePosn, mouseVec, spreadAngle);
            } else {
                this.pickShape = new PickConeRay(eyePosn, mouseVec, spreadAngle);
            }
        }
    }
}

