/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry.compression;

import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.geometry.compression.GeneralizedStripFlags;

class GeneralizedStrip {
    private static final boolean debug = false;
    private static final int CW = 0;
    private static final int CCW = 1;
    private static final int RESTART_CW = 0;
    private static final int RESTART_CCW = 1;
    private static final int REPLACE_MIDDLE = 2;
    private static final int REPLACE_OLDEST = 3;

    GeneralizedStrip() {
    }

    static StripArray[] toStripsAndFans(GeneralizedStripFlags vertices, int frontFace) {
        int size = vertices.getFlagCount();
        IntList stripVerts = new IntList(size * 3);
        IntList fanVerts = new IntList(size * 3);
        IntList stripCounts = new IntList(size);
        IntList fanCounts = new IntList(size);
        GeneralizedStrip.toStripsAndFans(vertices, frontFace, stripVerts, stripCounts, fanVerts, fanCounts);
        StripArray[] sa = new StripArray[2];
        if (stripCounts.count > 0) {
            sa[0] = new StripArray(stripVerts, stripCounts);
        }
        if (fanCounts.count > 0) {
            sa[1] = new StripArray(fanVerts, fanCounts);
        }
        return sa;
    }

    private static void toStripsAndFans(GeneralizedStripFlags vertices, int frontFace, IntList stripVerts, IntList stripCounts, IntList fanVerts, IntList fanCounts) {
        boolean transition = false;
        int stripStart = 0;
        int stripLength = 3;
        int curFlag = vertices.getFlag(0);
        int winding = curFlag == 0 ? 0 : 1;
        int v = 3;
        int size = vertices.getFlagCount();
        if (v < size) {
            curFlag = vertices.getFlag(v);
        }
        while (v < size) {
            int newFlag = vertices.getFlag(v);
            if (newFlag == curFlag && newFlag != 0 && newFlag != 1) {
                ++stripLength;
                ++v;
                continue;
            }
            if (curFlag == 2) {
                GeneralizedStrip.addFan(fanVerts, fanCounts, stripStart, stripLength, frontFace, winding, transition);
            } else {
                GeneralizedStrip.addStrip(stripVerts, stripCounts, stripStart, stripLength, frontFace, winding);
            }
            if (newFlag == 0 || newFlag == 1) {
                winding = newFlag == 0 ? 0 : 1;
                stripStart = v;
                stripLength = 3;
                transition = false;
                if ((v += 3) >= size) continue;
                curFlag = vertices.getFlag(v);
                continue;
            }
            if (newFlag == 3) {
                winding = winding == 0 ? 1 : 0;
                stripStart = v - 2;
                stripLength = 3;
            } else {
                if ((stripLength & 1) == 0) {
                    winding = winding == 0 ? 1 : 0;
                }
                stripStart = v - 3;
                stripLength = 4;
            }
            ++v;
            transition = true;
            curFlag = newFlag;
        }
        if (v == size) {
            if (curFlag == 2) {
                GeneralizedStrip.addFan(fanVerts, fanCounts, stripStart, stripLength, frontFace, winding, transition);
            } else {
                GeneralizedStrip.addStrip(stripVerts, stripCounts, stripStart, stripLength, frontFace, winding);
            }
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeneralizedStrip0"));
        }
    }

    private static void addStrip(IntList stripVerts, IntList stripCounts, int start, int length, int frontFace, int winding) {
        block4: {
            int vindex;
            block6: {
                block5: {
                    block3: {
                        vindex = start;
                        if (winding != frontFace) break block3;
                        stripCounts.add(length);
                        while (vindex < start + length) {
                            stripVerts.add(vindex++);
                        }
                        break block4;
                    }
                    if ((length & 1) != 1) break block5;
                    stripCounts.add(length);
                    vindex += length - 1;
                    while (vindex >= start) {
                        stripVerts.add(vindex--);
                    }
                    break block4;
                }
                if (length != 4) break block6;
                stripCounts.add(4);
                stripVerts.add(vindex);
                stripVerts.add(vindex + 2);
                stripVerts.add(vindex + 1);
                stripVerts.add(vindex + 3);
                break block4;
            }
            stripCounts.add(3);
            stripVerts.add(vindex);
            stripVerts.add(vindex + 2);
            stripVerts.add(vindex + 1);
            if (length <= 3) break block4;
            ++vindex;
            stripCounts.add(length - 1);
            while (vindex < start + length) {
                stripVerts.add(vindex++);
            }
        }
    }

    private static void addFan(IntList fanVerts, IntList fanCounts, int start, int length, int frontFace, int winding, boolean transition) {
        int vindex = start;
        fanVerts.add(vindex++);
        if (winding == frontFace) {
            if (transition) {
                fanCounts.add(length - 1);
                ++vindex;
            } else {
                fanCounts.add(length);
                fanVerts.add(vindex++);
            }
            while (vindex < start + length) {
                fanVerts.add(vindex++);
            }
        } else {
            vindex += length - 2;
            while (vindex > start + 1) {
                fanVerts.add(vindex--);
            }
            if (transition) {
                fanCounts.add(length - 1);
            } else {
                fanCounts.add(length);
                fanVerts.add(vindex);
            }
        }
    }

    static StripArray toTriangleStrips(GeneralizedStripFlags vertices, int frontFace) {
        int size = vertices.getFlagCount();
        IntList stripVerts = new IntList(size * 3);
        IntList fanVerts = new IntList(size * 3);
        IntList stripCounts = new IntList(size);
        IntList fanCounts = new IntList(size);
        GeneralizedStrip.toStripsAndFans(vertices, frontFace, stripVerts, stripCounts, fanVerts, fanCounts);
        if (fanCounts.count == 0) {
            if (stripCounts.count > 0) {
                return new StripArray(stripVerts, stripCounts);
            }
            return null;
        }
        int v = 0;
        int i2 = 0;
        while (i2 < fanCounts.count) {
            GeneralizedStrip.fanToStrips(v, fanCounts.ints[i2], fanVerts.ints, stripVerts, stripCounts, false);
            v += fanCounts.ints[i2];
            ++i2;
        }
        StripArray sa = new StripArray(stripVerts, stripCounts);
        return sa;
    }

    private static void fanToStrips(int v, int length, int[] fans, IntList stripVerts, IntList stripCounts, boolean convexPlanar) {
        if (convexPlanar) {
            stripCounts.add(length);
            stripVerts.add(fans[v]);
            int j2 = v + 1;
            int k2 = v + (length - 1);
            while (j2 <= k2) {
                stripVerts.add(fans[j2++]);
                if (j2 <= k2) {
                    stripVerts.add(fans[k2--]);
                    continue;
                }
                break;
            }
        } else {
            int fanStart = v++;
            while (v + 4 <= fanStart + length) {
                stripVerts.add(fans[v]);
                stripVerts.add(fans[v + 1]);
                stripVerts.add(fans[fanStart]);
                stripVerts.add(fans[v + 2]);
                stripVerts.add(fans[v + 3]);
                stripCounts.add(5);
                v += 3;
            }
            if (v + 1 < fanStart + length) {
                stripVerts.add(fans[v]);
                stripVerts.add(fans[v + 1]);
                stripVerts.add(fans[fanStart]);
                if (++v + 1 < fanStart + length) {
                    stripVerts.add(fans[v + 1]);
                    stripCounts.add(4);
                } else {
                    stripCounts.add(3);
                }
            }
        }
    }

    static int[] toTriangles(GeneralizedStripFlags vertices, int frontFace) {
        int vertexCount = 0;
        StripArray[] sa = GeneralizedStrip.toStripsAndFans(vertices, frontFace);
        if (sa[0] != null) {
            vertexCount = 3 * GeneralizedStrip.getTriangleCount(sa[0].stripCounts);
        }
        if (sa[1] != null) {
            vertexCount += 3 * GeneralizedStrip.getTriangleCount(sa[1].stripCounts);
        }
        int t = 0;
        int[] triangles = new int[vertexCount];
        if (sa[0] != null) {
            t = GeneralizedStrip.stripsToTriangles(t, triangles, 0, sa[0].vertices.ints, 0, sa[0].stripCounts.ints, sa[0].stripCounts.count);
        }
        if (sa[1] != null) {
            t = GeneralizedStrip.fansToTriangles(t, triangles, 0, sa[1].vertices.ints, 0, sa[1].stripCounts.ints, sa[1].stripCounts.count);
        }
        return triangles;
    }

    private static int stripsToTriangles(int tstart, int[] tbuff, int vstart, int[] vertices, int stripStart, int[] stripCounts, int stripCount) {
        int t = tstart;
        int v = vstart;
        int i2 = 0;
        while (i2 < stripCount) {
            int j2 = 0;
            while (j2 < stripCounts[i2 + stripStart] - 2) {
                if ((j2 & 1) == 0) {
                    tbuff[t * 3 + 0] = vertices[v + 0];
                    tbuff[t * 3 + 1] = vertices[v + 1];
                    tbuff[t * 3 + 2] = vertices[v + 2];
                } else {
                    tbuff[t * 3 + 0] = vertices[v + 1];
                    tbuff[t * 3 + 1] = vertices[v + 0];
                    tbuff[t * 3 + 2] = vertices[v + 2];
                }
                ++t;
                ++v;
                ++j2;
            }
            v += 2;
            ++i2;
        }
        return t;
    }

    private static int fansToTriangles(int tstart, int[] tbuff, int vstart, int[] vertices, int stripStart, int[] stripCounts, int stripCount) {
        int t = tstart;
        int v = vstart;
        int i2 = 0;
        while (i2 < stripCount) {
            int j2 = 0;
            while (j2 < stripCounts[i2 + stripStart] - 2) {
                tbuff[t * 3 + 0] = vertices[v];
                tbuff[t * 3 + 1] = vertices[v + j2 + 1];
                tbuff[t * 3 + 2] = vertices[v + j2 + 2];
                ++t;
                ++j2;
            }
            v += stripCounts[i2 + stripStart];
            ++i2;
        }
        return t;
    }

    static StripArray[] toStripsAndTriangles(GeneralizedStripFlags vertices, int frontFace, int shortStripSize, int maxShortStrips) {
        int longStripCount = 0;
        int longStripVertexCount = 0;
        int shortStripCount = 0;
        int triangleCount = 0;
        StripArray[] sa = new StripArray[2];
        StripArray ts = GeneralizedStrip.toTriangleStrips(vertices, frontFace);
        int i2 = 0;
        while (i2 < ts.stripCounts.count) {
            if (ts.stripCounts.ints[i2] <= shortStripSize) {
                ++shortStripCount;
                triangleCount += ts.stripCounts.ints[i2] - 2;
            } else {
                ++longStripCount;
                longStripVertexCount += ts.stripCounts.ints[i2];
            }
            ++i2;
        }
        if (shortStripCount <= maxShortStrips) {
            sa[0] = ts;
            sa[1] = null;
        } else {
            int si = 0;
            int[] newStripVerts = new int[longStripVertexCount];
            int ci = 0;
            int[] newStripCounts = new int[longStripCount];
            int ti = 0;
            int[] triangles = new int[3 * triangleCount];
            int vi = 0;
            int i3 = 0;
            while (i3 < ts.stripCounts.count) {
                if (ts.stripCounts.ints[i3] <= shortStripSize) {
                    ti = GeneralizedStrip.stripsToTriangles(ti, triangles, vi, ts.vertices.ints, i3, ts.stripCounts.ints, 1);
                    vi += ts.stripCounts.ints[i3];
                } else {
                    newStripCounts[ci++] = ts.stripCounts.ints[i3];
                    int j2 = 0;
                    while (j2 < ts.stripCounts.ints[i3]) {
                        newStripVerts[si++] = ts.vertices.ints[vi++];
                        ++j2;
                    }
                }
                ++i3;
            }
            sa[0] = longStripCount > 0 ? new StripArray(new IntList(newStripVerts), new IntList(newStripCounts)) : null;
            sa[1] = new StripArray(new IntList(triangles), null);
        }
        return sa;
    }

    static StripArray toLineStrips(GeneralizedStripFlags vertices) {
        int i2;
        int stripStart = 0;
        int stripLength = 2;
        int size = vertices.getFlagCount();
        IntList stripVerts = new IntList(size * 2);
        IntList stripCounts = new IntList(size);
        int v = 2;
        while (v < size) {
            int flag = vertices.getFlag(v);
            if (flag != 0 && flag != 1) {
                ++stripLength;
                ++v;
                continue;
            }
            stripCounts.add(stripLength);
            i2 = stripStart;
            while (i2 < stripStart + stripLength) {
                stripVerts.add(i2);
                ++i2;
            }
            stripStart = v;
            stripLength = 2;
            v += 2;
        }
        if (v == size) {
            stripCounts.add(stripLength);
            i2 = stripStart;
            while (i2 < stripStart + stripLength) {
                stripVerts.add(i2);
                ++i2;
            }
        } else {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("GeneralizedStrip0"));
        }
        if (stripCounts.count > 0) {
            return new StripArray(stripVerts, stripCounts);
        }
        return null;
    }

    static int getLineCount(int[] stripCounts) {
        int count = 0;
        int i2 = 0;
        while (i2 < stripCounts.length) {
            count += stripCounts[i2] - 1;
            ++i2;
        }
        return count;
    }

    static int getTriangleCount(int[] stripCounts) {
        int count = 0;
        int i2 = 0;
        while (i2 < stripCounts.length) {
            count += stripCounts[i2] - 2;
            ++i2;
        }
        return count;
    }

    static int getTriangleCount(IntList stripCounts) {
        int count = 0;
        int i2 = 0;
        while (i2 < stripCounts.count) {
            count += stripCounts.ints[i2] - 2;
            ++i2;
        }
        return count;
    }

    static int[] stripsToTriangles(int[] stripCounts) {
        int triangleCount = GeneralizedStrip.getTriangleCount(stripCounts);
        int[] tbuff = new int[3 * triangleCount];
        IntList vertices = new IntList(triangleCount + 2 * stripCounts.length);
        vertices.fillAscending();
        GeneralizedStrip.stripsToTriangles(0, tbuff, 0, vertices.ints, 0, stripCounts, stripCounts.length);
        return tbuff;
    }

    static int[] fansToTriangles(int[] stripCounts) {
        int triangleCount = GeneralizedStrip.getTriangleCount(stripCounts);
        int[] tbuff = new int[3 * triangleCount];
        IntList vertices = new IntList(triangleCount + 2 * stripCounts.length);
        vertices.fillAscending();
        GeneralizedStrip.fansToTriangles(0, tbuff, 0, vertices.ints, 0, stripCounts, stripCounts.length);
        return tbuff;
    }

    static StripArray fanToStrips(int v, int length, int[] fans, boolean convexPlanar) {
        IntList stripVerts = new IntList(length * 3);
        IntList stripCounts = new IntList(length);
        GeneralizedStrip.fanToStrips(v, length, fans, stripVerts, stripCounts, convexPlanar);
        return new StripArray(stripVerts, stripCounts);
    }

    static class IntList {
        int[] ints;
        int count;

        IntList(int initialSize) {
            this.ints = new int[initialSize];
            this.count = 0;
        }

        IntList(int[] ints) {
            this.ints = ints;
            this.count = ints.length;
        }

        void add(int i2) {
            if (this.count == this.ints.length) {
                int[] newints = new int[2 * this.count];
                System.arraycopy(this.ints, 0, newints, 0, this.count);
                this.ints = newints;
            }
            this.ints[this.count++] = i2;
        }

        int[] trim() {
            if (this.count != this.ints.length) {
                int[] newints = new int[this.count];
                System.arraycopy(this.ints, 0, newints, 0, this.count);
                this.ints = newints;
            }
            return this.ints;
        }

        void fillAscending() {
            int i2 = 0;
            while (i2 < this.ints.length) {
                this.ints[i2] = i2;
                ++i2;
            }
            this.count = this.ints.length;
        }

        public String toString() {
            String s = new String("[");
            int i2 = 0;
            while (i2 < this.count - 1) {
                s = String.valueOf(s) + Integer.toString(this.ints[i2]) + ", ";
                ++i2;
            }
            return String.valueOf(s) + Integer.toString(this.ints[this.count - 1]) + "]";
        }
    }

    static class StripArray {
        IntList vertices;
        IntList stripCounts;

        StripArray(IntList vertices, IntList stripCounts) {
            this.vertices = vertices;
            this.stripCounts = stripCounts;
        }
    }
}

