/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Numerics;
import org.jogamp.java3d.utils.geometry.Triangulator;

class Orientation {
    Orientation() {
    }

    static void adjustOrientation(Triangulator triRef, int i1, int i2) {
        int ind;
        if (i1 >= i2) {
            System.out.println("Orientation:adjustOrientation Problem i1>=i2 !!!");
        }
        if (triRef.numLoops >= triRef.maxNumPolyArea) {
            triRef.maxNumPolyArea = triRef.numLoops;
            double[] old = triRef.polyArea;
            triRef.polyArea = new double[triRef.maxNumPolyArea];
            if (old != null) {
                System.arraycopy(old, 0, triRef.polyArea, 0, old.length);
            }
        }
        int i3 = i1;
        while (i3 < i2) {
            ind = triRef.loops[i3];
            triRef.polyArea[i3] = Orientation.polygonArea(triRef, ind);
            ++i3;
        }
        double area = Math.abs(triRef.polyArea[i1]);
        int outer = i1;
        i3 = i1 + 1;
        while (i3 < i2) {
            if (area < Math.abs(triRef.polyArea[i3])) {
                area = Math.abs(triRef.polyArea[i3]);
                outer = i3;
            }
            ++i3;
        }
        if (outer != i1) {
            ind = triRef.loops[i1];
            triRef.loops[i1] = triRef.loops[outer];
            triRef.loops[outer] = ind;
            area = triRef.polyArea[i1];
            triRef.polyArea[i1] = triRef.polyArea[outer];
            triRef.polyArea[outer] = area;
        }
        if (triRef.polyArea[i1] < 0.0) {
            triRef.swapLinks(triRef.loops[i1]);
        }
        i3 = i1 + 1;
        while (i3 < i2) {
            if (triRef.polyArea[i3] > 0.0) {
                triRef.swapLinks(triRef.loops[i3]);
            }
            ++i3;
        }
    }

    static double polygonArea(Triangulator triRef, int ind) {
        int hook = 0;
        double area = 0.0;
        double area1 = 0.0;
        int ind1 = ind;
        int i1 = triRef.fetchData(ind1);
        int ind2 = triRef.fetchNextData(ind1);
        int i2 = triRef.fetchData(ind2);
        area = Numerics.stableDet2D(triRef, hook, i1, i2);
        ind1 = ind2;
        i1 = i2;
        while (ind1 != ind) {
            ind2 = triRef.fetchNextData(ind1);
            i2 = triRef.fetchData(ind2);
            area1 = Numerics.stableDet2D(triRef, hook, i1, i2);
            area += area1;
            ind1 = ind2;
            i1 = i2;
        }
        return area;
    }

    static void determineOrientation(Triangulator triRef, int ind) {
        double area = Orientation.polygonArea(triRef, ind);
        if (area < 0.0) {
            triRef.swapLinks(ind);
            triRef.ccwLoop = false;
        }
    }
}

