/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Basic;
import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Tuple2f;

class Numerics {
    Numerics() {
    }

    static double max3(double a2, double b2, double c2) {
        return a2 > b2 ? (a2 > c2 ? a2 : c2) : (b2 > c2 ? b2 : c2);
    }

    static double min3(double a2, double b2, double c2) {
        return a2 < b2 ? (a2 < c2 ? a2 : c2) : (b2 < c2 ? b2 : c2);
    }

    static boolean lt(double a2, double eps) {
        return a2 < -eps;
    }

    static boolean le(double a2, double eps) {
        return a2 <= eps;
    }

    static boolean ge(double a2, double eps) {
        return !(a2 <= -eps);
    }

    static boolean eq(double a2, double eps) {
        return a2 <= eps && !(a2 < -eps);
    }

    static boolean gt(double a2, double eps) {
        return !(a2 <= eps);
    }

    static double baseLength(Tuple2f u, Tuple2f v) {
        double x = v.x - u.x;
        double y = v.y - u.y;
        return Math.abs(x) + Math.abs(y);
    }

    static double sideLength(Tuple2f u, Tuple2f v) {
        double x = v.x - u.x;
        double y = v.y - u.y;
        return x * x + y * y;
    }

    static boolean inBetween(int i1, int i2, int i3) {
        return i1 <= i3 && i3 <= i2;
    }

    static boolean strictlyInBetween(int i1, int i2, int i3) {
        return i1 < i3 && i3 < i2;
    }

    static double stableDet2D(Triangulator triRef, int i2, int j2, int k2) {
        double det;
        if (i2 == j2 || i2 == k2 || j2 == k2) {
            det = 0.0;
        } else {
            Point2f numericsHP = triRef.points[i2];
            Point2f numericsHQ = triRef.points[j2];
            Point2f numericsHR = triRef.points[k2];
            det = i2 < j2 ? (j2 < k2 ? Basic.det2D(numericsHP, numericsHQ, numericsHR) : (i2 < k2 ? -Basic.det2D(numericsHP, numericsHR, numericsHQ) : Basic.det2D(numericsHR, numericsHP, numericsHQ))) : (i2 < k2 ? -Basic.det2D(numericsHQ, numericsHP, numericsHR) : (j2 < k2 ? Basic.det2D(numericsHQ, numericsHR, numericsHP) : -Basic.det2D(numericsHR, numericsHQ, numericsHP)));
        }
        return det;
    }

    static int orientation(Triangulator triRef, int i2, int j2, int k2) {
        double numericsHDet = Numerics.stableDet2D(triRef, i2, j2, k2);
        int ori = Numerics.lt(numericsHDet, triRef.epsilon) ? -1 : (Numerics.gt(numericsHDet, triRef.epsilon) ? 1 : 0);
        return ori;
    }

    static boolean isInCone(Triangulator triRef, int i2, int j2, int k2, int l2, boolean convex) {
        boolean flag = true;
        if (convex) {
            if (i2 != j2) {
                int numericsHOri1 = Numerics.orientation(triRef, i2, j2, l2);
                if (numericsHOri1 < 0) {
                    flag = false;
                } else if (numericsHOri1 == 0) {
                    if (i2 < j2) {
                        if (!Numerics.inBetween(i2, j2, l2)) {
                            flag = false;
                        }
                    } else if (!Numerics.inBetween(j2, i2, l2)) {
                        flag = false;
                    }
                }
            }
            if (j2 != k2 && flag) {
                int numericsHOri2 = Numerics.orientation(triRef, j2, k2, l2);
                if (numericsHOri2 < 0) {
                    flag = false;
                } else if (numericsHOri2 == 0) {
                    if (j2 < k2) {
                        if (!Numerics.inBetween(j2, k2, l2)) {
                            flag = false;
                        }
                    } else if (!Numerics.inBetween(k2, j2, l2)) {
                        flag = false;
                    }
                }
            }
        } else {
            int numericsHOri2;
            int numericsHOri1 = Numerics.orientation(triRef, i2, j2, l2);
            if (numericsHOri1 <= 0 && (numericsHOri2 = Numerics.orientation(triRef, j2, k2, l2)) < 0) {
                flag = false;
            }
        }
        return flag;
    }

    static int isConvexAngle(Triangulator triRef, int i2, int j2, int k2, int ind) {
        int angle;
        if (i2 == j2) {
            if (j2 == k2) {
                return 1;
            }
            return 1;
        }
        if (j2 == k2) {
            return -1;
        }
        int numericsHOri1 = Numerics.orientation(triRef, i2, j2, k2);
        if (numericsHOri1 > 0) {
            angle = 1;
        } else if (numericsHOri1 < 0) {
            angle = -1;
        } else {
            Point2f numericsHP = new Point2f();
            Point2f numericsHQ = new Point2f();
            Basic.vectorSub2D(triRef.points[i2], triRef.points[j2], numericsHP);
            Basic.vectorSub2D(triRef.points[k2], triRef.points[j2], numericsHQ);
            double numericsHDot = Basic.dotProduct2D(numericsHP, numericsHQ);
            angle = numericsHDot < 0.0 ? 0 : Numerics.spikeAngle(triRef, i2, j2, k2, ind);
        }
        return angle;
    }

    static boolean pntInTriangle(Triangulator triRef, int i1, int i2, int i3, int i4) {
        boolean inside = false;
        int numericsHOri1 = Numerics.orientation(triRef, i2, i3, i4);
        if (numericsHOri1 >= 0 && (numericsHOri1 = Numerics.orientation(triRef, i1, i2, i4)) >= 0 && (numericsHOri1 = Numerics.orientation(triRef, i3, i1, i4)) >= 0) {
            inside = true;
        }
        return inside;
    }

    static boolean vtxInTriangle(Triangulator triRef, int i1, int i2, int i3, int i4, int[] type) {
        boolean inside = false;
        int numericsHOri1 = Numerics.orientation(triRef, i2, i3, i4);
        if (numericsHOri1 >= 0) {
            numericsHOri1 = Numerics.orientation(triRef, i1, i2, i4);
            if (numericsHOri1 > 0) {
                numericsHOri1 = Numerics.orientation(triRef, i3, i1, i4);
                if (numericsHOri1 > 0) {
                    inside = true;
                    type[0] = 0;
                } else if (numericsHOri1 == 0) {
                    inside = true;
                    type[0] = 1;
                }
            } else if (numericsHOri1 == 0) {
                numericsHOri1 = Numerics.orientation(triRef, i3, i1, i4);
                if (numericsHOri1 > 0) {
                    inside = true;
                    type[0] = 2;
                } else if (numericsHOri1 == 0) {
                    inside = true;
                    type[0] = 3;
                }
            }
        }
        return inside;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean segIntersect(Triangulator triRef, int i1, int i2, int i3, int i4, int i5) {
        if (i1 == i2 || i3 == i4) {
            return false;
        }
        if (i1 == i3 && i2 == i4) {
            return true;
        }
        if (i3 == i5 || i4 == i5) {
            ++triRef.identCntr;
        }
        int ori3 = Numerics.orientation(triRef, i1, i2, i3);
        int ori4 = Numerics.orientation(triRef, i1, i2, i4);
        if (ori3 == 1 && ori4 == 1 || ori3 == -1 && ori4 == -1) {
            return false;
        }
        if (ori3 == 0) {
            if (Numerics.strictlyInBetween(i1, i2, i3)) {
                return true;
            }
            if (ori4 != 0) return false;
            if (Numerics.strictlyInBetween(i1, i2, i4)) {
                return true;
            }
        } else if (ori4 == 0) {
            return Numerics.strictlyInBetween(i1, i2, i4);
        }
        int ori1 = Numerics.orientation(triRef, i3, i4, i1);
        int ori2 = Numerics.orientation(triRef, i3, i4, i2);
        return (ori1 > 0 || ori2 > 0) && (ori1 < 0 || ori2 < 0);
    }

    static double getRatio(Triangulator triRef, int i2, int j2, int k2) {
        Point2f p = triRef.points[i2];
        Point2f q = triRef.points[j2];
        Point2f r = triRef.points[k2];
        double a2 = Numerics.baseLength(p, q);
        double b2 = Numerics.baseLength(p, r);
        double c2 = Numerics.baseLength(r, q);
        double base = Numerics.max3(a2, b2, c2);
        if (10.0 * a2 < Math.min(b2, c2)) {
            return 0.1;
        }
        double area = Numerics.stableDet2D(triRef, i2, j2, k2);
        if (Numerics.lt(area, triRef.epsilon)) {
            area = -area;
        } else if (!Numerics.gt(area, triRef.epsilon)) {
            if (base > a2) {
                return 0.1;
            }
            return Double.MAX_VALUE;
        }
        double ratio = base * base / area;
        if (ratio < 10.0) {
            return ratio;
        }
        if (a2 < base) {
            return 0.1;
        }
        return ratio;
    }

    static int spikeAngle(Triangulator triRef, int i2, int j2, int k2, int ind) {
        int ind2 = ind;
        int i22 = triRef.fetchData(ind2);
        int ind1 = triRef.fetchPrevData(ind2);
        int i1 = triRef.fetchData(ind1);
        int ind3 = triRef.fetchNextData(ind2);
        int i3 = triRef.fetchData(ind3);
        return Numerics.recSpikeAngle(triRef, i2, j2, k2, ind1, ind3);
    }

    static int recSpikeAngle(Triangulator triRef, int i1, int i2, int i3, int ind1, int ind3) {
        if (ind1 == ind3) {
            return -2;
        }
        if (i1 != i3) {
            int ii2;
            int ii1;
            if (i1 < i2) {
                ii1 = i1;
                ii2 = i2;
            } else {
                ii1 = i2;
                ii2 = i1;
            }
            if (Numerics.inBetween(ii1, ii2, i3)) {
                i2 = i3;
                ind3 = triRef.fetchNextData(ind3);
                i3 = triRef.fetchData(ind3);
                if (ind1 == ind3) {
                    return 2;
                }
                int ori = Numerics.orientation(triRef, i1, i2, i3);
                if (ori > 0) {
                    return 2;
                }
                if (ori < 0) {
                    return -2;
                }
                return Numerics.recSpikeAngle(triRef, i1, i2, i3, ind1, ind3);
            }
            i2 = i1;
            ind1 = triRef.fetchPrevData(ind1);
            i1 = triRef.fetchData(ind1);
            if (ind1 == ind3) {
                return 2;
            }
            int ori = Numerics.orientation(triRef, i1, i2, i3);
            if (ori > 0) {
                return 2;
            }
            if (ori < 0) {
                return -2;
            }
            return Numerics.recSpikeAngle(triRef, i1, i2, i3, ind1, ind3);
        }
        int i0 = i2;
        i2 = i1;
        ind1 = triRef.fetchPrevData(ind1);
        i1 = triRef.fetchData(ind1);
        if (ind1 == ind3) {
            return 2;
        }
        ind3 = triRef.fetchNextData(ind3);
        i3 = triRef.fetchData(ind3);
        if (ind1 == ind3) {
            return 2;
        }
        int ori = Numerics.orientation(triRef, i1, i2, i3);
        if (ori > 0) {
            int ori2;
            int ori1 = Numerics.orientation(triRef, i1, i2, i0);
            if (ori1 > 0 && (ori2 = Numerics.orientation(triRef, i2, i3, i0)) > 0) {
                return -2;
            }
            return 2;
        }
        if (ori < 0) {
            int ori2;
            int ori1 = Numerics.orientation(triRef, i2, i1, i0);
            if (ori1 > 0 && (ori2 = Numerics.orientation(triRef, i3, i2, i0)) > 0) {
                return 2;
            }
            return -2;
        }
        Point2f pq = new Point2f();
        Basic.vectorSub2D(triRef.points[i1], triRef.points[i2], pq);
        Point2f pr = new Point2f();
        Basic.vectorSub2D(triRef.points[i3], triRef.points[i2], pr);
        double dot = Basic.dotProduct2D(pq, pr);
        if (dot < 0.0) {
            ori = Numerics.orientation(triRef, i2, i1, i0);
            if (ori > 0) {
                return 2;
            }
            return -2;
        }
        return Numerics.recSpikeAngle(triRef, i1, i2, i3, ind1, ind3);
    }

    static double angle(Triangulator triRef, Point2f p, Point2f p1, Point2f p2) {
        double angle;
        int sign = Basic.signEps(Basic.det2D(p2, p, p1), triRef.epsilon);
        if (sign == 0) {
            return 0.0;
        }
        Point2f v1 = new Point2f();
        Point2f v2 = new Point2f();
        Basic.vectorSub2D(p1, p, v1);
        Basic.vectorSub2D(p2, p, v2);
        double angle1 = Math.atan2(v1.y, v1.x);
        double angle2 = Math.atan2(v2.y, v2.x);
        if (angle1 < 0.0) {
            angle1 += Math.PI * 2;
        }
        if (angle2 < 0.0) {
            angle2 += Math.PI * 2;
        }
        if ((angle = angle1 - angle2) > Math.PI) {
            angle = Math.PI * 2 - angle;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        if (sign == 1) {
            if (angle < 0.0) {
                return -angle;
            }
            return angle;
        }
        if (angle > 0.0) {
            return -angle;
        }
        return angle;
    }
}

