/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.HeapNode;
import org.jogamp.java3d.utils.geometry.Triangulator;

class Heap {
    Heap() {
    }

    static void printHeapData(Triangulator triRef) {
        System.out.println("\nHeap Data : numZero " + triRef.numZero + " numHeap " + triRef.numHeap);
        int i2 = 0;
        while (i2 < triRef.numHeap) {
            System.out.println(String.valueOf(i2) + " ratio " + triRef.heap[i2].ratio + ", index " + triRef.heap[i2].index + ", prev " + triRef.heap[i2].prev + ", next " + triRef.heap[i2].next);
            ++i2;
        }
        System.out.println(" ");
    }

    static void initHeap(Triangulator triRef) {
        triRef.maxNumHeap = triRef.numPoints;
        triRef.heap = new HeapNode[triRef.maxNumHeap];
        triRef.numHeap = 0;
        triRef.numZero = 0;
    }

    static void storeHeapData(Triangulator triRef, int index, double ratio, int ind, int prev, int next) {
        triRef.heap[index] = new HeapNode();
        triRef.heap[index].ratio = ratio;
        triRef.heap[index].index = ind;
        triRef.heap[index].prev = prev;
        triRef.heap[index].next = next;
    }

    static void dumpOnHeap(Triangulator triRef, double ratio, int ind, int prev, int next) {
        int index;
        if (triRef.numHeap >= triRef.maxNumHeap) {
            HeapNode[] old = triRef.heap;
            triRef.maxNumHeap += triRef.numPoints;
            triRef.heap = new HeapNode[triRef.maxNumHeap];
            System.arraycopy(old, 0, triRef.heap, 0, old.length);
        }
        if (ratio == 0.0) {
            if (triRef.numZero < triRef.numHeap) {
                if (triRef.heap[triRef.numHeap] == null) {
                    Heap.storeHeapData(triRef, triRef.numHeap, triRef.heap[triRef.numZero].ratio, triRef.heap[triRef.numZero].index, triRef.heap[triRef.numZero].prev, triRef.heap[triRef.numZero].next);
                } else {
                    triRef.heap[triRef.numHeap].copy(triRef.heap[triRef.numZero]);
                }
            }
            index = triRef.numZero++;
        } else {
            index = triRef.numHeap;
        }
        Heap.storeHeapData(triRef, index, ratio, ind, prev, next);
        ++triRef.numHeap;
    }

    static void insertIntoHeap(Triangulator triRef, double ratio, int ind, int prev, int next) {
        Heap.dumpOnHeap(triRef, ratio, ind, prev, next);
    }

    static boolean deleteFromHeap(Triangulator triRef, int[] ind, int[] prev, int[] next) {
        if (triRef.numZero > 0) {
            --triRef.numZero;
            --triRef.numHeap;
            ind[0] = triRef.heap[triRef.numZero].index;
            prev[0] = triRef.heap[triRef.numZero].prev;
            next[0] = triRef.heap[triRef.numZero].next;
            if (triRef.numZero < triRef.numHeap) {
                triRef.heap[triRef.numZero].copy(triRef.heap[triRef.numHeap]);
            }
            return true;
        }
        if (triRef.earsRandom) {
            if (triRef.numHeap <= 0) {
                triRef.numHeap = 0;
                return false;
            }
            double rnd = triRef.randomGen.nextDouble();
            int rndInd = (int)(rnd * (double)triRef.numHeap);
            --triRef.numHeap;
            if (rndInd > triRef.numHeap) {
                rndInd = triRef.numHeap;
            }
            ind[0] = triRef.heap[rndInd].index;
            prev[0] = triRef.heap[rndInd].prev;
            next[0] = triRef.heap[rndInd].next;
            if (rndInd < triRef.numHeap) {
                triRef.heap[rndInd].copy(triRef.heap[triRef.numHeap]);
            }
            return true;
        }
        if (triRef.numHeap <= 0) {
            triRef.numHeap = 0;
            return false;
        }
        --triRef.numHeap;
        ind[0] = triRef.heap[triRef.numHeap].index;
        prev[0] = triRef.heap[triRef.numHeap].prev;
        next[0] = triRef.heap[triRef.numHeap].next;
        return true;
    }
}

