/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.utils.geometry.GeomBuffer;
import org.jogamp.java3d.utils.geometry.Primitive;
import org.jogamp.java3d.utils.geometry.Quadrics;

public class Cone
extends Primitive {
    float radius;
    float height;
    int xdivisions;
    int ydivisions;
    static final int MID_REZ_DIV_X = 15;
    static final int MID_REZ_DIV_Y = 1;
    public static final int BODY = 0;
    public static final int CAP = 1;

    public Cone() {
        this(1.0f, 2.0f, 1, 15, 1, null);
    }

    public Cone(float radius, float height) {
        this(radius, height, 1, 15, 1, null);
    }

    public Cone(float radius, float height, Appearance ap) {
        this(radius, height, 1, 15, 1, ap);
    }

    public Cone(float radius, float height, int primflags, Appearance ap) {
        this(radius, height, primflags, 15, 1, ap);
    }

    @Override
    public Shape3D getShape(int partId) {
        if (partId > 1 || partId < 0) {
            return null;
        }
        return (Shape3D)this.getChild(partId);
    }

    @Override
    public void setAppearance(Appearance ap) {
        ((Shape3D)this.getChild(0)).setAppearance(ap);
        ((Shape3D)this.getChild(1)).setAppearance(ap);
    }

    @Override
    public Appearance getAppearance(int partId) {
        if (partId > 1 || partId < 0) {
            return null;
        }
        return this.getShape(partId).getAppearance();
    }

    public Cone(float radius, float height, int primflags, int xdivision, int ydivision, Appearance ap) {
        Shape3D[] shape = new Shape3D[2];
        this.radius = radius;
        this.height = height;
        this.xdivisions = xdivision;
        this.ydivisions = ydivision;
        this.flags = primflags;
        boolean outside = (this.flags & 4) == 0;
        boolean texCoordYUp = (this.flags & 8) != 0;
        Quadrics q = new Quadrics();
        GeomBuffer gbuf = null;
        GeomBuffer cache = this.getCachedGeometry(4, radius, 0.0f, height, xdivision, ydivision, primflags);
        if (cache != null) {
            shape[0] = new Shape3D(cache.getComputedGeometry());
            this.numVerts += cache.getNumVerts();
            this.numTris += cache.getNumTris();
        } else {
            gbuf = q.coneTop((double)height / 2.0 - (double)(height / (float)this.ydivisions), radius / (float)this.ydivisions, height / (float)this.ydivisions, this.xdivisions, 1.0 - 1.0 / (double)this.ydivisions, outside, texCoordYUp);
            shape[0] = new Shape3D(gbuf.getGeom(this.flags));
            this.numVerts += gbuf.getNumVerts();
            this.numTris += gbuf.getNumTris();
            if ((primflags & 0x10) == 0) {
                this.cacheGeometry(4, radius, 0.0f, height, xdivision, ydivision, primflags, gbuf);
            }
        }
        if (this.ydivisions > 1) {
            cache = this.getCachedGeometry(64, radius, 0.0f, height, xdivision, ydivision, primflags);
            if (cache != null) {
                shape[0].addGeometry(cache.getComputedGeometry());
                this.numVerts += cache.getNumVerts();
                this.numTris += cache.getNumTris();
            } else {
                gbuf = q.coneBody(-((double)height / 2.0), (double)height / 2.0 - (double)(height / (float)this.ydivisions), radius, radius / (float)this.ydivisions, this.xdivisions, this.ydivisions - 1, 1.0 / (double)this.ydivisions, outside, texCoordYUp);
                shape[0].addGeometry(gbuf.getGeom(this.flags));
                this.numVerts += gbuf.getNumVerts();
                this.numTris += gbuf.getNumTris();
                if ((primflags & 0x10) == 0) {
                    this.cacheGeometry(64, radius, 0.0f, height, xdivision, ydivision, primflags, gbuf);
                }
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape[0].setCapability(14);
            shape[0].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape[0].setCapability(12);
        }
        this.addChild(shape[0]);
        cache = this.getCachedGeometry(32, radius, radius, -height / 2.0f, xdivision, xdivision, primflags);
        if (cache != null) {
            shape[1] = new Shape3D(cache.getComputedGeometry());
            this.numVerts += cache.getNumVerts();
            this.numTris += cache.getNumTris();
        } else {
            gbuf = q.disk(radius, xdivision, -((double)height) / 2.0, !outside, texCoordYUp);
            shape[1] = new Shape3D(gbuf.getGeom(this.flags));
            this.numVerts += gbuf.getNumVerts();
            this.numTris += gbuf.getNumTris();
            if ((primflags & 0x10) == 0) {
                this.cacheGeometry(32, radius, radius, -height / 2.0f, xdivision, xdivision, primflags, gbuf);
            }
        }
        if ((this.flags & 0x40) != 0) {
            shape[1].setCapability(14);
            shape[1].setCapability(15);
        }
        if ((this.flags & 0x20) != 0) {
            shape[1].setCapability(12);
        }
        this.addChild(shape[1]);
        if (ap == null) {
            this.setAppearance();
        } else {
            this.setAppearance(ap);
        }
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        Cone c2 = new Cone(this.radius, this.height, this.flags, this.xdivisions, this.ydivisions, this.getAppearance());
        c2.duplicateNode(this, forceDuplicate);
        return c2;
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
    }

    public float getRadius() {
        return this.radius;
    }

    public float getHeight() {
        return this.height;
    }

    public int getXdivisions() {
        return this.xdivisions;
    }

    public int getYdivisions() {
        return this.ydivisions;
    }
}

