/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.sensor;

import org.jogamp.java3d.Appearance;
import org.jogamp.java3d.Material;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransparencyAttributes;
import org.jogamp.java3d.TriangleArray;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

public class SensorGnomonEcho
extends Shape3D {
    public SensorGnomonEcho(Transform3D transform, double baseWidth, double axisLength, boolean enableLighting) {
        int vertexFormat;
        int FRONT = 0;
        int BACK = 1;
        int LEFT = 2;
        int RIGHT = 3;
        int TOP = 4;
        int BOTTOM = 5;
        Point3f[] axes = new Point3f[6];
        float length = (float)axisLength;
        axes[FRONT] = new Point3f(0.0f, 0.0f, length);
        axes[BACK] = new Point3f(0.0f, 0.0f, -length);
        axes[LEFT] = new Point3f(-length, 0.0f, 0.0f);
        axes[RIGHT] = new Point3f(length, 0.0f, 0.0f);
        axes[TOP] = new Point3f(0.0f, length, 0.0f);
        axes[BOTTOM] = new Point3f(0.0f, -length, 0.0f);
        if (transform != null) {
            int i2 = FRONT;
            while (i2 <= BOTTOM) {
                transform.transform(axes[i2]);
                ++i2;
            }
        }
        float offset = (float)baseWidth / 2.0f;
        Point3f[][] cube = new Point3f[6][4];
        cube[FRONT][0] = new Point3f(-offset, -offset, offset);
        cube[FRONT][1] = new Point3f(offset, -offset, offset);
        cube[FRONT][2] = new Point3f(offset, offset, offset);
        cube[FRONT][3] = new Point3f(-offset, offset, offset);
        cube[BACK][0] = new Point3f(offset, -offset, -offset);
        cube[BACK][1] = new Point3f(-offset, -offset, -offset);
        cube[BACK][2] = new Point3f(-offset, offset, -offset);
        cube[BACK][3] = new Point3f(offset, offset, -offset);
        if (transform != null) {
            int i3 = FRONT;
            while (i3 <= BACK) {
                int j2 = 0;
                while (j2 < 4) {
                    transform.transform(cube[i3][j2]);
                    ++j2;
                }
                ++i3;
            }
        }
        cube[LEFT][0] = cube[BACK][1];
        cube[LEFT][1] = cube[FRONT][0];
        cube[LEFT][2] = cube[FRONT][3];
        cube[LEFT][3] = cube[BACK][2];
        cube[RIGHT][0] = cube[FRONT][1];
        cube[RIGHT][1] = cube[BACK][0];
        cube[RIGHT][2] = cube[BACK][3];
        cube[RIGHT][3] = cube[FRONT][2];
        cube[TOP][0] = cube[FRONT][3];
        cube[TOP][1] = cube[FRONT][2];
        cube[TOP][2] = cube[BACK][3];
        cube[TOP][3] = cube[BACK][2];
        cube[BOTTOM][0] = cube[BACK][1];
        cube[BOTTOM][1] = cube[BACK][0];
        cube[BOTTOM][2] = cube[FRONT][1];
        cube[BOTTOM][3] = cube[FRONT][0];
        int v = 0;
        Point3f[] vertices = new Point3f[72];
        int i4 = 0;
        while (i4 < 6) {
            vertices[v++] = cube[i4][0];
            vertices[v++] = cube[i4][1];
            vertices[v++] = axes[i4];
            vertices[v++] = cube[i4][1];
            vertices[v++] = cube[i4][2];
            vertices[v++] = axes[i4];
            vertices[v++] = cube[i4][2];
            vertices[v++] = cube[i4][3];
            vertices[v++] = axes[i4];
            vertices[v++] = cube[i4][3];
            vertices[v++] = cube[i4][0];
            vertices[v++] = axes[i4];
            ++i4;
        }
        Material m2 = new Material();
        m2.setCapability(0);
        m2.setCapability(1);
        if (enableLighting) {
            vertexFormat = 3;
            m2.setLightingEnable(true);
        } else {
            vertexFormat = 1;
            m2.setLightingEnable(false);
        }
        TriangleArray ta = new TriangleArray(72, vertexFormat);
        ta.setCoordinates(0, vertices);
        if (enableLighting) {
            Vector3f v0 = new Vector3f();
            Vector3f v1 = new Vector3f();
            Vector3f[] normals = new Vector3f[72];
            int i5 = 0;
            while (i5 < 72) {
                v0.sub(vertices[i5 + 1], vertices[i5]);
                v1.sub(vertices[i5 + 2], vertices[i5]);
                Vector3f n2 = new Vector3f();
                n2.cross(v0, v1);
                n2.normalize();
                normals[i5] = n2;
                normals[i5 + 1] = n2;
                normals[i5 + 2] = n2;
                i5 += 3;
            }
            ta.setNormals(0, normals);
        }
        Appearance a2 = new Appearance();
        a2.setMaterial(m2);
        a2.setCapability(0);
        a2.setCapability(1);
        TransparencyAttributes tra = new TransparencyAttributes();
        tra.setCapability(0);
        tra.setCapability(1);
        tra.setCapability(2);
        tra.setCapability(3);
        ta.setCapability(4);
        ta.setCapability(5);
        a2.setTransparencyAttributes(tra);
        a2.setCapability(10);
        a2.setCapability(11);
        this.setGeometry(ta);
        this.setAppearance(a2);
        this.setCapability(14);
        this.setCapability(15);
    }
}

