/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.sensor;

import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;

public class SensorEvent {
    public static final int PRESSED = 1;
    public static final int RELEASED = 2;
    public static final int DRAGGED = 3;
    public static final int READ = 4;
    public static final int NOBUTTON = -1;
    private int id = 0;
    private Object source = null;
    private Sensor sensor = null;
    private int button = -1;
    private int[] buttonState = null;
    private Transform3D sensorRead = null;
    private long time = 0L;
    private long lastTime = 0L;
    private boolean ephemeral = false;

    public SensorEvent(Object source, int id, Sensor sensor, Transform3D sensorRead, int[] buttonState, int button, long time, long lastTime) {
        this.source = source;
        this.id = id;
        this.sensor = sensor;
        this.button = button;
        this.time = time;
        this.lastTime = lastTime;
        if (sensorRead == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = new Transform3D(sensorRead);
        if (buttonState != null) {
            this.buttonState = new int[buttonState.length];
            int i2 = 0;
            while (i2 < buttonState.length) {
                this.buttonState[i2] = buttonState[i2];
                ++i2;
            }
        }
        this.ephemeral = false;
    }

    public SensorEvent() {
        this.ephemeral = true;
    }

    public SensorEvent(SensorEvent e2) {
        this.source = e2.source;
        this.id = e2.id;
        this.sensor = e2.sensor;
        this.button = e2.button;
        this.time = e2.time;
        this.lastTime = e2.lastTime;
        if (e2.sensorRead == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = new Transform3D(e2.sensorRead);
        if (e2.buttonState != null) {
            this.buttonState = new int[e2.buttonState.length];
            int i2 = 0;
            while (i2 < e2.buttonState.length) {
                this.buttonState[i2] = e2.buttonState[i2];
                ++i2;
            }
        }
        this.ephemeral = false;
    }

    public void set(Object source, int id, Sensor sensor, Transform3D sensorRead, int[] buttonState, int button, long time, long lastTime) {
        if (!this.ephemeral) {
            throw new IllegalStateException("Can't set the fields of non-ephemeral events");
        }
        this.source = source;
        this.id = id;
        this.sensor = sensor;
        if (sensorRead == null) {
            throw new NullPointerException("sensorRead can't be null");
        }
        this.sensorRead = sensorRead;
        this.buttonState = buttonState;
        this.button = button;
        this.time = time;
        this.lastTime = lastTime;
    }

    public Object getSource() {
        return this.source;
    }

    public int getID() {
        return this.id;
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public long getTime() {
        return this.time;
    }

    public long getLastTime() {
        return this.lastTime;
    }

    public void getSensorRead(Transform3D t) {
        t.set(this.sensorRead);
    }

    public int getButton() {
        return this.button;
    }

    public void getButtonState(int[] buttonState) {
        if (buttonState.length != this.buttonState.length) {
            throw new ArrayIndexOutOfBoundsException("buttonState array is the wrong length");
        }
        int i2 = 0;
        while (i2 < buttonState.length) {
            buttonState[i2] = this.buttonState[i2];
            ++i2;
        }
    }

    public boolean isEphemeral() {
        return this.ephemeral;
    }
}

