/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.sensor;

import java.util.Iterator;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Sensor;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.java3d.utils.behaviors.sensor.SensorEvent;
import org.jogamp.java3d.utils.behaviors.sensor.SensorEventAgent;
import org.jogamp.java3d.utils.behaviors.sensor.SensorGnomonEcho;
import org.jogamp.java3d.utils.behaviors.sensor.SensorReadListener;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3f;

public class Mouse6DPointerBehavior
extends Behavior {
    private Sensor sensor = null;
    private SensorEventAgent eventAgent = null;
    private TransformGroup echoTransformGroup = null;
    private WakeupCondition conditions = new WakeupOnElapsedFrames(0);

    public Mouse6DPointerBehavior(Sensor sensor, double size, boolean enableLighting) {
        this.sensor = sensor;
        this.echoTransformGroup = new TransformGroup();
        this.echoTransformGroup.setCapability(18);
        Point3d hotspot = new Point3d();
        sensor.getHotspot(hotspot);
        Transform3D t3d = new Transform3D();
        Vector3f v3f = new Vector3f(hotspot);
        t3d.set(v3f);
        SensorGnomonEcho echo = new SensorGnomonEcho(t3d, 0.001 * size, 0.005 * size, enableLighting);
        this.echoTransformGroup.addChild(echo);
        this.eventAgent = new SensorEventAgent(this);
        this.eventAgent.addSensorReadListener(sensor, new EchoReadListener());
    }

    public Mouse6DPointerBehavior(Sensor sensor, TransformGroup tg) {
        this.sensor = sensor;
        this.echoTransformGroup = tg;
        this.eventAgent = new SensorEventAgent(this);
        this.eventAgent.addSensorReadListener(sensor, new EchoReadListener());
    }

    public Sensor getSensor() {
        return this.sensor;
    }

    public TransformGroup getEcho() {
        return this.echoTransformGroup;
    }

    public SensorEventAgent getSensorEventAgent() {
        return this.eventAgent;
    }

    @Override
    public void initialize() {
        this.wakeupOn(this.conditions);
    }

    @Override
    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        this.eventAgent.dispatchEvents();
        this.wakeupOn(this.conditions);
    }

    public class EchoReadListener
    implements SensorReadListener {
        private Transform3D t3d = new Transform3D();

        @Override
        public void read(SensorEvent e2) {
            Mouse6DPointerBehavior.this.getView().getSensorToVworld(e2.getSensor(), this.t3d);
            Mouse6DPointerBehavior.this.echoTransformGroup.setTransform(this.t3d);
        }
    }
}

