/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.mouse;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Iterator;
import java.util.LinkedList;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOnBehaviorPost;
import org.jogamp.java3d.utils.behaviors.mouse.MouseBehavior;
import org.jogamp.java3d.utils.behaviors.mouse.MouseBehaviorCallback;
import org.jogamp.vecmath.Vector3d;

public class MouseWheelZoom
extends MouseBehavior {
    double z_factor = 0.1;
    Vector3d translation = new Vector3d();
    private MouseBehaviorCallback callback = null;

    public MouseWheelZoom(TransformGroup transformGroup) {
        super(transformGroup);
    }

    public MouseWheelZoom() {
        super(0);
    }

    public MouseWheelZoom(int flags) {
        super(flags);
    }

    public MouseWheelZoom(Component c2) {
        super(c2, 0);
    }

    public MouseWheelZoom(Component c2, TransformGroup transformGroup) {
        super(c2, transformGroup);
    }

    public MouseWheelZoom(Component c2, int flags) {
        super(c2, flags);
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.z_factor *= -1.0;
            this.invert = true;
        }
    }

    public double getFactor() {
        return this.z_factor;
    }

    public void setFactor(double factor) {
        this.z_factor = factor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        block3: while (criteria.hasNext()) {
            MouseEvent evt;
            WakeupCriterion wakeup = criteria.next();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                evt = (MouseEvent)events[events.length - 1];
                this.doProcess(evt);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseq;
                synchronized (linkedList) {
                    if (this.mouseq.isEmpty()) {
                        continue block3;
                    }
                    evt = (MouseEvent)this.mouseq.remove(0);
                    while (evt.getID() == 507 && !this.mouseq.isEmpty() && ((MouseEvent)this.mouseq.get(0)).getID() == 507) {
                        evt = (MouseEvent)this.mouseq.remove(0);
                    }
                }
                this.doProcess(evt);
            }
        }
        this.wakeupOn(this.mouseCriterion);
    }

    void doProcess(MouseEvent evt) {
        int units = 0;
        this.processMouseEvent(evt);
        if (evt.getID() == 507) {
            MouseWheelEvent wheelEvent = (MouseWheelEvent)evt;
            if (wheelEvent.getScrollType() == 0) {
                units = wheelEvent.getUnitsToScroll();
            }
            if (!this.reset) {
                this.transformGroup.getTransform(this.currXform);
                this.translation.z = (double)units * this.z_factor;
                this.transformX.set(this.translation);
                if (this.invert) {
                    this.currXform.mul(this.currXform, this.transformX);
                } else {
                    this.currXform.mul(this.transformX, this.currXform);
                }
                this.transformGroup.setTransform(this.currXform);
                this.transformChanged(this.currXform);
                if (this.callback != null) {
                    this.callback.transformChanged(2, this.currXform);
                }
            } else {
                this.reset = false;
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

