/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.mouse;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Iterator;
import java.util.LinkedList;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOnBehaviorPost;
import org.jogamp.java3d.WakeupOr;
import org.jogamp.java3d.internal.J3dUtilsI18N;

public abstract class MouseBehavior
extends Behavior
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private boolean listener = false;
    protected WakeupCriterion[] mouseEvents;
    protected WakeupOr mouseCriterion;
    protected int x;
    protected int y;
    protected int x_last;
    protected int y_last;
    protected TransformGroup transformGroup;
    protected Transform3D transformX;
    protected Transform3D transformY;
    protected Transform3D currXform;
    protected boolean buttonPress = false;
    protected boolean reset = false;
    protected boolean invert = false;
    protected boolean wakeUp = false;
    protected int flags = 0;
    protected LinkedList mouseq;
    protected boolean enable = true;
    public static final int MANUAL_WAKEUP = 1;
    public static final int INVERT_INPUT = 2;

    public MouseBehavior(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public MouseBehavior(int format) {
        this.flags = format;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public MouseBehavior(Component c2, TransformGroup transformGroup) {
        this(transformGroup);
        if (c2 != null) {
            c2.addMouseListener(this);
            c2.addMouseMotionListener(this);
            c2.addMouseWheelListener(this);
        }
        this.listener = true;
    }

    public MouseBehavior(Component c2, int format) {
        this(format);
        if (c2 != null) {
            c2.addMouseListener(this);
            c2.addMouseMotionListener(this);
            c2.addMouseWheelListener(this);
        }
        this.listener = true;
    }

    public void setTransformGroup(TransformGroup transformGroup) {
        this.transformGroup = transformGroup;
        this.currXform = new Transform3D();
        this.transformX = new Transform3D();
        this.transformY = new Transform3D();
        this.reset = true;
    }

    public TransformGroup getTransformGroup() {
        return this.transformGroup;
    }

    @Override
    public void initialize() {
        this.mouseEvents = new WakeupCriterion[4];
        if (!this.listener) {
            this.mouseEvents[0] = new WakeupOnAWTEvent(506);
            this.mouseEvents[1] = new WakeupOnAWTEvent(501);
            this.mouseEvents[2] = new WakeupOnAWTEvent(502);
            this.mouseEvents[3] = new WakeupOnAWTEvent(507);
        } else {
            this.mouseEvents[0] = new WakeupOnBehaviorPost(this, 506);
            this.mouseEvents[1] = new WakeupOnBehaviorPost(this, 501);
            this.mouseEvents[2] = new WakeupOnBehaviorPost(this, 502);
            this.mouseEvents[3] = new WakeupOnBehaviorPost(this, 507);
            this.mouseq = new LinkedList();
        }
        this.mouseCriterion = new WakeupOr(this.mouseEvents);
        this.wakeupOn(this.mouseCriterion);
        this.x = 0;
        this.y = 0;
        this.x_last = 0;
        this.y_last = 0;
    }

    public void wakeup() {
        this.wakeUp = true;
    }

    public void processMouseEvent(MouseEvent evt) {
        if (evt.getID() == 501) {
            this.buttonPress = true;
            return;
        }
        if (evt.getID() == 502) {
            this.buttonPress = false;
            this.wakeUp = false;
        }
    }

    @Override
    public abstract void processStimulus(Iterator<WakeupCriterion> var1);

    public void addListener(Component c2) {
        if (!this.listener) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Behavior0"));
        }
        c2.addMouseListener(this);
        c2.addMouseMotionListener(this);
        c2.addMouseWheelListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
    }

    @Override
    public void mouseExited(MouseEvent e2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mousePressed(MouseEvent e2) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(e2);
                if (this.mouseq.size() == 1) {
                    this.postId(501);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseReleased(MouseEvent e2) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(e2);
                if (this.mouseq.size() == 1) {
                    this.postId(502);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseDragged(MouseEvent e2) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(e2);
                if (this.mouseq.size() == 1) {
                    this.postId(506);
                }
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e2) {
    }

    @Override
    public void setEnable(boolean state) {
        super.setEnable(state);
        this.enable = state;
        if (!this.enable && this.mouseq != null) {
            this.mouseq.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (this.enable) {
            LinkedList linkedList = this.mouseq;
            synchronized (linkedList) {
                this.mouseq.add(e2);
                if (this.mouseq.size() == 1) {
                    this.postId(507);
                }
            }
        }
    }
}

