/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.keyboard;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.LinkedList;
import org.jogamp.java3d.Behavior;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCondition;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnAWTEvent;
import org.jogamp.java3d.WakeupOnBehaviorPost;
import org.jogamp.java3d.WakeupOnElapsedFrames;
import org.jogamp.java3d.WakeupOr;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.behaviors.keyboard.KeyNavigator;

public class KeyNavigatorBehavior
extends Behavior
implements KeyListener {
    private WakeupCriterion w1 = new WakeupOnAWTEvent(401);
    private WakeupCriterion w2 = new WakeupOnAWTEvent(402);
    private WakeupOnElapsedFrames w3 = new WakeupOnElapsedFrames(0);
    private WakeupCriterion[] warray = new WakeupCriterion[]{this.w1, this.w2, this.w3};
    private WakeupCondition w = new WakeupOr(this.warray);
    private KeyEvent eventKey;
    private KeyNavigator keyNavigator;
    private boolean listener = false;
    private LinkedList eventq;

    @Override
    public void initialize() {
        if (this.listener) {
            this.w1 = new WakeupOnBehaviorPost(this, 401);
            this.w2 = new WakeupOnBehaviorPost(this, 402);
            this.warray[0] = this.w1;
            this.warray[1] = this.w2;
            this.w = new WakeupOr(this.warray);
            this.eventq = new LinkedList();
        }
        this.wakeupOn(this.w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        boolean sawFrame = false;
        block3: while (criteria.hasNext()) {
            WakeupCriterion genericEvt = criteria.next();
            if (genericEvt instanceof WakeupOnAWTEvent) {
                WakeupOnAWTEvent ev = (WakeupOnAWTEvent)genericEvt;
                AWTEvent[] events = ev.getAWTEvent();
                this.processAWTEvent(events);
                continue;
            }
            if (genericEvt instanceof WakeupOnElapsedFrames && this.eventKey != null) {
                sawFrame = true;
                continue;
            }
            if (!(genericEvt instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.eventq;
                synchronized (linkedList) {
                    if (this.eventq.isEmpty()) {
                        continue block3;
                    }
                    this.eventKey = (KeyEvent)this.eventq.remove(0);
                    if (this.eventKey.getID() == 401 || this.eventKey.getID() == 402) {
                        this.keyNavigator.processKeyEvent(this.eventKey);
                    }
                }
            }
        }
        if (sawFrame) {
            this.keyNavigator.integrateTransformChanges();
        }
        this.wakeupOn(this.w);
    }

    private void processAWTEvent(AWTEvent[] events) {
        int loop = 0;
        while (loop < events.length) {
            if (events[loop] instanceof KeyEvent) {
                this.eventKey = (KeyEvent)events[loop];
                if (this.eventKey.getID() == 401 || this.eventKey.getID() == 402) {
                    this.keyNavigator.processKeyEvent(this.eventKey);
                }
            }
            ++loop;
        }
    }

    public void addListener(Component c2) {
        if (!this.listener) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Behavior0"));
        }
        c2.addKeyListener(this);
    }

    public KeyNavigatorBehavior(TransformGroup targetTG) {
        this.keyNavigator = new KeyNavigator(targetTG);
    }

    public KeyNavigatorBehavior(Component c2, TransformGroup targetTG) {
        this(targetTG);
        if (c2 != null) {
            c2.addKeyListener(this);
        }
        this.listener = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyPressed(KeyEvent evt) {
        LinkedList linkedList = this.eventq;
        synchronized (linkedList) {
            this.eventq.add(evt);
            if (this.eventq.size() == 1) {
                this.postId(401);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyReleased(KeyEvent evt) {
        LinkedList linkedList = this.eventq;
        synchronized (linkedList) {
            this.eventq.add(evt);
            if (this.eventq.size() == 1) {
                this.postId(402);
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent evt) {
    }
}

