/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.TransformInterpolator;
import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.java3d.utils.behaviors.interpolators.TCBKeyFrame;

public abstract class TCBSplinePathInterpolator
extends TransformInterpolator {
    private int keysLength;
    protected TCBKeyFrame[] keyFrames;
    protected float currentU;
    protected int lowerKnot;
    protected int upperKnot;

    TCBSplinePathInterpolator() {
    }

    public TCBSplinePathInterpolator(Alpha alpha, TCBKeyFrame[] keys) {
        this(alpha, null, keys);
    }

    public TCBSplinePathInterpolator(Alpha alpha, TransformGroup target, TCBKeyFrame[] keys) {
        super(alpha, target);
        this.processKeyFrames(keys);
    }

    public TCBSplinePathInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform, TCBKeyFrame[] keys) {
        super(alpha, target, axisOfTransform);
        this.processKeyFrames(keys);
    }

    private void processKeyFrames(TCBKeyFrame[] keys) {
        this.keysLength = keys.length;
        if (this.keysLength < 2) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator0"));
        }
        if ((double)keys[0].knot < -1.0E-4 || (double)keys[0].knot > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator1"));
        }
        if ((double)keys[this.keysLength - 1].knot - 1.0 < -1.0E-4 || (double)keys[this.keysLength - 1].knot - 1.0 > 1.0E-4) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator2"));
        }
        int i2 = 0;
        while (i2 < this.keysLength) {
            if (i2 > 0 && keys[i2].knot < keys[i2 - 1].knot) {
                throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBSplinePathInterpolator3"));
            }
            ++i2;
        }
        this.keyFrames = new TCBKeyFrame[this.keysLength + 2];
        this.keyFrames[0] = new TCBKeyFrame();
        this.keyFrames[0] = keys[0];
        i2 = 1;
        while (i2 < this.keysLength + 1) {
            this.keyFrames[i2] = keys[i2 - 1];
            ++i2;
        }
        this.keyFrames[this.keysLength + 1] = new TCBKeyFrame();
        this.keyFrames[this.keysLength + 1] = keys[this.keysLength - 1];
        this.keysLength += 2;
    }

    public int getArrayLength() {
        return this.keysLength - 2;
    }

    public TCBKeyFrame getKeyFrame(int index) {
        return this.keyFrames[index + 1];
    }

    protected void computePathInterpolation(float alphaValue) {
        int i2 = 1;
        int len = this.keysLength - 2;
        while (alphaValue > this.keyFrames[i2].knot && i2 < len) {
            ++i2;
        }
        if (i2 == 1) {
            this.currentU = 0.0f;
            this.lowerKnot = 1;
            this.upperKnot = 2;
        } else {
            this.currentU = (alphaValue - this.keyFrames[i2 - 1].knot) / (this.keyFrames[i2].knot - this.keyFrames[i2 - 1].knot);
            this.lowerKnot = i2 - 1;
            this.upperKnot = i2;
        }
    }

    protected void computePathInterpolation() {
        float value = this.getAlpha().value();
        this.computePathInterpolation(value);
    }

    @Override
    public void duplicateNode(Node originalNode, boolean forceDuplicate) {
        super.duplicateNode(originalNode, forceDuplicate);
        TCBSplinePathInterpolator originalSpline = (TCBSplinePathInterpolator)originalNode;
        this.setAlpha(originalSpline.getAlpha());
        this.keysLength = originalSpline.keysLength;
        this.keyFrames = new TCBKeyFrame[this.keysLength];
        System.arraycopy(originalSpline.keyFrames, 0, this.keyFrames, 0, this.keysLength);
    }
}

