/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.behaviors.interpolators;

import org.jogamp.java3d.internal.J3dUtilsI18N;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Quat4f;

public class TCBKeyFrame {
    public Point3f position;
    public Quat4f quat;
    public Point3f scale;
    public float tension;
    public float continuity;
    public float bias;
    public float knot;
    public int linear;

    TCBKeyFrame() {
        this.bias = 0.0f;
        this.continuity = 0.0f;
        this.tension = 0.0f;
    }

    public TCBKeyFrame(TCBKeyFrame kf) {
        this(kf.knot, kf.linear, kf.position, kf.quat, kf.scale, kf.tension, kf.continuity, kf.bias);
    }

    public TCBKeyFrame(float k2, int l2, Point3f pos, Quat4f q, Point3f s, float t, float c2, float b2) {
        this.knot = k2;
        this.linear = l2;
        this.position = new Point3f(pos);
        this.quat = new Quat4f(q);
        this.scale = new Point3f(s);
        if (t < -1.0f || t > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBKeyFrame0"));
        }
        if (b2 < -1.0f || b2 > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBKeyFrame1"));
        }
        if (c2 < -1.0f || c2 > 1.0f) {
            throw new IllegalArgumentException(J3dUtilsI18N.getString("TCBKeyFrame2"));
        }
        this.tension = t;
        this.continuity = c2;
        this.bias = b2;
    }

    public void debugPrint(String tag) {
        System.out.println("\n" + tag);
        System.out.println(" knot = " + this.knot);
        System.out.println(" linear = " + this.linear);
        System.out.println(" position(x,y,z) = " + this.position.x + " " + this.position.y + " " + this.position.z);
        System.out.println(" tension = " + this.tension);
        System.out.println(" continuity = " + this.continuity);
        System.out.println(" bias = " + this.bias);
    }
}

