/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.jogamp.java3d.loaders.ParsingErrorException;
import org.jogamp.java3d.loaders.lw3d.DebugOutput;

class LWOBFileReader
extends BufferedInputStream {
    static final int TRACE = 1;
    static final int VALUES = 2;
    static final int MISC = 4;
    static final int LINE_TRACE = 8;
    static final int NONE = 0;
    static final int EXCEPTION = 16;
    protected DebugOutput debugPrinter = new DebugOutput(127);
    protected String theFilename;
    protected int marker = 0;

    protected void debugOutputLn(int outputType, String theOutput) {
        if (theOutput.equals("")) {
            this.debugPrinter.println(outputType, theOutput);
        } else {
            this.debugPrinter.println(outputType, String.valueOf(this.getClass().getName()) + "::" + theOutput);
        }
    }

    public String getToken() throws ParsingErrorException {
        byte[] tokenBuffer;
        block3: {
            tokenBuffer = new byte[4];
            try {
                int readResult = this.read(tokenBuffer, 0, 4);
                if (readResult != -1) break block3;
                this.debugOutputLn(8, "no token - returning null");
                return null;
            }
            catch (IOException e2) {
                this.debugOutputLn(16, "getToken: " + e2);
                throw new ParsingErrorException(e2.getMessage());
            }
        }
        return new String(tokenBuffer);
    }

    public void skipLength(int amount) throws ParsingErrorException {
        try {
            this.skip(amount);
            this.marker += amount;
        }
        catch (IOException e2) {
            this.debugOutputLn(16, "skipLength: " + e2);
            throw new ParsingErrorException(e2.getMessage());
        }
    }

    public int getInt() throws ParsingErrorException {
        try {
            int x = 0;
            int i2 = 0;
            while (i2 < 4) {
                int readResult = this.read();
                if (readResult == -1) {
                    throw new ParsingErrorException("Unexpected EOF");
                }
                x = x << 8 | readResult;
                ++i2;
            }
            return x;
        }
        catch (IOException e2) {
            this.debugOutputLn(16, "getInt: " + e2);
            throw new ParsingErrorException(e2.getMessage());
        }
    }

    public float getFloat() throws ParsingErrorException {
        return Float.intBitsToFloat(this.getInt());
    }

    public String getFilename() {
        return this.theFilename;
    }

    public String getString() throws ParsingErrorException {
        byte[] buf = new byte[512];
        try {
            byte b2;
            int len = 0;
            do {
                b2 = (byte)this.read();
                buf[len++] = b2;
            } while (b2 != 0);
            if (len % 2 != 0) {
                this.read();
            }
        }
        catch (IOException e2) {
            this.debugOutputLn(16, "getString: " + e2);
            throw new ParsingErrorException(e2.getMessage());
        }
        return new String(buf);
    }

    public void getVerts(float[] ar, int num) throws ParsingErrorException {
        int i2 = 0;
        while (i2 < num) {
            ar[i2 * 3 + 0] = this.getFloat();
            ar[i2 * 3 + 1] = this.getFloat();
            ar[i2 * 3 + 2] = -this.getFloat();
            ++i2;
        }
    }

    public int getShortInt() throws ParsingErrorException {
        int i2 = 0;
        try {
            i2 = this.read();
            i2 = i2 << 8 | this.read();
            if ((i2 & 0x8000) != 0) {
                i2 |= 0xFFFF0000;
            }
        }
        catch (IOException e2) {
            this.debugOutputLn(16, "getShortInt: " + e2);
            throw new ParsingErrorException(e2.getMessage());
        }
        return i2;
    }

    public int getMarker() {
        return this.marker;
    }

    @Override
    public int read() throws IOException {
        ++this.marker;
        return super.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        int ret = super.read(buffer, offset, count);
        if (ret != -1) {
            this.marker += ret;
        }
        return ret;
    }

    public LWOBFileReader(String filename) throws FileNotFoundException {
        super(new FileInputStream(filename));
    }

    public LWOBFileReader(URL url) throws IOException {
        super(url.openStream());
    }
}

