/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

class ImageScaler {
    int origW;
    int origH;
    Image origImage;

    ImageScaler(Image image, int w, int h2) {
        this.origImage = image;
        this.origW = w;
        this.origH = h2;
    }

    ImageScaler(BufferedImage image) {
        this.origImage = image;
        this.origW = image.getWidth();
        this.origH = image.getHeight();
    }

    int getClosestPowerOf2(int value) {
        if (value < 1) {
            return value;
        }
        int powerValue = 1;
        int i2 = 1;
        while (i2 < 20) {
            if (value < (powerValue *= 2)) {
                int minBound = powerValue / 2;
                if (powerValue - value > value - minBound) {
                    return minBound;
                }
                return powerValue;
            }
            ++i2;
        }
        return 1;
    }

    Image getScaledImage() {
        int newWidth = this.getClosestPowerOf2(this.origW);
        int newHeight = this.getClosestPowerOf2(this.origH);
        if (newWidth == this.origW && newHeight == this.origH) {
            return this.origImage;
        }
        Image scaledImage = null;
        if (this.origImage instanceof BufferedImage) {
            BufferedImage origImageB = (BufferedImage)this.origImage;
            scaledImage = new BufferedImage(newWidth, newHeight, origImageB.getType());
            BufferedImage scaledImageB = (BufferedImage)scaledImage;
            float widthScale = (float)this.origW / (float)newWidth;
            float heightScale = (float)this.origH / (float)newHeight;
            int[] origPixels = ((DataBufferInt)origImageB.getRaster().getDataBuffer()).getData();
            int[] newPixels = ((DataBufferInt)scaledImageB.getRaster().getDataBuffer()).getData();
            int row = 0;
            while (row < newHeight) {
                int column = 0;
                while (column < newWidth) {
                    int oldRow = Math.min(this.origH - 1, (int)((float)row * heightScale + 0.5f));
                    int oldColumn = Math.min(this.origW - 1, (int)((float)column * widthScale + 0.5f));
                    newPixels[row * newWidth + column] = origPixels[oldRow * this.origW + oldColumn];
                    ++column;
                }
                ++row;
            }
        } else {
            scaledImage = this.origImage.getScaledInstance(newWidth, newHeight, 1);
        }
        return scaledImage;
    }
}

