/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BehaviorRetained;
import org.jogamp.java3d.BehaviorStructure;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.ViewPlatform;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupIndexedList;

public final class WakeupOnViewPlatformEntry
extends WakeupCriterion {
    static final int COND_IN_BS_LIST = 0;
    static final int BOUNDSENTRY_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    Bounds region;
    Bounds transformedRegion;
    ViewPlatformRetained triggeredVP;

    public WakeupOnViewPlatformEntry(Bounds region) {
        this.region = (Bounds)region.clone();
        WakeupIndexedList.init(this, 2);
    }

    public Bounds getBounds() {
        return (Bounds)this.region.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ViewPlatform getTriggeringViewPlatform() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnViewPlatformEntry0"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnViewPlatformEntry0"));
            }
        }
        return this.triggeredVP != null ? (ViewPlatform)this.triggeredVP.source : null;
    }

    void updateTransformRegion(BehaviorRetained b2) {
        if (this.transformedRegion != null) {
            this.transformedRegion.set(this.region);
        } else {
            this.transformedRegion = (Bounds)this.region.clone();
        }
        this.transformedRegion.transform(b2.getCurrentLocalToVworld(null));
    }

    @Override
    void addBehaviorCondition(BehaviorStructure bs) {
        this.updateTransformRegion(this.behav);
        this.behav.wakeupArray[2] = this.behav.wakeupArray[2] + 1;
        this.behav.wakeupMask |= 4;
        bs.addVPEntryCondition(this);
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure bs) {
        this.behav.wakeupArray[2] = this.behav.wakeupArray[2] - 1;
        if (this.behav.wakeupArray[2] == 0) {
            this.behav.wakeupMask &= 0xFFFFFFFB;
        }
        bs.removeVPEntryCondition(this);
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure bs) {
    }
}

