/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingPolytope;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.GeometryStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.PickBounds;
import org.jogamp.java3d.PickCone;
import org.jogamp.java3d.PickCylinder;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickRay;
import org.jogamp.java3d.PickSegment;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.Transform3D;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Vector3d;

class TriangleFanArrayRetained
extends GeometryStripArrayRetained {
    TriangleFanArrayRetained() {
        this.geoType = 6;
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Point3d[] pnts = new Point3d[3];
        double[] sdist = new double[1];
        double minDist = Double.MAX_VALUE;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        int i2 = 0;
        pnts[0] = new Point3d();
        pnts[1] = new Point3d();
        pnts[2] = new Point3d();
        int[] vtxIndexArr = new int[3];
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k2 = 0; k2 < 2; ++k2) {
                        vtxIndexArr[k2] = j2;
                        this.getVertexData(j2++, pnts[k2]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectRay(pnts, pickRay, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k3 = 0; k3 < 2; ++k3) {
                        vtxIndexArr[k3] = j2;
                        this.getVertexData(j2++, pnts[k3]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectSegment(pnts, pickSegment.start, pickSegment.end, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox bbox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k4 = 0; k4 < 2; ++k4) {
                        vtxIndexArr[k4] = j2;
                        this.getVertexData(j2++, pnts[k4]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectBoundingBox(pnts, bbox, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k5 = 0; k5 < 2; ++k5) {
                        vtxIndexArr[k5] = j2;
                        this.getVertexData(j2++, pnts[k5]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectBoundingSphere(pnts, bsphere, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k6 = 0; k6 < 2; ++k6) {
                        vtxIndexArr[k6] = j2;
                        this.getVertexData(j2++, pnts[k6]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k7 = 0; k7 < 2; ++k7) {
                        vtxIndexArr[k7] = j2;
                        this.getVertexData(j2++, pnts[k7]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectCylinder(pnts, pickCylinder, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    for (int k8 = 0; k8 < 2; ++k8) {
                        vtxIndexArr[k8] = j2;
                        this.getVertexData(j2++, pnts[k8]);
                    }
                    while (j2 < end) {
                        vtxIndexArr[2] = j2;
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectCone(pnts, pickCone, sdist, iPnt)) {
                            if (flags == 0) {
                                return true;
                            }
                            if (sdist[0] < minDist) {
                                minDist = sdist[0];
                                x = iPnt.x;
                                y = iPnt.y;
                                z = iPnt.z;
                                if ((flags & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                                }
                            }
                            if ((flags & 0x40) != 0) {
                                this.storeInterestData(pickInfo, flags, geom, geomIndex, vtxIndexArr, iPnt, sdist[0]);
                            }
                        }
                        pnts[1].set(pnts[2]);
                        vtxIndexArr[1] = vtxIndexArr[2];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("TriangleFanArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (minDist < Double.MAX_VALUE) {
            iPnt.x = x;
            iPnt.y = y;
            iPnt.z = z;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Point3d[] points = new Point3d[3];
        double[] dist = new double[1];
        int i2 = 0;
        points[0] = new Point3d();
        points[1] = new Point3d();
        points[2] = new Point3d();
        switch (pnts.length) {
            case 3: {
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    int end = j2 + this.stripVertexCounts[i2++];
                    this.getVertexData(j2++, points[0]);
                    this.getVertexData(j2++, points[1]);
                    while (j2 < end) {
                        this.getVertexData(j2++, points[2]);
                        if (this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2])) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 4: {
                while (i2 < this.stripVertexCounts.length) {
                    int j3 = this.stripStartVertexIndices[i2];
                    int end = j3 + this.stripVertexCounts[i2++];
                    this.getVertexData(j3++, points[0]);
                    this.getVertexData(j3++, points[1]);
                    while (j3 < end) {
                        this.getVertexData(j3++, points[2]);
                        if (this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[1], pnts[2]) || this.intersectTriTri(points[0], points[1], points[2], pnts[0], pnts[2], pnts[3])) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 2: {
                while (i2 < this.stripVertexCounts.length) {
                    int j4 = this.stripStartVertexIndices[i2];
                    int end = j4 + this.stripVertexCounts[i2++];
                    this.getVertexData(j4++, points[0]);
                    this.getVertexData(j4++, points[1]);
                    while (j4 < end) {
                        this.getVertexData(j4++, points[2]);
                        if (this.intersectSegment(points, pnts[0], pnts[1], dist, null)) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
            case 1: {
                while (i2 < this.stripVertexCounts.length) {
                    int j5 = this.stripStartVertexIndices[i2];
                    int end = j5 + this.stripVertexCounts[i2++];
                    this.getVertexData(j5++, points[0]);
                    this.getVertexData(j5++, points[1]);
                    while (j5 < end) {
                        this.getVertexData(j5++, points[2]);
                        if (this.intersectTriPnt(points[0], points[1], points[2], pnts[0])) {
                            return true;
                        }
                        points[1].set(points[2]);
                    }
                }
                break;
            }
        }
        return false;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        int i2 = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        while (i2 < this.stripVertexCounts.length) {
            int j2 = this.stripStartVertexIndices[i2];
            int end = j2 + this.stripVertexCounts[i2++];
            this.getVertexData(j2++, pnts[0]);
            this.getVertexData(j2++, pnts[1]);
            thisToOtherVworld.transform(pnts[0]);
            thisToOtherVworld.transform(pnts[1]);
            while (j2 < end) {
                this.getVertexData(j2++, pnts[2]);
                thisToOtherVworld.transform(pnts[2]);
                if (geom.intersect(pnts)) {
                    return true;
                }
                pnts[1].set(pnts[2]);
            }
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        int i2 = 0;
        Point3d[] pnts = new Point3d[]{new Point3d(), new Point3d(), new Point3d()};
        switch (targetBound.getPickType()) {
            case 6: {
                BoundingBox box = (BoundingBox)targetBound;
                while (i2 < this.stripVertexCounts.length) {
                    int j2 = this.stripStartVertexIndices[i2];
                    this.getVertexData(j2++, pnts[0]);
                    this.getVertexData(j2++, pnts[1]);
                    int end = j2 + this.stripVertexCounts[i2++];
                    while (j2 < end) {
                        this.getVertexData(j2++, pnts[2]);
                        if (this.intersectBoundingBox(pnts, box, null, null)) {
                            return true;
                        }
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere bsphere = (BoundingSphere)targetBound;
                while (i2 < this.stripVertexCounts.length) {
                    int j3 = this.stripStartVertexIndices[i2];
                    int end = j3 + this.stripVertexCounts[i2++];
                    this.getVertexData(j3++, pnts[0]);
                    this.getVertexData(j3++, pnts[1]);
                    while (j3 < end) {
                        this.getVertexData(j3++, pnts[2]);
                        if (this.intersectBoundingSphere(pnts, bsphere, null, null)) {
                            return true;
                        }
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope bpolytope = (BoundingPolytope)targetBound;
                while (i2 < this.stripVertexCounts.length) {
                    int j4 = this.stripStartVertexIndices[i2];
                    int end = j4 + this.stripVertexCounts[i2++];
                    this.getVertexData(j4++, pnts[0]);
                    this.getVertexData(j4++, pnts[1]);
                    while (j4 < end) {
                        this.getVertexData(j4++, pnts[2]);
                        if (this.intersectBoundingPolytope(pnts, bpolytope, null, null)) {
                            return true;
                        }
                        pnts[1].set(pnts[2]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + targetBound);
            }
        }
        return false;
    }

    @Override
    void computeCentroid() {
        double area;
        Vector3d vec = new Vector3d();
        Vector3d normal = new Vector3d();
        Vector3d tmpvec = new Vector3d();
        Point3d pnt0 = new Point3d();
        Point3d pnt1 = new Point3d();
        Point3d pnt2 = new Point3d();
        double totalarea = 0.0;
        int i2 = 0;
        this.centroid.x = 0.0;
        this.centroid.y = 0.0;
        this.centroid.z = 0.0;
        while (i2 < this.stripVertexCounts.length) {
            int j2 = this.stripStartVertexIndices[i2];
            int end = j2 + this.stripVertexCounts[i2++];
            this.getVertexData(j2++, pnt0);
            this.getVertexData(j2++, pnt1);
            int replaceIndex = 2;
            while (j2 < end) {
                area = 0.0;
                if (replaceIndex == 2) {
                    this.getVertexData(j2++, pnt2);
                    replaceIndex = 1;
                } else {
                    this.getVertexData(j2++, pnt1);
                    replaceIndex = 2;
                }
                vec.sub(pnt0, pnt1);
                tmpvec.sub(pnt1, pnt2);
                normal.cross(vec, tmpvec);
                normal.normalize();
                if (Double.isNaN(normal.x + normal.y + normal.z)) continue;
                tmpvec.set(0.0, 0.0, 0.0);
                this.getCrossValue(pnt0, pnt1, tmpvec);
                this.getCrossValue(pnt1, pnt2, tmpvec);
                this.getCrossValue(pnt2, pnt0, tmpvec);
                area = normal.dot(tmpvec);
                totalarea += area;
                this.centroid.x += (pnt0.x + pnt1.x + pnt2.x) * area;
                this.centroid.y += (pnt0.y + pnt1.y + pnt2.y) * area;
                this.centroid.z += (pnt0.z + pnt1.z + pnt2.z) * area;
            }
        }
        if (totalarea != 0.0) {
            area = 1.0 / (3.0 * totalarea);
            this.centroid.x *= area;
            this.centroid.y *= area;
            this.centroid.z *= area;
        }
    }

    @Override
    int getClassType() {
        return 3;
    }
}

