/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Context;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.VirtualUniverse;

class TransparencyAttributesRetained
extends NodeComponentRetained {
    static final int MODE_CHANGED = 1;
    static final int VALUE_CHANGED = 2;
    static final int SRC_BLEND_FUNCTION_CHANGED = 4;
    static final int DST_BLEND_FUNCTION_CHANGED = 8;
    int isDirty = 65535;
    int transparencyMode = 4;
    float transparency = 0.0f;
    int srcBlendFunction = 2;
    int dstBlendFunction = 3;

    TransparencyAttributesRetained() {
    }

    final void initTransparencyMode(int transparencyMode) {
        this.transparencyMode = transparencyMode;
    }

    final void setTransparencyMode(int transparencyMode) {
        this.initTransparencyMode(transparencyMode);
        this.sendMessage(1, new Integer(transparencyMode));
    }

    final int getTransparencyMode() {
        return this.transparencyMode;
    }

    final void initTransparency(float transparency) {
        this.transparency = transparency = Math.max(0.0f, Math.min(1.0f, transparency));
    }

    final void setTransparency(float transparency) {
        transparency = Math.max(0.0f, Math.min(1.0f, transparency));
        this.initTransparency(transparency);
        this.sendMessage(2, new Float(transparency));
    }

    final float getTransparency() {
        return this.transparency;
    }

    final void initSrcBlendFunction(int blendFunction) {
        this.srcBlendFunction = blendFunction;
    }

    final void setSrcBlendFunction(int blendFunction) {
        this.initSrcBlendFunction(blendFunction);
        this.sendMessage(4, new Integer(blendFunction));
    }

    final int getSrcBlendFunction() {
        return this.srcBlendFunction;
    }

    final void initDstBlendFunction(int blendFunction) {
        this.dstBlendFunction = blendFunction;
    }

    final void setDstBlendFunction(int blendFunction) {
        this.initDstBlendFunction(blendFunction);
        this.sendMessage(8, new Integer(blendFunction));
    }

    final int getDstBlendFunction() {
        return this.dstBlendFunction;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TransparencyAttributesRetained mirrorTa = new TransparencyAttributesRetained();
                mirrorTa.source = this.source;
                mirrorTa.set(this);
                this.mirror = mirrorTa;
            }
        } else {
            ((TransparencyAttributesRetained)this.mirror).set(this);
        }
    }

    static boolean useAlpha(TransparencyAttributesRetained ta) {
        return ta != null && ta.transparencyMode != 4 && ta.transparencyMode != 3;
    }

    void updateNative(Context ctx, float alpha, int geometryType, int polygonMode, boolean lineAA, boolean pointAA) {
        Pipeline.getPipeline().updateTransparencyAttributes(ctx, alpha, geometryType, polygonMode, lineAA, pointAA, this.transparencyMode, this.srcBlendFunction, this.dstBlendFunction);
    }

    @Override
    synchronized void initMirrorObject() {
        ((TransparencyAttributesRetained)this.mirror).set(this);
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        TransparencyAttributesRetained mirrorTa = (TransparencyAttributesRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorTa.transparencyMode = (Integer)value;
        } else if ((component & 2) != 0) {
            mirrorTa.transparency = ((Float)value).floatValue();
        } else if ((component & 4) != 0) {
            mirrorTa.srcBlendFunction = (Integer)value;
        } else if ((component & 8) != 0) {
            mirrorTa.dstBlendFunction = (Integer)value;
        }
    }

    boolean equivalent(TransparencyAttributesRetained tr) {
        return tr != null && tr.transparencyMode == this.transparencyMode && tr.transparency == this.transparency && tr.srcBlendFunction == this.srcBlendFunction && tr.dstBlendFunction == this.dstBlendFunction;
    }

    protected void set(TransparencyAttributesRetained transp) {
        super.set(transp);
        this.transparencyMode = transp.transparencyMode;
        this.transparency = transp.transparency;
        this.srcBlendFunction = transp.srcBlendFunction;
        this.dstBlendFunction = transp.dstBlendFunction;
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 12;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i2 = 0; i2 < univList.size(); ++i2) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 12;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        if (bit == 1 || bit == 3 || bit == 5) {
            this.setFrequencyChangeMask(bit, 1);
        }
    }
}

