/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CachedTargets;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.ObjectUpdate;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.SwitchState;
import org.jogamp.java3d.TargetsInterface;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroupData;
import org.jogamp.java3d.TransformGroupRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.VirtualUniverse;

class TransformStructure
extends J3dStructure
implements ObjectUpdate {
    private HashSet<TransformData> transformSet = new HashSet();
    private ArrayList objectList = new ArrayList();
    private ArrayList blUsers = new ArrayList();
    private UpdateTargets targets = new UpdateTargets();
    private ArrayList collisionObjectList = new ArrayList();
    private ArrayList<TransformGroupRetained> dirtyTransformGroups = new ArrayList();
    private ArrayList keySet = new ArrayList();
    private ArrayList<TransformGroupRetained> activeTraverseList = new ArrayList();
    private ArrayList<TransformGroupRetained> switchDirtyTgList = new ArrayList(1);
    private boolean lazyUpdate = false;
    private ArrayList switchChangedList = new ArrayList();
    private boolean inUpdateObjectList = false;

    TransformStructure(VirtualUniverse u) {
        super(u, 8192);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        this.targets.clearNodes();
        this.objectList.clear();
        this.blUsers.clear();
        this.inUpdateObjectList = false;
        Object object = this.universe.sceneGraphLock;
        synchronized (object) {
            J3dMessage m2;
            int i2;
            for (i2 = nMsg - 1; i2 >= 0; --i2) {
                m2 = messages[i2];
                if (m2.type != 3) continue;
                this.transformSet.add(new TransformData((TransformGroupRetained)m2.args[1], (Transform3D)m2.args[2]));
            }
            for (i2 = 0; i2 < nMsg; ++i2) {
                m2 = messages[i2];
                switch (m2.type) {
                    case 0: {
                        this.objectList.add(m2.args[0]);
                        if (m2.args[1] == null) break;
                        TargetsInterface ti = (TargetsInterface)m2.args[1];
                        ti.updateCachedTargets(0, (CachedTargets[])m2.args[2]);
                        break;
                    }
                    case 1: {
                        this.removeNodes(m2);
                        break;
                    }
                    case 27: {
                        this.processSwitchChanged(m2);
                        break;
                    }
                    case 24: {
                        this.objectList.add(m2.args[3]);
                        if (m2.args[4] == null) break;
                        TargetsInterface ti = (TargetsInterface)m2.args[4];
                        ti.updateCachedTargets(0, (CachedTargets[])m2.args[5]);
                        break;
                    }
                    case 17: {
                        this.objectList.add(m2.args[0]);
                        break;
                    }
                    case 16: {
                        this.objectList.add(m2.args[3]);
                        break;
                    }
                    case 26: {
                        this.objectList.add(m2.args[1]);
                        Object[] tiArr = (Object[])m2.args[2];
                        if (tiArr == null) break;
                        Object[] newCtArr = (Object[])m2.args[3];
                        for (int j2 = 0; j2 < tiArr.length; ++j2) {
                            TargetsInterface ti = (TargetsInterface)tiArr[j2];
                            ti.updateCachedTargets(0, (CachedTargets[])newCtArr[j2]);
                        }
                        break;
                    }
                    case 25: {
                        this.objectList.add(m2.args[0]);
                        break;
                    }
                    case 37: {
                        this.processBoundsAutoComputeChanged(m2);
                        break;
                    }
                    case 35: {
                        this.processRegionBoundChanged(m2);
                        break;
                    }
                    case 34: {
                        this.processCollisionBoundChanged(m2);
                    }
                }
                m2.decRefcount();
            }
            this.processCurrentLocalToVworld();
            if (this.objectList.size() > 0) {
                this.processGeometryAtomVwcBounds();
            }
            this.processVwcBounds();
        }
        this.objectList.clear();
        Arrays.fill(messages, 0, nMsg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processCurrentLocalToVworld() {
        this.lazyUpdate = false;
        int tSize = this.transformSet.size();
        int sSize = this.switchDirtyTgList.size();
        if (tSize <= 0 && sSize <= 0) {
            return;
        }
        if (tSize > 0) {
            for (TransformData lData : this.transformSet) {
                TransformGroupRetained tg = lData.getTransformGroupRetained();
                tg.currentTransform.set(lData.getTransform3D());
                TransformGroupRetained transformGroupRetained = tg;
                synchronized (transformGroupRetained) {
                    if (tg.perPathData != null) {
                        TransformGroupData data;
                        if (!tg.inSharedGroup) {
                            data = tg.perPathData[0];
                            if (!data.switchState.inSwitch) {
                                this.activeTraverseList.add(tg);
                                data.markedDirty = true;
                                data.switchDirty = false;
                            } else if (data.switchState.currentSwitchOn) {
                                this.activeTraverseList.add(tg);
                                data.switchDirty = false;
                                data.markedDirty = true;
                            } else {
                                data.switchDirty = true;
                                data.markedDirty = false;
                            }
                        } else {
                            int npaths = tg.perPathData.length;
                            boolean added = false;
                            for (int k2 = 0; k2 < npaths; ++k2) {
                                data = tg.perPathData[k2];
                                if (!data.switchState.inSwitch) {
                                    if (!added) {
                                        added = true;
                                        this.activeTraverseList.add(tg);
                                    }
                                    data.markedDirty = true;
                                    data.switchDirty = false;
                                    continue;
                                }
                                if (data.switchState.currentSwitchOn) {
                                    if (!added) {
                                        added = true;
                                        this.activeTraverseList.add(tg);
                                    }
                                    data.switchDirty = false;
                                    data.markedDirty = true;
                                    continue;
                                }
                                data.switchDirty = true;
                                data.markedDirty = false;
                            }
                        }
                    }
                }
            }
        }
        if (sSize > 0) {
            this.activeTraverseList.addAll(this.switchDirtyTgList);
            this.switchDirtyTgList.clear();
            this.lazyUpdate = true;
        }
        tSize = this.activeTraverseList.size();
        TransformGroupRetained[] tgs = this.activeTraverseList.toArray(new TransformGroupRetained[tSize]);
        if (tSize > 0) {
            this.sortTransformGroups(tSize, tgs);
            for (int i2 = 0; i2 < tSize; ++i2) {
                tgs[i2].processChildLocalToVworld(this.dirtyTransformGroups, this.keySet, this.targets, this.blUsers);
            }
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
        this.transformSet.clear();
        this.activeTraverseList.clear();
    }

    private void sortTransformGroups(int size, TransformGroupRetained[] tgs) {
        if (size < 7) {
            this.insertSort(size, tgs);
        } else {
            this.quicksort(0, size - 1, tgs);
        }
    }

    private void insertSort(int size, TransformGroupRetained[] tgs) {
        for (int i2 = 0; i2 < size; ++i2) {
            for (int j2 = i2; j2 > 0 && tgs[j2 - 1].maxTransformLevel > tgs[j2].maxTransformLevel; --j2) {
                TransformGroupRetained tmptg = tgs[j2];
                tgs[j2] = tgs[j2 - 1];
                tgs[j2 - 1] = tmptg;
            }
        }
    }

    private void quicksort(int l2, int r, TransformGroupRetained[] tgs) {
        int i2 = l2;
        int j2 = r;
        double k2 = tgs[(l2 + r) / 2].maxTransformLevel;
        while (true) {
            if ((double)tgs[i2].maxTransformLevel < k2) {
                ++i2;
                continue;
            }
            while (k2 < (double)tgs[j2].maxTransformLevel) {
                --j2;
            }
            if (i2 <= j2) {
                TransformGroupRetained tmptg = tgs[i2];
                tgs[i2] = tgs[j2];
                tgs[j2] = tmptg;
                ++i2;
                --j2;
            }
            if (i2 > j2) break;
        }
        if (l2 < j2) {
            this.quicksort(l2, j2, tgs);
        }
        if (l2 < r) {
            this.quicksort(i2, r, tgs);
        }
    }

    @Override
    public void updateObject() {
        this.processLastLocalToVworld();
        this.processLastSwitchOn();
    }

    void processLastSwitchOn() {
        int size = this.switchChangedList.size();
        if (size > 0) {
            for (int i2 = 0; i2 < size; ++i2) {
                SwitchState switchState = (SwitchState)this.switchChangedList.get(i2);
                switchState.updateLastSwitchOn();
            }
            this.switchChangedList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processLastLocalToVworld() {
        int dTGSize = this.dirtyTransformGroups.size();
        int k2 = 0;
        for (int i2 = 0; i2 < dTGSize; ++i2) {
            TransformGroupRetained tg;
            TransformGroupRetained transformGroupRetained = tg = this.dirtyTransformGroups.get(i2);
            synchronized (transformGroupRetained) {
                if (tg.childLocalToVworld != null) {
                    if (tg.inSharedGroup) {
                        int j2;
                        HashKey key = (HashKey)this.keySet.get(k2++);
                        for (j2 = 0; j2 < tg.localToVworldKeys.length && !tg.localToVworldKeys[j2].equals((Object)key); ++j2) {
                        }
                        if (j2 < tg.localToVworldKeys.length) {
                            tg.childLocalToVworldIndex[j2][0] = tg.childLocalToVworldIndex[j2][1];
                        }
                    } else {
                        tg.childLocalToVworldIndex[0][0] = tg.childLocalToVworldIndex[0][1];
                    }
                }
                continue;
            }
        }
        this.dirtyTransformGroups.clear();
        this.keySet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processGeometryAtomVwcBounds() {
        Shape3DRetained ms;
        GeometryAtom ga;
        Object object;
        int j2;
        Object[] nodes;
        int i2;
        int oSize = this.objectList.size();
        for (i2 = 0; i2 < oSize; ++i2) {
            nodes = (Object[])this.objectList.get(i2);
            for (j2 = 0; j2 < nodes.length; ++j2) {
                object = nodes[j2];
                synchronized (object) {
                    if (nodes[j2] instanceof GeometryAtom) {
                        ga = (GeometryAtom)nodes[j2];
                        ms = ga.source;
                        Bounds bounds = ms.bounds;
                        synchronized (bounds) {
                            ms.vwcBounds.transform(ms.bounds, ms.getCurrentLocalToVworld(0));
                        }
                        if (ms.collisionBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                        ga.centroidIsDirty = true;
                    } else if (nodes[j2] instanceof GroupRetained) {
                        GroupRetained g2 = (GroupRetained)nodes[j2];
                        Bounds bound = g2.sourceNode.collisionBound != null ? g2.sourceNode.collisionBound : g2.sourceNode.getEffectiveBounds();
                        g2.collisionVwcBounds.transform(bound, g2.getCurrentLocalToVworld());
                    }
                    continue;
                }
            }
        }
        for (i2 = 0; i2 < this.collisionObjectList.size(); ++i2) {
            nodes = (Object[])this.collisionObjectList.get(i2);
            for (j2 = 0; j2 < nodes.length; ++j2) {
                object = nodes[j2];
                synchronized (object) {
                    if (nodes[j2] instanceof GeometryAtom) {
                        ga = (GeometryAtom)nodes[j2];
                        ms = ga.source;
                        if (ms.collisionVwcBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                    }
                    continue;
                }
            }
        }
        this.collisionObjectList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processVwcBounds() {
        Shape3DRetained ms;
        GeometryAtom ga;
        Object object;
        int j2;
        Object[] nodes;
        int i2;
        Object[] nodesArr;
        int size;
        UnorderList arrList = this.targets.targetList[0];
        if (arrList != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (i2 = 0; i2 < size; ++i2) {
                nodes = (Object[])nodesArr[i2];
                for (j2 = 0; j2 < nodes.length; ++j2) {
                    object = nodes[j2];
                    synchronized (object) {
                        ga = (GeometryAtom)nodes[j2];
                        ms = ga.source;
                        Bounds bounds = ms.bounds;
                        synchronized (bounds) {
                            ms.vwcBounds.transform(ms.bounds, ms.getCurrentLocalToVworld(0));
                        }
                        if (ms.collisionBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                        ga.centroidIsDirty = true;
                        continue;
                    }
                }
            }
        }
        if ((arrList = this.targets.targetList[6]) != null) {
            size = arrList.size();
            nodesArr = arrList.toArray(false);
            for (i2 = 0; i2 < size; ++i2) {
                nodes = (Object[])nodesArr[i2];
                for (j2 = 0; j2 < nodes.length; ++j2) {
                    GroupRetained g2 = (GroupRetained)nodes[j2];
                    Bounds bound = g2.sourceNode.collisionBound != null ? g2.sourceNode.collisionBound : g2.sourceNode.getEffectiveBounds();
                    g2.collisionVwcBounds.transform(bound, g2.getCurrentLocalToVworld());
                }
            }
        }
        for (i2 = 0; i2 < this.collisionObjectList.size(); ++i2) {
            nodes = (Object[])this.collisionObjectList.get(i2);
            for (j2 = 0; j2 < nodes.length; ++j2) {
                object = nodes[j2];
                synchronized (object) {
                    if (nodes[j2] instanceof GeometryAtom) {
                        ga = (GeometryAtom)nodes[j2];
                        ms = ga.source;
                        if (ms.collisionVwcBound != null) {
                            ms.collisionVwcBound.transform(ms.collisionBound, ms.getCurrentLocalToVworld(0));
                        }
                    }
                    continue;
                }
            }
        }
        this.collisionObjectList.clear();
    }

    void processRegionBoundChanged(J3dMessage m2) {
        this.processBoundsChanged((Object[])m2.args[0], (Bounds)m2.args[1]);
    }

    void processBoundsChanged(Object[] gaArray, Bounds updateBounds) {
        for (int i2 = 0; i2 < gaArray.length; ++i2) {
            GeometryAtom ga = (GeometryAtom)gaArray[i2];
            Shape3DRetained ms = ga.source;
            ms.bounds = updateBounds;
            if (ms.collisionBound != null) continue;
            ms.collisionVwcBound = ms.vwcBounds;
        }
        this.objectList.add(gaArray);
    }

    void processCollisionBoundChanged(J3dMessage m2) {
        Bounds collisionBound = (Bounds)m2.args[1];
        if (m2.args[0] instanceof GroupRetained) {
            GroupRetained g2 = (GroupRetained)m2.args[0];
            if (g2.mirrorGroup != null) {
                this.objectList.add(g2.mirrorGroup.toArray());
            }
        } else {
            Object[] gaArray = (Object[])m2.args[0];
            for (int i2 = 0; i2 < gaArray.length; ++i2) {
                GeometryAtom ga = (GeometryAtom)gaArray[i2];
                Shape3DRetained ms = ga.source;
                ms.collisionBound = collisionBound;
                ms.collisionVwcBound = ms.collisionBound != null ? (Bounds)ms.collisionBound.clone() : ms.vwcBounds;
            }
            this.collisionObjectList.add(gaArray);
        }
    }

    void processBoundsAutoComputeChanged(J3dMessage m2) {
        this.processBoundsChanged((Object[])m2.args[0], (Bounds)m2.args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSwitchChanged(J3dMessage m2) {
        ArrayList switchList = (ArrayList)m2.args[2];
        int size = switchList.size();
        if (size > 0) {
            for (int j2 = 0; j2 < size; ++j2) {
                SwitchState switchState = (SwitchState)switchList.get(j2);
                switchState.updateCurrentSwitchOn();
            }
            UpdateTargets targets = (UpdateTargets)m2.args[0];
            UnorderList arrList = targets.targetList[6];
            if (arrList != null) {
                Object[] nodesArr = arrList.toArray(false);
                int aSize = arrList.size();
                for (int j3 = 0; j3 < aSize; ++j3) {
                    Object[] nodes = (Object[])nodesArr[j3];
                    for (int i2 = 0; i2 < nodes.length; ++i2) {
                        TransformGroupRetained tg;
                        boolean added = false;
                        TransformGroupRetained transformGroupRetained = tg = (TransformGroupRetained)nodes[i2];
                        synchronized (transformGroupRetained) {
                            if (tg.perPathData != null) {
                                for (TransformGroupData data : tg.perPathData) {
                                    if (!data.switchState.currentSwitchOn || !data.switchDirty) continue;
                                    if (!added) {
                                        this.switchDirtyTgList.add(tg);
                                        added = true;
                                    }
                                    data.switchDirty = false;
                                    data.markedDirty = true;
                                }
                            }
                            continue;
                        }
                    }
                }
            }
            this.switchChangedList.addAll(switchList);
            if (!this.inUpdateObjectList) {
                VirtualUniverse.mc.addMirrorObject(this);
                this.inUpdateObjectList = true;
            }
        }
    }

    UpdateTargets getTargetList() {
        return this.targets;
    }

    ArrayList getBlUsers() {
        return this.blUsers;
    }

    boolean getLazyUpdate() {
        return this.lazyUpdate;
    }

    @Override
    void removeNodes(J3dMessage m2) {
        if (m2.args[1] != null) {
            TargetsInterface ti = (TargetsInterface)m2.args[1];
            ti.updateCachedTargets(0, (CachedTargets[])m2.args[2]);
        }
    }

    @Override
    void cleanup() {
    }

    private class TransformData {
        private TransformGroupRetained transformGroupRetained;
        private Transform3D transform3D;

        TransformData(TransformGroupRetained tgr, Transform3D t3d) {
            this.transformGroupRetained = tgr;
            this.transform3D = t3d;
        }

        public int hashCode() {
            return this.transformGroupRetained.hashCode();
        }

        public boolean equals(Object o2) {
            if (!(o2 instanceof TransformData)) {
                return false;
            }
            return this.transformGroupRetained.equals(((TransformData)o2).getTransformGroupRetained());
        }

        TransformGroupRetained getTransformGroupRetained() {
            return this.transformGroupRetained;
        }

        Transform3D getTransform3D() {
            return this.transform3D;
        }
    }
}

