/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.Iterator;
import org.jogamp.java3d.Alpha;
import org.jogamp.java3d.Interpolator;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeReferenceTable;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TransformGroup;
import org.jogamp.java3d.WakeupCriterion;
import org.jogamp.java3d.WakeupOnElapsedFrames;

public abstract class TransformInterpolator
extends Interpolator {
    protected TransformGroup target = null;
    protected Transform3D axis = new Transform3D();
    protected Transform3D axisInverse = new Transform3D();
    private Transform3D currentTransform = new Transform3D();
    private float prevAlphaValue = Float.NaN;
    private WakeupCriterion passiveWakeupCriterion = new WakeupOnElapsedFrames(0, true);

    public TransformInterpolator() {
    }

    public TransformInterpolator(Alpha alpha, TransformGroup target) {
        super(alpha);
        this.target = target;
        this.axis.setIdentity();
        this.axisInverse.setIdentity();
    }

    public TransformInterpolator(Alpha alpha, TransformGroup target, Transform3D axisOfTransform) {
        super(alpha);
        this.target = target;
        this.axis.set(axisOfTransform);
        this.axisInverse.invert(this.axis);
    }

    public void setTarget(TransformGroup target) {
        this.target = target;
    }

    public TransformGroup getTarget() {
        return this.target;
    }

    public void setTransformAxis(Transform3D axisOfTransform) {
        this.axis.set(axisOfTransform);
        this.axisInverse.invert(this.axis);
    }

    public Transform3D getTransformAxis() {
        return new Transform3D(this.axis);
    }

    public abstract void computeTransform(float var1, Transform3D var2);

    @Override
    public void processStimulus(Iterator<WakeupCriterion> criteria) {
        WakeupCriterion criterion = this.passiveWakeupCriterion;
        if (this.alpha != null) {
            float value = this.alpha.value();
            if (value != this.prevAlphaValue) {
                this.computeTransform(value, this.currentTransform);
                this.target.setTransform(this.currentTransform);
                this.prevAlphaValue = value;
            }
            if (!this.alpha.finished() && !this.alpha.isPaused()) {
                criterion = this.defaultWakeupCriterion;
            }
        }
        this.wakeupOn(criterion);
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        TransformInterpolator ti = (TransformInterpolator)originalNode;
        this.setTransformAxis(ti.getTransformAxis());
        this.setTarget(ti.getTarget());
    }

    @Override
    public void updateNodeReferences(NodeReferenceTable referenceTable) {
        super.updateNodeReferences(referenceTable);
        TransformGroup n2 = this.getTarget();
        if (n2 != null) {
            this.setTarget((TransformGroup)referenceTable.getNewObjectReference(n2));
        }
    }
}

