/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponent;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.TexCoordGeneration;
import org.jogamp.java3d.TexCoordGenerationRetained;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.TextureAttributes;
import org.jogamp.java3d.TextureAttributesRetained;
import org.jogamp.java3d.TextureRetained;
import org.jogamp.java3d.VirtualUniverse;

class TextureUnitStateRetained
extends NodeComponentRetained {
    static final int TEXTURE_CHANGED = 1;
    static final int TEXTURE_ATTRS_CHANGED = 2;
    static final int TEXCOORD_GEN_CHANGED = 4;
    static final int ALL_STATE_CHANGED = 8;
    TextureRetained texture = null;
    TextureAttributesRetained texAttrs = null;
    TexCoordGenerationRetained texGen = null;

    TextureUnitStateRetained() {
    }

    final void setTextureUnitStateComponent(NodeComponent comp, NodeComponentRetained thisComp, int messageOp) {
        if (this.source.isLive()) {
            if (comp == null && thisComp == null || comp != null && comp.retained == thisComp) {
                return;
            }
            if (thisComp != null) {
                thisComp.clearLive(this.refCount);
                thisComp.removeMirrorUsers(this);
            }
            if (comp != null) {
                ((NodeComponentRetained)comp.retained).setLive(this.inBackgroundGroup, this.refCount);
                ((NodeComponentRetained)comp.retained).copyMirrorUsers(this);
            }
            if (messageOp != -1) {
                this.sendMessage(messageOp, comp == null ? null : ((NodeComponentRetained)comp.retained).mirror);
            }
        }
    }

    final void initTextureUnitState(Texture texture, TextureAttributes texAttrs, TexCoordGeneration texGen) {
        this.initTexture(texture);
        this.initTextureAttributes(texAttrs);
        this.initTexCoordGeneration(texGen);
    }

    final void setTextureUnitState(Texture texture, TextureAttributes texAttrs, TexCoordGeneration texGen) {
        this.setTextureUnitStateComponent(texture, this.texture, -1);
        this.setTextureUnitStateComponent(texAttrs, this.texAttrs, -1);
        this.setTextureUnitStateComponent(texGen, this.texGen, -1);
        Object[] args = new Object[]{texture == null ? null : ((TextureRetained)texture.retained).mirror, texAttrs == null ? null : ((TextureAttributesRetained)texAttrs.retained).mirror, texGen == null ? null : ((TexCoordGenerationRetained)texGen.retained).mirror};
        this.sendMessage(8, args);
        this.initTextureUnitState(texture, texAttrs, texGen);
    }

    final void initTexture(Texture texture) {
        this.texture = texture == null ? null : (TextureRetained)texture.retained;
    }

    final void setTexture(Texture texture) {
        this.setTextureUnitStateComponent(texture, this.texture, 1);
        this.initTexture(texture);
    }

    final void initTextureAttributes(TextureAttributes texAttrs) {
        this.texAttrs = texAttrs == null ? null : (TextureAttributesRetained)texAttrs.retained;
    }

    final void setTextureAttributes(TextureAttributes texAttrs) {
        this.setTextureUnitStateComponent(texAttrs, this.texAttrs, 2);
        this.initTextureAttributes(texAttrs);
    }

    final void initTexCoordGeneration(TexCoordGeneration texGen) {
        this.texGen = texGen == null ? null : (TexCoordGenerationRetained)texGen.retained;
    }

    final void setTexCoordGeneration(TexCoordGeneration texGen) {
        this.setTextureUnitStateComponent(texGen, this.texGen, 4);
        this.initTexCoordGeneration(texGen);
    }

    Texture getTexture() {
        return this.texture == null ? null : (Texture)this.texture.source;
    }

    TextureAttributes getTextureAttributes() {
        return this.texAttrs == null ? null : (TextureAttributes)this.texAttrs.source;
    }

    TexCoordGeneration getTexCoordGeneration() {
        return this.texGen == null ? null : (TexCoordGeneration)this.texGen.source;
    }

    void updateNative(int unitIndex, Canvas3D cv, boolean reload, boolean simulate) {
        boolean dirty;
        int index = unitIndex;
        if (index < 0) {
            index = 0;
        }
        boolean bl = dirty = (cv.canvasDirty & 0xC00) != 0;
        if (this.texture == null) {
            if (cv.texUnitState[index].texture != null) {
                cv.resetTexture(cv.ctx, unitIndex);
                cv.texUnitState[index].texture = null;
            }
            cv.canvasDirty &= 0xFFFFF7FF;
            return;
        }
        Pipeline.getPipeline().updateTextureUnitState(cv.ctx, unitIndex, true);
        if (reload || dirty || cv.texUnitState[index].texture != this.texture) {
            this.texture.updateNative(cv);
            cv.texUnitState[index].texture = this.texture;
        }
        if (this.texAttrs == null) {
            if (reload || dirty || cv.texUnitState[index].texAttrs != null) {
                cv.resetTextureAttributes(cv.ctx);
                cv.setBlendFunc(cv.ctx, 1, 0);
                cv.texUnitState[index].texAttrs = null;
            }
        } else {
            TextureAttributesRetained mTexAttrs = this.texAttrs.mirror == null ? this.texAttrs : (TextureAttributesRetained)this.texAttrs.mirror;
            if (mTexAttrs.mirrorCompDirty) {
                cv.texUnitState[index].texAttrs = null;
                mTexAttrs.mirrorCompDirty = false;
            }
            if (reload || dirty || cv.texUnitState[index].texAttrs != mTexAttrs) {
                this.texAttrs.updateNative(cv, simulate, this.texture.format);
                cv.texUnitState[index].texAttrs = mTexAttrs;
            }
        }
        if (this.texGen == null) {
            if (reload || dirty || cv.texUnitState[index].texGen != null) {
                cv.resetTexCoordGeneration(cv.ctx);
                cv.texUnitState[index].texGen = null;
            }
        } else {
            TexCoordGenerationRetained mTexGen = this.texGen.mirror == null ? this.texGen : (TexCoordGenerationRetained)this.texGen.mirror;
            if (mTexGen.mirrorCompDirty) {
                cv.texUnitState[index].texGen = null;
                mTexGen.mirrorCompDirty = false;
            }
            if (reload || dirty || cv.texUnitState[index].texGen != mTexGen) {
                this.texGen.updateNative(cv);
                cv.texUnitState[index].texGen = mTexGen;
            }
        }
        cv.canvasDirty &= 0xFFFFF7FF;
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            TextureUnitStateRetained mirrorTus = new TextureUnitStateRetained();
            this.mirror = mirrorTus;
        }
        this.mirror.source = this.source;
        this.initMirrorObject();
    }

    @Override
    synchronized void initMirrorObject() {
        TextureUnitStateRetained mirrorTus = (TextureUnitStateRetained)this.mirror;
        mirrorTus.texture = this.texture != null ? (TextureRetained)this.texture.mirror : null;
        mirrorTus.texAttrs = this.texAttrs != null ? (TextureAttributesRetained)this.texAttrs.mirror : null;
        mirrorTus.texGen = this.texGen != null ? (TexCoordGenerationRetained)this.texGen.mirror : null;
    }

    @Override
    synchronized void updateMirrorObject(int component, Object value) {
        TextureUnitStateRetained mirrorTus = (TextureUnitStateRetained)this.mirror;
        if ((component & 1) != 0) {
            mirrorTus.texture = (TextureRetained)value;
        } else if ((component & 2) != 0) {
            mirrorTus.texAttrs = (TextureAttributesRetained)value;
        } else if ((component & 4) != 0) {
            mirrorTus.texGen = (TexCoordGenerationRetained)value;
        } else if ((component & 8) != 0) {
            Object[] args = (Object[])value;
            mirrorTus.texture = (TextureRetained)args[0];
            mirrorTus.texAttrs = (TextureAttributesRetained)args[1];
            mirrorTus.texGen = (TexCoordGenerationRetained)args[2];
        }
    }

    boolean equivalent(TextureUnitStateRetained tr) {
        if (tr == null) {
            return false;
        }
        if (this.changedFrequent != 0 || tr.changedFrequent != 0) {
            return this.mirror == tr;
        }
        if (this.texture != tr.texture) {
            return false;
        }
        if (this.texAttrs != null && !this.texAttrs.equivalent(tr.texAttrs)) {
            return false;
        }
        return this.texGen == null || this.texGen.equivalent(tr.texGen);
    }

    @Override
    protected Object clone() {
        TextureUnitStateRetained tr = (TextureUnitStateRetained)super.clone();
        if (this.texAttrs != null) {
            tr.texAttrs = (TextureAttributesRetained)this.texAttrs.clone();
        }
        if (this.texGen != null) {
            tr.texGen = (TexCoordGenerationRetained)this.texGen.clone();
        }
        return tr;
    }

    protected void set(TextureUnitStateRetained tr) {
        super.set(tr);
        this.texture = tr.texture;
        if (tr.texAttrs == null) {
            this.texAttrs = null;
        } else if (this.texAttrs == null) {
            this.texAttrs = (TextureAttributesRetained)tr.texAttrs.clone();
        } else {
            this.texAttrs.set(tr.texAttrs);
        }
        if (tr.texGen == null) {
            this.texGen = null;
        } else if (this.texGen == null) {
            this.texGen = (TexCoordGenerationRetained)tr.texGen.clone();
        } else {
            this.texGen.set(tr.texGen);
        }
    }

    protected void set(TextureRetained texture, TextureAttributesRetained texAttrs, TexCoordGenerationRetained texGen) {
        this.texture = texture;
        this.texAttrs = texAttrs;
        this.texGen = texGen;
    }

    @Override
    synchronized void addAMirrorUser(Shape3DRetained shape) {
        super.addAMirrorUser(shape);
        if (this.texture != null) {
            this.texture.addAMirrorUser(shape);
        }
        if (this.texAttrs != null) {
            this.texAttrs.addAMirrorUser(shape);
        }
        if (this.texGen != null) {
            this.texGen.addAMirrorUser(shape);
        }
    }

    @Override
    synchronized void removeAMirrorUser(Shape3DRetained shape) {
        super.removeAMirrorUser(shape);
        if (this.texture != null) {
            this.texture.removeAMirrorUser(shape);
        }
        if (this.texAttrs != null) {
            this.texAttrs.removeAMirrorUser(shape);
        }
        if (this.texGen != null) {
            this.texGen.removeAMirrorUser(shape);
        }
    }

    @Override
    synchronized void removeMirrorUsers(NodeComponentRetained node) {
        super.removeMirrorUsers(node);
        if (this.texture != null) {
            this.texture.removeMirrorUsers(node);
        }
        if (this.texAttrs != null) {
            this.texAttrs.removeMirrorUsers(node);
        }
        if (this.texGen != null) {
            this.texGen.removeMirrorUsers(node);
        }
    }

    @Override
    synchronized void copyMirrorUsers(NodeComponentRetained node) {
        super.copyMirrorUsers(node);
        if (this.texture != null) {
            this.texture.copyMirrorUsers(node);
        }
        if (this.texAttrs != null) {
            this.texAttrs.copyMirrorUsers(node);
        }
        if (this.texGen != null) {
            this.texGen.copyMirrorUsers(node);
        }
    }

    @Override
    void setLive(boolean backgroundGroup, int refCount) {
        if (this.texture != null) {
            this.texture.setLive(backgroundGroup, refCount);
        }
        if (this.texAttrs != null) {
            this.texAttrs.setLive(backgroundGroup, refCount);
        }
        if (this.texGen != null) {
            this.texGen.setLive(backgroundGroup, refCount);
        }
        super.doSetLive(backgroundGroup, refCount);
        super.markAsLive();
    }

    @Override
    void clearLive(int refCount) {
        super.clearLive(refCount);
        if (this.texture != null) {
            this.texture.clearLive(refCount);
        }
        if (this.texAttrs != null) {
            this.texAttrs.clearLive(refCount);
        }
        if (this.texGen != null) {
            this.texGen.clearLive(refCount);
        }
    }

    @Override
    boolean isStatic() {
        return !(!this.source.capabilityBitsEmpty() || this.texture != null && !this.texture.isStatic() || this.texAttrs != null && !this.texAttrs.isStatic() || this.texGen != null && !this.texGen.isStatic());
    }

    @Override
    void compile(CompileState compState) {
        this.setCompiled();
        if (this.texture != null) {
            this.texture.compile(compState);
        }
        if (this.texAttrs != null) {
            this.texAttrs.compile(compState);
        }
        if (this.texGen != null) {
            this.texGen.compile(compState);
        }
    }

    boolean equals(TextureUnitStateRetained ts) {
        return ts == this || ts != null && (this.texture == ts.texture || this.texture != null && this.texture.equals(ts.texture)) && (this.texAttrs == ts.texAttrs || this.texAttrs != null && this.texAttrs.equals(ts.texAttrs)) && (this.texGen == ts.texGen || this.texGen != null && this.texGen.equals(ts.texGen));
    }

    @Override
    void setInImmCtx(boolean flag) {
        super.setInImmCtx(flag);
        if (this.texture != null) {
            this.texture.setInImmCtx(flag);
        }
        if (this.texAttrs != null) {
            this.texAttrs.setInImmCtx(flag);
        }
        if (this.texGen != null) {
            this.texGen.setInImmCtx(flag);
        }
    }

    @Override
    boolean getInImmCtx() {
        return super.getInImmCtx() || this.texture != null && this.texture.getInImmCtx() || this.texAttrs != null && this.texAttrs.getInImmCtx() || this.texGen != null && this.texGen.getInImmCtx();
    }

    boolean isLive() {
        return this.source.isLive() || this.texture != null && this.texture.source.isLive() || this.texAttrs != null && this.texAttrs.source.isLive() || this.texGen != null && this.texGen.source.isLive();
    }

    final void sendMessage(int attrMask, Object attr) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 47;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr;
        createMessage.args[3] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i2 = 0; i2 < univList.size(); ++i2) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 47;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    boolean isTextureEnabled() {
        return this.texture != null && this.texture.enable;
    }

    @Override
    void handleFrequencyChange(int bit) {
        switch (bit) {
            case 1: {
                this.setFrequencyChangeMask(bit, bit);
            }
        }
    }
}

