/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NodeComponentRetained;
import org.jogamp.java3d.Pipeline;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Texture;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Color4f;

class TextureAttributesRetained
extends NodeComponentRetained {
    static final int TRANSFORM_CHANGED = 1;
    static final int MODE_CHANGED = 2;
    static final int COLOR_CHANGED = 4;
    static final int CORRECTION_CHANGED = 8;
    static final int TEXTURE_COLOR_TABLE_CHANGED = 16;
    static final int COMBINE_RGB_MODE_CHANGED = 32;
    static final int COMBINE_ALPHA_MODE_CHANGED = 64;
    static final int COMBINE_RGB_SRC_CHANGED = 128;
    static final int COMBINE_ALPHA_SRC_CHANGED = 256;
    static final int COMBINE_RGB_FCN_CHANGED = 512;
    static final int COMBINE_ALPHA_FCN_CHANGED = 1024;
    static final int COMBINE_RGB_SCALE_CHANGED = 2048;
    static final int COMBINE_ALPHA_SCALE_CHANGED = 4096;
    static final Integer[] enums = new Integer[10];
    Transform3D transform = new Transform3D();
    int textureMode = 5;
    Color4f textureBlendColor = new Color4f(0.0f, 0.0f, 0.0f, 0.0f);
    int[] textureColorTable = null;
    int numTextureColorTableComponents = 0;
    int textureColorTableSize = 0;
    int combineRgbMode = 1;
    int combineAlphaMode = 1;
    int[] combineRgbSrc = null;
    int[] combineAlphaSrc = null;
    int[] combineRgbFcn = null;
    int[] combineAlphaFcn = null;
    int combineRgbScale = 1;
    int combineAlphaScale = 1;
    int perspCorrectionMode = 1;
    boolean mirrorCompDirty = false;

    TextureAttributesRetained() {
    }

    final void initCombineMode(TextureAttributesRetained tr) {
        tr.combineRgbSrc = new int[3];
        tr.combineAlphaSrc = new int[3];
        tr.combineRgbFcn = new int[3];
        tr.combineAlphaFcn = new int[3];
        tr.combineRgbSrc[0] = 1;
        tr.combineRgbSrc[1] = 3;
        tr.combineRgbSrc[2] = 2;
        tr.combineAlphaSrc[0] = 1;
        tr.combineAlphaSrc[1] = 3;
        tr.combineAlphaSrc[2] = 2;
        tr.combineRgbFcn[0] = 0;
        tr.combineRgbFcn[1] = 0;
        tr.combineRgbFcn[2] = 0;
        tr.combineAlphaFcn[0] = 2;
        tr.combineAlphaFcn[1] = 2;
        tr.combineAlphaFcn[2] = 2;
    }

    final void initTextureMode(int textureMode) {
        this.textureMode = textureMode;
        if (textureMode == 6 && this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
    }

    final void setTextureMode(int textureMode) {
        this.initTextureMode(textureMode);
        this.sendMessage(2, enums[textureMode], null);
    }

    final int getTextureMode() {
        return this.textureMode;
    }

    final void initTextureBlendColor(Color4f textureBlendColor) {
        this.textureBlendColor.set(textureBlendColor);
    }

    final void setTextureBlendColor(Color4f textureBlendColor) {
        this.textureBlendColor.set(textureBlendColor);
        this.sendMessage(4, new Color4f(textureBlendColor), null);
    }

    final void initTextureBlendColor(float r, float g2, float b2, float a2) {
        this.textureBlendColor.set(r, g2, b2, a2);
    }

    final void setTextureBlendColor(float r, float g2, float b2, float a2) {
        this.textureBlendColor.set(r, g2, b2, a2);
        this.sendMessage(4, new Color4f(r, g2, b2, a2), null);
    }

    final void getTextureBlendColor(Color4f textureBlendColor) {
        textureBlendColor.set(this.textureBlendColor);
    }

    final void initTextureTransform(Transform3D transform) {
        this.transform.set(transform);
    }

    final void setTextureTransform(Transform3D transform) {
        this.transform.set(transform);
        this.sendMessage(1, new Transform3D(transform), null);
    }

    final void getTextureTransform(Transform3D transform) {
        transform.set(this.transform);
    }

    final void initPerspectiveCorrectionMode(int mode) {
        this.perspCorrectionMode = mode;
    }

    final void setPerspectiveCorrectionMode(int mode) {
        this.perspCorrectionMode = mode;
        this.sendMessage(8, enums[mode], null);
    }

    final int getPerspectiveCorrectionMode() {
        return this.perspCorrectionMode;
    }

    final void setTextureColorTable(int[][] table) {
        this.initTextureColorTable(table);
        if (table == null) {
            this.sendMessage(16, null, null);
        } else {
            int[] ctable = new int[this.textureColorTableSize * this.numTextureColorTableComponents];
            System.arraycopy(this.textureColorTable, 0, ctable, 0, this.textureColorTable.length);
            Object[] args = new Object[]{new Integer(this.numTextureColorTableComponents), new Integer(this.textureColorTableSize), ctable};
            this.sendMessage(16, args, null);
        }
    }

    final void initTextureColorTable(int[][] table) {
        this.numTextureColorTableComponents = 0;
        this.textureColorTableSize = 0;
        if (table == null) {
            this.textureColorTable = null;
            return;
        }
        if (table.length < 3 || table.length > 4) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes13"));
        }
        if (Texture.getPowerOf2(table[0].length) == -1) {
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes14"));
        }
        for (int i2 = 1; i2 < table.length; ++i2) {
            if (table[i2].length == table[0].length) continue;
            throw new IllegalArgumentException(J3dI18N.getString("TextureAttributes15"));
        }
        this.numTextureColorTableComponents = table.length;
        this.textureColorTableSize = table[0].length;
        if (this.textureColorTable == null || this.textureColorTable.length != this.numTextureColorTableComponents * this.textureColorTableSize) {
            this.textureColorTable = new int[this.numTextureColorTableComponents * this.textureColorTableSize];
        }
        int k2 = 0;
        for (int i3 = 0; i3 < this.textureColorTableSize; ++i3) {
            for (int j2 = 0; j2 < this.numTextureColorTableComponents; ++j2) {
                this.textureColorTable[k2++] = table[j2][i3];
            }
        }
    }

    final void getTextureColorTable(int[][] table) {
        if (this.textureColorTable == null) {
            return;
        }
        int k2 = 0;
        for (int i2 = 0; i2 < this.textureColorTableSize; ++i2) {
            for (int j2 = 0; j2 < this.numTextureColorTableComponents; ++j2) {
                table[j2][i2] = this.textureColorTable[k2++];
            }
        }
    }

    final int getNumTextureColorTableComponents() {
        return this.numTextureColorTableComponents;
    }

    final int getTextureColorTableSize() {
        return this.textureColorTableSize;
    }

    final void initCombineRgbMode(int mode) {
        this.combineRgbMode = mode;
    }

    final void setCombineRgbMode(int mode) {
        this.initCombineRgbMode(mode);
        this.sendMessage(32, enums[mode], null);
    }

    final int getCombineRgbMode() {
        return this.combineRgbMode;
    }

    final void initCombineAlphaMode(int mode) {
        this.combineAlphaMode = mode;
    }

    final void setCombineAlphaMode(int mode) {
        this.initCombineAlphaMode(mode);
        this.sendMessage(64, enums[mode], null);
    }

    final int getCombineAlphaMode() {
        return this.combineAlphaMode;
    }

    final void initCombineRgbSource(int index, int src) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineRgbSrc[index] = src;
    }

    final void setCombineRgbSource(int index, int src) {
        this.initCombineRgbSource(index, src);
        this.sendMessage(128, enums[index], enums[src]);
    }

    final int getCombineRgbSource(int index) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineRgbSrc[index];
    }

    final void initCombineAlphaSource(int index, int src) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineAlphaSrc[index] = src;
    }

    final void setCombineAlphaSource(int index, int src) {
        this.initCombineAlphaSource(index, src);
        this.sendMessage(256, enums[index], enums[src]);
    }

    final int getCombineAlphaSource(int index) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineAlphaSrc[index];
    }

    final void initCombineRgbFunction(int index, int fcn) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineRgbFcn[index] = fcn;
    }

    final void setCombineRgbFunction(int index, int fcn) {
        this.initCombineRgbFunction(index, fcn);
        this.sendMessage(512, enums[index], enums[fcn]);
    }

    final int getCombineRgbFunction(int index) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineRgbFcn[index];
    }

    final void initCombineAlphaFunction(int index, int fcn) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        this.combineAlphaFcn[index] = fcn;
    }

    final void setCombineAlphaFunction(int index, int fcn) {
        this.initCombineAlphaFunction(index, fcn);
        this.sendMessage(1024, enums[index], enums[fcn]);
    }

    final int getCombineAlphaFunction(int index) {
        if (this.combineRgbSrc == null) {
            this.initCombineMode(this);
        }
        return this.combineAlphaFcn[index];
    }

    final void initCombineRgbScale(int scale) {
        this.combineRgbScale = scale;
    }

    final void setCombineRgbScale(int scale) {
        this.initCombineRgbScale(scale);
        this.sendMessage(2048, enums[scale], null);
    }

    final int getCombineRgbScale() {
        return this.combineRgbScale;
    }

    final void initCombineAlphaScale(int scale) {
        this.combineAlphaScale = scale;
    }

    final void setCombineAlphaScale(int scale) {
        this.initCombineAlphaScale(scale);
        this.sendMessage(4096, enums[scale], null);
    }

    final int getCombineAlphaScale() {
        return this.combineAlphaScale;
    }

    void updateNative(Canvas3D cv, boolean simulate, int textureFormat) {
        boolean isIdentity;
        boolean bl = isIdentity = (this.transform.getType() & 2) != 0;
        if (!simulate) {
            if (VirtualUniverse.mc.useCombiners && (cv.textureExtendedFeatures & 0x40) != 0) {
                Pipeline.getPipeline().updateRegisterCombiners(cv.ctx, this.transform.mat, isIdentity, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, textureFormat, this.combineRgbMode, this.combineAlphaMode, this.combineRgbSrc, this.combineAlphaSrc, this.combineRgbFcn, this.combineAlphaFcn, this.combineRgbScale, this.combineAlphaScale);
            } else if (this.textureMode == 6) {
                if ((cv.textureExtendedFeatures & 8) != 0) {
                    int _combineRgbMode = this.combineRgbMode;
                    int _combineAlphaMode = this.combineAlphaMode;
                    Pipeline.getPipeline().updateTextureAttributes(cv.ctx, this.transform.mat, isIdentity, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, textureFormat);
                    if (this.combineRgbMode == 6 && (cv.textureExtendedFeatures & 0x10) == 0 || this.combineRgbMode == 4 && (cv.textureExtendedFeatures & 0x20) == 0) {
                        _combineRgbMode = 0;
                    }
                    if (this.combineAlphaMode == 6 && (cv.textureExtendedFeatures & 0x10) == 0 || this.combineAlphaMode == 4 && (cv.textureExtendedFeatures & 0x20) == 0) {
                        _combineAlphaMode = 0;
                    }
                    Pipeline.getPipeline().updateCombiner(cv.ctx, _combineRgbMode, _combineAlphaMode, this.combineRgbSrc, this.combineAlphaSrc, this.combineRgbFcn, this.combineAlphaFcn, this.combineRgbScale, this.combineAlphaScale);
                } else {
                    Pipeline.getPipeline().updateTextureAttributes(cv.ctx, this.transform.mat, isIdentity, 5, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, textureFormat);
                }
            } else {
                Pipeline.getPipeline().updateTextureAttributes(cv.ctx, this.transform.mat, isIdentity, this.textureMode, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, textureFormat);
            }
            if ((cv.textureExtendedFeatures & 2) != 0 && this.textureColorTable != null) {
                Pipeline.getPipeline().updateTextureColorTable(cv.ctx, this.numTextureColorTableComponents, this.textureColorTableSize, this.textureColorTable);
            }
        } else {
            Pipeline.getPipeline().updateTextureAttributes(cv.ctx, this.transform.mat, isIdentity, 5, this.perspCorrectionMode, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w, textureFormat);
            if ((cv.textureExtendedFeatures & 2) != 0 && this.textureColorTable != null) {
                Pipeline.getPipeline().updateTextureColorTable(cv.ctx, this.numTextureColorTableComponents, this.textureColorTableSize, this.textureColorTable);
            }
            switch (this.textureMode) {
                case 5: 
                case 6: {
                    cv.setBlendFunc(cv.ctx, 1, 0);
                    break;
                }
                case 2: {
                    cv.setBlendFunc(cv.ctx, 4, 0);
                    break;
                }
                case 3: {
                    if (textureFormat == 6) {
                        cv.setBlendFunc(cv.ctx, 2, 3);
                        break;
                    }
                    cv.setBlendFunc(cv.ctx, 1, 0);
                    break;
                }
                case 4: {
                    cv.setBlendColor(cv.ctx, this.textureBlendColor.x, this.textureBlendColor.y, this.textureBlendColor.z, this.textureBlendColor.w);
                    cv.setBlendFunc(cv.ctx, 8, 7);
                }
            }
        }
    }

    @Override
    synchronized void createMirrorObject() {
        if (this.mirror == null) {
            if (this.isStatic()) {
                this.mirror = this;
            } else {
                TextureAttributesRetained mirrorTa = new TextureAttributesRetained();
                mirrorTa.source = this.source;
                mirrorTa.set(this);
                this.mirror = mirrorTa;
            }
        } else {
            ((TextureAttributesRetained)this.mirror).set(this);
        }
    }

    @Override
    synchronized void initMirrorObject() {
        ((TextureAttributesRetained)this.mirror).set(this);
    }

    synchronized void updateMirrorObject(int component, Object value, Object value2) {
        TextureAttributesRetained mirrorTa = (TextureAttributesRetained)this.mirror;
        mirrorTa.mirrorCompDirty = true;
        if ((component & 1) != 0) {
            mirrorTa.transform.set((Transform3D)value);
        } else if ((component & 2) != 0) {
            mirrorTa.textureMode = (Integer)value;
            if (mirrorTa.textureMode == 6 && mirrorTa.combineRgbSrc == null) {
                this.initCombineMode(mirrorTa);
            }
        } else if ((component & 4) != 0) {
            mirrorTa.textureBlendColor.set((Color4f)value);
        } else if ((component & 8) != 0) {
            mirrorTa.perspCorrectionMode = (Integer)value;
        } else if ((component & 0x10) != 0) {
            if (value == null) {
                mirrorTa.textureColorTable = null;
                mirrorTa.numTextureColorTableComponents = 0;
                mirrorTa.textureColorTableSize = 0;
            } else {
                Object[] args = (Object[])value;
                mirrorTa.textureColorTable = (int[])args[2];
                mirrorTa.numTextureColorTableComponents = (Integer)args[0];
                mirrorTa.textureColorTableSize = (Integer)args[1];
            }
        } else if ((component & 0x20) != 0) {
            mirrorTa.combineRgbMode = (Integer)value;
        } else if ((component & 0x40) != 0) {
            mirrorTa.combineAlphaMode = (Integer)value;
        } else if ((component & 0x80) != 0) {
            if (mirrorTa.combineRgbSrc == null) {
                this.initCombineMode(mirrorTa);
            }
            int index = (Integer)value;
            mirrorTa.combineRgbSrc[index] = (Integer)value2;
        } else if ((component & 0x100) != 0) {
            if (mirrorTa.combineRgbSrc == null) {
                this.initCombineMode(mirrorTa);
            }
            int index = (Integer)value;
            mirrorTa.combineAlphaSrc[index] = (Integer)value2;
        } else if ((component & 0x200) != 0) {
            if (mirrorTa.combineRgbSrc == null) {
                this.initCombineMode(mirrorTa);
            }
            int index = (Integer)value;
            mirrorTa.combineRgbFcn[index] = (Integer)value2;
        } else if ((component & 0x400) != 0) {
            if (mirrorTa.combineRgbSrc == null) {
                this.initCombineMode(mirrorTa);
            }
            int index = (Integer)value;
            mirrorTa.combineAlphaFcn[index] = (Integer)value2;
        } else if ((component & 0x800) != 0) {
            mirrorTa.combineRgbScale = (Integer)value;
        } else if ((component & 0x1000) != 0) {
            mirrorTa.combineAlphaScale = (Integer)value;
        }
    }

    boolean equivalent(TextureAttributesRetained tr) {
        if (tr == null) {
            return false;
        }
        if (this.changedFrequent != 0 || tr.changedFrequent != 0) {
            return this == tr;
        }
        if (!tr.transform.equals(this.transform) || !tr.textureBlendColor.equals(this.textureBlendColor) || tr.textureMode != this.textureMode || tr.perspCorrectionMode != this.perspCorrectionMode) {
            return false;
        }
        if (this.textureMode == 6) {
            if (tr.combineRgbMode != this.combineRgbMode || tr.combineAlphaMode != this.combineAlphaMode || tr.combineRgbScale != this.combineRgbScale || tr.combineAlphaScale != this.combineAlphaScale) {
                return false;
            }
            int nOpNeeded = 0;
            nOpNeeded = this.combineRgbMode == 0 ? 1 : (this.combineRgbMode == 5 ? 3 : 2);
            for (int i2 = 0; i2 < nOpNeeded; ++i2) {
                if (tr.combineRgbSrc[i2] == this.combineRgbSrc[i2] && tr.combineAlphaSrc[i2] == this.combineAlphaSrc[i2] && tr.combineRgbFcn[i2] == this.combineRgbFcn[i2] && tr.combineAlphaFcn[i2] == this.combineAlphaFcn[i2]) continue;
                return false;
            }
        }
        if (tr.textureColorTable == null) {
            return this.textureColorTable == null;
        }
        if (this.textureColorTable == null) {
            return false;
        }
        if (tr.textureColorTable.length != this.textureColorTable.length) {
            return false;
        }
        for (int i3 = 0; i3 < this.textureColorTable.length; ++i3) {
            if (this.textureColorTable[i3] == tr.textureColorTable[i3]) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Object clone() {
        TextureAttributesRetained tr = (TextureAttributesRetained)super.clone();
        tr.transform = new Transform3D(this.transform);
        tr.textureBlendColor = new Color4f(this.textureBlendColor);
        if (this.textureColorTable != null) {
            tr.textureColorTable = new int[this.textureColorTable.length];
            System.arraycopy(this.textureColorTable, 0, tr.textureColorTable, 0, this.textureColorTable.length);
        } else {
            tr.textureColorTable = null;
        }
        if (this.combineRgbSrc != null) {
            tr.combineRgbSrc = new int[3];
            tr.combineAlphaSrc = new int[3];
            tr.combineRgbFcn = new int[3];
            tr.combineAlphaFcn = new int[3];
            for (int i2 = 0; i2 < 3; ++i2) {
                tr.combineRgbSrc[i2] = this.combineRgbSrc[i2];
                tr.combineAlphaSrc[i2] = this.combineAlphaSrc[i2];
                tr.combineRgbFcn[i2] = this.combineRgbFcn[i2];
                tr.combineAlphaFcn[i2] = this.combineAlphaFcn[i2];
            }
        }
        return tr;
    }

    protected void set(TextureAttributesRetained tr) {
        super.set(tr);
        this.transform.set(tr.transform);
        this.textureBlendColor.set(tr.textureBlendColor);
        this.textureMode = tr.textureMode;
        this.perspCorrectionMode = tr.perspCorrectionMode;
        if (tr.textureColorTable != null) {
            if (this.textureColorTable == null || this.textureColorTable.length != tr.textureColorTable.length) {
                this.textureColorTable = new int[tr.textureColorTable.length];
            }
            System.arraycopy(tr.textureColorTable, 0, this.textureColorTable, 0, tr.textureColorTable.length);
        } else {
            this.textureColorTable = null;
        }
        this.numTextureColorTableComponents = tr.numTextureColorTableComponents;
        this.textureColorTableSize = tr.textureColorTableSize;
        this.combineRgbMode = tr.combineRgbMode;
        this.combineAlphaMode = tr.combineAlphaMode;
        this.combineRgbScale = tr.combineRgbScale;
        this.combineAlphaScale = tr.combineAlphaScale;
        if (tr.combineRgbSrc != null) {
            if (this.combineRgbSrc == null) {
                this.combineRgbSrc = new int[3];
                this.combineAlphaSrc = new int[3];
                this.combineRgbFcn = new int[3];
                this.combineAlphaFcn = new int[3];
            }
            for (int i2 = 0; i2 < 3; ++i2) {
                this.combineRgbSrc[i2] = tr.combineRgbSrc[i2];
                this.combineAlphaSrc[i2] = tr.combineAlphaSrc[i2];
                this.combineRgbFcn[i2] = tr.combineRgbFcn[i2];
                this.combineAlphaFcn[i2] = tr.combineAlphaFcn[i2];
            }
        }
    }

    final void sendMessage(int attrMask, Object attr1, Object attr2) {
        ArrayList<VirtualUniverse> univList = new ArrayList<VirtualUniverse>();
        ArrayList<ArrayList<GeometryAtom>> gaList = Shape3DRetained.getGeomAtomsList(this.mirror.users, univList);
        J3dMessage createMessage = new J3dMessage();
        createMessage.threads = 1024;
        createMessage.type = 11;
        createMessage.universe = null;
        createMessage.args[0] = this;
        createMessage.args[1] = new Integer(attrMask);
        createMessage.args[2] = attr1;
        createMessage.args[3] = attr2;
        createMessage.args[4] = new Integer(this.changedFrequent);
        VirtualUniverse.mc.processMessage(createMessage);
        for (int i2 = 0; i2 < univList.size(); ++i2) {
            createMessage = new J3dMessage();
            createMessage.threads = 128;
            createMessage.type = 11;
            createMessage.universe = univList.get(i2);
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(attrMask);
            createMessage.args[2] = attr1;
            ArrayList<GeometryAtom> gL = gaList.get(i2);
            GeometryAtom[] gaArr = new GeometryAtom[gL.size()];
            gL.toArray(gaArr);
            createMessage.args[3] = gaArr;
            VirtualUniverse.mc.processMessage(createMessage);
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        switch (bit) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                this.setFrequencyChangeMask(bit, bit);
            }
        }
    }

    static {
        for (int i2 = 0; i2 < enums.length; ++i2) {
            TextureAttributesRetained.enums[i2] = new Integer(i2);
        }
    }
}

