/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CachedTargets;
import org.jogamp.java3d.Canvas3D;
import org.jogamp.java3d.Font3D;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryAtom;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.NnuId;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.RenderAtom;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.TargetsInterface;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.VirtualUniverse;
import org.jogamp.vecmath.Point3d;
import org.jogamp.vecmath.Point3f;
import org.jogamp.vecmath.Vector3f;

class Text3DRetained
extends GeometryRetained {
    Font3D font3D = null;
    String string = null;
    Point3f position = new Point3f(0.0f, 0.0f, 0.0f);
    int alignment = 1;
    int path = 1;
    float charSpacing = 0.0f;
    int numChars = 0;
    static final int targetThreads = 8384;
    Transform3D[] charTransforms = new Transform3D[0];
    GeometryArrayRetained[] geometryList = new GeometryArrayRetained[0];
    GlyphVector[] glyphVecs = new GlyphVector[0];
    Point3d lower = new Point3d();
    Point3d upper = new Point3d();
    ArrayList newGeometryAtomList = new ArrayList();
    ArrayList oldGeometryAtomList = new ArrayList();
    Transform3D vpcToEc;
    Transform3D drawTransform;

    Text3DRetained() {
        this.geoType = 16;
    }

    @Override
    synchronized void computeBoundingBox() {
        Point3d l2 = new Point3d();
        Point3d u = new Point3d();
        Vector3f location = new Vector3f(this.position);
        int k2 = 0;
        int numTotal = 0;
        double width = 0.0;
        double height = 0.0;
        l2.set(location);
        u.set(location);
        if (this.numChars != 0) {
            Rectangle2D bounds;
            if (this.path == 1 || this.path == 2) {
                k2 = 0;
                numTotal = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                k2 = 1;
                numTotal = this.numChars;
                bounds = this.glyphVecs[0].getVisualBounds();
                u.x += bounds.getWidth();
                u.y += bounds.getHeight();
            }
            int i2 = 1;
            while (i2 < numTotal) {
                width = this.glyphVecs[k2].getLogicalBounds().getWidth();
                bounds = this.glyphVecs[k2].getVisualBounds();
                width += (double)this.charSpacing;
                height = bounds.getHeight();
                switch (this.path) {
                    case 1: {
                        u.x += width;
                        if (!(u.y < height + (double)location.y)) break;
                        u.y = (double)location.y + height;
                        break;
                    }
                    case 0: {
                        l2.x -= width;
                        if (!(u.y < height + (double)location.y)) break;
                        u.y = (double)location.y + height;
                        break;
                    }
                    case 2: {
                        u.y += height;
                        if (!(u.x < bounds.getWidth() + (double)location.x)) break;
                        u.x = (double)location.x + bounds.getWidth();
                        break;
                    }
                    case 3: {
                        l2.y -= height;
                        if (!(u.x < bounds.getWidth() + (double)location.x)) break;
                        u.x = (double)location.x + bounds.getWidth();
                    }
                }
                ++i2;
                ++k2;
            }
            if (this.alignment != 1) {
                double cx = u.x - l2.x;
                double cy = u.y - l2.y;
                if (this.alignment == 0) {
                    cx *= 0.5;
                    cy *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        l2.x -= cx;
                        u.x -= cx;
                        break;
                    }
                    case 0: {
                        l2.x += cx;
                        u.x += cx;
                        break;
                    }
                    case 2: {
                        l2.y -= cy;
                        u.y -= cy;
                        break;
                    }
                    case 3: {
                        l2.y += cy;
                        u.y += cy;
                    }
                }
            }
        }
        l2.z = 0.0;
        u.z = this.font3D == null || this.font3D.fontExtrusion == null ? l2.z : l2.z + (double)this.font3D.fontExtrusion.length;
    }

    @Override
    void update() {
    }

    final Font3D getFont3D() {
        return this.font3D;
    }

    final void setFont3D(Font3D font3d) {
        this.geomLock.getLock();
        this.font3D = font3d;
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final String getString() {
        return this.string;
    }

    final void setString(String string) {
        this.geomLock.getLock();
        this.string = string;
        this.numChars = string == null ? 0 : string.length();
        this.updateCharacterData();
        this.geomLock.unLock();
        this.sendDataChangedMessage();
    }

    final void getPosition(Point3f position) {
        position.set(this.position);
    }

    final void setPosition(Point3f position) {
        this.geomLock.getLock();
        this.position.set(position);
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getAlignment() {
        return this.alignment;
    }

    final void setAlignment(int alignment) {
        this.geomLock.getLock();
        this.alignment = alignment;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    final int getPath() {
        return this.path;
    }

    final void setPath(int path) {
        this.path = path;
        this.updateTransformData();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void getBoundingBox(BoundingBox bounds) {
        Text3DRetained text3DRetained = this;
        synchronized (text3DRetained) {
            bounds.setLower(this.lower);
            bounds.setUpper(this.upper);
        }
    }

    final float getCharacterSpacing() {
        return this.charSpacing;
    }

    final void setCharacterSpacing(float characterSpacing) {
        this.geomLock.getLock();
        this.charSpacing = characterSpacing;
        this.updateTransformData();
        this.geomLock.unLock();
        this.sendTransformChangedMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendDataChangedMessage() {
        ArrayList<TargetsInterface> tiArrList = new ArrayList<TargetsInterface>();
        ArrayList<CachedTargets[]> newCtArrArrList = new ArrayList<CachedTargets[]>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int numMessages = this.universeList.size();
                    J3dMessage[] m2 = new J3dMessage[numMessages];
                    for (int i2 = 0; i2 < numMessages; ++i2) {
                        int k2;
                        int j2;
                        m2[i2] = new J3dMessage();
                        m2[i2].type = 26;
                        m2[i2].threads = 8384;
                        ArrayList shapeList = (ArrayList)this.userLists.get(i2);
                        this.newGeometryAtomList.clear();
                        this.oldGeometryAtomList.clear();
                        for (j2 = 0; j2 < shapeList.size(); ++j2) {
                            int gaCnt;
                            Shape3DRetained s = (Shape3DRetained)shapeList.get(j2);
                            if (s.boundsAutoCompute) {
                                s.getCombineBounds((BoundingBox)s.bounds);
                            }
                            int gSize = s.geometryList.size();
                            GeometryAtom oldGA = Shape3DRetained.getGeomAtom(s);
                            GeometryAtom newGA = new GeometryAtom();
                            int geometryCnt = 0;
                            for (k2 = 0; k2 < gSize; ++k2) {
                                GeometryRetained geomRetained = s.geometryList.get(k2);
                                if (geomRetained != null) {
                                    Text3DRetained tempT3d = (Text3DRetained)geomRetained;
                                    geometryCnt += tempT3d.numChars;
                                    continue;
                                }
                                ++geometryCnt;
                            }
                            newGA.geometryArray = new GeometryRetained[geometryCnt];
                            newGA.lastLocalTransformArray = new Transform3D[geometryCnt];
                            geometryCnt = 0;
                            newGA.locale = s.locale;
                            newGA.visible = s.visible;
                            newGA.source = s;
                            GeometryRetained geometry = null;
                            for (gaCnt = 0; gaCnt < gSize; ++gaCnt) {
                                geometry = s.geometryList.get(gaCnt);
                                if (geometry == null) continue;
                                newGA.geoType = geometry.geoType;
                                newGA.alphaEditable = s.isAlphaEditable(geometry);
                                break;
                            }
                            while (gaCnt < gSize) {
                                geometry = s.geometryList.get(gaCnt);
                                if (geometry == null) {
                                    newGA.geometryArray[gaCnt] = null;
                                } else {
                                    Text3DRetained t = (Text3DRetained)geometry;
                                    k2 = 0;
                                    while (k2 < t.numChars) {
                                        GeometryArrayRetained geo = t.geometryList[k2];
                                        if (geo != null) {
                                            newGA.geometryArray[geometryCnt] = geo;
                                            newGA.lastLocalTransformArray[geometryCnt] = t.charTransforms[k2];
                                        } else {
                                            newGA.geometryArray[geometryCnt] = null;
                                            newGA.lastLocalTransformArray[geometryCnt] = null;
                                        }
                                        ++k2;
                                        ++geometryCnt;
                                    }
                                }
                                ++gaCnt;
                            }
                            this.oldGeometryAtomList.add(oldGA);
                            this.newGeometryAtomList.add(newGA);
                            Shape3DRetained.setGeomAtom(s, newGA);
                        }
                        Object[] oldGAArray = this.oldGeometryAtomList.toArray();
                        Object[] newGAArray = this.newGeometryAtomList.toArray();
                        ArrayList uniqueList = this.getUniqueSource(shapeList);
                        int numSrc = uniqueList.size();
                        for (j2 = 0; j2 < numSrc; ++j2) {
                            CachedTargets[] newCtArr = null;
                            Shape3DRetained src = (Shape3DRetained)uniqueList.get(j2);
                            int numMS3D = src.mirrorShape3D.size();
                            TargetsInterface ti = ((GroupRetained)src.parent).getClosestTargetsInterface(0);
                            if (ti == null) continue;
                            newCtArr = new CachedTargets[numMS3D];
                            for (k2 = 0; k2 < numMS3D; ++k2) {
                                CachedTargets ct;
                                int kk;
                                Shape3DRetained ms = src.mirrorShape3D.get(k2);
                                GeometryAtom ga = Shape3DRetained.getGeomAtom(ms);
                                for (kk = 0; kk < newGAArray.length && ga != newGAArray[kk]; ++kk) {
                                }
                                if (kk == newGAArray.length) {
                                    System.err.println("Text3DRetained : Problem !!! Can't find matching geomAtom");
                                }
                                if ((ct = ti.getCachedTargets(0, k2, -1)) != null) {
                                    newCtArr[k2] = new CachedTargets();
                                    newCtArr[k2].copy(ct);
                                    newCtArr[k2].replace((NnuId)oldGAArray[kk], (NnuId)newGAArray[kk], 0);
                                    continue;
                                }
                                newCtArr[k2] = null;
                            }
                            ti.resetCachedTargets(0, newCtArr, -1);
                            tiArrList.add(ti);
                            newCtArrArrList.add(newCtArr);
                        }
                        m2[i2].args[0] = oldGAArray;
                        m2[i2].args[1] = newGAArray;
                        m2[i2].universe = (VirtualUniverse)this.universeList.get(i2);
                        if (tiArrList.size() > 0) {
                            m2[i2].args[2] = tiArrList.toArray();
                            m2[i2].args[3] = newCtArrArrList.toArray();
                        }
                        tiArrList.clear();
                        newCtArrArrList.clear();
                    }
                    VirtualUniverse.mc.processMessage(m2);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void sendTransformChangedMessage() {
        ArrayList<GeometryAtom> gaList = new ArrayList<GeometryAtom>();
        Object object = this.liveStateLock;
        synchronized (object) {
            if (this.source.isLive()) {
                ArrayList arrayList = this.universeList;
                synchronized (arrayList) {
                    int numMessages = this.universeList.size();
                    J3dMessage[] m2 = new J3dMessage[numMessages];
                    for (int i2 = 0; i2 < numMessages; ++i2) {
                        m2[i2] = new J3dMessage();
                        m2[i2].type = 25;
                        m2[i2].threads = 8384;
                        ArrayList shapeList = (ArrayList)this.userLists.get(i2);
                        for (int j2 = 0; j2 < shapeList.size(); ++j2) {
                            GeometryRetained geomR;
                            int sCnt;
                            Shape3DRetained s = (Shape3DRetained)shapeList.get(j2);
                            for (sCnt = 0; sCnt < s.geometryList.size() && (geomR = s.geometryList.get(sCnt)) != this; ++sCnt) {
                            }
                            if (sCnt >= s.geometryList.size()) continue;
                            gaList.add(Shape3DRetained.getGeomAtom(s));
                        }
                        m2[i2].args[0] = gaList.toArray();
                        m2[i2].args[1] = this.charTransforms;
                        m2[i2].universe = (VirtualUniverse)this.universeList.get(i2);
                    }
                    VirtualUniverse.mc.processMessage(m2);
                }
            }
        }
    }

    final void updateCharacterData() {
        char[] c2 = new char[1];
        if (this.geometryList.length != this.numChars) {
            this.geometryList = new GeometryArrayRetained[this.numChars];
            this.glyphVecs = new GlyphVector[this.numChars];
        }
        if (this.font3D != null) {
            for (int i2 = 0; i2 < this.numChars; ++i2) {
                c2[0] = this.string.charAt(i2);
                this.glyphVecs[i2] = this.font3D.font.createGlyphVector(this.font3D.frc, c2);
                this.geometryList[i2] = this.font3D.triangulateGlyphs(this.glyphVecs[i2], c2[0]);
            }
        }
        this.updateTransformData();
    }

    final void updateTransformData() {
        int i2;
        int k2 = 0;
        int numTotal = 0;
        double width = 0.0;
        double height = 0.0;
        Vector3f location = new Vector3f(this.position);
        this.lower.set(location);
        this.upper.set(location);
        this.charTransforms = new Transform3D[this.numChars];
        for (i2 = 0; i2 < this.numChars; ++i2) {
            this.charTransforms[i2] = new Transform3D();
        }
        if (this.numChars != 0) {
            Rectangle2D bounds;
            this.charTransforms[0].set(location);
            if (this.path == 1 || this.path == 2) {
                k2 = 0;
                numTotal = this.numChars + 1;
            } else if (this.path == 0 || this.path == 3) {
                k2 = 1;
                numTotal = this.numChars;
                bounds = this.glyphVecs[0].getVisualBounds();
                this.upper.x += bounds.getWidth();
                this.upper.y += bounds.getHeight();
            }
            i2 = 1;
            while (i2 < numTotal) {
                width = this.glyphVecs[k2].getLogicalBounds().getWidth();
                bounds = this.glyphVecs[k2].getVisualBounds();
                width += (double)this.charSpacing;
                height = bounds.getHeight();
                switch (this.path) {
                    case 1: {
                        location.x = (float)((double)location.x + width);
                        this.upper.x += width;
                        if (!(this.upper.y < height + (double)location.y)) break;
                        this.upper.y = (double)location.y + height;
                        break;
                    }
                    case 0: {
                        location.x = (float)((double)location.x - width);
                        this.lower.x -= width;
                        if (!(this.upper.y < height + (double)location.y)) break;
                        this.upper.y = (double)location.y + height;
                        break;
                    }
                    case 2: {
                        location.y = (float)((double)location.y + height);
                        this.upper.y += height;
                        if (!(this.upper.x < bounds.getWidth() + (double)location.x)) break;
                        this.upper.x = (double)location.x + bounds.getWidth();
                        break;
                    }
                    case 3: {
                        location.y = (float)((double)location.y - height);
                        this.lower.y -= height;
                        if (!(this.upper.x < bounds.getWidth() + (double)location.x)) break;
                        this.upper.x = (double)location.x + bounds.getWidth();
                    }
                }
                if (i2 < this.numChars) {
                    this.charTransforms[i2].set(location);
                }
                ++i2;
                ++k2;
            }
            if (this.alignment != 1) {
                double cx = this.upper.x - this.lower.x;
                double cy = this.upper.y - this.lower.y;
                if (this.alignment == 0) {
                    cx *= 0.5;
                    cy *= 0.5;
                }
                switch (this.path) {
                    case 1: {
                        for (i2 = 0; i2 < this.numChars; ++i2) {
                            this.charTransforms[i2].mat[3] = this.charTransforms[i2].mat[3] - cx;
                        }
                        this.lower.x -= cx;
                        this.upper.x -= cx;
                        break;
                    }
                    case 0: {
                        for (i2 = 0; i2 < this.numChars; ++i2) {
                            this.charTransforms[i2].mat[3] = this.charTransforms[i2].mat[3] + cx;
                        }
                        this.lower.x += cx;
                        this.upper.x += cx;
                        break;
                    }
                    case 2: {
                        for (i2 = 0; i2 < this.numChars; ++i2) {
                            this.charTransforms[i2].mat[7] = this.charTransforms[i2].mat[7] - cy;
                        }
                        this.lower.y -= cy;
                        this.upper.y -= cy;
                        break;
                    }
                    case 3: {
                        for (i2 = 0; i2 < this.numChars; ++i2) {
                            this.charTransforms[i2].mat[7] = this.charTransforms[i2].mat[7] + cy;
                        }
                        this.lower.y += cy;
                        this.upper.y += cy;
                    }
                }
            }
        }
        this.lower.z = 0.0;
        this.upper.z = this.font3D == null || this.font3D.fontExtrusion == null ? this.lower.z : this.lower.z + (double)this.font3D.fontExtrusion.length;
        this.getBoundingBox(this.geoBounds);
    }

    @Override
    void setLive(boolean inBackgroundGroup, int refCount) {
        this.updateCharacterData();
        super.doSetLive(inBackgroundGroup, refCount);
        super.markAsLive();
    }

    @Override
    boolean intersect(PickShape pickShape, PickInfo pickInfo, int flags, Point3d iPnt, GeometryRetained geom, int geomIndex) {
        Transform3D tempT3D = new Transform3D();
        GeometryArrayRetained geo = null;
        int sIndex = -1;
        double minDist = Double.MAX_VALUE;
        double distance = 0.0;
        Point3d closestIPnt = new Point3d();
        for (int i2 = 0; i2 < this.numChars; ++i2) {
            geo = this.geometryList[i2];
            if (geo == null) continue;
            tempT3D.invert(this.charTransforms[i2]);
            PickShape newPS = pickShape.transform(tempT3D);
            if (!geo.intersect(newPS, pickInfo, flags, iPnt, geom, geomIndex)) continue;
            if (flags == 0) {
                return true;
            }
            distance = newPS.distance(iPnt);
            if (!(distance < minDist)) continue;
            sIndex = i2;
            minDist = distance;
            closestIPnt.set(iPnt);
        }
        if (sIndex >= 0) {
            iPnt.set(closestIPnt);
            this.charTransforms[sIndex].transform(iPnt);
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Point3d[] pnts) {
        Transform3D tempT3D = new Transform3D();
        boolean isIntersect = false;
        Point3d[] transPnts = new Point3d[pnts.length];
        for (int j2 = pnts.length - 1; j2 >= 0; --j2) {
            transPnts[j2] = new Point3d();
        }
        for (int i2 = this.numChars - 1; i2 >= 0; --i2) {
            GeometryArrayRetained ga = this.geometryList[i2];
            if (ga == null) continue;
            tempT3D.invert(this.charTransforms[i2]);
            for (int j3 = pnts.length - 1; j3 >= 0; --j3) {
                tempT3D.transform(pnts[j3], transPnts[j3]);
            }
            if (!ga.intersect(transPnts)) continue;
            isIntersect = true;
            break;
        }
        return isIntersect;
    }

    @Override
    boolean intersect(Transform3D thisToOtherVworld, GeometryRetained geom) {
        for (int i2 = this.numChars - 1; i2 >= 0; --i2) {
            GeometryArrayRetained ga = this.geometryList[i2];
            if (ga == null || !ga.intersect(thisToOtherVworld, geom)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean intersect(Bounds targetBound) {
        for (int i2 = this.numChars - 1; i2 >= 0; --i2) {
            GeometryArrayRetained ga = this.geometryList[i2];
            if (ga == null || !ga.intersect(targetBound)) continue;
            return true;
        }
        return false;
    }

    void setModelViewMatrix(Transform3D vpcToEc, Transform3D drawTransform) {
        this.vpcToEc = vpcToEc;
        this.drawTransform = drawTransform;
    }

    @Override
    void execute(Canvas3D cv, RenderAtom ra, boolean isNonUniformScale, boolean updateAlpha, float alpha, int screen, boolean ignoreVertexColors) {
        Transform3D trans = new Transform3D();
        for (int i2 = 0; i2 < this.geometryList.length; ++i2) {
            trans.set(this.drawTransform);
            trans.mul(this.charTransforms[i2]);
            cv.setModelViewMatrix(cv.ctx, this.vpcToEc.mat, trans);
            this.geometryList[i2].execute(cv, ra, isNonUniformScale, updateAlpha, alpha, screen, ignoreVertexColors);
        }
    }

    @Override
    int getClassType() {
        return 6;
    }

    ArrayList getUniqueSource(ArrayList shapeList) {
        ArrayList<NodeRetained> uniqueList = new ArrayList<NodeRetained>();
        int size = shapeList.size();
        for (int i2 = 0; i2 < size; ++i2) {
            NodeRetained src = ((Shape3DRetained)shapeList.get((int)i2)).sourceNode;
            int index = uniqueList.indexOf(src);
            if (index != -1) continue;
            uniqueList.add(src);
        }
        return uniqueList;
    }
}

