/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.BoundingLeafRetained;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.CachedTargets;
import org.jogamp.java3d.CompileState;
import org.jogamp.java3d.GroupRetained;
import org.jogamp.java3d.HashKey;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.LinkRetained;
import org.jogamp.java3d.MasterControl;
import org.jogamp.java3d.Node;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.SetLiveState;
import org.jogamp.java3d.SharedGroupRetained;
import org.jogamp.java3d.SwitchState;
import org.jogamp.java3d.Targets;
import org.jogamp.java3d.TargetsInterface;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.VirtualUniverse;

class SwitchRetained
extends GroupRetained
implements TargetsInterface {
    static final int GEO_NODES = 1;
    static final int ENV_NODES = 2;
    static final int BEHAVIOR_NODES = 4;
    static final int SOUND_NODES = 8;
    static final int BOUNDINGLEAF_NODES = 16;
    int whichChild = -1;
    BitSet childMask = new BitSet();
    BitSet renderChildMask = new BitSet();
    boolean isDirty = true;
    ArrayList<Integer> switchLevels = new ArrayList(1);
    HashKey switchKey = new HashKey();
    int switchIndexCount = 0;
    UpdateTargets updateTargets = null;
    ArrayList<ArrayList<SwitchState>> childrenSwitchStates = null;

    SwitchRetained() {
        this.nodeType = 18;
    }

    synchronized void setWhichChild(int whichChild, boolean updateAlways) {
        this.whichChild = whichChild;
        this.isDirty = true;
        if (this.source != null && this.source.isLive()) {
            this.updateTargets = new UpdateTargets();
            ArrayList<SwitchState> updateList = new ArrayList<SwitchState>(1);
            int nchildren = this.children.size();
            switch (whichChild) {
                case -2: {
                    for (int i2 = 0; i2 < nchildren; ++i2) {
                        if (this.renderChildMask.get(i2) && !updateAlways) continue;
                        this.renderChildMask.set(i2);
                        this.updateSwitchChild(i2, true, updateList);
                    }
                    break;
                }
                case -1: {
                    for (int i3 = 0; i3 < nchildren; ++i3) {
                        if (!this.renderChildMask.get(i3) && !updateAlways) continue;
                        this.renderChildMask.clear(i3);
                        this.updateSwitchChild(i3, false, updateList);
                    }
                    break;
                }
                case -3: {
                    for (int i4 = 0; i4 < nchildren; ++i4) {
                        if (this.childMask.get(i4)) {
                            if (this.renderChildMask.get(i4) && !updateAlways) continue;
                            this.renderChildMask.set(i4);
                            this.updateSwitchChild(i4, true, updateList);
                            continue;
                        }
                        if (!this.renderChildMask.get(i4) && !updateAlways) continue;
                        this.renderChildMask.clear(i4);
                        this.updateSwitchChild(i4, false, updateList);
                    }
                    break;
                }
                default: {
                    for (int i5 = 0; i5 < nchildren; ++i5) {
                        if (i5 == whichChild) {
                            if (this.renderChildMask.get(i5) && !updateAlways) continue;
                            this.renderChildMask.set(i5);
                            this.updateSwitchChild(i5, true, updateList);
                            continue;
                        }
                        if (!this.renderChildMask.get(i5) && !updateAlways) continue;
                        this.renderChildMask.clear(i5);
                        this.updateSwitchChild(i5, false, updateList);
                    }
                }
            }
            this.sendMessage(updateList);
        }
        this.dirtyBoundsCache();
    }

    int getWhichChild() {
        return this.whichChild;
    }

    final synchronized void setChildMask(BitSet childMask) {
        int i2;
        int nbits = childMask.size() > this.childMask.size() ? childMask.size() : this.childMask.size();
        for (i2 = 0; i2 < nbits; ++i2) {
            if (childMask.get(i2)) {
                this.childMask.set(i2);
                continue;
            }
            this.childMask.clear(i2);
        }
        this.isDirty = true;
        if (this.source != null && this.source.isLive() && this.whichChild == -3) {
            this.updateTargets = new UpdateTargets();
            ArrayList<SwitchState> updateList = new ArrayList<SwitchState>(1);
            int nchildren = this.children.size();
            for (i2 = 0; i2 < nchildren; ++i2) {
                if (childMask.get(i2)) {
                    if (this.renderChildMask.get(i2)) continue;
                    this.renderChildMask.set(i2);
                    this.updateSwitchChild(i2, true, updateList);
                    continue;
                }
                if (!this.renderChildMask.get(i2)) continue;
                this.renderChildMask.clear(i2);
                this.updateSwitchChild(i2, false, updateList);
            }
            this.sendMessage(updateList);
        }
        this.dirtyBoundsCache();
    }

    void sendMessage(ArrayList<SwitchState> updateList) {
        UnorderList vpList;
        int i2;
        Object[] nodes;
        int j2;
        Object[] nodesArr;
        int size;
        int threads = this.updateTargets.computeSwitchThreads();
        if (threads > 0) {
            J3dMessage m2 = new J3dMessage();
            m2.type = 27;
            m2.universe = this.universe;
            m2.threads = threads;
            m2.args[0] = this.updateTargets;
            m2.args[2] = updateList;
            UnorderList blnList = this.updateTargets.targetList[5];
            if (blnList != null) {
                size = blnList.size();
                Object[] boundingLeafUsersArr = new Object[size];
                nodesArr = blnList.toArray(false);
                for (j2 = 0; j2 < size; ++j2) {
                    Object[] boundingLeafUsers;
                    nodes = (Object[])nodesArr[j2];
                    boundingLeafUsersArr[j2] = boundingLeafUsers = new Object[nodes.length];
                    for (i2 = 0; i2 < nodes.length; ++i2) {
                        BoundingLeafRetained mbleaf = (BoundingLeafRetained)nodes[i2];
                        boundingLeafUsers[i2] = mbleaf.users.toArray();
                    }
                }
                m2.args[1] = boundingLeafUsersArr;
            }
            VirtualUniverse.mc.processMessage(m2);
        }
        if ((vpList = this.updateTargets.targetList[4]) != null) {
            size = vpList.size();
            nodesArr = vpList.toArray(false);
            for (j2 = 0; j2 < size; ++j2) {
                nodes = (Object[])nodesArr[j2];
                for (i2 = 0; i2 < nodes.length; ++i2) {
                    ViewPlatformRetained vp = (ViewPlatformRetained)nodes[i2];
                    vp.processSwitchChanged();
                }
            }
        }
    }

    final BitSet getChildMask() {
        return (BitSet)this.childMask.clone();
    }

    Node currentChild() {
        if (this.whichChild < 0 || this.whichChild >= this.children.size()) {
            return null;
        }
        return this.getChild(this.whichChild);
    }

    void updateSwitchChild(int child, boolean switchOn, ArrayList<SwitchState> updateList) {
        if (this.inSharedGroup) {
            for (int i2 = 0; i2 < this.localToVworldKeys.length; ++i2) {
                int switchLevel = this.switchLevels.get(i2);
                this.traverseSwitchChild(child, this.localToVworldKeys[i2], i2, this, false, false, switchOn, switchLevel, updateList);
            }
        } else {
            int switchLevel = this.switchLevels.get(0);
            this.traverseSwitchChild(child, null, 0, this, false, false, switchOn, switchLevel, updateList);
        }
    }

    @Override
    void setAuxData(SetLiveState s, int index, int hkIndex) {
        super.setAuxData(s, index, hkIndex);
        this.switchLevels.add(new Integer(s.switchLevels[index]));
        int nchildren = this.children.size();
        for (int i2 = 0; i2 < nchildren; ++i2) {
            ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(i2);
            switchStates.add(hkIndex, new SwitchState(true));
        }
    }

    @Override
    void setNodeData(SetLiveState s) {
        super.setNodeData(s);
        if (!(s.childSwitchLinks == null || this.inSharedGroup && s.childSwitchLinks.contains(this))) {
            s.childSwitchLinks.add(this);
        }
        s.parentSwitchLink = this;
        if (!this.inSharedGroup) {
            this.setAuxData(s, 0, 0);
        } else {
            s.hashkeyIndex = new int[s.keys.length];
            for (int j2 = 0; j2 < s.keys.length; ++j2) {
                int hkIndex = s.keys[j2].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex >= 0) {
                    this.setAuxData(s, j2, hkIndex);
                } else {
                    MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
                }
                s.hashkeyIndex[j2] = hkIndex;
            }
        }
    }

    @Override
    void setLive(SetLiveState s) {
        boolean switchOn;
        int size;
        SwitchRetained switchRoot;
        int i2;
        Targets[] savedSwitchTargets = s.switchTargets;
        ArrayList<SwitchState> savedSwitchStates = s.switchStates;
        SwitchRetained[] savedClosestSwitchParents = s.closestSwitchParents;
        int[] savedClosestSwitchIndices = s.closestSwitchIndices;
        ArrayList<NodeRetained> savedChildSwitchLinks = s.childSwitchLinks;
        GroupRetained savedParentSwitchLink = s.parentSwitchLink;
        int[] savedHashkeyIndex = s.hashkeyIndex;
        s.closestSwitchParents = (SwitchRetained[])savedClosestSwitchParents.clone();
        s.closestSwitchIndices = Arrays.copyOf(savedClosestSwitchIndices, savedClosestSwitchIndices.length);
        for (i2 = 0; i2 < s.switchLevels.length; ++i2) {
            int n2 = i2;
            s.switchLevels[n2] = s.switchLevels[n2] + 1;
            s.closestSwitchParents[i2] = this;
        }
        super.doSetLive(s);
        this.initRenderChildMask();
        if (this.inSharedGroup) {
            for (i2 = 0; i2 < s.keys.length; ++i2) {
                int j2 = s.hashkeyIndex[i2];
                if (j2 >= this.localToVworldKeys.length) continue;
                switchRoot = s.switchLevels[i2] == 0 ? this : null;
                size = this.children.size();
                for (int k2 = 0; k2 < size; ++k2) {
                    switchOn = this.renderChildMask.get(k2);
                    this.traverseSwitchChild(k2, s.keys[i2], j2, switchRoot, true, false, switchOn, s.switchLevels[i2], null);
                }
            }
        } else {
            switchRoot = s.switchLevels[0] == 0 ? this : null;
            size = this.children.size();
            for (i2 = 0; i2 < size; ++i2) {
                switchOn = this.renderChildMask.get(i2);
                this.traverseSwitchChild(i2, null, 0, switchRoot, true, false, switchOn, s.switchLevels[0], null);
            }
        }
        s.switchTargets = savedSwitchTargets;
        s.switchStates = savedSwitchStates;
        s.closestSwitchParents = savedClosestSwitchParents;
        s.closestSwitchIndices = savedClosestSwitchIndices;
        i2 = 0;
        while (i2 < s.switchLevels.length) {
            int n3 = i2++;
            s.switchLevels[n3] = s.switchLevels[n3] - 1;
        }
        s.childSwitchLinks = savedChildSwitchLinks;
        s.parentSwitchLink = savedParentSwitchLink;
        s.hashkeyIndex = savedHashkeyIndex;
        super.markAsLive();
    }

    @Override
    void removeNodeData(SetLiveState s) {
        int numChildren = this.children.size();
        if (this.refCount <= 0) {
            if (this.parentSwitchLink != null) {
                for (int i2 = 0; i2 < this.parentSwitchLink.childrenSwitchLinks.size(); ++i2) {
                    ArrayList<NodeRetained> switchLinks = this.parentSwitchLink.childrenSwitchLinks.get(i2);
                    if (!switchLinks.contains(this)) continue;
                    switchLinks.remove(this);
                    break;
                }
            }
            for (int j2 = 0; j2 < numChildren; ++j2) {
                ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(j2);
                switchStates.clear();
            }
            this.switchLevels.remove(0);
        } else {
            for (int i3 = s.keys.length - 1; i3 >= 0; --i3) {
                int hkIndex = s.keys[i3].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (hkIndex < 0) continue;
                for (int j3 = 0; j3 < numChildren; ++j3) {
                    ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(j3);
                    switchStates.remove(hkIndex);
                }
                this.switchLevels.remove(hkIndex);
            }
        }
        super.removeNodeData(s);
    }

    @Override
    synchronized void clearLive(SetLiveState s) {
        Targets[] savedSwitchTargets = s.switchTargets;
        s.switchTargets = null;
        super.clearLive(s);
        s.switchTargets = savedSwitchTargets;
    }

    void initRenderChildMask() {
        int nchildren = this.children.size();
        switch (this.whichChild) {
            case -2: {
                for (int i2 = 0; i2 < nchildren; ++i2) {
                    this.renderChildMask.set(i2);
                }
                break;
            }
            case -1: {
                for (int i3 = 0; i3 < nchildren; ++i3) {
                    this.renderChildMask.clear(i3);
                }
                break;
            }
            case -3: {
                for (int i4 = 0; i4 < nchildren; ++i4) {
                    if (this.childMask.get(i4)) {
                        this.renderChildMask.set(i4);
                        continue;
                    }
                    this.renderChildMask.clear(i4);
                }
                break;
            }
            default: {
                for (int i5 = 0; i5 < nchildren; ++i5) {
                    if (i5 == this.whichChild) {
                        this.renderChildMask.set(i5);
                        continue;
                    }
                    this.renderChildMask.clear(i5);
                }
            }
        }
    }

    void traverseSwitchChild(int child, HashKey key, int index, SwitchRetained switchRoot, boolean init, boolean swChanged, boolean switchOn, int switchLevel, ArrayList<SwitchState> updateList) {
        boolean newSwChanged = false;
        ArrayList<SwitchState> childSwitchStates = this.childrenSwitchStates.get(child);
        SwitchState switchState = childSwitchStates.get(index);
        switchState.updateCompositeSwitchMask(switchLevel, switchOn);
        if (switchRoot != null) {
            if (init) {
                if (!switchState.initialized) {
                    switchState.initSwitchOn();
                }
            } else {
                boolean compositeSwitchOn = switchState.evalCompositeSwitchOn();
                if (switchState.cachedSwitchOn != compositeSwitchOn) {
                    switchState.updateCachedSwitchOn();
                    switchRoot.updateTargets.addCachedTargets(switchState.cachedTargets);
                    newSwChanged = true;
                    updateList.add(switchState);
                }
            }
        }
        ArrayList childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(child);
        int cslSize = childSwitchLinks.size();
        for (int i2 = 0; i2 < cslSize; ++i2) {
            int j2;
            Object obj = childSwitchLinks.get(i2);
            if (obj instanceof SwitchRetained) {
                SwitchRetained sw = (SwitchRetained)obj;
                int swSize = sw.children.size();
                for (j2 = 0; j2 < swSize; ++j2) {
                    sw.traverseSwitchChild(j2, key, index, switchRoot, init, newSwChanged, switchOn, switchLevel, updateList);
                }
                continue;
            }
            LinkRetained ln = (LinkRetained)obj;
            if (key == null) {
                this.switchKey.reset();
                this.switchKey.append(this.locale.nodeId);
            } else {
                this.switchKey.set(key);
            }
            this.switchKey.append(LinkRetained.plus).append(ln.nodeId);
            if (ln.sharedGroup == null || ln.sharedGroup.localToVworldKeys == null) continue;
            j2 = this.switchKey.equals(ln.sharedGroup.localToVworldKeys, 0, ln.sharedGroup.localToVworldKeys.length);
            if (j2 < 0) {
                System.err.println("SwitchRetained : Can't find hashKey");
            }
            if (j2 >= ln.sharedGroup.localToVworldKeys.length) continue;
            int lscSize = ln.sharedGroup.children.size();
            for (int k2 = 0; k2 < lscSize; ++k2) {
                ln.sharedGroup.traverseSwitchChild(k2, ln.sharedGroup.localToVworldKeys[j2], j2, switchRoot, init, newSwChanged, switchOn, switchLevel, updateList);
            }
        }
    }

    void traverseSwitchParent() {
        if (this.inSharedGroup) {
            for (int j2 = 0; j2 < this.localToVworldKeys.length; ++j2) {
                int switchLevel = this.switchLevels.get(j2);
                SwitchRetained switchRoot = switchLevel == 0 ? this : null;
                int size = this.children.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    boolean switchOn = this.renderChildMask.get(i2);
                    this.traverseSwitchChild(i2, this.localToVworldKeys[j2], j2, switchRoot, true, false, switchOn, switchLevel, null);
                }
            }
        } else {
            int switchLevel = this.switchLevels.get(0);
            SwitchRetained switchRoot = switchLevel == 0 ? this : null;
            int size = this.children.size();
            for (int i3 = 0; i3 < size; ++i3) {
                boolean switchOn = this.renderChildMask.get(i3);
                this.traverseSwitchChild(i3, null, 0, switchRoot, true, false, switchOn, switchLevel, null);
            }
        }
        if (this.parentSwitchLink != null) {
            if (this.parentSwitchLink instanceof SwitchRetained) {
                ((SwitchRetained)this.parentSwitchLink).traverseSwitchParent();
            } else if (this.parentSwitchLink instanceof SharedGroupRetained) {
                ((SharedGroupRetained)this.parentSwitchLink).traverseSwitchParent();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        block16: {
            block13: {
                block14: {
                    NodeRetained child;
                    block17: {
                        block15: {
                            if (!this.boundsAutoCompute) break block13;
                            if (VirtualUniverse.mc.cacheAutoComputedBounds) break block14;
                            if (this.whichChild != -2) break block15;
                            for (int i2 = 0; i2 < this.children.size(); ++i2) {
                                NodeRetained child2 = (NodeRetained)this.children.get(i2);
                                if (child2 == null) continue;
                                child2.computeCombineBounds(bounds);
                            }
                            break block16;
                        }
                        if (this.whichChild != -3) break block17;
                        for (int i3 = 0; i3 < this.children.size(); ++i3) {
                            NodeRetained child3;
                            if (!this.childMask.get(i3) || (child3 = (NodeRetained)this.children.get(i3)) == null) continue;
                            child3.computeCombineBounds(bounds);
                        }
                        break block16;
                    }
                    if (this.whichChild == -1 || this.whichChild >= this.children.size() || (child = (NodeRetained)this.children.get(this.whichChild)) == null) break block16;
                    child.computeCombineBounds(bounds);
                    break block16;
                }
                if (!this.validCachedBounds) {
                    NodeRetained child;
                    this.validCachedBounds = true;
                    this.cachedBounds = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
                    if (this.whichChild == -2) {
                        for (int i4 = 0; i4 < this.children.size(); ++i4) {
                            NodeRetained child4 = (NodeRetained)this.children.get(i4);
                            if (child4 == null) continue;
                            child4.computeCombineBounds(this.cachedBounds);
                        }
                    } else if (this.whichChild == -3) {
                        for (int i5 = 0; i5 < this.children.size(); ++i5) {
                            NodeRetained child5;
                            if (!this.childMask.get(i5) || (child5 = (NodeRetained)this.children.get(i5)) == null) continue;
                            child5.computeCombineBounds(this.cachedBounds);
                        }
                    } else if (this.whichChild != -1 && this.whichChild < this.children.size() && (child = (NodeRetained)this.children.get(this.whichChild)) != null) {
                        child.computeCombineBounds(this.cachedBounds);
                    }
                }
                bounds.combine(this.cachedBounds);
                break block16;
            }
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            NodeRetained child;
            if (this.validCachedBounds) {
                return (Bounds)this.cachedBounds.clone();
            }
            Bounds boundingObject = null;
            boundingObject = VirtualUniverse.mc.useBoxForGroupBounds ? new BoundingBox((Bounds)null) : new BoundingSphere((Bounds)null);
            if (this.whichChild == -2) {
                for (int i2 = 0; i2 < this.children.size(); ++i2) {
                    NodeRetained child2 = (NodeRetained)this.children.get(i2);
                    if (child2 == null) continue;
                    child2.computeCombineBounds(boundingObject);
                }
            } else if (this.whichChild == -3) {
                for (int i3 = 0; i3 < this.children.size(); ++i3) {
                    NodeRetained child3;
                    if (!this.childMask.get(i3) || (child3 = (NodeRetained)this.children.get(i3)) == null) continue;
                    child3.computeCombineBounds(boundingObject);
                }
            } else if (this.whichChild != -1 && this.whichChild >= 0 && this.whichChild < this.children.size() && (child = (NodeRetained)this.children.get(this.whichChild)) != null) {
                child.computeCombineBounds(boundingObject);
            }
            return boundingObject;
        }
        return super.getBounds();
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        this.mergeFlag = 0;
    }

    @Override
    void insertChildrenData(int index) {
        if (this.childrenSwitchStates == null) {
            this.childrenSwitchStates = new ArrayList(1);
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(index, new ArrayList(1));
        ArrayList<SwitchState> switchStates = new ArrayList<SwitchState>(1);
        this.childrenSwitchStates.add(index, switchStates);
        if (this.source != null && this.source.isLive()) {
            for (int i2 = 0; i2 < this.localToVworld.length; ++i2) {
                switchStates.add(new SwitchState(true));
            }
        }
    }

    @Override
    void appendChildrenData() {
        if (this.childrenSwitchStates == null) {
            this.childrenSwitchStates = new ArrayList(1);
            this.childrenSwitchLinks = new ArrayList(1);
        }
        this.childrenSwitchLinks.add(new ArrayList(1));
        ArrayList<SwitchState> switchStates = new ArrayList<SwitchState>(1);
        this.childrenSwitchStates.add(switchStates);
        if (this.source != null && this.source.isLive()) {
            for (int i2 = 0; i2 < this.localToVworld.length; ++i2) {
                switchStates.add(new SwitchState(true));
            }
        }
    }

    @Override
    void removeChildrenData(int index) {
        ArrayList<SwitchState> oldSwitchStates = this.childrenSwitchStates.get(index);
        oldSwitchStates.clear();
        this.childrenSwitchStates.remove(index);
        ArrayList oldSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(index);
        oldSwitchLinks.clear();
        this.childrenSwitchLinks.remove(index);
    }

    @Override
    void childDoSetLive(NodeRetained child, int childIndex, SetLiveState s) {
        int numPaths = this.inSharedGroup ? s.keys.length : 1;
        s.childSwitchLinks = (ArrayList)this.childrenSwitchLinks.get(childIndex);
        for (int j2 = 0; j2 < numPaths; ++j2) {
            s.closestSwitchIndices[j2] = this.switchIndexCount;
            s.closestSwitchParents[j2] = this;
        }
        ++this.switchIndexCount;
        Targets[] newTargets = new Targets[numPaths];
        for (int i2 = 0; i2 < numPaths; ++i2) {
            newTargets[i2] = new Targets();
        }
        s.switchTargets = newTargets;
        s.switchStates = this.childrenSwitchStates.get(childIndex);
        if (child != null) {
            child.setLive(s);
        }
        if (!this.inSharedGroup) {
            CachedTargets cachedTargets = s.switchTargets[0].snapShotInit();
            SwitchState switchState = s.switchStates.get(0);
            switchState.cachedTargets = cachedTargets;
        } else {
            for (int i3 = 0; i3 < numPaths; ++i3) {
                CachedTargets cachedTargets = s.switchTargets[i3].snapShotInit();
                SwitchState switchState = s.switchStates.get(s.hashkeyIndex[i3]);
                switchState.cachedTargets = cachedTargets;
            }
        }
    }

    @Override
    TargetsInterface getClosestTargetsInterface(int type) {
        return type == 1 ? this : (TargetsInterface)((Object)this.parentTransformLink);
    }

    @Override
    public CachedTargets getCachedTargets(int type, int index, int child) {
        if (type == 1) {
            ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(child);
            if (index < switchStates.size()) {
                SwitchState switchState = switchStates.get(index);
                return switchState.cachedTargets;
            }
            return null;
        }
        System.err.println("getCachedTargets: wrong arguments");
        return null;
    }

    @Override
    public void resetCachedTargets(int type, CachedTargets[] newCtArr, int child) {
        if (type == 1) {
            ArrayList<SwitchState> switchStates = this.childrenSwitchStates.get(child);
            if (newCtArr.length != switchStates.size()) {
                System.err.println("resetCachedTargets: unmatched length!" + newCtArr.length + " " + switchStates.size());
                System.err.println("  resetCachedTargets: " + this);
            }
            for (int i2 = 0; i2 < newCtArr.length; ++i2) {
                SwitchState switchState = switchStates.get(i2);
                switchState.cachedTargets = newCtArr[i2];
            }
        } else {
            System.err.println("resetCachedTargets: wrong arguments");
        }
    }

    @Override
    public ArrayList<SwitchState> getTargetsData(int type, int child) {
        if (type == 1) {
            return this.childrenSwitchStates.get(child);
        }
        System.err.println("getTargetsData: wrong arguments");
        return null;
    }

    @Override
    public int getTargetThreads(int type) {
        System.err.println("getTargetsThreads: wrong arguments");
        return -1;
    }

    @Override
    public void updateCachedTargets(int type, CachedTargets[] newCt) {
        System.err.println("updateCachedTarget: wrong arguments");
    }

    @Override
    public void computeTargetThreads(int type, CachedTargets[] newCt) {
        System.err.println("computeTargetThreads: wrong arguments");
    }

    @Override
    public void updateTargetThreads(int type, CachedTargets[] newCt) {
        System.err.println("updateTargetThreads: wrong arguments");
    }

    @Override
    public void propagateTargetThreads(int type, int newTargetThreads) {
        System.err.println("propagateTargetThreads: wrong arguments");
    }

    @Override
    public void copyCachedTargets(int type, CachedTargets[] newCt) {
        System.err.println("copyCachedTarget: wrong arguments");
    }
}

