/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

public class SparseArray<E>
implements Cloneable {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;
    static final boolean[] EMPTY_BOOLEANS = new boolean[0];
    static final int[] EMPTY_INTS = new int[0];
    static final long[] EMPTY_LONGS = new long[0];
    static final Object[] EMPTY_OBJECTS = new Object[0];

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        if (initialCapacity == 0) {
            this.mKeys = EMPTY_INTS;
            this.mValues = EMPTY_OBJECTS;
        } else {
            initialCapacity = SparseArray.idealIntArraySize(initialCapacity);
            this.mKeys = new int[initialCapacity];
            this.mValues = new Object[initialCapacity];
        }
        this.mSize = 0;
    }

    public SparseArray<E> clone() {
        SparseArray clone = null;
        try {
            clone = (SparseArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E valueIfKeyNotFound) {
        int i2 = SparseArray.binarySearch(this.mKeys, this.mSize, key);
        if (i2 < 0 || this.mValues[i2] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i2];
    }

    public void delete(int key) {
        int i2 = SparseArray.binarySearch(this.mKeys, this.mSize, key);
        if (i2 >= 0 && this.mValues[i2] != DELETED) {
            this.mValues[i2] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int key) {
        this.delete(key);
    }

    public void removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    public void removeAtRange(int index, int size) {
        int end = Math.min(this.mSize, index + size);
        for (int i2 = index; i2 < end; ++i2) {
            this.removeAt(i2);
        }
    }

    private void gc() {
        int n2 = this.mSize;
        int o2 = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object val = values[i2];
            if (val == DELETED) continue;
            if (i2 != o2) {
                keys[o2] = keys[i2];
                values[o2] = val;
                values[i2] = null;
            }
            ++o2;
        }
        this.mGarbage = false;
        this.mSize = o2;
    }

    public void put(int key, E value) {
        int i2 = SparseArray.binarySearch(this.mKeys, this.mSize, key);
        if (i2 >= 0) {
            this.mValues[i2] = value;
        } else {
            if ((i2 ^= 0xFFFFFFFF) < this.mSize && this.mValues[i2] == DELETED) {
                this.mKeys[i2] = key;
                this.mValues[i2] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i2 = ~SparseArray.binarySearch(this.mKeys, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n2 = SparseArray.idealIntArraySize(this.mSize + 1);
                int[] nkeys = new int[n2];
                Object[] nvalues = new Object[n2];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i2 != 0) {
                System.arraycopy(this.mKeys, i2, this.mKeys, i2 + 1, this.mSize - i2);
                System.arraycopy(this.mValues, i2, this.mValues, i2 + 1, this.mSize - i2);
            }
            this.mKeys[i2] = key;
            this.mValues[i2] = value;
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArray.binarySearch(this.mKeys, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (this.mValues[i2] != value) continue;
            return i2;
        }
        return -1;
    }

    public void clear() {
        int n2 = this.mSize;
        Object[] values = this.mValues;
        for (int i2 = 0; i2 < n2; ++i2) {
            values[i2] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n2 = SparseArray.idealIntArraySize(pos + 1);
            int[] nkeys = new int[n2];
            Object[] nvalues = new Object[n2];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public String toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i2 = 0; i2 < this.mSize; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i2);
            buffer.append(key);
            buffer.append('=');
            E value = this.valueAt(i2);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    public static int idealByteArraySize(int need) {
        for (int i2 = 4; i2 < 32; ++i2) {
            if (need > (1 << i2) - 12) continue;
            return (1 << i2) - 12;
        }
        return need;
    }

    public static int idealIntArraySize(int need) {
        return SparseArray.idealByteArraySize(need * 8) / 8;
    }

    static int binarySearch(int[] array, int size, int value) {
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            int midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    static int binarySearch(long[] array, int size, long value) {
        int lo = 0;
        int hi = size - 1;
        while (lo <= hi) {
            int mid = lo + hi >>> 1;
            long midVal = array[mid];
            if (midVal < value) {
                lo = mid + 1;
                continue;
            }
            if (midVal > value) {
                hi = mid - 1;
                continue;
            }
            return mid;
        }
        return ~lo;
    }

    public void putAll(SparseArray<E> sa) {
        for (int i2 = 0; i2 < sa.size(); ++i2) {
            this.put(sa.keyAt(i2), sa.get(sa.keyAt(i2)));
        }
    }

    public int[] keySet() {
        int[] keys = new int[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            keys[i2] = this.keyAt(i2);
        }
        return keys;
    }

    public void put(Integer key, E value) {
        throw new UnsupportedOperationException("This is exactly the sort of thing I'm trying to avoid!");
    }

    public E get(Integer key) {
        throw new UnsupportedOperationException("This is exactly the sort of thing I'm trying to avoid!");
    }

    public E remove(Integer key) {
        throw new UnsupportedOperationException("This is exactly the sort of thing I'm trying to avoid!");
    }
}

