/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.jogamp.java3d.AuralAttributesRetained;
import org.jogamp.java3d.BoundingSphere;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.ConeSoundRetained;
import org.jogamp.java3d.J3dMessage;
import org.jogamp.java3d.J3dStructure;
import org.jogamp.java3d.MediaContainer;
import org.jogamp.java3d.NodeRetained;
import org.jogamp.java3d.PointSoundRetained;
import org.jogamp.java3d.SoundRetained;
import org.jogamp.java3d.SoundscapeRetained;
import org.jogamp.java3d.UnorderList;
import org.jogamp.java3d.UpdateTargets;
import org.jogamp.java3d.View;
import org.jogamp.java3d.ViewPlatformRetained;
import org.jogamp.java3d.VirtualUniverse;

class SoundStructure
extends J3dStructure {
    UnorderList nonViewScopedSounds = new UnorderList(SoundRetained.class);
    HashMap viewScopedSounds = new HashMap();
    UnorderList nonViewScopedSoundscapes = new UnorderList(SoundscapeRetained.class);
    HashMap viewScopedSoundscapes = new HashMap();
    UnorderList viewPlatforms = new UnorderList(ViewPlatformRetained.class);
    BoundingSphere tempSphere = new BoundingSphere();
    BoundingSphere vpsphere = new BoundingSphere();
    ArrayList objList = new ArrayList();
    ArrayList xformChangeList = new ArrayList();
    ArrayList switchChangeLeafNodes = new ArrayList();
    ArrayList switchChangeLeafMasks = new ArrayList();
    boolean transformMsg = false;
    UpdateTargets targets = null;
    static final boolean debugFlag = false;
    static final boolean internalErrors = false;

    SoundStructure(VirtualUniverse u) {
        super(u, 512);
    }

    @Override
    void processMessages(long referenceTime) {
        Object[] messages = this.getMessages(referenceTime);
        int nMsg = this.getNumMessage();
        if (nMsg <= 0) {
            return;
        }
        for (int i2 = 0; i2 < nMsg; ++i2) {
            J3dMessage m2 = messages[i2];
            switch (m2.type) {
                case 0: {
                    this.insertNodes(m2);
                    break;
                }
                case 1: {
                    this.removeNodes(m2);
                    break;
                }
                case 38: {
                    this.changeNodeAttrib(m2);
                    break;
                }
                case 45: {
                    this.changeNodeState(m2);
                    break;
                }
                case 39: 
                case 40: {
                    this.changeNodeAttrib(m2);
                    break;
                }
                case 3: {
                    this.transformMsg = true;
                    break;
                }
                case 27: {
                    if (!this.universe.transformStructure.getLazyUpdate()) break;
                    this.transformMsg = true;
                    break;
                }
                case 56: {
                    this.updateViewSpecificGroupChanged(m2);
                }
            }
            m2.decRefcount();
        }
        if (this.transformMsg) {
            this.targets = this.universe.transformStructure.getTargetList();
            this.updateTransformChange(this.targets, referenceTime);
            this.transformMsg = false;
            this.targets = null;
        }
        Arrays.fill(messages, 0, nMsg, null);
    }

    void insertNodes(J3dMessage m2) {
        Object[] nodes = (Object[])m2.args[0];
        ArrayList viewScopedNodes = (ArrayList)m2.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m2.args[4];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object node = nodes[i2];
            if (node instanceof SoundRetained) {
                this.addNonScopedSound((SoundRetained)node);
            }
            if (!(node instanceof SoundscapeRetained)) continue;
            this.addNonSoundscape((SoundscapeRetained)node);
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (int i3 = 0; i3 < size; ++i3) {
                View view;
                int k2;
                NodeRetained node = (NodeRetained)viewScopedNodes.get(i3);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i3);
                int vsize = vl.size();
                if (node instanceof SoundRetained) {
                    ((SoundRetained)node).isViewScoped = true;
                    for (k2 = 0; k2 < vsize; ++k2) {
                        view = (View)vl.get(k2);
                        this.addScopedSound((SoundRetained)node, view);
                    }
                    continue;
                }
                if (!(node instanceof SoundscapeRetained)) continue;
                ((SoundscapeRetained)node).isViewScoped = true;
                for (k2 = 0; k2 < vsize; ++k2) {
                    view = (View)vl.get(k2);
                    this.addScopedSoundscape((SoundscapeRetained)node, view);
                }
            }
        }
    }

    void addScopedSound(SoundRetained mirSound, View view) {
        ArrayList<SoundRetained> l2 = (ArrayList<SoundRetained>)this.viewScopedSounds.get(view);
        if (l2 == null) {
            l2 = new ArrayList<SoundRetained>();
            this.viewScopedSounds.put(view, l2);
        }
        l2.add(mirSound);
    }

    void addNonScopedSound(SoundRetained mirSound) {
        this.nonViewScopedSounds.add(mirSound);
    }

    void addScopedSoundscape(SoundscapeRetained soundscape, View view) {
        ArrayList<SoundscapeRetained> l2 = (ArrayList<SoundscapeRetained>)this.viewScopedSoundscapes.get(view);
        if (l2 == null) {
            l2 = new ArrayList<SoundscapeRetained>();
            this.viewScopedSoundscapes.put(view, l2);
        }
        l2.add(soundscape);
    }

    void addNonSoundscape(SoundscapeRetained soundscape) {
        this.nonViewScopedSoundscapes.add(soundscape);
    }

    @Override
    void removeNodes(J3dMessage m2) {
        Object[] nodes = (Object[])m2.args[0];
        ArrayList viewScopedNodes = (ArrayList)m2.args[3];
        ArrayList scopedNodesViewList = (ArrayList)m2.args[4];
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            Object node = nodes[i2];
            if (node instanceof SoundRetained) {
                this.deleteNonScopedSound((SoundRetained)node);
            }
            if (!(node instanceof SoundscapeRetained)) continue;
            this.deleteNonScopedSoundscape((SoundscapeRetained)node);
        }
        if (viewScopedNodes != null) {
            int size = viewScopedNodes.size();
            for (int i3 = 0; i3 < size; ++i3) {
                View view;
                int k2;
                NodeRetained node = (NodeRetained)viewScopedNodes.get(i3);
                ArrayList vl = (ArrayList)scopedNodesViewList.get(i3);
                int vsize = vl.size();
                if (node instanceof SoundRetained) {
                    ((SoundRetained)node).isViewScoped = false;
                    for (k2 = 0; k2 < vsize; ++k2) {
                        view = (View)vl.get(k2);
                        this.deleteScopedSound((SoundRetained)node, view);
                    }
                    continue;
                }
                if (!(node instanceof SoundscapeRetained)) continue;
                ((SoundscapeRetained)node).isViewScoped = false;
                for (k2 = 0; k2 < vsize; ++k2) {
                    view = (View)vl.get(k2);
                    this.deleteScopedSoundscape((SoundscapeRetained)node, view);
                }
            }
        }
    }

    void deleteNonScopedSound(SoundRetained sound) {
        if (!this.nonViewScopedSounds.isEmpty()) {
            int index = this.nonViewScopedSounds.indexOf(sound);
            this.nonViewScopedSounds.remove(index);
        }
    }

    void deleteNonScopedSoundscape(SoundscapeRetained soundscape) {
        boolean error = this.nonViewScopedSoundscapes.remove(soundscape);
    }

    void deleteScopedSound(SoundRetained sound, View view) {
        ArrayList l2 = (ArrayList)this.viewScopedSounds.get(view);
        if (!l2.isEmpty()) {
            int index = l2.indexOf(sound);
            l2.remove(index);
        }
        if (l2.isEmpty()) {
            this.viewScopedSounds.remove(view);
        }
    }

    void deleteScopedSoundscape(SoundscapeRetained soundscape, View view) {
        ArrayList l2 = (ArrayList)this.viewScopedSoundscapes.get(view);
        if (!l2.isEmpty()) {
            int index = l2.indexOf(soundscape);
            l2.remove(index);
        }
        if (l2.isEmpty()) {
            this.viewScopedSoundscapes.remove(view);
        }
    }

    void changeNodeAttrib(J3dMessage m2) {
        Object node = m2.args[0];
        Object value = m2.args[1];
        if (node instanceof SoundRetained) {
            int attribDirty = (Integer)value;
            if ((attribDirty & 0x20) > 0) {
                // empty if block
            }
            if ((attribDirty & 1) > 0) {
                this.loadSound((SoundRetained)node, true);
            }
            ((SoundRetained)node).updateMirrorObject(m2.args);
        }
        if (node instanceof SoundscapeRetained) {
            ((SoundscapeRetained)node).updateTransformChange();
        }
    }

    void changeNodeState(J3dMessage m2) {
        Object node = m2.args[0];
        Object value = m2.args[1];
        if (node instanceof SoundRetained) {
            int stateDirty = (Integer)value;
            if ((stateDirty & 1) > 0) {
                this.loadSound((SoundRetained)node, false);
            }
            if ((stateDirty & 0x20) > 0) {
                this.enableSound((SoundRetained)node);
            }
            ((SoundRetained)node).updateMirrorObject(m2.args);
        }
    }

    boolean intersect(Bounds region) {
        if (region == null) {
            return false;
        }
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            vpLists[i2].schedSphere.getWithLock(this.tempSphere);
            if (!this.tempSphere.intersect(region)) continue;
            return true;
        }
        return false;
    }

    void loadSound(SoundRetained sound, boolean forceLoad) {
        MediaContainer mediaContainer = sound.getSoundData();
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] views = vpLists[i2].getViewList();
            for (int j2 = views.length - 1; j2 >= 0; --j2) {
                View v = views[j2];
                v.soundScheduler.loadSound(sound, forceLoad);
            }
        }
    }

    void enableSound(SoundRetained sound) {
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] views = vpLists[i2].getViewList();
            for (int j2 = views.length - 1; j2 >= 0; --j2) {
                View v = views[j2];
                v.soundScheduler.enableSound(sound);
            }
        }
    }

    void muteSound(SoundRetained sound) {
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] views = vpLists[i2].getViewList();
            for (int j2 = views.length - 1; j2 >= 0; --j2) {
                View v = views[j2];
                v.soundScheduler.muteSound(sound);
            }
        }
    }

    void pauseSound(SoundRetained sound) {
        ViewPlatformRetained[] vpLists = (ViewPlatformRetained[])this.viewPlatforms.toArray(false);
        for (int i2 = this.viewPlatforms.arraySize() - 1; i2 >= 0; --i2) {
            View[] views = vpLists[i2].getViewList();
            for (int j2 = views.length - 1; j2 >= 0; --j2) {
                View v = views[j2];
                v.soundScheduler.pauseSound(sound);
            }
        }
    }

    void processSwitchChanged(J3dMessage m2) {
    }

    UnorderList getSoundList(View view) {
        ArrayList l2 = (ArrayList)this.viewScopedSounds.get(view);
        if (l2 == null) {
            return this.nonViewScopedSounds;
        }
        UnorderList newS = (UnorderList)this.nonViewScopedSounds.clone();
        int size = l2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            newS.add(l2.get(i2));
        }
        return newS;
    }

    UnorderList getSoundscapeList(View view) {
        ArrayList l2 = (ArrayList)this.viewScopedSoundscapes.get(view);
        if (l2 == null) {
            return this.nonViewScopedSoundscapes;
        }
        UnorderList newS = (UnorderList)this.nonViewScopedSoundscapes.clone();
        int size = l2.size();
        for (int i2 = 0; i2 < size; ++i2) {
            newS.add(l2.get(i2));
        }
        return newS;
    }

    void updateTransformChange(UpdateTargets targets, long referenceTime) {
        UnorderList arrList = targets.targetList[3];
        if (arrList != null) {
            int size = arrList.size();
            Object[] nodesArr = arrList.toArray(false);
            for (int j2 = 0; j2 < size; ++j2) {
                Object[] nodes = (Object[])nodesArr[j2];
                for (int i2 = 0; i2 < nodes.length; ++i2) {
                    if (nodes[i2] instanceof ConeSoundRetained) {
                        this.xformChangeList.add(nodes[i2]);
                        ConeSoundRetained cnSndNode = (ConeSoundRetained)nodes[i2];
                        cnSndNode.updateTransformChange();
                        continue;
                    }
                    if (nodes[i2] instanceof PointSoundRetained) {
                        this.xformChangeList.add(nodes[i2]);
                        PointSoundRetained ptSndNode = (PointSoundRetained)nodes[i2];
                        ptSndNode.updateTransformChange();
                        continue;
                    }
                    if (nodes[i2] instanceof SoundRetained) {
                        this.xformChangeList.add(nodes[i2]);
                        SoundRetained sndNode = (SoundRetained)nodes[i2];
                        sndNode.updateTransformChange();
                        continue;
                    }
                    if (nodes[i2] instanceof SoundscapeRetained) {
                        this.xformChangeList.add(nodes[i2]);
                        SoundscapeRetained sndScapeNode = (SoundscapeRetained)nodes[i2];
                        sndScapeNode.updateTransformChange();
                        continue;
                    }
                    if (!(nodes[i2] instanceof AuralAttributesRetained)) continue;
                    this.xformChangeList.add(nodes[i2]);
                }
            }
        }
    }

    void debugPrint(String message) {
    }

    boolean isSoundScopedToView(Object obj, View view) {
        ArrayList l2;
        SoundRetained s = (SoundRetained)obj;
        return !s.isViewScoped || (l2 = (ArrayList)this.viewScopedSounds.get(view)).contains(s);
    }

    boolean isSoundscapeScopedToView(Object obj, View view) {
        ArrayList l2;
        SoundscapeRetained s = (SoundscapeRetained)obj;
        return !s.isViewScoped || (l2 = (ArrayList)this.viewScopedSoundscapes.get(view)).contains(s);
    }

    void updateViewSpecificGroupChanged(J3dMessage m2) {
        Object obj;
        int i2;
        int size;
        int component = (Integer)m2.args[0];
        Object[] objAry = (Object[])m2.args[1];
        ArrayList soundList = null;
        ArrayList soundsScapeList = null;
        if ((component & 2) != 0 || (component & 1) != 0) {
            View view = (View)objAry[0];
            ArrayList leafList = (ArrayList)objAry[2];
            size = leafList.size();
            if (size > 0) {
                for (i2 = 0; i2 < size; ++i2) {
                    obj = leafList.get(i2);
                    if (obj instanceof SoundRetained) {
                        if (soundList == null && (soundList = (ArrayList)this.viewScopedSounds.get(view)) == null) {
                            soundList = new ArrayList();
                            this.viewScopedSounds.put(view, soundList);
                        }
                        soundList.add(obj);
                        continue;
                    }
                    if (!(obj instanceof SoundscapeRetained)) continue;
                    if (soundsScapeList == null && (soundsScapeList = (ArrayList)this.viewScopedSoundscapes.get(view)) == null) {
                        soundsScapeList = new ArrayList();
                        this.viewScopedSoundscapes.put(view, soundsScapeList);
                    }
                    soundsScapeList.add(obj);
                }
            }
        }
        if ((component & 4) != 0 || (component & 1) != 0) {
            ArrayList leafList;
            View view;
            if ((component & 4) != 0) {
                view = (View)objAry[0];
                leafList = (ArrayList)objAry[2];
            } else {
                view = (View)objAry[4];
                leafList = (ArrayList)objAry[6];
            }
            size = leafList.size();
            if (size > 0) {
                for (i2 = 0; i2 < size; ++i2) {
                    obj = leafList.get(i2);
                    if (obj instanceof SoundRetained) {
                        if (soundList == null) {
                            soundList = (ArrayList)this.viewScopedSounds.get(view);
                        }
                        soundList.remove(obj);
                    }
                    if (!(obj instanceof SoundscapeRetained)) continue;
                    if (soundsScapeList == null) {
                        soundsScapeList = (ArrayList)this.viewScopedSoundscapes.get(view);
                    }
                    soundsScapeList.remove(obj);
                }
                if (soundList != null && soundList.size() == 0) {
                    this.viewScopedSounds.remove(view);
                }
                if (soundsScapeList != null && soundsScapeList.size() == 0) {
                    this.viewScopedSoundscapes.remove(view);
                }
            }
        }
    }

    @Override
    void cleanup() {
    }
}

