/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.jogamp.java3d.BoundingBox;
import org.jogamp.java3d.Bounds;
import org.jogamp.java3d.Geometry;
import org.jogamp.java3d.GeometryArrayRetained;
import org.jogamp.java3d.GeometryRetained;
import org.jogamp.java3d.IndexedLineArrayRetained;
import org.jogamp.java3d.IndexedLineStripArrayRetained;
import org.jogamp.java3d.IndexedPointArrayRetained;
import org.jogamp.java3d.IndexedQuadArrayRetained;
import org.jogamp.java3d.IndexedTriangleArrayRetained;
import org.jogamp.java3d.IndexedTriangleFanArrayRetained;
import org.jogamp.java3d.IndexedTriangleStripArrayRetained;
import org.jogamp.java3d.J3dI18N;
import org.jogamp.java3d.LineArrayRetained;
import org.jogamp.java3d.LineStripArrayRetained;
import org.jogamp.java3d.PickInfo;
import org.jogamp.java3d.PickShape;
import org.jogamp.java3d.PointArrayRetained;
import org.jogamp.java3d.QuadArrayRetained;
import org.jogamp.java3d.SceneGraphObjectRetained;
import org.jogamp.java3d.SceneGraphPath;
import org.jogamp.java3d.Shape3D;
import org.jogamp.java3d.Shape3DRetained;
import org.jogamp.java3d.Transform3D;
import org.jogamp.java3d.TriangleArrayRetained;
import org.jogamp.java3d.TriangleFanArrayRetained;
import org.jogamp.java3d.TriangleStripArrayRetained;
import org.jogamp.vecmath.Point3d;

class Shape3DCompileRetained
extends Shape3DRetained {
    int numShapes = 0;
    ArrayList<ArrayList<Geometry>> geometryInfo = null;
    Object[] srcList = null;

    Shape3DCompileRetained(Shape3DRetained[] shapes, int nShapes, int compileFlags) {
        int i2;
        ArrayList[] mergedList = new ArrayList[15];
        ArrayList[] separateList = new ArrayList[15];
        this.numShapes = nShapes;
        this.srcList = new Object[nShapes];
        if (nShapes > 0) {
            this.boundsAutoCompute = shapes[0].boundsAutoCompute;
            this.source = shapes[0].source;
        }
        this.geometryList.remove(0);
        this.boundsAutoCompute = shapes[0].boundsAutoCompute;
        this.isPickable = shapes[0].isPickable;
        this.isCollidable = shapes[0].isCollidable;
        this.appearanceOverrideEnable = shapes[0].appearanceOverrideEnable;
        this.appearance = shapes[0].appearance;
        this.collisionBound = shapes[0].collisionBound;
        this.localBounds = shapes[0].localBounds;
        if ((compileFlags & 2) != 0) {
            this.geometryInfo = new ArrayList();
        }
        for (i2 = 0; i2 < nShapes; ++i2) {
            int j2;
            Shape3DRetained shape = shapes[i2];
            ((Shape3D)shape.source).id = i2;
            shape.source.retained = this;
            this.srcList[i2] = shape.source;
            for (j2 = 0; j2 < shape.geometryList.size(); ++j2) {
                GeometryArrayRetained geo = (GeometryArrayRetained)shape.geometryList.get(j2);
                if (geo == null) continue;
                if (shape.willRemainOpaque(geo.geoType) && geo.isMergeable()) {
                    if (mergedList[geo.geoType] == null) {
                        mergedList[geo.geoType] = new ArrayList();
                    }
                    mergedList[geo.geoType].add(geo);
                    continue;
                }
                if (separateList[geo.geoType] == null) {
                    separateList[geo.geoType] = new ArrayList();
                }
                separateList[geo.geoType].add(geo);
            }
            if ((compileFlags & 2) == 0) continue;
            ArrayList<Geometry> sList = new ArrayList<Geometry>();
            for (j2 = 0; j2 < shape.geometryList.size(); ++j2) {
                GeometryRetained g2 = shape.geometryList.get(j2);
                if (g2 != null) {
                    sList.add((Geometry)g2.source);
                    continue;
                }
                sList.add(null);
            }
            this.geometryInfo.add(sList);
        }
        block19: for (i2 = 1; i2 <= 14; ++i2) {
            switch (i2) {
                case 1: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new QuadArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 2: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new TriangleArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 3: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new PointArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 4: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new LineArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 5: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new TriangleStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 6: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new TriangleFanArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 7: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new LineStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 8: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedQuadArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 9: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedTriangleArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 10: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedPointArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 11: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedLineArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 12: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedTriangleStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 13: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedTriangleFanArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                    continue block19;
                }
                case 14: {
                    if (mergedList[i2] != null) {
                        this.addMergedList(mergedList[i2], new IndexedLineStripArrayRetained());
                    }
                    this.addSeparateList(separateList[i2]);
                }
            }
        }
    }

    private void addMergedList(ArrayList<GeometryArrayRetained> glist, GeometryArrayRetained cgeo) {
        cgeo.setCompiled(glist);
        this.geometryList.add(cgeo);
        cgeo.setSource(((SceneGraphObjectRetained)glist.get((int)0)).source);
    }

    private void addSeparateList(ArrayList<GeometryArrayRetained> glist) {
        if (glist == null) {
            return;
        }
        for (int k2 = 0; k2 < glist.size(); ++k2) {
            this.geometryList.add(glist.get(k2));
        }
    }

    @Override
    Bounds getCollisionBounds(int childIndex) {
        return this.collisionBound;
    }

    @Override
    int numGeometries(int childIndex) {
        return this.geometryInfo.get(childIndex).size();
    }

    @Override
    Geometry getGeometry(int i2, int childIndex) {
        return this.geometryInfo.get(childIndex).get(i2);
    }

    @Override
    Iterator<Geometry> getAllGeometries(int childIndex) {
        ArrayList<Geometry> geoInfo = this.geometryInfo.get(childIndex);
        Vector<Geometry> geomList = new Vector<Geometry>();
        for (int i2 = 0; i2 < geoInfo.size(); ++i2) {
            geomList.add(geoInfo.get(i2));
        }
        return geomList.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Bounds getBounds(int childIndex) {
        if (!this.boundsAutoCompute) {
            return super.getBounds();
        }
        ArrayList<Geometry> glist = this.geometryInfo.get(childIndex);
        if (glist == null) {
            return null;
        }
        BoundingBox bbox = new BoundingBox((Bounds)null);
        for (int i2 = 0; i2 < glist.size(); ++i2) {
            Geometry g2 = glist.get(i2);
            if (g2 == null) continue;
            GeometryRetained geometry = (GeometryRetained)g2.retained;
            if (geometry.geoType == -1) continue;
            geometry.computeBoundingBox();
            BoundingBox boundingBox = geometry.geoBounds;
            synchronized (boundingBox) {
                bbox.combine(geometry.geoBounds);
                continue;
            }
        }
        return bbox;
    }

    @Override
    boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        PickInfo pickInfo = new PickInfo();
        Transform3D localToVworld = path.getTransform();
        if (localToVworld == null) {
            throw new IllegalArgumentException(J3dI18N.getString("Shape3DRetained3"));
        }
        pickInfo.setLocalToVWorldRef(localToVworld);
        Shape3D shape = (Shape3D)path.getObject();
        ArrayList<Geometry> glist = this.geometryInfo.get(shape.id);
        if (dist == null) {
            return this.intersect(pickInfo, pickShape, 0, glist);
        }
        int flags = 16;
        if (this.intersect(pickInfo, pickShape, flags, glist)) {
            dist[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int flags, ArrayList<Geometry> geometryList) {
        Transform3D localToVworld = pickInfo.getLocalToVWorldRef();
        Transform3D t3d = new Transform3D();
        t3d.invert(localToVworld);
        PickShape newPS = pickShape.transform(t3d);
        int geomListSize = geometryList.size();
        if ((flags & 8) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0 && (flags & 0x40) == 0) {
            for (int i2 = 0; i2 < geomListSize; ++i2) {
                GeometryRetained geometry = (GeometryRetained)geometryList.get((int)i2).retained;
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, null, 0, null, null, 0)) continue;
                return true;
            }
        } else {
            double minDist = Double.POSITIVE_INFINITY;
            Point3d closestIPnt = new Point3d();
            Point3d iPnt = new Point3d();
            Point3d iPntVW = new Point3d();
            for (int i3 = 0; i3 < geomListSize; ++i3) {
                GeometryRetained geometry = (GeometryRetained)geometryList.get((int)i3).retained;
                if (geometry == null) continue;
                if (geometry.mirrorGeometry != null) {
                    geometry = geometry.mirrorGeometry;
                }
                if (!geometry.intersect(newPS, pickInfo, flags, iPnt, geometry, i3)) continue;
                iPntVW.set(iPnt);
                localToVworld.transform(iPntVW);
                double distance = pickShape.distance(iPntVW);
                if (!(minDist > distance)) continue;
                minDist = distance;
                closestIPnt.set(iPnt);
            }
            if (minDist < Double.POSITIVE_INFINITY) {
                if ((flags & 0x10) != 0) {
                    pickInfo.setClosestDistance(minDist);
                }
                if ((flags & 8) != 0) {
                    pickInfo.setClosestIntersectionPoint(closestIPnt);
                }
                return true;
            }
        }
        return false;
    }
}

